// name: HDF4 to HDF5 Converter Tool
// description: Basic utility to convert HDF4(.hdf) to HDF5(.h5). Requires installation of h4h5tools.
Window.Theme(Window.THEME_CURRENT); //sets the theme of the window boxes to the current theme
Window.Message("h4toh5convert","Select HDF4 files to convert.");
var files = Window.GetFiles("*.hdf");

if(files)
{
    var fname_windows = "h4toh5.bat"; //batch file for windows
    var fname_unix    = "h4toh5.sh"; //shell file for Unix
    var cwd = GetCurrentDirectory();
    if(Windows())
    {
        var fname = fname_windows;
        var exe = "h4toh5convert"; //giving the command followed by filename works for windows
    }
    else if(Unix())
    {
        var fname = fname_unix;
        Window.Message("h4toh5convert","Select h4h5convert exe from the H4H5/2.2.5/bin folder.");
        exe = Window.GetFile("*"); //Linux needs the complete address of the exe
        if(!exe)
        {
            Window.Message("h4toh5convert","h4h5convert exe not selected.");
            Exit(); //exit from the script if exe is not given
        }
    }

    var write_file = new File(fname, File.WRITE);

    for (var i=0;i<files.length;i++)
    {
        write_file.Write(exe + " " + files[i] + "\n");
    }

    write_file.Close();

    if(Windows())
    {
        var run_bat_file = Execute({program: fname}); //the bat file has got the convert command and filename so no arguments required
    }
    if(Unix())
    {
        var run_bat_file = Execute({program: '/bin/chmod', arguments: ['775',fname]}); //the permissions for the file need to be changed so that the shell file can be executed
        var run_bat_file = Execute({program: '/bin/sh', arguments:[cwd+'/'+fname]}); //the file needs to be run through the command line shell 
    }

    Message(run_bat_file.stdout);
    if(run_bat_file.stderr!="")
    {
        WarningMessage(run_bat_file.stderr);
    }
    if(run_bat_file.stderr=="") //no error means files have been converted
    {
        Window.Message("h4toh5convert","All selected files have been converted to HDF5(.h5) format in the same directory.");
        var del = File.Delete(fname);
    }
    else
    {
        if((run_bat_file.stderr.indexOf("'h4toh5convert' is not recognized")!=-1 && Windows()) || (run_bat_file.stderr.indexOf("h4toh5convert: command not found")!=-1 && Unix()))
            Window.Warning("h4toh5convert","The h4toh5 convertor is not installed. Please install and try again. It can be downloaded from https://portal.hdfgroup.org/display/support/Download+h4h5tools - more information can be found in HDF section of the T/HIS manual.");
        else
        {
            Window.Warning("h4toh5convert","Some of the selected files failed to convert. See dialogue window for details.");
        }
    }
}
else
    Message("No files selected.");
