/*   
**  This script writes selected curves out to a file in a simple X, Y format
**
*/
//name: Write X,Y curve

//New UI:
Window.Theme(Window.THEME_CURRENT);

// Prompt the user to select curves to write
var f = AllocateFlag();

var n = Curve.Select(f, 'Select curves');

if (!n)
{
  Message("*** No curves selected. Exiting Script ***");
  Exit();
}

// Get a file to write to from the user
var filename = Window.GetFilename("Select File", "Choose a file to write X, Y points");

if (!filename)
{
  Message("*** File not selected. Exiting Script ***");
  Exit();
}

// Open the file for writing
var file = new File(filename, File.WRITE);

// Now loop over all the curves writing the x, y points of the selected curves to file
var c = Curve.First();

while(c)
{
  if(c.Flagged(f))
  {
// Write model and label
    file.Writeln("$ M" + c.model + " " + c.label);
    
// Write X, Y points
    for (var i=1; i<=c.npoints; i++)
    {
      var p = c.GetPoint(i);
      
      var x = p[0];
      var y = p[1];
      
      file.Writeln(x + ", " + y);
    }
  }

  c = c.Next();
}

// Close the file
file.Close();

// Return the flag
ReturnFlag(f);
