/*   
**  This script shades adds the values of two curves together
**
*/
//name: Add curves

//New UI:
Window.Theme(Window.THEME_CURRENT);

// Select two curves to compare
var f = AllocateFlag();

var n = Curve.Select(f, 'Select 2 curves');

// User pressed cancel - exit script
if (!n) Exit();

// Make sure the user selected 2 curves, if not tell them and exit
if (n != 2)
{
  Window.Message("", "You need to select two curves");
  Exit();
}

// Get the 2 curves
var c = Curve.First();

var i = 1;

while(c)
{
  if(c.Flagged(f))
  {
    if (i==1) var c1 = c;
    if (i==2) var c2 = c;
    
    i++;
  }

  c = c.Next();
}

// Check the curves have the same number of points
if (c1.npoints != c2.npoints)
{
  Window.Message("", "The curves have a different number of points. Unable to continue.");
  Exit();
}

// Loop over each point adding the y values to create a new curve
var c_new = new Curve(Curve.HighestID() + 1);

for (var i=1; i<=c1.npoints; i++)
{
  var p1 = c1.GetPoint(i);
  var p2 = c2.GetPoint(i);

  var yval = p1[1] + p2[1];
  
  c_new.AddPoint(p1[0], yval);
}

// Give the new curve a label
c_new.label = "Simple Add: " + c1.label + " and " + c2.label;

// Plot the graph
Plot();

// Return the flag
ReturnFlag(f);
