/*   
**  This script shades the gaps between two curves
**
**  It assumes the curves start and end at the same x value
**  and have the same number of points
**
*/
//name: Shade curve dif

//New UI:
Window.Theme(Window.THEME_CURRENT);

// Select two curves to compare
var f = AllocateFlag();

var n = Curve.Select(f, 'Select 2 curves');

// User pressed cancel - exit script
if (!n) Exit();

// Make sure the user selected 2 curves, if not tell them and exit
if (n != 2)
{
  Window.Message("", "You need to select two curves");
  Exit();
}

// Get the 2 curves selected
var c = Curve.First();

var i = 1;

while(c)
{
  if(c.Flagged(f))
  {
    if (i==1) var c1 = c;
    if (i==2) var c2 = c;
    
    i++;
  }

  c = c.Next();
}

// Check the start and end x points are the same
if (c1.xmin != c2.xmin)
{
  Window.Message("", "The curves do not start at the same X value. Try Editing them so they do.");
  Exit();
}

if (c1.xmax != c2.xmax)
{
  Window.Message("", "The curves do not end at the same X value. Try Editing them so they do.");
  Exit();
}

// Check the curves have the same number of points
if (c1.npoints != c2.npoints)
{
  Window.Message("", "The curves have a different number of points. Try REGularising them so they do.");
  Exit();
}

// Loop over each point on the curves getting the max and min y values
var ymax = new Array();
var ymin = new Array();
var xval = new Array();

for (var i=1; i<=c1.npoints; i++)
{
  var p1 = c1.GetPoint(i);
  var p2 = c2.GetPoint(i);

  xval[i-1] = p1[0];
  
  if (p1[1] >= p2[1])
  {
    ymax[i-1] = p1[1];
    ymin[i-1] = p2[1];
  }
  else
  {
    ymax[i-1] = p2[1];
    ymin[i-1] = p1[1];
  }
}

// Now create an curve to shade the difference
var c_new = new Curve(Curve.HighestID() + 1);

for (var i=0;             i<ymax.length; i++) c_new.AddPoint(xval[i], ymax[i]);
for (var i=ymin.length-1; i>=0;          i--) c_new.AddPoint(xval[i], ymin[i]);

c_new.AddPoint(xval[0], ymin[0]);
c_new.AddPoint(xval[0], ymax[0]);
    
for (var i=1; i<ymax.length; i++)
{
  if (i % 2 == 0)
  {
    c_new.AddPoint(xval[i], ymin[i]);
    c_new.AddPoint(xval[i], ymax[i]);
  }
  else
  {
    c_new.AddPoint(xval[i], ymax[i]);
    c_new.AddPoint(xval[i], ymin[i]);
  }
}

// Give the shaded curve a label
c_new.label = "Dif between " + c1.label + " and " + c2.label;

// Plot the graph
Plot();

// Return the flag
ReturnFlag(f);
