/*   
**  This script loops through all the curves and colours them by model ID
**
*/
//name:  Colour By Model
highest_model = Model.HighestID();
num_models = Model.Total();
num_curves = Curve.HighestID();

Message("Highest Model : ",highest_model);
Message("Number of Model : ",num_models);
Message("Number of Curves : ",num_curves);

for(i=1;i<=num_curves;i++)
{
  curve = Curve.GetFromID(i);
  
  if(curve)
  {
	  model = curve.model;
  	if (model > 0)
	  {
      curve.colour = model;
  	}
	  else
	  {
      curve.colour = highest_model+1;
    }
  }
}	


Plot();



