/*   
**  This script colours curves by their maximum value.
**  It also demonstrates the use of Widgets to create GUIs.
**
*/
//name: Colour by value

//New UI:
Window.Theme(Window.THEME_CURRENT);

// Create a Window to get information from the user
var w = new Window("Colour by value", 0.8, 1.0, 0.5, 0.6);

// Button to calculate bands automatically
var idy = 6;
var iy1 = 1;
var iy2 = iy1 + idy;

var ix1 = 1;
var ix2 = 20;

var btnAuto = new Widget(w, Widget.BUTTON, ix1, ix2, iy1, iy2, "Auto Calc");
btnAuto.background = Widget.DARKBLUE;
btnAuto.foreground = Widget.WHITE;

// Add textboxes to specify the bands of values to colour the curves
var iy1 = iy2 + 2;
var iy2 = iy1 + idy;

var ix1 = 1;
var ix2  = ix1 + 6;
var ix3  = ix2 + 1;
var ix4  = ix3 + 49;
var ix5  = ix4 + 2;
var ix6  = ix5 + 20;
var ix7  = ix6 + 2;
var ix8  = ix7 + 10;
var ix9  = ix8 + 2;
var ix10 = ix9 + 20;

// Condition 1
var cbxCond1      = new Widget(w, Widget.CHECKBOX, ix1, ix2,  iy1, iy2);
var lblCond1_1    = new Widget(w, Widget.LABEL,    ix3, ix4,  iy1, iy2, "Condition 1: Max Between");
var txtCond1_low  = new Widget(w, Widget.TEXTBOX,  ix5, ix6,  iy1, iy2, "0");
var lblCond1_2    = new Widget(w, Widget.LABEL,    ix7, ix8,  iy1, iy2, "and");
var txtCond1_high = new Widget(w, Widget.TEXTBOX,  ix9, ix10, iy1, iy2, "500");
cbxCond1.pushed = true;

var cond1_low  = 0;
var cond1_high = 500;

var iy1 = iy2 + 2;
var iy2 = iy1 + idy;

// Condition 2
var cbxCond2      = new Widget(w, Widget.CHECKBOX, ix1, ix2,  iy1, iy2);
var lblCond2_1    = new Widget(w, Widget.LABEL,    ix3, ix4,  iy1, iy2, "Condition 2: Max Between");
var txtCond2_low  = new Widget(w, Widget.TEXTBOX,  ix5, ix6,  iy1, iy2, "500");
var lblCond2_2    = new Widget(w, Widget.LABEL,    ix7, ix8,  iy1, iy2, "and");
var txtCond2_high = new Widget(w, Widget.TEXTBOX,  ix9, ix10, iy1, iy2, "1000");
cbxCond2.pushed = true;

var cond2_low  = 500;
var cond2_high = 1000;

var iy1 = iy2 + 2;
var iy2 = iy1 + idy;

// Condition 3
var cbxCond3      = new Widget(w, Widget.CHECKBOX, ix1, ix2,  iy1, iy2);
var lblCond3_1    = new Widget(w, Widget.LABEL,    ix3, ix4,  iy1, iy2, "Condition 3: Max Between");
var txtCond3_low  = new Widget(w, Widget.TEXTBOX,  ix5, ix6,  iy1, iy2, "1000");
var lblCond3_2    = new Widget(w, Widget.LABEL,    ix7, ix8,  iy1, iy2, "and");
var txtCond3_high = new Widget(w, Widget.TEXTBOX,  ix9, ix10, iy1, iy2, "2000");
cbxCond3.pushed = true;

var cond3_low  = 1000;
var cond3_high = 2000;

// Exit and Apply buttons
var iy1 = iy2 + 2;
var iy2 = iy1 + idy;

var ix1 = 1;
var ix2 = 20;
var ix3 = 22;
var ix4 = 42;

var btnExit  = new Widget(w, Widget.BUTTON, ix1, ix2, iy1, iy2, "Exit");   btnExit.category = Widget.CATEGORY_CANCEL;
var btnApply = new Widget(w, Widget.BUTTON, ix3, ix4, iy1, iy2, "Apply"); btnApply.category = Widget.CATEGORY_APPLY;
btnExit.background = Widget.DARKRED;
btnExit.foreground = Widget.WHITE;
btnApply.background = Widget.DARKGREEN;
btnApply.foreground = Widget.WHITE;

// Assign callback functions
btnAuto.onClick  = auto_calc_bands;
btnExit.onClick  = do_exit;
btnApply.onClick = do_apply;
cbxCond1.onClick = condition_select;
cbxCond2.onClick = condition_select;
cbxCond3.onClick = condition_select;
txtCond1_low.onChange  = text_change;
txtCond1_high.onChange = text_change;
txtCond2_low.onChange  = text_change;
txtCond2_high.onChange = text_change;
txtCond3_low.onChange  = text_change;
txtCond3_high.onChange = text_change;

// Display the window
w.Show();

// GUI callback functions
function do_exit()
{
// Exit the script
  Exit();
}

function text_change()
{
// Updates condition values based on text in text boxes
// Does a check to make sure it is a numbers
  
  var fltTemp;
  var strTemp = this.text;

// Check it's valid  
  if (isNaN(fltTemp = parseFloat(strTemp)))
  {
    Error("Invalid number");
    return;
  }
  
// Valid number - so assign the value to the correct variable
  if (this == txtCond1_low)  cond1_low  = fltTemp;
  if (this == txtCond1_high) cond1_high = fltTemp;
  if (this == txtCond2_low)  cond2_low  = fltTemp;
  if (this == txtCond2_high) cond2_high = fltTemp;
  if (this == txtCond3_low)  cond3_low  = fltTemp;
  if (this == txtCond3_high) cond3_high = fltTemp;
}

function auto_calc_bands()
{
// Automatically calculate the conditions, based on the maximum values of each curve

// Get the boundaries
  var low  =  1e20;
  var high = -1e20;
    
// Loop over each curve and set the colour based on it's maximum value
  var c = Curve.First();
  
  while (c)
  {
    low  = Math.min(c.ymax, low);
    high = Math.max(c.ymax, high);
    
    c = c.Next();
  }

// Increment per band
  var inc = (high - low) / 3;

  cond1_low  = low;
  cond1_high = low + inc;
  cond2_low  = low + inc;
  cond2_high = low + 2 * inc;
  cond3_low  = low + 2 * inc;
  cond3_high = high;
  
  txtCond1_low.text  = cond1_low.toPrecision(4);
  txtCond1_high.text = cond1_high.toPrecision(4);
  txtCond2_low.text  = cond2_low.toPrecision(4);
  txtCond2_high.text = cond2_high.toPrecision(4);
  txtCond3_low.text  = cond3_low.toPrecision(4);
  txtCond3_high.text = cond3_high.toPrecision(4);
  
  Plot();
}

function condition_select()
{
// (Un)activate the condition widgets depending on whether checkbox is pressed

  var status;

  if (this.pushed) status = true;
  else             status = false;

  if (this == cbxCond1)
  {
    txtCond1_low.active  = status;
    txtCond1_high.active = status;
  }
  if (this == cbxCond2)
  {
    txtCond2_low.active  = status;
    txtCond2_high.active = status;
  }
  if (this == cbxCond3)
  {
    txtCond3_low.active  = status;
    txtCond3_high.active = status;
  }
}


function do_apply()
{
// Colours all the curves based on the conditions specified
   
// Loop over each curve and set the colour based on it's maximum value

  var c = Curve.First();
  
  while (c)
  {
    if (cbxCond1.pushed == true) // Condition 1 - colour GREEN
    {
      if (c.ymax >= cond1_low && c.ymax <= cond1_high)
      {
        c.colour = Colour.GREEN;
      }
    }
    
    if (cbxCond2.pushed == true) // Condition 2 - colour ORANGE
    {
      if (c.ymax > cond2_low && c.ymax <= cond2_high)
      {
        c.colour = Colour.ORANGE;
      }
    }
    
    if (cbxCond3.pushed == true) // Condition 3 - colour RED
    {
      if (c.ymax > cond3_low && c.ymax <= cond3_high)
      {
        c.colour = Colour.RED;
      }
    }
    
    c = c.Next();
  }

  Plot();
}




