/// <reference path="C:/SOURCE14/this_dir/this_js_api/this.intellisense.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common1.js" />

var REG_DT = 0.00001; // dt for regularising curves (in seconds)

var limits = {};

limits.EuroNCAP = {};
limits.JNCAP = {};
limits.KNCAP = {};
limits.GTR = {};
limits.CNCAP = {};

limits.EuroNCAP["2020"] = {};
limits.EuroNCAP["2023"] = {};
limits.JNCAP["2018"] = {};
limits.KNCAP["2019"] = {};
limits.GTR["2019"] = {};
limits.CNCAP["2021"] = {};

/* Euro NCAP */

// Femur Limits

limits.EuroNCAP["2020"].FEMUR_BENDING_MOMENT_GOOD   = 285;      // Nm
limits.EuroNCAP["2020"].FEMUR_BENDING_MOMENT_WEAK   = 350;      // Nm

limits.EuroNCAP["2020"].FEMUR_FORCE_GOOD            = 5;      // kN
limits.EuroNCAP["2020"].FEMUR_FORCE_WEAK            = 6;      // kN

limits.EuroNCAP["2020"].FEMUR_HI_SCORE              = 1.0;
limits.EuroNCAP["2020"].FEMUR_LO_SCORE              = 0.0;

// Lower Leg limits

limits.EuroNCAP["2020"].TIBIA_BENDING_MOMENT_GOOD   = 282;      // Nm
limits.EuroNCAP["2020"].TIBIA_BENDING_MOMENT_WEAK   = 340;      // Nm

limits.EuroNCAP["2020"].MCL_ELONGATION_GOOD         = 19.0;   // mm
limits.EuroNCAP["2020"].MCL_ELONGATION_WEAK         = 22.0;   // mm

limits.EuroNCAP["2020"].ACL_ELONGATION_GOOD         = 10.0;   // mm
limits.EuroNCAP["2020"].ACL_ELONGATION_WEAK         = 10.0;   // mm

limits.EuroNCAP["2020"].PCL_ELONGATION_GOOD         = 10.0;   // mm
limits.EuroNCAP["2020"].PCL_ELONGATION_WEAK         = 10.0;   // mm
limits.EuroNCAP["2020"].LOW_HI_SCORE_KNEE           = 0.5;
limits.EuroNCAP["2020"].LOW_HI_SCORE_TIBIA          = 0.5;
limits.EuroNCAP["2020"].LOW_LO_SCORE                = 0.0;

// Score maxima
limits.EuroNCAP["2020"].UPPER_MAX_POSS_SCORE              = 6.0;
limits.EuroNCAP["2020"].LOWER_MAX_POSS_SCORE              = 6.0;
limits.EuroNCAP["2020"].TIBIA_MAX_POSS_SCORE              = 0.5;
limits.EuroNCAP["2020"].KNEE_MAX_POSS_SCORE               = 0.5;
limits.EuroNCAP["2020"].LOWER_SINGLE_MAX_POSS_SCORE       = 1.00;
limits.EuroNCAP["2020"].UPPER_SINGLE_MAX_POSS_SCORE       = 1.00;
limits.EuroNCAP["2020"].MAX_POSS_SCORE                    = 12.0;

//2023 EuroNCAP

limits.EuroNCAP["2023"].FEMUR_FORCE_GOOD            = 5;      // kN
limits.EuroNCAP["2023"].FEMUR_FORCE_WEAK            = 6;      // kN

limits.EuroNCAP["2023"].FEMUR_BENDING_MOMENT_GOOD   = 390;      // Nm
limits.EuroNCAP["2023"].FEMUR_BENDING_MOMENT_WEAK   = 440;      // Nm

limits.EuroNCAP["2023"].FEMUR_HI_SCORE              = 1.0;
limits.EuroNCAP["2023"].FEMUR_LO_SCORE              = 0.0;

limits.EuroNCAP["2023"].TIBIA_BENDING_MOMENT_GOOD   = 275;      // Nm
limits.EuroNCAP["2023"].TIBIA_BENDING_MOMENT_WEAK   = 320;      // Nm

limits.EuroNCAP["2023"].LOW_HI_SCORE_TIBIA          = 1.0;
limits.EuroNCAP["2023"].LOW_HI_SCORE_KNEE           = 1.0;
limits.EuroNCAP["2023"].LOW_LO_SCORE                = 0.0;

limits.EuroNCAP["2023"].MCL_ELONGATION_GOOD         = 27.0;   // mm
limits.EuroNCAP["2023"].MCL_ELONGATION_WEAK         = 32.0;   // mm

limits.EuroNCAP["2023"].UPPER_MAX_POSS_SCORE              = 4.5;
limits.EuroNCAP["2023"].FEMUR_MAX_POSS_SCORE              = 4.5;
limits.EuroNCAP["2023"].KNEE_AND_TIBIA_MAX_POSS_SCORE     = 9.0;
limits.EuroNCAP["2023"].APLI_MAX_POSS_SCORE               = 13.5;
limits.EuroNCAP["2023"].MAX_POSS_SCORE                    = 18.0;

limits.EuroNCAP["2023"].UPPER_SINGLE_MAX_POSS_SCORE       = 1.00;

/* CNCAP */
limits.CNCAP["2021"].FEMUR_BENDING_MOMENT_GOOD   = 390;      // Nm
limits.CNCAP["2021"].FEMUR_BENDING_MOMENT_WEAK   = 440;      // Nm
limits.CNCAP["2021"].FEMUR_MAX_POSS_SCORE        = 0.4;

limits.CNCAP["2021"].FEMUR_HI_SCORE        = 0.4;
limits.CNCAP["2021"].FEMUR_LO_SCORE        = 0.0;

limits.CNCAP["2021"].TIBIA_BENDING_MOMENT_GOOD   = 275;      // Nm
limits.CNCAP["2021"].TIBIA_BENDING_MOMENT_WEAK   = 320;      // Nm
limits.CNCAP["2021"].TIBIA_MAX_POSS_SCORE        = 0.4;

limits.CNCAP["2021"].MCL_ELONGATION_GOOD         = 27.0;   // mm
limits.CNCAP["2021"].MCL_ELONGATION_WEAK         = 32.0;   // mm
limits.CNCAP["2021"].MCL_MAX_POSS_SCORE          = 0.2;

limits.CNCAP["2021"].LOW_HI_SCORE_FEMUR          = 0.4;
limits.CNCAP["2021"].LOW_HI_SCORE_TIBIA          = 0.4;
limits.CNCAP["2021"].LOW_HI_SCORE_KNEE           = 0.2;
limits.CNCAP["2021"].LOW_LO_SCORE                = 0.0;

limits.CNCAP["2021"].SINGLE_MAX_POSS_SCORE       = 1.00;

limits.CNCAP["2021"].MAX_POSS_SCORE              = 5.0;

/* JNCAP */

// No Femur Limits for JNCAP
   
// Lower Leg limits
    
limits.JNCAP["2018"].TIBIA_BENDING_MOMENT_GOOD      = 202.0;   // Nm
limits.JNCAP["2018"].TIBIA_BENDING_MOMENT_ADEQUATE  = 253.0;
limits.JNCAP["2018"].TIBIA_BENDING_MOMENT_MARGINAL  = 283.0;
limits.JNCAP["2018"].TIBIA_BENDING_MOMENT_WEAK      = 306.0;      // Nm

limits.JNCAP["2018"].MCL_ELONGATION_GOOD            = 14.8;   // mm
limits.JNCAP["2018"].MCL_ELONGATION_ADEQUATE        = 17.7;
limits.JNCAP["2018"].MCL_ELONGATION_MARGINAL        = 18.9;
limits.JNCAP["2018"].MCL_ELONGATION_WEAK            = 19.8;   // mm

limits.JNCAP["2018"].ACL_ELONGATION_GOOD            = 13.0;   // mm
limits.JNCAP["2018"].ACL_ELONGATION_WEAK            = 13.0;   // mm

limits.JNCAP["2018"].PCL_ELONGATION_GOOD            = 13.0;   // mm
limits.JNCAP["2018"].PCL_ELONGATION_WEAK            = 13.0;   // mm

limits.JNCAP["2018"].LOW_HI_SCORE_KNEE              = 0.27;
limits.JNCAP["2018"].LOW_HI_SCORE_TIBIA             = 0.73;
limits.JNCAP["2018"].LOW_LO_SCORE                   = 0.0;

// Score maxima
limits.JNCAP["2018"].UPPER_MAX_POSS_SCORE              = "N/A";
limits.JNCAP["2018"].LOWER_MAX_POSS_SCORE              = 25.0;
limits.JNCAP["2018"].TIBIA_MAX_POSS_SCORE              = 2.92;
limits.JNCAP["2018"].KNEE_MAX_POSS_SCORE               = 1.08;
limits.JNCAP["2018"].LOWER_SINGLE_MAX_POSS_SCORE       = 4.00;
limits.JNCAP["2018"].UPPER_SINGLE_MAX_POSS_SCORE       = 999; //not used in JNCAP report
limits.JNCAP["2018"].MAX_POSS_SCORE                    = 25.0;

/* KNCAP */

//Lower legform exactly the same as EuroNCAP 2019, Upper Legform different limits

// Upper Leg limits

limits.KNCAP["2019"].FEMUR_BENDING_MOMENT_GOOD   = 300;      // Nm
limits.KNCAP["2019"].FEMUR_BENDING_MOMENT_WEAK   = 510;      // Nm

limits.KNCAP["2019"].FEMUR_FORCE_GOOD            = 5.0;      // kN
limits.KNCAP["2019"].FEMUR_FORCE_WEAK            = 7.5;      // kN

limits.KNCAP["2019"].FEMUR_HI_SCORE              = 1.0;
limits.KNCAP["2019"].FEMUR_LO_SCORE              = 0.0;

// Lower Leg limits

limits.KNCAP["2019"].TIBIA_BENDING_MOMENT_GOOD   = 282;      // Nm
limits.KNCAP["2019"].TIBIA_BENDING_MOMENT_WEAK   = 340;      // Nm

limits.KNCAP["2019"].MCL_ELONGATION_GOOD         = 19.0;   // mm
limits.KNCAP["2019"].MCL_ELONGATION_WEAK         = 22.0;   // mm

limits.KNCAP["2019"].ACL_ELONGATION_GOOD         = 10.0;   // mm
limits.KNCAP["2019"].ACL_ELONGATION_WEAK         = 10.0;   // mm

limits.KNCAP["2019"].PCL_ELONGATION_GOOD         = 10.0;   // mm
limits.KNCAP["2019"].PCL_ELONGATION_WEAK         = 10.0;   // mm
limits.KNCAP["2019"].LOW_HI_SCORE_KNEE           = 0.5;
limits.KNCAP["2019"].LOW_HI_SCORE_TIBIA          = 0.5;
limits.KNCAP["2019"].LOW_LO_SCORE                = 0.0;


// Score maxima
limits.KNCAP["2019"].UPPER_MAX_POSS_SCORE              = 6.0;
limits.KNCAP["2019"].LOWER_MAX_POSS_SCORE              = 6.0;
limits.KNCAP["2019"].TIBIA_MAX_POSS_SCORE              = 0.5;
limits.KNCAP["2019"].KNEE_MAX_POSS_SCORE               = 0.5;
limits.KNCAP["2019"].MAX_POSS_SCORE                    = 12.0;
limits.KNCAP["2019"].LOWER_SINGLE_MAX_POSS_SCORE    = 1.00;
limits.KNCAP["2019"].UPPER_SINGLE_MAX_POSS_SCORE    = 1.00;

/* GTR */

// Upper Leg limits

limits.GTR["2019"].FEMUR_BENDING_MOMENT_GOOD   = 510;      // Nm
limits.GTR["2019"].FEMUR_BENDING_MOMENT_WEAK   = 510;      // Nm

limits.GTR["2019"].FEMUR_FORCE_GOOD            = 7.5;      // kN
limits.GTR["2019"].FEMUR_FORCE_WEAK            = 7.5;      // kN

limits.GTR["2019"].FEMUR_HI_SCORE              = "PASS";
limits.GTR["2019"].FEMUR_LO_SCORE              = "FAIL";



// Lower Leg limits

limits.GTR["2019"].TIBIA_BENDING_MOMENT_GOOD   = 340;      // Nm
limits.GTR["2019"].TIBIA_BENDING_MOMENT_WEAK   = 380;      // Nm

limits.GTR["2019"].MCL_ELONGATION_GOOD         = 22.0;   // mm
limits.GTR["2019"].MCL_ELONGATION_WEAK         = 22.0;   // mm

limits.GTR["2019"].ACL_ELONGATION_GOOD         = 13.0;   // mm
limits.GTR["2019"].ACL_ELONGATION_WEAK         = 13.0;   // mm

limits.GTR["2019"].PCL_ELONGATION_GOOD         = 13.0;   // mm
limits.GTR["2019"].PCL_ELONGATION_WEAK         = 13.0;   // mm
limits.GTR["2019"].LOW_HI_SCORE_KNEE           = "PASS";
limits.GTR["2019"].LOW_HI_SCORE_TIBIA          = "PASS";
limits.GTR["2019"].LOW_LO_SCORE                = "FAIL";

// Score maxima
limits.GTR["2019"].UPPER_MAX_POSS_SCORE              = 6.0;
limits.GTR["2019"].LOWER_MAX_POSS_SCORE              = 6.0;
limits.GTR["2019"].TIBIA_MAX_POSS_SCORE              = 0.5;
limits.GTR["2019"].KNEE_MAX_POSS_SCORE               = 0.5;
limits.GTR["2019"].MAX_POSS_SCORE                    = 12.0;
limits.GTR["2019"].LOWER_SINGLE_MAX_POSS_SCORE    = 1.00;
limits.GTR["2019"].UPPER_SINGLE_MAX_POSS_SCORE    = 1.00;


var legform_data = limits[template_reg][template_year];
