/* When REPORTER has the Use() function it would be better to change the
 * "termination.js" script to include this script and use the same function.
 */

function TerminationStatus(otf_filename)
// Function that obtains Normal or Error termination from OTF file
// Returns "Normal termination", "Error termination", or "file incomplete, possible error"
{
    for (var i=1; i<99; i++)
    {
        var nstring = i.toString();
        if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
        var test_filename = otf_filename + nstring;
        if (File.Exists(test_filename))
            otf_filename = test_filename;
        else
            break;
    }

    var line;
    var match_regex  = new RegExp("\\s+(.*)\\s+t e r m i n a t i o n");
    var result;
    var message;

    // We do 2 passes (if required). On the 1st pass try reading the last 5000 bytes in the file
    // to see if the data is there. If it isn't we do a 2nd pass starting from the beginning of
    // the file.
    var start_pass = 1;
    var finished   = false;

    // Get file size and subtract 5000 from it for position to start read from
    var size = File.Size(otf_filename) - 5000;
    if (size < 0) start_pass = 2;

    for (var pass=start_pass; pass<=2; pass++)
    {
        var otf_file = new File(otf_filename, File.READ);

    // Jump to the start position if 1st pass
        if (pass == 1) otf_file.Seek(size);

        while ( (line = otf_file.FindLineContaining("t e r m i n a t i o n") ) != File.EOF)
        {
            if ((result = line.match(match_regex)) != null)
            {
                message = result[1];
                message = message.replace(/\s+/g, "");
                finished = true;
                break;
            }
        }

        otf_file.Close();

        if (finished) break;
    }

    if (finished == false) message = "file incomplete, possible error";

    return message;
}
