// memory: 1000
//THIS SCRIPT IS CALLED BY REPORTER TEMPLATES IN A  "reporter template script"
//THIS SCRIPT   (the "master script") REQUIRES THE FOLLOWING VARIABLES TO BE DEFINED in the reporter template script:
// input_variables - array - a list of variable names (strings)
// w_title  -  string - title to be used for the GUI
// key_name - string - file name of the key file to be read in (including path)
// csv_fname - string - default csv file name for outputting the variable ids to


//LOGIC OF THE SCRIPT
// Variables are split into "occupant" and "non-occupant" variables. An occupant variable is one with "Driver"/"passenger" etc in the name.
// Occupant variables are added first. These are added in columns. If there are 2 occupants, then there will be two columns -e.g. one for driver variables, one for passenger variables
// The order that the occupant variables appear on the screen is goverened by their "subset" - HEAD/NECK/TORSO etc. A heading is put between each subset in the GUI
// Within each subset, the order of the variables is the order that they are defined in the reporter template script
//
// Within the occupant variables section, a row can contain a variable for each occupant, but it must be the same variable appart from the occupant bit - i.e. if a row has "DRIVER_HEAD_NODE" in it,
// then the only other variable which can be in that row is "PASSENGER_HEAD_NODE"
//
//Next the non-occupant variables are added. These are added below the occupant variables. The variables are split into x columns where x is the number of occupants used above.

// Increase the max number of widgets permitted to account for when a model contains many DATABASE_HISTORY cards:
Options.max_widgets = 10000;

// New UI:
Window.Theme(Window.THEME_CURRENT);
//
// Need to write a file to say we've not selected all the info yet.
// This will get deleted if/when the user saves the required data.
var fNoData = new File(no_data_fname, File.WRITE);
fNoData.Close();

if (typeof(min_columns) == "undefined") var min_columns = 2;
if (typeof(uses_list_file) == "undefined") var uses_list_file =false;
if (typeof(read_key) == "undefined") var read_key =true;
var split_name = csv_fname.split("/");
if (split_name[split_name.length-1] == "") csv_fname = csv_fname + "inputs_for_reporter.csv";
var dont_write_variables = ["ELEMENT_NUMBER_CSV","OFFSET_FOR_IDS", "IDS_FROM_CSV"];

if(uses_list_file)
{
    if(File.Exists(fname_lst_orig) && File.IsFile(fname_lst_orig))
    {
        var f_lst_orig = new File(fname_lst_orig, File.READ);
        var models       = [];
        var comments     = [];
        var non_comments = [];
        var line
        while ( (line = f_lst_orig.ReadLine()) != undefined)
        {
            if(line[0] != '$')
            {
// Lines with no '$' are comma separated -> <fname>,<template_name>,<zone_name>,....
// We just want the value in the first column.
                var list = line.split(",");
                models.push(list[0]);
                non_comments.push(line);  // store full line
            }
            else
            {
// For lines beginning with '$', store it if it's not one of the variables we are 
// getting from the user here.
                var list = line.split(",");
                if(list[0] != '$UNIT_LENGTH' &&
                    list[0] != '$UNIT_MASS'   &&
                    list[0] != '$UNIT_TIME'   &&

                    list[0] != '$ADULT_HEAD_NODE_ID' &&
                    list[0] != '$ADULT_HEAD_NODE_ID_Y'&&
                    list[0] != '$ADULT_HEAD_NODE_ID_Z'&&

                    list[0] != '$CHILD_HEAD_NODE_ID' &&
                    list[0] != '$CHILD_HEAD_NODE_ID_Y'&&
                    list[0] != '$CHILD_HEAD_NODE_ID_Z'&&
                    
                    list[0] != '$SPRING1_ID'  &&
                    list[0] != '$SPRING2_ID')
                {
                    comments.push(line);
                }
            }
        }
        f_lst_orig.Close();
    }

// Attempt to read in the first model and exit from the script if unsuccessful.

    var m;
    if(models.length > 0) m = Model.Read(models[0]);

    if(!m)
    {
        Window.Message("", "Could not read in model. Unable to continue");
        Exit();
    }

}
else
{
    if (read_key == true) var m = Model.Read(key_name);
    var m = Model.Select("Select a model");
}

var possible_variables = [];
var w_title = "Variable import for reporter";

//Make list of possible occupants- many variables will be added for all possible occupants
var possible_occupants = ["Driver","Front Passenger","Rear Passenger","Passenger"];
var possible_subsets   = ["DUMMY", "HEAD","NECK","TORSO","LOWER BODY","OTHER","UNITS","STRUCTURE" ];

var occupant_prefixes = [];
for(i = 0; i < possible_occupants.length; i++)
{
    occupant_prefixes.push(possible_occupants[i].toString().split(' ').join('_').toUpperCase());
}

//Add all possible variables to an array

//TO ADD A NEW VARIABLE:
//1. add a new line with  add_to_array() and the appropriate arugments
//     i) - if it is an occupant variable (i.e. variable name contains "DRIVER" or "PASSENGER" etc - add it directly below here within the for loop
//       ii) - if it isn't, add it below the for loop

//TO ADD A NEW SUBSET
// Add it to the list of "possible_subsets"

for(i = 0; i < occupant_prefixes.length; i++)
{
    add_to_array("Dummy",occupant_prefixes[i]+"_DUMMY","String",[], occupant_prefixes[i], "DUMMY");
    add_to_array("Head Node (X-accelerometer)",occupant_prefixes[i]+"_HEAD_NODE","ID","Node",occupant_prefixes[i], "HEAD");
    add_to_array("Head Node (Y-accelerometer)",occupant_prefixes[i]+"_HEAD_NODE_Y","ID","Node", occupant_prefixes[i], "HEAD");
    add_to_array("Head Node (Z-accelerometer)",occupant_prefixes[i]+"_HEAD_NODE_Z","ID","Node", occupant_prefixes[i], "HEAD");
    add_to_array("Neck Loadcell (Beam)",occupant_prefixes[i]+"_NECK_LOADCELL","ID","Beam", occupant_prefixes[i], "NECK");
    add_to_array("Chest Node (X Accn)",occupant_prefixes[i]+"_CHEST_NODE_X","ID","Node", occupant_prefixes[i], "TORSO");
    add_to_array("Chest Node (Y Accn)",occupant_prefixes[i]+"_CHEST_NODE_Y","ID","Node", occupant_prefixes[i], "TORSO");
    add_to_array("Chest Node (Z Accn)",occupant_prefixes[i]+"_CHEST_NODE_Z","ID","Node",occupant_prefixes[i], "TORSO");
    add_to_array("Left Knee Transducer (Spring)",occupant_prefixes[i]+"_LEFT_KNEE_TRANSDUCER","ID","Spring", occupant_prefixes[i], "LOWER BODY");
    add_to_array("Right Knee Transducer (Spring)",occupant_prefixes[i]+"_RIGHT_KNEE_TRANSDUCER","ID","Spring", occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Femur Loadcell (Beam)",occupant_prefixes[i]+"_LEFT_FEMUR_LOADCELL","ID","Beam", occupant_prefixes[i], "LOWER BODY");
    add_to_array("Right Femur Loadcell (Beam)",occupant_prefixes[i]+"_RIGHT_FEMUR_LOADCELL","ID","Beam", occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Upper Tibia Loadcell (Beam)",occupant_prefixes[i]+"_LEFT_UPPER_TIBIA_LOADCELL","ID","Beam", occupant_prefixes[i], "LOWER BODY");
    add_to_array("Right Upper Tibia Loadcell (Beam)",occupant_prefixes[i]+"_RIGHT_UPPER_TIBIA_LOADCELL","ID","Beam", occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Lower Tibia Loadcell (Beam)",occupant_prefixes[i]+"_LEFT_LOWER_TIBIA_LOADCELL","ID","Beam", occupant_prefixes[i], "LOWER BODY");
    add_to_array("Right Lower Tibia Loadcell (Beam)",occupant_prefixes[i]+"_RIGHT_LOWER_TIBIA_LOADCELL","ID","Beam",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Shoulder Deflection (Spring)",occupant_prefixes[i]+"_SHOULDER_TRANSDUCER","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Top Thorax Rib Deflection (Spring)",occupant_prefixes[i]+"_TOP_THORAX_TRANSDUCER","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Middle Thorax Rib Deflection (Spring)",occupant_prefixes[i]+"_MIDDLE_THORAX_TRANSDUCER","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Bottom Thorax Rib Deflection (Spring)",occupant_prefixes[i]+"_BOTTOM_THORAX_TRANSDUCER","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Top Abdomen Rib Deflection (Spring)",occupant_prefixes[i]+"_TOP_ABDOMEN_TRANSDUCER","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Bottom Abdomen Rib Deflection (Spring)",occupant_prefixes[i]+"_BOTTOM_ABDOMEN_TRANSDUCER","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Left Femur Loadcell (Beam)",occupant_prefixes[i]+"_BOTTOM_FEMUR_BEAM","ID","Beam",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Upper Femur Loadcell (Beam)",occupant_prefixes[i]+"_UPPER_FEMUR_BEAM","ID","Beam",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Loadcell (Beam)",occupant_prefixes[i]+"_NECK_BEAM","ID","Beam",occupant_prefixes[i], "NECK");
    add_to_array("Chest Transducer (Spring)",occupant_prefixes[i]+"_CHEST_SPRING","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Chest Transducer (Spring)",occupant_prefixes[i]+"_CHEST_TRANSDUCER","ID","Spring",occupant_prefixes[i], "TORSO");      // we can remove this if we chnage the this_IIHS_Front_Impact_common.js for the chest
    add_to_array("Left Femur Loadcell (Beam)",occupant_prefixes[i]+"_LEFT_FEMUR_BEAM","ID","Beam",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Right Femur Loadcell (Beam)",occupant_prefixes[i]+"_RIGHT_FEMUR_BEAM","ID","Beam",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Upper Rib Deflection (Spring)",occupant_prefixes[i]+"_CHEST_SPRING_UPP","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Front Abdomen Force (Beam)",occupant_prefixes[i]+"_ABDOMEN_BEAM_FRNT","ID","Beam",occupant_prefixes[i], "TORSO");
    add_to_array("Middle Rib Deflection (Spring)",occupant_prefixes[i]+"_CHEST_SPRING_MID","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Middle Abdomen Force (Beam)",occupant_prefixes[i]+"_ABDOMEN_BEAM_MID","ID","Beam",occupant_prefixes[i], "TORSO");
    add_to_array("Lower Rib Deflection (Spring)",occupant_prefixes[i]+"_CHEST_SPRING_LOW","ID","Spring",occupant_prefixes[i], "TORSO");
    add_to_array("Back Abdomen Force (Beam)",occupant_prefixes[i]+"_ABDOMEN_BEAM_BACK","ID","Beam",occupant_prefixes[i], "TORSO");
    add_to_array("Pubic Symphysis Loadcell (Beam)",occupant_prefixes[i]+"_PUBIC_SYMPHYSIS_BEAM","ID","Beam",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Acetabular Loadcell (Xsec)","XSECTION_"+occupant_prefixes[i]+"_ACETABULAR_ID","ID","Xsec",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Iliac Loadcell (Xsec)","XSECTION_"+occupant_prefixes[i]+"_ILIAC_ID","ID","Xsec",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Iliac Loadcell (Xsec)", occupant_prefixes[i]+"_XSECTION_ILIAC_ID","ID","Xsec",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Acetabular Loadcell (Xsec)", occupant_prefixes[i]+"_XSECTION_ACETABULAR_ID","ID","Xsec",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Left Foot Node",occupant_prefixes[i]+"_LEFT_FOOT_NODE","ID","Node",occupant_prefixes[i], "LOWER BODY");
    add_to_array("Right Foot Node",occupant_prefixes[i]+"_RIGHT_FOOT_NODE","ID","Node",occupant_prefixes[i], "LOWER BODY");
    add_to_array("(X)  Footrest Intrusion Spring",occupant_prefixes[i]+"_FOOTREST_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Footrest Intrusion Spring",occupant_prefixes[i]+"_FOOTREST_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Footrest Intrusion Spring",occupant_prefixes[i]+"_FOOTREST_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Left Toepan Intrusion Spring",occupant_prefixes[i]+"_LEFT_TOEPAN_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Left Toepan Intrusion Spring",occupant_prefixes[i]+"_LEFT_TOEPAN_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Left Toepan Intrusion Spring",occupant_prefixes[i]+"_LEFT_TOEPAN_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Right Toepan Intrusion Spring",occupant_prefixes[i]+"_RIGHT_TOEPAN_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Right Toepan Intrusion Spring",occupant_prefixes[i]+"_RIGHT_TOEPAN_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Right Toepan Intrusion Spring",occupant_prefixes[i]+"_RIGHT_TOEPAN_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Center Toepan Intrusion Spring",occupant_prefixes[i]+"_CENTER_TOEPAN_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Center Toepan Intrusion Spring",occupant_prefixes[i]+"_CENTER_TOEPAN_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Center Toepan Intrusion Spring",occupant_prefixes[i]+"_CENTER_TOEPAN_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Upper Dash Intrusion Spring",occupant_prefixes[i]+"_UPPER_DASH_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Upper Dash Intrusion Spring",occupant_prefixes[i]+"_UPPER_DASH_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Upper Dash Intrusion Spring",occupant_prefixes[i]+"_UPPER_DASH_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Center Dash Intrusion Spring",occupant_prefixes[i]+"_CENTER_DASH_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Center Dash Intrusion Spring",occupant_prefixes[i]+"_CENTER_DASH_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Center Dash Intrusion Spring",occupant_prefixes[i]+"_CENTER_DASH_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Left Lower Dash Intrusion Spring",occupant_prefixes[i]+"_LEFT_LOWER_DASH_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Left Lower Dash Intrusion Spring",occupant_prefixes[i]+"_LEFT_LOWER_DASH_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Left Lower Dash Intrusion Spring",occupant_prefixes[i]+"_LEFT_LOWER_DASH_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Right Lower Dash Intrusion Spring",occupant_prefixes[i]+"_RIGHT_LOWER_DASH_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Right Lower Dash Intrusion Spring",occupant_prefixes[i]+"_RIGHT_LOWER_DASH_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Right Lower Dash Intrusion Spring",occupant_prefixes[i]+"_RIGHT_LOWER_DASH_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Lower Hinge 1 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_1_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Lower Hinge 1 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_1_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Lower Hinge 1 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_1_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Lower Hinge 2 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_2_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Lower Hinge 2 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_2_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Lower Hinge 2 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_2_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Lower Hinge 3 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_3_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Lower Hinge 3 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_3_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Lower Hinge 3 Intrusion Spring",occupant_prefixes[i]+"_LOWER_HINGE_3_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Upper Hinge 1 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_1_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Upper Hinge 1 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_1_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Upper Hinge 1 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_1_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Upper Hinge 2 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_2_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Upper Hinge 2 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_2_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Upper Hinge 2 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_2_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(X)  Upper Hinge 3 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_3_INTRUSION_SPRING_X","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Upper Hinge 3 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_3_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Z)  Upper Hinge 3 Intrusion Spring",occupant_prefixes[i]+"_UPPER_HINGE_3_INTRUSION_SPRING_Z","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Rocker Panel 1 Intrusion Spring",occupant_prefixes[i]+"_ROCKER_PANEL_1_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Rocker Panel 2 Intrusion Spring",occupant_prefixes[i]+"_ROCKER_PANEL_2_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
    add_to_array("(Y)  Rocker Panel 3 Intrusion Spring",occupant_prefixes[i]+"_ROCKER_PANEL_3_INTRUSION_SPRING_Y","ID","Spring",occupant_prefixes[i],"STRUCTURE");
}

//NON-OCCUPANT VARIABLES
add_to_array("Chest Left Upper Transducer (Spring)","DRIVER_CHEST_COMPRESSION_UPPER_LEFT","ID","Spring", "DRIVER", "TORSO");
add_to_array("Chest Right Upper Transducer (Spring)","DRIVER_CHEST_COMPRESSION_UPPER_RIGHT","ID","Spring", "DRIVER", "TORSO");
add_to_array("Chest Left Lower Transducer (Spring)","DRIVER_CHEST_COMPRESSION_LOWER_LEFT","ID","Spring", "DRIVER", "TORSO");
add_to_array("Chest Right Lower Transducer (Spring)","DRIVER_CHEST_COMPRESSION_LOWER_RIGHT","ID","Spring", "DRIVER", "TORSO");
// For with reference to the "HUMANETICS_THOR_50M_EuroNCAP_V1.8 " dummy nodes are used to track the IR-TRACC real-time length change or the ribs compression
add_to_array("Chest Left Upper IR-TRACC (node1)","DRIVER_CHEST_COMPRESSION_UPPER_LEFT_NODE_1","ID","Node", "DRIVER", "TORSO");
add_to_array("Chest Left Upper IR-TRACC (node2)","DRIVER_CHEST_COMPRESSION_UPPER_LEFT_NODE_2","ID","Node", "DRIVER", "TORSO");
add_to_array("Chest Left Lower IR-TRACC (node1)","DRIVER_CHEST_COMPRESSION_LOWER_LEFT_NODE_1","ID","Node", "DRIVER", "TORSO");
add_to_array("Chest Left Lower IR-TRACC (node2)","DRIVER_CHEST_COMPRESSION_LOWER_LEFT_NODE_2","ID","Node", "DRIVER", "TORSO");
add_to_array("Chest Right Upper IR-TRACC (node1)","DRIVER_CHEST_COMPRESSION_UPPER_RIGHT_NODE_1","ID","Node", "DRIVER", "TORSO");
add_to_array("Chest Right Upper IR-TRACC (node2)","DRIVER_CHEST_COMPRESSION_UPPER_RIGHT_NODE_2","ID","Node", "DRIVER", "TORSO");
add_to_array("Chest Right Lower IR-TRACC (node1)","DRIVER_CHEST_COMPRESSION_LOWER_RIGHT_NODE_1","ID","Node", "DRIVER", "TORSO");
add_to_array("Chest Right Lower IR-TRACC (node2)","DRIVER_CHEST_COMPRESSION_LOWER_RIGHT_NODE_2","ID","Node", "DRIVER", "TORSO");
add_to_array("Abdomen Left IR-TRACC (node1)","DRIVER_ABDOMEN_COMPRESSION_LEFT_NODE_1","ID","Node", "DRIVER", "TORSO");
add_to_array("Abdomen Left IR-TRACC (node2)","DRIVER_ABDOMEN_COMPRESSION_LEFT_NODE_2","ID","Node", "DRIVER", "TORSO");
add_to_array("Abdomen Right IR-TRACC (node1)","DRIVER_ABDOMEN_COMPRESSION_RIGHT_NODE_1","ID","Node", "DRIVER", "TORSO");
add_to_array("Abdomen Right IR-TRACC (node2)","DRIVER_ABDOMEN_COMPRESSION_RIGHT_NODE_2","ID","Node", "DRIVER", "TORSO");

// This is not used in function "do_chest_rating_calc_CNCAP" of calculation js yet. 
add_to_array("Abdomen Left Transducer (Spring)","DRIVER_ABDOMEN_COMPRESSION_LEFT","ID","Spring", "DRIVER", "TORSO");
add_to_array("Abdomen Right Transducer (Spring)","DRIVER_ABDOMEN_COMPRESSION_RIGHT","ID","Spring", "DRIVER", "TORSO");

add_to_array("Left Pelvis Force (Xsec)","DRIVER_LEFT_ACETABULUM_LOADCELL","ID","Xsec","DRIVER", "LOWER BODY");
add_to_array("Right Pelvis Force (Xsec)","DRIVER_RIGHT_ACETABULUM_LOADCELL","ID","Xsec","DRIVER", "LOWER BODY");
add_to_array("Chest Transducer (Spring)","PASSENGER_CHEST_TRANSDUCER","ID","Spring", "PASSENGER", "TORSO");

add_to_array("Dummy", "DUMMY","String",[],"none","DUMMY");
add_to_array("A-Pillar Intrusion Spring","A_PILLAR_INTRUSION_SPRING","ID","Spring","none","OTHER");
add_to_array("(X) Steering Column Intrusion Spring","STEERING_COL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Z) Steering Column Intrusion Spring","STEERING_COL_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Acceleration Pedal Intrusion Spring","ACCN_PEDAL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Z) Acceleration Pedal Intrusion Spring","ACCN_PEDAL_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Brake Pedal Intrusion Spring","BRAKE_PEDAL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Z) Brake Pedal Intrusion Spring","BRAKE_PEDAL_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Clutch Pedal Intrusion Spring","CLUTCH_PEDAL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Z) Clutch Pedal Intrusion Spring","CLUTCH_PEDAL_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("Model Length Unit","UNIT_LENGTH","String",["mm", "cm", "m", "inch", "ft"],"none","UNITS");
add_to_array("Model Mass Unit","UNIT_MASS","String",["tonne", "kg", "lb", "slug", "gm"],"none","UNITS");
add_to_array("Model Time Unit","UNIT_TIME","String",["s", "ms", "us"],"none","UNITS");
add_to_array("Steering Wheel Airbag","STEERING_WHEEL_AIRBAG","String",["Yes", "No"],"none","OTHER");
add_to_array("(Y) Steering Column Intrusion Spring","STEERING_COL_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("Head node (X-accelerometer)","ADULT_HEAD_NODE_ID","ID","Node","none","HEAD");
add_to_array("Head node (Y-accelerometer)","ADULT_HEAD_NODE_ID_Y","ID","Node","none","HEAD");
add_to_array("Head node (Z-accelerometer)","ADULT_HEAD_NODE_ID_Z","ID","Node","none","HEAD");
add_to_array("Head node (X-accelerometer)","CHILD_HEAD_NODE_ID","ID","Node","none","HEAD");
add_to_array("Head node (Y-accelerometer)","CHILD_HEAD_NODE_ID_Y","ID","Node","none","HEAD");
add_to_array("Head node (Z-accelerometer)","CHILD_HEAD_NODE_ID_Z","ID","Node","none","HEAD");
add_to_array("Tibia Acceleration (Node)","TIBIA_NODE_ID","ID","Node","none","LOWER BODY");
add_to_array("Knee Displacement (Spring)","KNEE_DISPLACEMENT_SPRING_ID","ID","Spring","none","LOWER BODY");
add_to_array("Knee Angle (Spring)","KNEE_ANGLE_SPRING_ID","ID","Spring","none","LOWER BODY");
add_to_array("Upper Femur Force (Beam)","BEAM_FEMUR1_ID","ID","Beam","none","LOWER BODY");
add_to_array("Lower Femur Force (Beam)","BEAM_FEMUR2_ID","ID","Beam","none","LOWER BODY");
add_to_array("Upper Femur Moment (Xsec)","XSECTION_FEMUR_UPPER_ID","ID","Xsec","none","LOWER BODY");
add_to_array("Centre Femur Moment (Xsec)","XSECTION_FEMUR_CENTRE_ID","ID","Xsec","none","LOWER BODY");
add_to_array("Lower Femur Moment (Xsec)","XSECTION_FEMUR_LOWER_ID","ID","Xsec","none","LOWER BODY");
add_to_array("Upper Tibia Moment (Xsec)","XSECTION_TIBIA_UPPER_ID","ID","Xsec","none","LOWER BODY");
add_to_array("Mid-Upper Tibia Moment (Xsec)","XSECTION_TIBIA_MID_UPPER_ID","ID","Xsec","none","LOWER BODY");
add_to_array("Mid-Lower Tibia Moment (Xsec)","XSECTION_TIBIA_MID_LOWER_ID","ID","Xsec","none","LOWER BODY");
add_to_array("Lower Tibia Moment (Xsec)","XSECTION_TIBIA_LOWER_ID","ID","Xsec","none","LOWER BODY");
add_to_array("PCL Displacement (Spring)","SPRING_PCL_ID","ID","Spring","none","LOWER BODY");
add_to_array("ACL Displacement (Spring)","SPRING_ACL_ID","ID","Spring","none","LOWER BODY");
add_to_array("MCL Displacement (Spring)","SPRING_MCL_ID","ID","Spring","none","LOWER BODY");
add_to_array("Head Node (X-accelerometer)","HEAD_NODE","ID","Node","none","HEAD");
add_to_array("Head Node (Y-accelerometer)","HEAD_NODE_Y","ID","Node","none","HEAD");
add_to_array("Head Node (Z-accelerometer)","HEAD_NODE_Z","ID","Node","none","HEAD");
add_to_array("Chest Upper Rib Transducer (Spring)","CHEST_UPPER_RIB_SPRING","ID","Spring","none","TORSO");
add_to_array("Chest Middle Rib Transducer (Spring)","CHEST_MIDDLE_RIB_SPRING","ID","Spring","none","TORSO");
add_to_array("Chest Lower Rib Transducer (Spring)","CHEST_BOTTOM_RIB_SPRING","ID","Spring","none","TORSO");
add_to_array("Abdomen measurement method","ABDOMEN_FORCE_METHOD","String",["Beam", "Contact"],"none","TORSO");
add_to_array("Abdomen Front Loadcell (Beam)","ABDOMEN_FORCE_FRONT_BEAM","ID","Beam","none","TORSO");
add_to_array("Abdomen Middle Loadcell (Beam)","ABDOMEN_FORCE_MID_BEAM","ID","Beam","none","TORSO");
add_to_array("Abdomen Rear Loadcell (Beam)","ABDOMEN_FORCE_REAR_BEAM","ID","Beam","none","TORSO");
add_to_array("Pelvis Loadcell (Beam)","PELVIS_BEAM","ID","Beam","none","LOWER BODY");
add_to_array("T12 Loadcell (Beam)","T12_BEAM","ID","Beam","none","TORSO");
add_to_array("Back Plate Loadcell (Beam)","BACK_PLATE_BEAM","ID","Beam","none","TORSO");
add_to_array("Shoulder Loadcell (Beam)","SHOULDER_BEAM","ID","Beam","none","TORSO");
add_to_array("Femur Loadcell - Struck Side (Beam)","FEMUR_BEAM","ID","Beam","none","LOWER BODY");
add_to_array("Left Shoulder Loadcell (Beam)","SHOULDER_LEFT_BEAM","ID","Beam","none","TORSO");
add_to_array("Right Shoulder Loadcell (Beam)","SHOULDER_RIGHT_BEAM","ID","Beam","none","TORSO");
add_to_array("Chest Upper Rib Rotation Transducer (Spring)","CHEST_UPPER_RIB_SPRING_ROT","ID","Spring","none","TORSO");
add_to_array("Chest Middle Rib Rotation Transducer (Spring)","CHEST_MIDDLE_RIB_SPRING_ROT","ID","Spring","none","TORSO");
add_to_array("Chest Lower Rib Rotation Transducer (Spring)","CHEST_BOTTOM_RIB_SPRING_ROT","ID","Spring","none","TORSO");
add_to_array("Chest Upper Rib Deflection Transducer (Spring)","CHEST_UPPER_RIB_SPRING_TRANS","ID","Spring","none","TORSO");
add_to_array("Chest Middle Rib Deflection Transducer (Spring)","CHEST_MIDDLE_RIB_SPRING_TRANS","ID","Spring","none","TORSO");
add_to_array("Chest Lower Rib Deflection Transducer (Spring)","CHEST_BOTTOM_RIB_SPRING_TRANS","ID","Spring","none","TORSO");
add_to_array("Upper Abdomen Rotation Transducer (Spring)","ABDOMEN_UPPER_SPRING_ROT","ID","Spring","none","TORSO");
add_to_array("Lower Abdomen Rotation Transducer (Spring)","ABDOMEN_LOWER_SPRING_ROT","ID","Spring","none","TORSO");
add_to_array("Upper Abdomen Deflection Transducer (Spring)","ABDOMEN_UPPER_SPRING_TRANS","ID","Spring","none","TORSO");
add_to_array("Lower Abdomen Deflection Transducer (Spring)","ABDOMEN_LOWER_SPRING_TRANS","ID","Spring","none","TORSO");
add_to_array("Vehicle Impact","VEHICLE_IMPACT","String",["Front Impact", "Side Impact"],"none","OTHER");
add_to_array("Ref Node 1","REF_NODE_1","ID","Node_no_hist","none","OTHER");
add_to_array("Ref Node 2","REF_NODE_2","ID","Node_no_hist","none","OTHER");
add_to_array("Ref Node 3","REF_NODE_3","ID","Node_no_hist","none","OTHER");
add_to_array("(X) Footrest Intrusion Spring","FOOTREST_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Footrest Intrusion Spring","FOOTREST_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Footrest Intrusion Spring","FOOTREST_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Left Toepan Intrusion Spring","LEFT_TOEPAN_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Left Toepan Intrusion Spring","LEFT_TOEPAN_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Left Toepan Intrusion Spring","LEFT_TOEPAN_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Centre Toepan Intrusion Spring","CENTRE_TOEPAN_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Centre Toepan Intrusion Spring","CENTRE_TOEPAN_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Centre Toepan Intrusion Spring","CENTRE_TOEPAN_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Right Toepan Intrusion Spring","RIGHT_TOEPAN_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Right Toepan Intrusion Spring","RIGHT_TOEPAN_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Right Toepan Intrusion Spring","RIGHT_TOEPAN_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(Y) Brake Pedal Intrusion Spring","BRAKE_PEDAL_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(X) Left Inst Panel Intrusion Spring","LEFT_INST_PANEL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(X) Right Inst Panel Intrusion Spring","RIGHT_INST_PANEL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(X) Door Intrusion Spring","DOOR_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(X) Steering Column Intrusion Spring","STEERING_COLUMN_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(X) Inst Panel Intrusion Spring","INSTRUMENT_PANEL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Inst Panel Intrusion Spring","INSTRUMENT_PANEL_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Inst Panel Intrusion Spring","INSTRUMENT_PANEL_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Parking Brake Pedal Intrusion Spring","PARKING_BRAKE_PEDAL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Parking Brake Pedal Intrusion Spring","PARKING_BRAKE_PEDAL_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Parking Brake Pedal Intrusion Spring","PARKING_BRAKE_PEDAL_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Toepan Intrusion Spring","TOEPAN_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Toepan Intrusion Spring","TOEPAN_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Toepan Intrusion Spring","TOEPAN_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Upper Dash Intrusion Spring","UPPER_DASH_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Upper Dash Intrusion Spring","UPPER_DASH_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Upper Dash Intrusion Spring","UPPER_DASH_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Lower Hinge 1 Intrusion Spring","LOWER_HINGE_1_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Lower Hinge 1 Intrusion Spring","LOWER_HINGE_1_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Lower Hinge 1 Intrusion Spring","LOWER_HINGE_1_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Lower Hinge 2 Intrusion Spring","LOWER_HINGE_2_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Lower Hinge 2 Intrusion Spring","LOWER_HINGE_2_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Lower Hinge 2 Intrusion Spring","LOWER_HINGE_2_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Lower Hinge 3 Intrusion Spring","LOWER_HINGE_3_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Lower Hinge 3 Intrusion Spring","LOWER_HINGE_3_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Lower Hinge 3 Intrusion Spring","LOWER_HINGE_3_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Upper Hinge 1 Intrusion Spring","UPPER_HINGE_1_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Upper Hinge 1 Intrusion Spring","UPPER_HINGE_1_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Upper Hinge 1 Intrusion Spring","UPPER_HINGE_1_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Upper Hinge 2 Intrusion Spring","UPPER_HINGE_2_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Upper Hinge 2 Intrusion Spring","UPPER_HINGE_2_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Upper Hinge 2 Intrusion Spring","UPPER_HINGE_2_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(X) Upper Hinge 3 Intrusion Spring","UPPER_HINGE_3_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Upper Hinge 3 Intrusion Spring","UPPER_HINGE_3_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Upper Hinge 3 Intrusion Spring","UPPER_HINGE_3_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");
add_to_array("(Y) Rocker Panel 1 Intrusion Spring","ROCKER_PANEL_1_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Y) Rocker Panel 2 Intrusion Spring","ROCKER_PANEL_2_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Y) Rocker Panel 3 Intrusion Spring","ROCKER_PANEL_3_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("Shift Deform Node 1","SHIFT_DEFORM_NODE_1","ID","Node_no_hist","none","OTHER");
add_to_array("Shift Deform Node 2","SHIFT_DEFORM_NODE_2","ID","Node_no_hist","none","OTHER");
add_to_array("Shift Deform Node 3","SHIFT_DEFORM_NODE_3","ID","Node_no_hist","none","OTHER");
add_to_array("Cut-section Definition Method","CUTSECTION_DEFINITION_METHOD","String",["", "Constant X", "Constant Y", "Constant Z", "Three Nodes"],"none","OTHER");
add_to_array("Node 1", "CUT_SECTION_NODE_1","ID","Node_no_hist","none","OTHER");
add_to_array("Node 2", "CUT_SECTION_NODE_2","ID","Node_no_hist","none","OTHER");
add_to_array("Node 3","CUT_SECTION_NODE_3","ID","Node_no_hist","none","OTHER");
add_to_array("Precrash B-Pillar Parts","PRECRASH_PARTS","ID","Part","none","OTHER");
add_to_array("Postcrash B-Pillar Parts", "BPILLAR_PARTS","ID","Part","none","OTHER");
add_to_array("Instrusion Parts", "INTRUSION_PARTS","ID","Part","none","OTHER");
add_to_array("Seat Centre Y","SEAT_CENTRE_Y","Value","","none","OTHER");
add_to_array("Near Seat Centre Y","NEAR_SEAT_CENTRE_Y","Value","","none","OTHER", "i.e. y coordinate of the middle of the passenger seat (used in EuroNCAP Far Side assessment) ");//i.e. passenger seat (used in EuroNCAP Far Side assessment)
add_to_array("H Point Z", "HPOINT_Z","Value","","none","OTHER");
add_to_array("Ground Z", "GROUND_Z","Value","","none","OTHER");
add_to_array("(X) Left Inst Panel Intrusion Spring","LEFT_INSTRUMENT_PANEL_INTRUSION_SPRING_X","ID","Spring","none","OTHER");
add_to_array("(Y) Left Inst Panel Intrusion Spring","LEFT_INSTRUMENT_PANEL_INTRUSION_SPRING_Y","ID","Spring","none","OTHER");
add_to_array("(Z) Left Inst Panel Intrusion Spring","LEFT_INSTRUMENT_PANEL_INTRUSION_SPRING_Z","ID","Spring","none","OTHER");

//LUMBAR
add_to_array("Lumbar loadcell (Beam)","LUMBAR_BEAM","ID","Beam","none","LOWER BODY");
//NECK
add_to_array("Upper neck (Beam)","NECK_UPPER_BEAM","ID","Beam","none","NECK");
add_to_array("Lower neck (Beam)","NECK_LOWER_BEAM","ID","Beam","none","NECK");
//PARTS
add_to_array("Head Parts","HEAD_PARTS","ID","Part","none","OTHER","Select shell part(s) on the dummy head.\nThis is used in EuroNCAP Far Side assessment to calculate max excursion"); //

//FOR SIDE IMPACT INTRUSION
//FOR SIDE IMPACT INTRUSION
add_to_array("H-point Node",      "H_POINT_NODE",      "ID","Node","none", "LOWER BODY","The R-point is assumed to be coincident with the H-point \nand is used to define the A and B bounding lines in the intrusion zone box. \n(see Appendix I of the EuroNCAP FAR SIDE OCCUPANT TEST & ASSESSMENT PROCEDURE) ");
add_to_array("H-point Left Node" ,"H_POINT_LEFT_NODE", "ID","Node","none", "LOWER BODY","The R-point is assumed to be the mid-point between the left and right H-points and to define the A and B bounding lines in the intrusion zone box. \n(see Appendix I of the EuroNCAP FAR SIDE OCCUPANT TEST & ASSESSMENT PROCEDURE) ");
add_to_array("H-point Right Node","H_POINT_RIGHT_NODE","ID","Node","none", "LOWER BODY","The R-point is assumed to be the mid-point between the left and right H-points and to define the A and B bounding lines in the intrusion zone box. \n(see Appendix I of the EuroNCAP FAR SIDE OCCUPANT TEST & ASSESSMENT PROCEDURE) ");
//add_to_array("R-point node",        "R_POINT_NODE",        "ID","Node","none","OTHER","This is used to define the A and B bounding lines in the intrusion zone box. \n(see Appendix I of the EuroNCAP FAR SIDE OCCUPANT TEST & ASSESSMENT PROCEDURE) ");
add_to_array("Door waist line node","DOOR_WAIST_LINE_NODE","ID","Node","none","OTHER","Pick a node on the door waist-line (bottom of window frame) which has the highest z coordinate. \nThis is used to define the D bounding line of the intrusion zone box \n(see Appendix I of the EuroNCAP FAR SIDE OCCUPANT TEST & ASSESSMENT PROCEDURE) ");
add_to_array("Headrest node",       "HEADREST_NODE",       "ID","Node","none","OTHER","Pick any node on the headrest. The x coordinate is used to define the C bounding line of the intrusion zone box. \n(see Appendix I of the EuroNCAP FAR SIDE OCCUPANT TEST & ASSESSMENT PROCEDURE) ");
add_to_array("Door Parts",          "DOOR_PARTS",          "ID","Part","none","OTHER","Pick the door and pillar part(s) that you expect to protrude the most in to the vehicle. \nThe intrusion is only considered for picked parts. ");
add_to_array("Barrier Parts",       "BARRIER_PARTS",       "ID","Part","none","OTHER","Pick barrier part(s) - they will be coloured dark grey in the EuroNCAP Far Side Head Excursion output image. ");
add_to_array("Countermeasure",      "COUNTERMEASURE",      "String",["Yes", "No"],"none","OTHER", "Does the vehicle have an adequate countermeasure (e.g. air bags) for far side impact?");
add_to_array("Vehicle Direction",   "VEHICLE_DIRECTION",   "String",["negative X", "positive X"], "none","OTHER", "Select the direction the vehicle points in.");
add_to_array("Cut Section Thickness","CUTSECTION_THICKNESS","Value","800","none","OTHER", "Thickness of cut (mm) used in report head excursion image. Enter 0 for thin cut and a large number (e.g. 99999) for no cut.");


// If unsuccessful, exit from the script
if(!m)
{
    Window.Message("", "Could not read in model. Unable to continue");
    Exit();
}

var data               = [];
var browse_buttons     = [];
var browse_fields      = [];
var import_ids_buttons = [];
var id_offset_fields   = [];
var r = 1;  // Row number

//get a list of occupants
var occupants = [];

for (i = 0; i < input_variables.length; i++)
{
    for (j = 0; j < occupant_prefixes.length; j++)
    {
        for(k = 0; k < possible_variables.length; k++)
        {
            if (possible_variables[k].variable_name == input_variables[i] && possible_variables[k].occupant != "none")
            {

                if (occupants.indexOf(possible_variables[k].occupant) == -1) //i.e. if it isn't in the list already;
                {
                    occupants.push(possible_variables[k].occupant);
                }
            }
        }
    }
}

occupants = occupants.sort();

var row_variable = [];
var row_variable_subset = [];

var variable_ignore_list = ["CUT_SECTION_NODE_1", "CUT_SECTION_NODE_2","CUT_SECTION_NODE_3"];
var previous_variable_type = "0";

// loop through the occupants (Driver, passenger, etc) and add the widgets to the GUI for each
for (var i=0; i<occupants.length; i++)
{
//create a list of variables for this occupant (e.g. just driver variables). These are found by seeing if the variable name contains an occupant name
    var temp_this_occupant_variables = [] ;

    for(var j = 0; j < input_variables.length; j++)
    {
        var found = false;
        for(var k = 0; k < possible_variables.length; k++)
        {
            if (possible_variables[k].variable_name == input_variables[j])
            {
                var found = true;
                if (possible_variables[k].occupant==occupants[i])
                {
                    temp_this_occupant_variables.push(input_variables[j]);
                }                        
            }
        }
        if (found == false)
        {
            Window.Error("Variable not found","unrecognised variable "+ input_variables[j] + " not found - please add it to the top of the master script");
        }
    }

//sort the list of variables so that they are in the correct order by subset. Start with an empty list and then append the variables to it in the right order.
    var this_occupant_variables = [];
    for(var p=0; p < possible_subsets.length; p++)
    {
        for(var j=0; j < temp_this_occupant_variables.length; j++)
        {
            for(var k = 0; k < possible_variables.length; k++)
            {
                if (possible_variables[k].variable_name == temp_this_occupant_variables[j])
                {
                    if (possible_variables[k].variable_subset == possible_subsets[p])
                    {
                        this_occupant_variables.push(temp_this_occupant_variables[j]);
                    }
                }
            }
        }
    }

//loop through the list of variables for this occupant and add the widgets.
    for(var j=0; j <this_occupant_variables.length; j++)
    {

        var found_variable = false; // so that the script can throw an error if the variable isn't found

// at this stage, this script does not know if the input variables are in its master list (possible_variables) Loop through the master list to see if the input variable can be found in it        
        for(var k = 0; k < possible_variables.length; k++)
        //for(var k = 0; k < 163; k++)
        {
            if (possible_variables[k].variable_name == this_occupant_variables[j])
            {
                found_variable = true;

                var var_name_no_occupant = possible_variables[k].variable_name.replace(occupants[i], "");
                var row_index;

//if this variable is in a different subset to the one before, add a title to separate out the different subsets
                if (possible_variables[k].variable_subset != previous_variable_type)
                {

                    row_index = get_row_number(possible_variables[k].variable_subset+"2");
                    add_object_to_data_array(occupants[i].replace("_"," ") + " " +possible_variables[k].variable_subset, '', '', 'Subsection', [], '', '', row_index, i+1, possible_variables[k].occupant, possible_variables[k].description);
                    
                    row_index++;
                }
                previous_variable_type = possible_variables[k].variable_subset;

//Add the widgets - how this is done depeneds on the type of the variable. The previous functionality (add_object_to_array) is used.
                row_index = get_row_number(var_name_no_occupant);

                // Added for MPDB cases specifically; 
                // the "PASSENGER_CHEST_TRANSDUCER" for passenger is not shown previously, so this will create a new row index if not assigning it.
                // the 13 are given by testing, which related to location where you put "add_to_array("Chest Transducer (Spring)","PASSENGER_CHEST_TRANSDUCER","ID","Spring", "PASSENGER", "TORSO");"
                if(var_name_no_occupant == "_CHEST_TRANSDUCER"){
                    // Need change for CNCAP
                    row_index = 13;
                }

                if(possible_variables[k].variable_type =="ID")
                {
                    add_object_to_data_array(possible_variables[k].label,   possible_variables[k].variable_name,                possible_variables[k].id_type,       "ID", [], "", "",row_index  , i+1, possible_variables[k].occupant, possible_variables[k].description);
                }
                if(possible_variables[k].variable_type =="String")
                {
                    add_object_to_data_array(possible_variables[k].label,    possible_variables[k].variable_name,          "",       "String", possible_variables[k].combobox_options,"" , "",row_index  , i+1, possible_variables[k].occupant, possible_variables[k].description);
                }

//special logic for if it is a dummy specification - in this case some extra buttons must be added so the user can add import default id values from a csv.
                if(possible_variables[k].variable_name.replace(occupants[i],"")=="_DUMMY")
                {
                    add_object_to_data_array("Element number csv",                              "ELEMENT_NUMBER_CSV",                          "",       "file_name", [], "", "",get_row_number("ELEMENT_NUMBER_CSV" ) , i+1, "");
                    add_object_to_data_array("Offset for IDs",                              "OFFSET_FOR_IDS",                          "",       "offset_id", [], "", "",get_row_number("OFFSET_FOR_IDS" ), i+1, "");
                    add_object_to_data_array("Import IDs from csv file with offset",                              "IDS_FROM_CSV",                          "",       "button", [], "", "", get_row_number("IDS_FROM_CSV" ) ,i+1,"");
                }
            }
        }
        if (found_variable == false)
        {
            Window.Error("Variable not found","unrecognised variable "+ this_occupant_variables[j] + " not found - please add it to the top of the master script");
        }
    }
}

//NON_OCCUPANT VARIABLES
var non_occupant_variables = [];
//First, create a list of all non occupant variables
for(i = 0; i < input_variables.length; i++)
{
    var is_occupant = false;
    for(j = 0; j < occupants.length; j++)
    {
        if (input_variables[i].toString().indexOf(occupants[j]) !== -1) is_occupant = true;
    }
    if (!is_occupant) non_occupant_variables.push(input_variables[i]);
}

var start_row = row_variable.length + 1; 
var row_nums = [];

//loop through the possible subsets and add the widgets for each
for(var sub = 0; sub < possible_subsets.length; sub++)
{
    //Get a list of non occupant variables for this subset
    var this_subset_variables = [];
    for(var i = 0; i < non_occupant_variables.length; i++)
    {
        var found_variable = false;
        for(var j = 0; j < possible_variables.length; j++)
        {
            if (possible_variables[j].variable_name == non_occupant_variables[i])
            {
                found_variable = true;
                if (possible_variables[j].variable_subset == possible_subsets[sub])
                {
                    this_subset_variables.push(non_occupant_variables[i]);
                }
            }
        }
        if (!found_variable)
        {
            Window.Message("Variable not found","unrecognised variable "+ non_occupant_variables[i] + " not found - please add it to the top of the master script");
        }
    }

    start_row = Math.max(start_row, Math.max.apply(null, row_nums) +1);
    if (this_subset_variables.length > 0)
    {
        add_object_to_data_array(possible_subsets[sub], '', '',  'full_width_Subsection', [], '', '', start_row, occupants.length,"");
        start_row++;
    }
    //calculate the number of rows and columns required for the non_occupant variables
    var N_cols = Math.max(occupants.length, min_columns);
    var N_rows = Math.ceil(this_subset_variables.length / N_cols);
    var occupant_variable_columns = [];

    //split the variables for this subset up into sub-lists, where each sublist will be added as a column of widgets
    for(var i = 0; i < N_cols; i++)
    {
        var end_ind = Math.min(this_subset_variables.length, (i+1)*N_rows);
        occupant_variable_columns.push(this_subset_variables.slice(i*N_rows, end_ind));
    }

    //loop through the columns adding the widgets for each 
    for (var col = 0; col < N_cols; col++)
    {
        var row_num = start_row;

        var this_col_variables = occupant_variable_columns[col];
        row_index = row_variable.length;
        for(var i = 0; i < this_col_variables.length; i++)
        {
            var found_variable = false;
            for(var k = 0; k < possible_variables.length; k++)
            {
                if (possible_variables[k].variable_name == this_col_variables[i])
                {
                    found_variable = true;
                    var var_name_no_occupant = possible_variables[k].variable_name;

                    if (possible_variables[k].variable_type == "ID")
                    {
                        if(variable_ignore_list.indexOf(possible_variables[k].variable_name.toString()) < 0) // first check it isn't in the list of variables to ignore
                        {
                            add_object_to_data_array(possible_variables[k].label, possible_variables[k].variable_name, possible_variables[k].id_type, "ID", [], "", "", row_num, col+1, possible_variables[k].occupant, possible_variables[k].description);
                        }
                    }
                    if (possible_variables[k].variable_type =="String")
                    {
                        add_object_to_data_array(possible_variables[k].label, possible_variables[k].variable_name, "", "String", possible_variables[k].combobox_options, "", "", row_num, col+1, possible_variables[k].occupant, possible_variables[k].description);
                    }
                    if (possible_variables[k].variable_type =="Value")
                    {
                        add_object_to_data_array(possible_variables[k].label, possible_variables[k].variable_name, "", "Value", "", "", "", row_num, col+1, possible_variables[k].occupant, possible_variables[k].description);
                    }
                    if (possible_variables[k].variable_name == "CUTSECTION_DEFINITION_METHOD") //special logic for the cutsection - if the cut_Section_method is a specified in the input variables then 3 node fields also need to be added
                    {
                        add_object_to_data_array("Node 1", "CUT_SECTION_NODE_1", "Node_no_hist", "nx", [], "", "", row_num+1, col+1, "none");
                        row_num++;
                        add_object_to_data_array("Node 2", "CUT_SECTION_NODE_2", "Node_no_hist", "nx", [], "", "", row_num+1, col+1, "none");
                        row_num++;
                        add_object_to_data_array("Node 3", "CUT_SECTION_NODE_3", "Node_no_hist", "nx", [], "", "", row_num+1, col+1, "none");        
                        row_num++;
                    }        
                    if(possible_variables[k].variable_name == "DUMMY")
                    {
                        add_object_to_data_array("Element number csv",                   "ELEMENT_NUMBER_CSV", "", "file_name", [], "", "", row_num+1, col+1,"none");
                        row_num++;
                        add_object_to_data_array("Offset for IDs",                       "OFFSET_FOR_IDS",     "", "offset_id", [], "", "", row_num+1, col+1, "none");
                        row_num++;
                        add_object_to_data_array("Import IDs from csv file with offset", "IDS_FROM_CSV",       "", "button",    [], "", "", row_num+1, col+1, "none");
                        row_num++;                
                    }
                }
            }
            row_nums.push(row_num);
            row_num++;
        }
    }
}

// function get_row_number(variable, variable_subset)
function get_row_number(variable)
{
    //For a given variable, this function will give it the row number to use. It looks to see if there is already a row with this variable, and if there isn't it'll give it the next free row.
    var row_index = row_variable.indexOf(variable);
    if (row_index < 0) //i.e. if this variable does not have row allocated yet
    {
        row_index = row_variable.length;
        row_variable.push(variable);
    }
    return row_index + 1;
}

r = Math.max.apply(null, row_nums) + 1;

add_object_to_data_array("", "", "", "Line", [], "", "", r++, 1, "none");

///////////////////////////////////////////////////////////////////////////

// Popup Windows for selecting database history entities from a list

var node_pw = new PopupWindow();
var node_no_hist_pw = new PopupWindow();
var beam_pw = new PopupWindow();
var disc_pw = new PopupWindow();
var xsec_pw = new PopupWindow();
var part_pw = new PopupWindow();
var joint_pw = new PopupWindow();
var jointstiff_pw = new PopupWindow();
var contact_pw = new PopupWindow();

var node_title = "DATABASE_HISTORY_NODE:";
var beam_title = "DATABASE_HISTORY_BEAM:";
var disc_title = "DATABASE_HISTORY_DISCRETE:";
var xsec_title = "DATABASE_CROSS_SECTION:";

// Create widgets in popup windows

var node_x1 = 1;    var beam_x1 = 1;    var disc_x1 = 1; var xsec_x1 = 1;
var node_x2 = 100;  var beam_x2 = 100;  var disc_x2 = 100; var xsec_x2 = 100;

var dy = 7;

var node_y1             = 1;              var beam_y1 = 1;              var disc_y1 = 1;            var xsec_y1 = 1;
var node_y2             = node_y1 + dy;   var beam_y2 = beam_y1 + dy;   var disc_y2 = disc_y1 + dy; var xsec_y2 = xsec_y1 + dy;
var node_pick           = new Widget(node_pw,           Widget.BUTTON, node_x1, node_x2, node_y1, node_y2, "PICK...");
var node_no_hist_pick   = new Widget(node_no_hist_pw,   Widget.BUTTON, node_x1, node_x2, node_y1, node_y2, "PICK...");
var beam_pick           = new Widget(beam_pw,           Widget.BUTTON, beam_x1, beam_x2, beam_y1, beam_y2, "PICK...");
var disc_pick           = new Widget(disc_pw,           Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "PICK...");
var xsec_pick           = new Widget(xsec_pw,           Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "PICK...");
var part_pick           = new Widget(part_pw,           Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "PICK...");
var joint_pick          = new Widget(joint_pw,          Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "PICK...");
var jointstiff_pick     = new Widget(jointstiff_pw,     Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "PICK...");
var contact_pick        = new Widget(contact_pw,        Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "PICK...");

node_pick.onClick           = popup_node_pick;
node_no_hist_pick.onClick   = popup_node_pick;
beam_pick.onClick           = popup_beam_pick;
disc_pick.onClick           = popup_disc_pick;
part_pick.onClick           = popup_part_pick;
joint_pick.onClick          = popup_joint_pick;
jointstiff_pick.onClick     = popup_jointstiff_pick;
xsec_pick.onClick           = popup_xsec_pick;
contact_pick.onClick        = popup_contact_pick;

node_y1 += dy;   beam_y1 += dy;   disc_y1 += dy; xsec_y1 += dy;
node_y2 += dy;   beam_y2 += dy;   disc_y2 += dy; xsec_y2 += dy;

var node_sel            = new Widget(node_pw,           Widget.BUTTON, node_x1, node_x2, node_y1, node_y2, "SELECT...");
var node_no_hist_sel    = new Widget(node_no_hist_pw,   Widget.BUTTON, node_x1, node_x2, node_y1, node_y2, "SELECT...");
var beam_sel            = new Widget(beam_pw,           Widget.BUTTON, beam_x1, beam_x2, beam_y1, beam_y2, "SELECT...");
var disc_sel            = new Widget(disc_pw,           Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "SELECT...");
var part_sel            = new Widget(part_pw,           Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "SELECT...");
var xsec_sel            = new Widget(xsec_pw,           Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "SELECT...");
var joint_sel           = new Widget(joint_pw,          Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "SELECT...");
var jointstiff_sel      = new Widget(jointstiff_pw,     Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "SELECT...");
var contact_sel         = new Widget(contact_pw,        Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, "SELECT...");

node_no_hist_sel.onClick    = popup_node_sel;
node_sel.onClick            = popup_node_sel;
beam_sel.onClick            = popup_beam_sel;
disc_sel.onClick            = popup_disc_sel;
part_sel.onClick            = popup_part_sel;
xsec_sel.onClick            = popup_xsec_sel;
joint_sel.onClick           = popup_joint_sel;
jointstiff_sel.onClick      = popup_jointstiff_sel;
contact_sel.onClick         = popup_contact_sel;

node_y1 += dy;   beam_y1 += dy;   disc_y1 += dy; xsec_y1 += dy;
node_y2 += dy;   beam_y2 += dy;   disc_y2 += dy; xsec_y2 += dy;
var node_lbl = new Widget(node_pw, Widget.LABEL, node_x1, node_x2, node_y1, node_y2, node_title);
var beam_lbl = new Widget(beam_pw, Widget.LABEL, beam_x1, beam_x2, beam_y1, beam_y2, beam_title);
var disc_lbl = new Widget(disc_pw, Widget.LABEL, disc_x1, disc_x2, disc_y1, disc_y2, disc_title);
var xsec_lbl = new Widget(xsec_pw, Widget.LABEL, disc_x1, disc_x2, disc_y1, disc_y2, xsec_title);

node_y1 += dy;   beam_y1 += dy;   disc_y1 += dy; xsec_y1 += dy;
node_y2 += dy;   beam_y2 += dy;   disc_y2 += dy; xsec_y2 += dy;

var node_btns = [];
var beam_btns = [];
var disc_btns = [];
var xsec_btns = [];

var node_i = 0;
var beam_i = 0;
var disc_i = 0;
var xsec_i = 0;


var nodout_flag = false;
var elout_flag = false;
var deforc_flag = false;
var xsecout_flag =false;

// Store all of the DATABASE_CROSS_SECTION cards in the model
var x_sec = CrossSection.First(m);
var database_cards = [];
var num_xsec=0;
while(x_sec && num_xsec < 100)
{
    xsec_btns[xsec_i] = new Widget(xsec_pw, Widget.BUTTON, xsec_x1, xsec_x2, xsec_y1, xsec_y2, x_sec.label + " " +x_sec.heading);
    xsec_btns[xsec_i].justify = Widget.LEFT;
    xsec_btns[xsec_i].onClick = update_popup_tbx;
    xsec_i++;
    xsec_y1 += dy;
    xsec_y2 += dy;
    xsecout_flag = true;

    database_cards.push({type:"XSEC", label:x_sec.label, heading:x_sec.heading});
	num_xsec++;
    x_sec = x_sec.Next();
}

// Store all of the DATABASE_HISTORY cards in the model
//it has been observed from one of the aPLI model that the impactor can have lots of beam_set which can make it cross the widget limit of 10000
// so now a limit of 100 widgets has been specified for every history card in this way 100 of them can be seen in the popup and the rest can be typed in
var h = History.First(m);
var num_node=0,num_nodeset=0,num_beam=0,num_beamset=0,num_disc=0,num_discset=0;
while(h)
{
    // Choose whether to use the id of the time history or the heading (for both displaying in the GUI and outputting to reporter).
    // Choose the heading if it exists. Otherwise use the id.
    if (h.heading == "") var label = h.id.toString();
    else var label = h.heading;
    switch(h.type)
    {
        case History.NODE:
			if(num_node < 100)
			{
				node_btns[node_i] = new Widget(node_pw, Widget.BUTTON, node_x1, node_x2, node_y1, node_y2,  label);
				node_btns[node_i].justify = Widget.LEFT;
				node_btns[node_i].onClick = update_popup_tbx;
				node_i++;
				node_y1 += dy;
				node_y2 += dy;
				database_cards.push({type:"NODE", label:h.id.toString(), heading:h.heading});
				num_node++;
			}
			break;

        case History.NODE_SET:
            var set = Set.GetFromID(m, h.id, Set.NODE);
            if(set)
            {
                var id;
                set.StartSpool();
                while( (id = set.Spool()) && num_nodeset < 100)
                {
                    node_btns[node_i] = new Widget(node_pw, Widget.BUTTON, node_x1, node_x2, node_y1, node_y2, label);
                    node_btns[node_i].justify = Widget.LEFT;
                    node_btns[node_i].onClick = update_popup_tbx;
                    node_i++;
                    node_y1 += dy;
                    node_y2 += dy;
                    database_cards.push({type:"NODE", label:h.id.toString(), heading:h.heading});
					num_nodeset++;
                }
            }
            break;

        case History.BEAM:         
			if(num_beam < 100)
			{
				beam_btns[beam_i] = new Widget(beam_pw, Widget.BUTTON, beam_x1, beam_x2, beam_y1, beam_y2, label);
				beam_btns[beam_i].justify = Widget.LEFT;
				beam_btns[beam_i].onClick = update_popup_tbx;
				beam_i++;
				beam_y1 += dy;
				beam_y2 += dy;
				database_cards.push({type:"BEAM", label:h.id.toString(), heading:h.heading});
				num_beam++;
			}
			break;

        case History.BEAM_SET:
            var set = Set.GetFromID(m, h.id, Set.BEAM);
            if(set)
            {
                var id;
                set.StartSpool();
                while( (id = set.Spool()) && num_beamset < 100)
                {
                    beam_btns[beam_i] = new Widget(beam_pw, Widget.BUTTON, beam_x1, beam_x2, beam_y1, beam_y2, label);
                    beam_btns[beam_i].justify = Widget.LEFT;
                    beam_btns[beam_i].onClick = update_popup_tbx;
                    beam_i++;
                    beam_y1 += dy;
                    beam_y2 += dy;
                    database_cards.push({type:"BEAM", label:h.id.toString(), heading:h.heading});
					num_beamset++;
                }
            }
            break;

        case History.DISCRETE:   
			if(num_disc < 100)
			{
				disc_btns[disc_i] = new Widget(disc_pw, Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2,  label);                                
				disc_btns[disc_i].justify = Widget.LEFT;                                
				disc_btns[disc_i].onClick = update_popup_tbx;                                
				disc_i++;                                
				disc_y1 += dy;
				disc_y2 += dy;
				database_cards.push({type:"SPRING", label:h.id.toString(), heading:h.heading});
				num_disc++;
			}
			break;

        case History.DISCRETE_SET:
            var set = Set.GetFromID(m, h.id, Set.BEAM);
            if(set)
            {
                var id;                                  
                set.StartSpool();                                  
                while( (id = set.Spool()) && num_discset<100)
                {
                    disc_btns[disc_i] = new Widget(disc_pw, Widget.BUTTON, disc_x1, disc_x2, disc_y1, disc_y2, label);                                    
                    disc_btns[disc_i].justify = Widget.LEFT;                                
                    disc_btns[disc_i].onClick = update_popup_tbx;                                    
                    disc_i++;                                    
                    disc_y1 += dy;
                    disc_y2 += dy;
                    database_cards.push({type:"SPRING", label:h.id.toString(), heading:h.heading});
					num_discset++;
                }
            }                                
            break;
    }

    h = h.Next();
}

// Store all of the part IDs in the model
var p = Part.First(m);
var pid_index = [];

while (p)
{
    pid_index[p.pid] = 1;
    p = p.Next();
}

// Store all of the node IDs in the model
var n = Node.First(m);
var nid_index = [];

while (n)
{
    nid_index[n.nid] = 1;
    n = n.Next();
}

// Store all of the Joint IDs in the model
var j = Joint.First(m);
var jid_index = [];

while (j)
{
    jid_index[j.label] = 1;
    j = j.Next();
}

// Store all of the JointStiffness IDs in the model
var j = JointStiffness.First(m);
var jsid_index = [];

while (j)
{
    jsid_index[j.label] = 1;
    j = j.Next();
}

// Colour buttons

for(var i=0; i<node_btns.length; i++) { node_btns[i].background = Widget.DARKBLUE;   node_btns[i].foreground = Widget.WHITE; }
for(var i=0; i<beam_btns.length; i++) { beam_btns[i].background = Widget.DARKBLUE;   beam_btns[i].foreground = Widget.WHITE; }
for(var i=0; i<disc_btns.length; i++) { disc_btns[i].background = Widget.DARKBLUE;   disc_btns[i].foreground = Widget.WHITE; }
for(var i=0; i<xsec_btns.length; i++) { xsec_btns[i].background = Widget.DARKBLUE;   xsec_btns[i].foreground = Widget.WHITE; }
// Sort buttons into alphabetical then numerical order

node_btns.sort(sort_history_buttons);
beam_btns.sort(sort_history_buttons);
disc_btns.sort(sort_history_buttons);
xsec_btns.sort(sort_history_buttons);
// Textbox that popup was clicked in
var popup_tbx = null;

// Main window
var w = new Window(w_title, 0.8, 1.0, 0.2, 0.6);

var x1, x2, x3, x4, x5, x6, x7, x8;
var y1, y2;
var dy = 7; 

var lbls = [];
var tbxs = [];
var btns = [];
var cbs  = [];
var dummy_str_fields = [];
var dummy_names= new Array();
// Find the highest column so we know where the right hand side is

var max_col = 0;
for(var i=0; i<data.length; i++) max_col = Math.max(data[i].col, max_col);

var x_rhs = 139 + 145 * (max_col - 1);

// Create widgets based on objects in global <data> array

for(var i = 0; i < data.length; i++)
{
    y1 = (dy+1) * (data[i].row - 1);
    y2 = y1 + dy;

    x1 = 1 + 145 * (data[i].col - 1);
    x2 = x1 + 72;
    x3 = x2 +  1;
    x4 = x3 + 45;
    x5 = x4 +  1;
    x6 = x5 + 19;
    x7 = x5 +  9;
    x8 = x5 +  7;
    // Label

    // Textbox and Select button for IDs

    if(data[i].variable_type == "ID")
    {  
        var l = new Widget(w, Widget.LABEL,   x1, x2, y1, y2, data[i].label);
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.justify   = Widget.LEFT;
        l.variable_name = data[i].variable_name;
        lbls.push(l);

        var t = new Widget(w, Widget.TEXTBOX, x3, x6, y1, y2, data[i].value.toString());
        t.variable_name = data[i].variable_name;
        t.linked_to     = data[i].linked_to;
        t.map_value     = data[i].map_value;
        t.select_type   = data[i].select_type;
        t.onChange      = textbox_change;
        t.justify       = Widget.RIGHT;
        t.variable_type = "ID"
        // Link popup
        if(data[i].select_type == "Node")   t.popupWindow = node_pw;  
        if(data[i].select_type == "Node_no_hist") t.popupWindow =node_no_hist_pw;
        if(data[i].select_type == "Beam")   t.popupWindow = beam_pw;  
        if(data[i].select_type == "Spring") t.popupWindow = disc_pw;
        if(data[i].select_type == "Xsec") t.popupWindow = xsec_pw;
        if(data[i].select_type == "Joint") t.popupWindow = joint_pw;
        if(data[i].select_type == "JointStiffness") t.popupWindow = jointstiff_pw;
        if(data[i].select_type == "Contact") t.popupWindow = contact_pw;
        if(data[i].select_type == "Part") t.popupWindow = part_pw;
        t.onPopup        = popup_pressed;
        t.popupDirection = Widget.RIGHT;

        tbxs.push(t);

    }
    if(data[i].variable_type == "Value")
    {  
        var l = new Widget(w, Widget.LABEL, x1, x2, y1, y2, data[i].label);
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.justify   = Widget.LEFT;
        lbls.push(l);

        var t = new Widget(w, Widget.TEXTBOX, x3, x6, y1, y2, "0");
        t.variable_name = data[i].variable_name;
        t.linked_to     = data[i].linked_to;
        t.map_value     = data[i].map_value;
        t.select_type   = data[i].select_type;
        t.onChange      = textbox_change;
        t.justify       = Widget.RIGHT;
        tbxs.push(t);

    }
    // ComboBox for strings

    else if(data[i].variable_type == "String")
    {
        var l = new Widget(w, Widget.LABEL,   x1, x2, y1, y2, data[i].label);
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.justify   = Widget.LEFT;

        lbls.push(l);

        var cb = new Widget(w, Widget.COMBOBOX, x3, x6, y1, y2);
        cb.variable_name = data[i].variable_name;

        for(var j = 0; j < data[i].combobox_options.length; j++)
        {
            var wi = new WidgetItem(cb, data[i].combobox_options[j]);
        }
        if (data[i].variable_name.indexOf("DUMMY") > -1) 
        {
            dummy_str_fields.push(cb)
            cb.index = dummy_str_fields.indexOf(cb)
            cb.onChange =dummy_change;
            dummy_names.push(data[i].variable_name)
            for (j = 0; j < dummy_dict[data[i].occupant].length; j++)
            {
                var wi = new WidgetItem(cb, dummy_dict[data[i].occupant][j]);
            }
        }
        else
        {
            cb.onChange = combobox_change;
        }
        cbs.push(cb);
    }

    else if(data[i].variable_type == "button")
    {
        var import_ids_button = new Widget(w, Widget.BUTTON, x3, x6, y1, y2,data[i].label);    
        import_ids_buttons.push(import_ids_button);
        import_ids_button.index = import_ids_buttons.indexOf(import_ids_button);
        import_ids_button.onClick = import_ids;
    }

    else if(data[i].variable_type == "file_name")
    {
        var l = new Widget(w, Widget.LABEL,   x1, x2, y1, y2, data[i].label);
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.justify   = Widget.LEFT;

        var b = new Widget(w, Widget.TEXTBOX, x3, x8, y1, y2,"C:\\");
        b.background = Widget.DARKBLUE;
        b.foreground = Widget.WHITE;

        var b_browse_csv2 = new Widget(w, Widget.BUTTON, x7, x6, y1, y2, "");
        b_browse_csv2.DirectoryIcon(Widget.BLACK, Widget.YELLOW);  

        browse_fields.push(b);
        browse_buttons.push(b_browse_csv2);
        b_browse_csv2.onClick = get_csv_file;
        b.onChange = update_csv_fname;
    }
    if (data[i].variable_type == "Subsection")
    {
        var l = new Widget(w, Widget.LABEL, x1, x6, y1, y2, data[i].label);
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.background = Widget.DARKGREY;
        l.foreground = Widget.WHITE;
        l.fontSize = 10;
        l.justify = Widget.CENTRE;
    }
    else if (data[i].variable_type == "full_width_Subsection")
    {
        var l = new Widget(w, Widget.LABEL, 1, x_rhs, y1, y2, data[i].label);
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.background = Widget.DARKGREY;
        l.foreground = Widget.WHITE;
        l.fontSize = 10;
        l.justify = Widget.CENTRE;
    }
    else if(data[i].variable_type == "offset_id")
    {
        var l = new Widget(w, Widget.LABEL, x1, x2, y1, y2, data[i].label);
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.justify = Widget.LEFT;
        
        lbls.push(l);
        var id_offset = new Widget(w, Widget.TEXTBOX, x3, x6, y1, y2,"0");
        id_offset_fields.push(id_offset);
    }
    else if(data[i].variable_type == "nx")
    {
        var l = new Widget(w, Widget.LABEL, x1, x2, y1, y2, data[i].label);
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.justify   = Widget.LEFT;
        l.variable_name = data[i].variable_name;


        lbls.push(l);
        id_offset_fields.push(id_offset);
        var t = new Widget(w, Widget.TEXTBOX, x3, x6, y1, y2, data[i].value.toString());
        t.variable_name = data[i].variable_name;
        t.linked_to     = data[i].linked_to;
        t.map_value     = data[i].map_value;
        t.select_type   = data[i].select_type;
        t.onChange      = textbox_change;
        t.justify       = Widget.RIGHT;
        t.variable_type = "nx"

        // Link popup
        t.popupWindow =node_no_hist_pw;
        t.onPopup        = popup_pressed;
        t.popupDirection = Widget.RIGHT;
        tbxs.push(t);
        //id_offset.active=false;
    }  
    // Line to break up menu
    else if(data[i].variable_type == "XSEC")
    {  
        var l = new Widget(w, Widget.LABEL,   x3, x4, y1, y2, "0 cross sections selected");
        l.variable_name = data[i].variable_name;
        l.linked_to = data[i].linked_to;
        l.map_value = data[i].map_value;
        l.justify   = Widget.LEFT;

        lbls.push(l);

        var b = new Widget(w, Widget.BUTTON,  x5, x6, y1, y2, "Select");
        b.background = Widget.DARKBLUE;
        b.foreground = Widget.WHITE;
        b.variable_name = data[i].variable_name;
        b.linked_to     = data[i].linked_to;
        b.map_value     = data[i].map_value;
        b.select_type   = data[i].select_type;
        b.onClick       = select_xsec;

        btns.push(b);
    }  
    else if(data[i].variable_type == "Line")
    {
        var l = new Widget(w, Widget.LABEL, x1, x_rhs, y1, y2, "");
        l.Line(Widget.COLOUR_NEUTRAL, 0,50, 100,50);
    }

    //add hovertext if description given

    if (data[i].description)
    {
        l.hover = data[i].description;
    }
    
}

y1 = y2 + 1;
y2 = Math.round(y1 + 1.5*dy);

x1 = 1;
x2 = 40;
x3 = 42;
x4 = x_rhs-16;
x5 = x_rhs-14;
x6 = x_rhs;

var b_save_csv = new Widget(w, Widget.BUTTON, x1, x2, y1, y2, "Save as .csv");

var t_save_csv = new Widget(w, Widget.TEXTBOX, x3, x4, y1, y2, csv_fname);
t_save_csv.background = Widget.DARKBLUE;
t_save_csv.foreground = Widget.WHITE;

var b_browse_csv = new Widget(w, Widget.BUTTON, x5, x6, y1, y2, "");
b_browse_csv.DirectoryIcon(Widget.BLACK, Widget.YELLOW);  

y1 = y2 + 1;
y2 = Math.round(y1 + 1.5*dy);
if (uses_list_file)
{
    b_save_csv.text         = "Save as .lst"
    b_save_csv.onClick      = write_lst;
    b_browse_csv.onClick    = get_lst_file;
    lst_fname               = csv_fname;
    t_save_csv.onChange     = update_lst_fname;
}
else
{
    var b_save_post_end = new Widget(w, Widget.BUTTON, x1, x2, y1, y2, "Save as post *END");
    b_save_post_end.onClick = write_post_end;
    y1 = y2 + 1;
    y2 = Math.round(y1 + 1.5*dy);
    b_save_csv.onClick   = write_csv;
    b_browse_csv.onClick = get_csv_file;
    t_save_csv.onChange  = update_csv_fname;
}

var b_cancel = new Widget(w, Widget.BUTTON, x1, x2, y1, y2, "Cancel");
b_cancel.category = Widget.CATEGORY_CANCEL;
b_cancel.onClick = exit;

update_menu();
for (i = 0; i < dummy_str_fields.length; i++)
{
    var test = {};
    test.index = i;
    test.dummy_change = dummy_change;
    test.dummy_change();

}
w.Show(false);

function import_ids()
{
    //Read the text file in the field above this "import ids..." button
    var column_id = this.index;

    var file_name = browse_fields[column_id].text;

    //throw a warning if the filename specified doesn't exist or is a directory instead of a file
    if (!File.Exists(file_name))
    {
        Window.Warning("File does not exist", "Please specify a csv to import ids from");
        return;
    }
    if (!File.IsFile(file_name))
    {
        Window.Warning("File does not exist", "Please specify a csv to import ids from");
        return;
    }
    var f = new File(file_name, File.READ);

    var line = f.ReadLine();
    //RESET ALL VARIABLES IN THIS COLUMN TO ZERO FIRST
    for(var i = 0; i < data.length; i++)
    {
        if (data[i].variable_name.indexOf(occupants[column_id]) > -1)
        {
            if (!(dummy_names.indexOf(data[i].variable_name)>-1))// don't put it to zero if it is the dummy name
            {
            data[i].value= 0
            }
        }
    }
    var poss_types = ["Node","Beam","Spring","Xsec","Joint","JointStiffness","Contact"];
    while (line != undefined)
    {
        var line_split  = line.split(",");
        var var_name = line_split[0]; // Add the column name (driver, front_passenger etc) to the front of imported variable name)
        var different_type = false;
        var type = line_split[2];

        if (poss_types.indexOf(type) > -1) // check it is a possible type first before changing the label and popup
        {
            different_type = true;
        }
        if (column_id < occupants.length) //i.e. if this is in the occupants variables 
        {
            id = parseInt(line_split[1]) + parseInt(id_offset_fields[column_id].text); //Add the offset from the id offset box above
            if (isNaN(id)) //then it is probably a label not a id
            {
                id = line_split[1];
            }
            //Find the variable which has this as the variable_name and set it to the value in the csv file        
            for (var i = 0; i < data.length; i++)
            {
                var data_name_no_occ = data[i].variable_name.replace(occupants[column_id]+"_", ""); //the variable name without the occupant bit

                if (data_name_no_occ == var_name && data[i].occupant != "none")
                {
                    data[i].value = id;

                    if (different_type == true)
                    {
                        var split_label = data[i].label.split(" ");
                        var new_label = split_label.slice(0,-1).join(" ") + " (" + type + ")"; //replace the old label with a new one with the correct type in the brackets
                        data[i].label = new_label;
                        data[i].select_type = type; //this is to update the popup window -see the update_menu function whihc is called at the end of import_ids
                    }
                    else
                    { //i.e. if this variable does not a different type specified in the dummy input csv file, just use the default label and popup type from the possible_variables list.
                        for (var j = 0; j < possible_variables.length; j++)
                        {
                            if (possible_variables[j].variable_name == data[i].variable_name)
                            {                                
                                data[i].label = possible_variables[j].label;
                                data[i].select_type = possible_variables[j].id_type;
                            }
                        }
                    }
                }
            }
        }
        else //i.e. the variables don't have "DRIVER" etc in them - section might need completing
        {
            id = parseInt(line_split[1]) + parseInt(id_offset_fields[column_id].text) //Add the offset from the id offset box above

            //Find the variable which has this as the variable_name and set it to the value in the csv file        
            for (var i = 0; i < data.length; i++)
            {
                if (data[i].variable_name == var_name)
                {
                    data[i].value = id;
                    if (different_type == true)
                    {
                        var split_label = data[i].label.split(" ");
                        var new_label = split_label.slice(0,-1).join(" ") + " (" + type + ")"; //replace the old label with a new one with the correct type in the brackets
                        data[i].label = new_label;
                        data[i].select_type = type; //this is to update the popup window -see the update_menu function whihc is called at the end of import_ids
                    }
                }
            }
        }
        line=f.ReadLine();
    }
    f.Close();
    update_menu();
}

function textbox_change()
{
    // Updates the <value> property on the appropriate object in the global <data> array
    // when a textbox text changes.

    var obj;

    for(var i = 0; i < data.length; i++)
    {
        if(this.variable_name == data[i].variable_name) obj = data[i];
    }

    obj.value = this.text;

    update_menu();
}


function popup_pressed()
{
    // Sets the current popup textbox so we can update the correct
    // one when the user clicks on a button in the popup. 

    popup_tbx = this;

    // Update widget positions so it will fit on the screen

    switch(this.select_type)
    {
        case "Node":
            arrange_popup_widgets(node_btns, node_pick, node_sel, node_lbl);
            break;

        case "Beam":
            arrange_popup_widgets(beam_btns, beam_pick, beam_sel, beam_lbl);
            break;

        case "Spring":
            arrange_popup_widgets(disc_btns, disc_pick,  disc_sel, disc_lbl);
            break;

        case "Xsec":
            arrange_popup_widgets(xsec_btns, xsec_pick,  xsec_sel, xsec_lbl);
            break;

        case "Contact":
            arrange_popup_widgets(contact_btns, [], [], contact_lbl);
            break;
    }
}

function popup_node_pick()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var picked_node = Node.Pick("Pick a node", m);
    if (picked_node == null) return;
    obj.value = picked_node.nid;

    update_menu();
}

function popup_joint_pick()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var picked_joint = Joint.Pick("Pick a joint", m);
    if (picked_joint ==null) return;
    obj.value = picked_joint.label;

    update_menu();
}

function popup_jointstiff_pick()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var picked_jointstiff = JointStiffness.Pick("Pick a joint", m);
    if (picked_jointstiff ==null) return;
    obj.value = picked_jointstiff.label;

    update_menu();
}

function popup_xsec_pick()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var picked_xsec = CrossSection.Pick("Pick a database_cross_section", m);
    if (picked_xsec == null) return;
    obj.value = picked_xsec.label;

    update_menu();
}

function popup_xsec_sel()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    flag_find_xsecs = AllocateFlag()

    var selected_xsecs = CrossSection.Select(flag_find_xsecs, "Select a database_cross_section", m);
    if (selected_xsecs == null) return;
    if (selected_xsecs .length > 1)
    {
        Window.Warning("Multiple cross sections selected", "Please select only one cross section");
        return;
    }
    obj.value = CrossSection.GetFlagged(m, flag_find_xsecs)[0].label;

    update_menu();
}

function popup_contact_pick()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if(popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var picked_contact = Contact.Pick("Pick a contact",m)
    if (picked_contact ==null) return;
    obj.value = picked_contact.label

    update_menu()
}

function popup_beam_pick()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var picked_beam = Beam.Pick("Pick a beam", m);
    if (picked_beam == null) return;
    obj.value = picked_beam.eid;

    update_menu();
}

function popup_disc_pick()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var picked_disc = Discrete.Pick("Pick a spring", m);
    if (picked_disc == null) return;
    obj.value = picked_disc.eid;

    update_menu();
}

function popup_part_pick()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var picked_part = Part.Pick("Pick a part", m);
    if (picked_part == null) return;
    obj.value = picked_part.pid;

    update_menu();
}
function popup_node_sel()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var flag_find_nodes = AllocateFlag();

    var selected_nodes = Node.Select(flag_find_nodes, "Select a node", m);
    if (selected_nodes == null) return;
    if (selected_nodes.length > 1)
    {
        Window.Warning("Multiple nodes selected", "Please select only one node");
        return;
    }
    obj.value = Node.GetFlagged(m, flag_find_nodes)[0].nid;

    update_menu();
}

function popup_joint_sel()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if(popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    flag_find_joints = AllocateFlag();

    var selected_joints = Joint.Select(flag_find_joints, "Select a joint", m);
    if (selected_joints == null) return;
    if (selected_joints.length > 1)
    {
        Window.Warning("Multiple joints selected", "Please select only one joint");
        return;
    }
    obj.value = Joint.GetFlagged(m, flag_find_joints)[0].label;

    update_menu();
}

function popup_jointstiff_sel()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if(popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    flag_find_joints = AllocateFlag();

    var selected_joints = JointStiffness.Select(flag_find_joints, "Select a joint", m);
    if (selected_joints == null) return;
    if (selected_joints.length > 1)
    {
        Window.Warning("Multiple joints selected", "Please select only one joint");
        return;
    }
    obj.value = JointStiffness.GetFlagged(m, flag_find_joints)[0].label;

    update_menu();
}

function popup_contact_sel()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if (popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    flag_find_contacts = AllocateFlag();

    var selected_contacts = Contact.Select(flag_find_contacts, "Select a contact", m);
    if (selected_contacts == null) return;
    if (selected_contacts.length > 1)
    {
        Window.Warning("Multiple contacts selected", "Please select only one contact");
        return;
    }
    obj.value = Contact.GetFlagged(m, flag_find_contacts)[0].label;

    update_menu();
}
function popup_beam_sel()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if(popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    flag_find_beams = AllocateFlag();

    var selected_beams = Beam.Select(flag_find_beams, "Select a beam", m);
    if (selected_beams == null) return;
    if (selected_beams.length > 1)
    {
        Window.Warning("Multiple beams selected", "Please select only one beam");
        return;
    }
    obj.value = Beam.GetFlagged(m, flag_find_beams)[0].nid;

    update_menu();
}

function popup_disc_sel()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if(popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    flag_find_discs = AllocateFlag();

    var selected_discs = Discrete.Select(flag_find_discs, "Select a node", m);
    if (selected_discs == null) return;
    if (selected_discs.length > 1)
    {
        Window.Warning("Multiple nodes selected", "Please select only one node");
        return;
    }
    obj.value = Discrete.GetFlagged(m, flag_find_discs)[0].eid;

    update_menu();
}

function popup_part_sel()
{
    var obj;
    for(var i = 0; i < data.length; i++)
    {
        if(popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }
    var flag_find_parts = AllocateFlag();

    var selected_parts = Part.Select(flag_find_parts, "Select a part", m);
    if (selected_parts == null) return;
    var sel_parts = Part.GetFlagged(m, flag_find_parts);
    var value_out = "";
    for(var i = 0; i < sel_parts.length; i++)
    {
        value_out += sel_parts[i].pid.toString() + " "; 
    }
    obj.value = value_out;

    update_menu();
}

function update_popup_tbx()
{
    // Updates the <value> property on the appropriate object in the global <data> array
    // when the user clicks on a button in a popup.  Uses <popup_tbx> set above, which
    // is the textbox that the popup is linked to.
    //
    // <this> is the button that was pressed in the popup window.

    var obj;

    for(var i = 0; i < data.length; i++)
    {
        if(popup_tbx.variable_name == data[i].variable_name) obj = data[i];
    }

    obj.value = this.text;

    update_menu();
}


function combobox_change()
{
    // Updates the <value> property on the appropriate object in the global <data> array
    // when a combobox selection changes.

    var obj;

    for(var i = 0; i < data.length; i++)
    {
        if(this.variable_name == data[i].variable_name) obj = data[i];
    }
    obj.value = this.selectedItem.text;
    update_menu();
}

function dummy_change()
{
    // updates the dummy csv file box when the dummy combobox is changed

    var i =this.index;
    if (dummy_str_fields[i].text != "") // i.e. only try to update if the dummy name is not blank. Useful if there are no default csv files available.
    {
        browse_fields[i].text = dummy_dir + "/" + dummy_str_fields[i].text + ".csv";

        //change the value in the data array
    for(var j=0; j<data.length; j++)
    {
        if(dummy_names[i]== data[j].variable_name) {
            data[j].value =dummy_str_fields[i].text ;
        }
    }
        // import the ids from this csv
        var test = {};
        test.index = this.index;
        test.import_ids = import_ids;
        test.import_ids();
    }
    update_menu();
}

function update_csv_fname()
{
    csv_fname = this.text;
    update_menu();
}

function update_lst_fname()
{
    lst_fname = this.text;
    update_menu();
}


function get_lst_file()
{
    var strTemp;
    //Put the filename from the Getfile browsing window into the corrext text widget. The 3 passenger csv buttons are in the browse_buttons widget
    for (i = 0; i < browse_buttons.length; i++)
    {
        if (this == browse_buttons[i])
        {
            strTemp = Window.GetFile(".lst", false);
            if (strTemp == null) return;
            browse_fields[i].text = strTemp;
        }
    }
    //This is for the browse button at the bottom of the window (for saving to)
    if (this == b_browse_csv)
    {
        strTemp = Window.GetFile(".lst", true);
        if (strTemp == null) return;
        lst_fname = strTemp;
    }

    update_menu();
}

function get_csv_file()
{
    var strTemp;
    //Put the filename from the Getfile browsing window into the corrext text widget. The 3 passenger csv buttons are in the browse_buttons widget
    for (i = 0; i < browse_buttons.length; i++)
    {
        if (this == browse_buttons[i])
        {
            strTemp = Window.GetFile(".csv", false);
            if (strTemp == null) return;
            browse_fields[i].text = strTemp;
        }
    }
    //This is for the browse button at the bottom of the window (for saving to)
    if (this == b_browse_csv)
    {
        strTemp = Window.GetFile(".csv", true);
        if (strTemp == null) return;
        csv_fname = strTemp;
    }

    update_menu();
}



function update_menu()
{
    // Map/unmap widgets based on values of other variables they may be linked to
    for(var i=0; i<cbs.length;i++)
    {
        if(cbs[i].variable_name == "CUTSECTION_DEFINITION_METHOD")
        {
            var sect_type = cbs[i].text;
        }
    }
    var nodes_active = [false, false, false];
    switch(sect_type)
    {
        case "":
            nodes_active = [false, false, false];
            break;

        case "Constant X":
            nodes_active = [true, false, false];
            break;

        case "Constant Y":
            nodes_active = [false, true, false];
            break;

        case "Constant Z":
            nodes_active = [false, false, true];
            break;

        case "Three Nodes":
            nodes_active = [true, true,true];
            break;
    }
    for(var i = 0; i < nodes_active.length; i++)
    {
        for(var j = 0; j < tbxs.length; j++)
        {
            if(tbxs[j].variable_name == "CUT_SECTION_NODE_" + (i+1).toString())
            {
                tbxs[j].active = nodes_active[i];
            }
        }
    }

    for(var i=0; i<lbls.length; i++) { lbls[i].Hide();  lbls[i].mapped = false; }
    for(var i=0; i<tbxs.length; i++) { tbxs[i].Hide();  tbxs[i].mapped = false; }
    for(var i=0; i<btns.length; i++) { btns[i].Hide();  btns[i].mapped = false; }

    for(var pass = 0; pass < 3; pass++)
    {
        var wdgts;

        if(pass == 0) wdgts = lbls;
        else if(pass == 1) wdgts = tbxs;
        else if(pass == 2) wdgts = btns;

        for(var i = 0; i < wdgts.length; i++)
        {
            if(wdgts[i].linked_to == "")
            {
                // Doesn't depend on value of any other variable, so map it unconditionally

                wdgts[i].Show();
                wdgts[i].mapped = true;
            }
            else
            {
                // Whether this widget is shown or not depends on the value of another variable.
                // Find the value of this variable and if the variable is set to the value that
                // means the widget should be mapped, map it.

                for(var j = 0; j < data.length; j++)
                {
                    if(data[j].variable_name == wdgts[i].linked_to)
                    {
                        if(data[j].value == wdgts[i].map_value)
                        {
                            wdgts[i].Show();
                            wdgts[i].mapped = true;
                        }
                    }
                }
            }
        }
    }


    var write_active = true;
    //update labels which may have changed due to the different variable types from different dummies
    for(var i = 0; i < lbls.length; i++)
    {
        for(var j = 0; j < data.length; j++)
        {
            if(lbls[i].variable_name == data[j].variable_name)
            {
                lbls[i].text = data[j].label;
            }
        }
    }
    //update the popup window which depends on the variable type - the variable type may have changed as some dummies have different types of variable for each injury channel.
    for(var i = 0; i < tbxs.length; i++)
    {
        for(var j = 0; j<data.length; j++)
        {

            if(tbxs[i].variable_name == data[j].variable_name)
            {
                if(data[j].select_type == "Node")   tbxs[i].popupWindow = node_pw;  
                if(data[j].select_type == "Node_no_hist") tbxs[i].popupWindow = node_no_hist_pw;
                if(data[j].select_type == "Beam")   tbxs[i].popupWindow = beam_pw;  
                if(data[j].select_type == "Spring") tbxs[i].popupWindow = disc_pw;
                if(data[j].select_type == "Xsec") tbxs[i].popupWindow = xsec_pw;
                if(data[j].select_type == "Joint") tbxs[i].popupWindow = joint_pw;
                if(data[j].select_type == "JointStiffness") tbxs[i].popupWindow = jointstiff_pw;
                if(data[j].select_type == "Part") tbxs[i].popupWindow = part_pw;
                if(data[j].select_type == "Contact") tbxs[i].popupWindow = contact_pw;
            }
        }
    }
    // Update text and colour of textboxes using information on the global <data> array

    for(var i = 0; i < tbxs.length; i++)
    {
        for(var j = 0; j < data.length; j++)
        {
            if(tbxs[i].variable_name == data[j].variable_name)
            {
                tbxs[i].text = data[j].value.toString();

                // Now we check whether the entry for each entity is valid
                var found_entity = false;

                // Some of the nodes just have to exist in the model (they don't have to be DATABASE_HISTORY_NODEs)
                if ((data[j].select_type == "Node" || data[j].select_type == "Node_no_hist") || (data[j].variable_name.substr(0, 17) == "CUT_SECTION_NODE_" ||
                                                                                                data[j].variable_name.substr(0,  9) == "REF_NODE_"         ||
                                                                                                data[j].variable_name.substr(0, 18) == "SHIFT_DEFORM_NODE_" ))
                    
                {
                    if (nid_index[data[j].value] != undefined) // If node ID exists in current model
                    {
                        found_entity = true;
                    }
                }
                if (data[j].select_type == "Part")
                {
                    // If value is string (e.g. list of part IDs "30400 30800 130800")
                    // then split into individual values and check that ALL exist in model
                    if (typeof(data[j].value) == "string")
                    {
                        var id_strings = data[j].value.split(" ");
                        var all_valid = true;
                        for (var s = 0; s < id_strings.length; s++)
                        {
                            if (id_strings[s] == "") continue;
                            var value = parseInt(id_strings[s]);
                            if (isNaN(value)) all_valid = false;
                            else if(pid_index[value] == undefined) all_valid = false; // If part ID does not exist in current model
                        }
                        if (all_valid == true) found_entity = true;
                    }
                    // Else just check to see if value exists in model
                    else if (pid_index[data[j].value] != undefined) // If part ID exists in current model
                    {
                        found_entity = true;
                    }
                }
                if (data[j].select_type == "Joint") // Joints just have to exist in the model (no database history for joints)
                {
                    if (jid_index[data[j].value] != undefined) // If Joint ID exists in current model
                    {
                        found_entity = true;
                    }
                }
                if (data[j].select_type == "JointStiffness") // Joints just have to exist in the model (no database history for joints)
                {
                    if (jsid_index[data[j].value] != undefined) // If JointStiffness ID exists in current model
                    {
                        found_entity = true;
                    }
                }

                for(var k = 0; k < database_cards.length; k++) //Loop through the list of database cards and see if there is one of this type and with this id 
                {
                    if (database_cards[k].type == data[j].select_type.toUpperCase())
                    {
                        if (data[j].value == "") continue;
                        if (data[j].value == database_cards[k].label || data[j].value == database_cards[k].heading)
                        {
                            found_entity = true;
                        }        
                    }
                }
                if(found_entity == false && (tbxs[i].variable_type == "ID" || tbxs[i].variable_type == "nx"))
                {
                    if(Window.Theme() == Window.USE_OLD_UI_JS) tbxs[i].background = Widget.DARKRED;
                    else                                       tbxs[i].category   = Widget.CATEGORY_WARNING_ACTION;
                    if(tbxs[i].mapped) write_active = false;
                }
                else
                {
                    if(Window.Theme() == Window.USE_OLD_UI_JS) tbxs[i].background = Widget.DARKBLUE;
                    else                                       tbxs[i].category   = Widget.CATEGORY_TEXT_BOX;                    
                    tbxs[i].background = Widget.DARKBLUE;
                }
            }
        }
    }

    // Update text in csv filename textbox
    t_save_csv.text = csv_fname;
}


function add_object_to_data_array(label, variable_name, select_type, variable_type, combobox_options, linked_to, map_value, row, col, occupant, description)
{
    // Adds an object to the global <data> array to create widgets

    var obj = {};

    obj.label = label;
    obj.occupant = occupant;
    if(variable_type == "ID")           obj.value = 0;
    if(variable_type == "nx")           obj.value = 0;
    if(variable_type == "Value")        obj.value = 0;
    else if(variable_type == "String")  obj.value = combobox_options[0];

    obj.variable_name    = variable_name
    obj.select_type      = select_type;
    obj.variable_type    = variable_type;
    obj.combobox_options = combobox_options;
    obj.variable_type    = variable_type;
    obj.linked_to        = linked_to;
    obj.map_value        = map_value;
    obj.row              = row;
    obj.col              = col;

    if (!description) description = ""; //if description is blank hover text will not display
    obj.description      = description; //this is used for hover text

    data.push(obj);
}


function exit()
{
    // Exits the script
    Exit();
}


function write_csv()
{
    // Writes the selected data to a csv file in <reporter_temp_csv_fname> and the file
    // selected by the user.
    // Then deletes <no_data_fname>
    // before exiting the script

    // csv file in REPORTER_TEMP. This has to be written for the template to work.
    var dont_write_variables = ["ELEMENT_NUMBER_CSV","OFFSET_FOR_IDS", "IDS_FROM_CSV"]
    var f = new File(reporter_temp_csv_fname, File.WRITE); 

    if(File.Exists(reporter_temp_csv_fname))
    {
        write_data(f);
        delete_no_data_file();
        f.Close();
    }
    else
    {
        Window.Error("", "Could not write csv file to " + reporter_temp_csv_fname + ". Template will not generate.");
    }

    // csv file specified by user. If this doesn't get written, it's not fatal, but let the user know.

    var f = new File(csv_fname, File.WRITE);   // File specified by user

    if(File.Exists(csv_fname))
    {
        write_data(f);            
        f.Close();
    }
    else
    {
        Window.Message("", "Could not write csv file to " + csv_fname + ". Template should still generate.");
    }

    // Exit script
    Exit();
}



function write_post_end()
{
    // Writes data as post *END data.
    // 
    // Also writes the selected data to a csv file <reporter_temp_csv_fname>
    // then deletes <no_data_fname>
    // before exiting the script.

    // Remove any existing EuroNCAP Front Impact user data

    remove_front_impact_data(m);

    // Add selected data to model user data

    var new_data = write_data();

    add_front_impact_data(m, new_data);

    // Save the master file

    m.Write(key_name, Include.MASTER_ONLY, Include.RELATIVE, Include.UNIX);

    // Write a csv file with the information too.  This is what Reporter
    // will read to get the information.
    //
    // This will also delete the <no_data_fname>
    // file and exit the script

    write_csv();
}

function write_data(file)
// Function that either writes the data to the specified CSV <file> if defined,
// or if undefined, returns the data in an array to be written out with the 
// model as post-*END data.
{
    var post_end_data = [];
    for (var i = 0; i < data.length; i++)
    {
        if(data[i].variable_type != "Line" && data[i].variable_type != "Subsection" && data[i].variable_type != "full_width_Subsection")
        {
            // Don't write IDs if they are zero
            if(!(data[i].variable_type == "ID" && data[i].value == 0))
            {
                if (dont_write_variables.indexOf(data[i].variable_name) == -1)
                {
                    // Write each part ID as a separate entry (preserves compatibility with other scripts in templates)
                    if (data[i].select_type == "Part")
                    {
                        var string_value = data[i].value.toString(); //need to do this as if pick is used (rather than select) value comes through as int
                        var pids = string_value.split(" ");
                        for (var s = 0; s < pids.length; s++)
                        {
                            if (pids[s] == "") continue;
                            var str = data[i].variable_name + "," + pids[s];
                            if (file == undefined)
                                post_end_data.push(str);
                            else
                                file.Writeln(str);
                        }
                    }
                    else
                    {
                        var str = data[i].variable_name + "," + data[i].value;
                        if (file == undefined)
                            post_end_data.push(str);
                        else
                            file.Writeln(str);
                    }
                }
            }
        }
    }
    return post_end_data;
}



function remove_front_impact_data(m)
{
    // Removes user data from model <m> of the format:
    //
    // <post_end_header>
    //    .
    //    .
    //    .
    // <post_end_footer>
    //

    // Get current data

    var current_data = m.user_data.split("\n");

    // Populate <new_data> array without the IIHS front impact data

    var new_data = [];

    if(current_data.length > 0)
    {
        var remove = false;

        for(var i = 0; i < current_data.length; i++)
        {
            if(current_data[i] == post_end_header) remove = true;

            if(!remove) new_data.push(current_data[i]);

            if(current_data[i] == post_end_footer) remove = false;
        }

        // Re-write user data
        if(new_data.length > 0)
        {
            m.user_data = new_data[0];

            for(var i = 1; i < new_data.length; i++)
            {
                m.user_data += "\n" + new_data[i];
            }
        }
    }
}



function add_front_impact_data(m, new_data)
{
    // Adds user data to model <m> of the format:
    //
    // <post_end_header>
    // data[0]
    // data[1]
    // data[2]
    //    .
    //    .
    // data[n]
    // <post_end_footer>
    //


    // Add on <new_data> array to current model user data

    if(new_data.length > 0)
    {
        m.user_data += post_end_header + "\n";

        for(var i = 0; i < new_data.length; i++)
        {
            m.user_data += new_data[i] + "\n";
        }

        m.user_data += post_end_footer;
    }
}

function delete_no_data_file()
{
    // Deletes the <no_data_fname> file

    if(File.Exists(no_data_fname))
    {
        File.Delete(no_data_fname);
    }
}


function sort_history_buttons(a, b)
{
    // Sort array of buttons into alphabetical then numerical order

    var ai = parseInt(a.text);
    var bi = parseInt(b.text);

    // Both text - case insensitive

    if(isNaN(ai) && isNaN(bi))
    {
        if(a.text.toLowerCase() > b.text.toLowerCase())      return  1;
        else if(a.text.toLowerCase() < b.text.toLowerCase()) return -1;
        else                                                 return  0;
    }

    // Both numbers

    else if(!isNaN(ai) && !isNaN(bi))
    {
        return ai - bi;
    }

    // One text, one number -> text should come first

    else
    {
        if(isNaN(ai)) return -1;
        else          return  1;
    }

    return 0;
}


function arrange_popup_widgets(btns, pick, sel, lbl)
{
    // Arranges the widgets <btns> and <lbl> in a popup window
    // so that it will fit in the graphics window

    //if(btns.length == 0) return;

    // Calculate how many columns and rows we'll need

    var res = Window.MasterResolution();

    var dy = 6;
    var ppu = Widget.PixelsPerUnit();

    res[1] /= Math.floor(ppu);
    res[1] -= 2*dy;

    var max_y = res[1] - (res[1] % dy);

    var ncols = Math.ceil(((btns.length) * dy) / max_y);
    var nrows = Math.ceil((btns.length) / ncols);

    // Calculate width of columns needed to fit text on buttons

    var dx = new Array(ncols);

    for(var col = 1; col < ncols; col++) dx[col] = 0;

    var col = 0;
    var row = 0;

    dx[0] = 0;

    for(var i = 0; i < btns.length; i++)
    {
        // Next column
        if(row >= nrows)
        {
            row = 0;
            col++;
            dx[col] = 0;
        }

        var temp = Widget.StringLength(btns[i].text) + 4;

        dx[col] = Math.max(temp, dx[col]);

        row++;
    }

    // The total width of the popup window needs to be wide enough to fit the
    // label in the first row.  Scale them if needed.

    var tot_width = 0;

    for(var i = 0; i < dx.length; i++) tot_width += dx[i];

    var lbl_length = Widget.StringLength(lbl.text) + 4;

    var ratio = lbl_length / tot_width;

    // Scale rows if needed and recalc total width

    if(ratio > 1.0)
    {
        tot_width = 0;

        for(var i = 0; i < dx.length; i++)
        {
            dx[i] = Math.ceil(dx[i] * ratio);

            tot_width += dx[i];
        }
    }
    if(btns.length == 0) tot_width = 55;

    // Now rearrange widgets

    // Label

    var y1 = 10;
    var y2 = y1 + dy;

    var x1 = 1;
    var x2 = x1 + tot_width;

    lbl.left  = x1;
    lbl.right = x2;

    pick.left = x1;
    pick.right = x2;

    sel.left = x1;
    sel.right = x2;

    // Buttons

    var col = 0;
    var row = 0;

    var x1 = 1;
    var x2 = x1 + dx[0];

    y1 += dy;
    y2 += dy;
    y1 += dy;
    y2 += dy;

    for(var i = 0; i < btns.length; i++)
    {
        // Next column
        if(row >= nrows)
        {
            // Start the second column below the pick, select, and label
            y1 = 1 + 3*(dy+1); // pick, select and label were originally defined with dy = 7 rather than 6 hence dy+1
            y2 = y1 + dy;

            x1 += dx[col];

            row = 0;
            col++;

            x2 += dx[col];
        }

        btns[i].top    = y1;
        btns[i].bottom = y2;

        btns[i].left  = x1;
        btns[i].right = x2;

        y1 += dy;
        y2 += dy;

        row += 1;
    }
}


function add_to_array(label, variable_name, variable_type, type_or_options, occupant, variable_subset, description)
{
    var obj = {};
    obj.label           = label;
    obj.variable_name   = variable_name;
    obj.variable_type   = variable_type;
    obj.variable_subset = variable_subset;
    obj.occupant        = occupant;
    if(obj.variable_type == "ID")
    {
        obj.value = 0; // this will be displayed in the box
        obj.id_type = type_or_options;
    }
    else if(obj.variable_type == "String")
    {
        obj.combobox_options = type_or_options;
        obj.value = obj.combobox_options[0];
    }
    else if(obj.variable_type == "Value")
    {
        //type_or_options is the default value
        if (type_or_options && (type_or_options.toUpperCase() != "NONE"))
        {
            obj.value = type_or_options; // this will be displayed in the box
        }
        else
        {
            obj.value = 0; // this will be displayed in the box
        }
        
    }

    //add label name as hover text (plus optional additional description)
    if (!description) description = label;
    else description = label + "\n\n" + description;
    obj.description = description;

    possible_variables.push(obj);

}


function write_lst()
{
    // Writes the selected data to a lst file in %REPORTER_TEMP% and the file
    // selected by the user.
    // Then deletes "%REPORTER_TEMP%" + "/EuroNCAP_Adult_Headform_No_Data.txt"
    // before exiting the script

    // lst file in REPORTER_TEMP. This has to be written for the template to work.

    var f = new File(reporter_temp_lst_fname, File.WRITE); 

    if(File.Exists(reporter_temp_lst_fname))
    {
        for(var i = 0; i<data.length; i++)
        {
            if(data[i].variable_type != "full_width_Subsection" && data[i].variable_type != "Line")
            {
                // Don't write IDs if they are zero

                if(!(data[i].variable_type == "ID" && data[i].value == 0))
                {
                    f.Write("$" + data[i].variable_name + "," + data[i].value + "\n");
                }
            }
        }

        // Also write data from original .lst file (stored in global <comments> and <non_comments> arrays)

        for(var i=0; i<comments.length;     i++) f.Write(comments[i]     + "\n");
        for(var i=0; i<non_comments.length; i++) f.Write(non_comments[i] + "\n");

        // Delete the file that tells Reporter that data wasn't selected

        delete_no_data_file();
        f.Close();
    }
    else
    {
        Window.Error("", "Could not write lst file to " + reporter_temp_lst_fname + ". Template will not generate.");
    }

    // lst file specified by user. If this doesn't get written, it's not fatal, but let the user know.

    var f = new File(lst_fname, File.WRITE);   // File specified by user

    if(File.Exists(lst_fname))
    {
        for(var i = 0; i < data.length; i++)
        {

            if(data[i].variable_type != "full_width_Subsection" && data[i].variable_type != "Line")
            {
                // Don't write IDs if they are zero

                if(!(data[i].variable_type == "ID" && data[i].value == 0))
                {
                    f.Write("$" + data[i].variable_name + "," + data[i].value + "\n");
                }
            }
        }

        // Also write data from original .lst file (stored in global <comments> and <non_comments> arrays)

        for(var i=0; i<comments.length;     i++) f.Write(comments[i]     + "\n");
        for(var i=0; i<non_comments.length; i++) f.Write(non_comments[i] + "\n");

        f.Close();
    }
    else
    {
        Window.Message("", "Could not write lst file to " + lst_fname + ". Template should still generate.");
    }

    // Exit script

    Exit();
}
