
function find_lsdyna_files(dir, job_name, type)
// Searches a directory for filenames matching either Arup or LSTC filename conventions.
// Searches for files in directory <dir> of type <type>, possibly containing
// <job_name>, and returns the first match in the priority lists below.
{
    var filters = [];

    switch (type)
    {
        case "KEY":
            var filters = [new RegExp("^" + job_name + "\.key$"),
                           new RegExp("^" + job_name + "\.k$"),
                           new RegExp("^" + job_name + ".*\.key$"),
                           new RegExp("^" + job_name + ".*\.k$"),
                           new RegExp(".*\.key$"),
                           new RegExp(".*\.k$")];

            break;

        case "PTF":
            var filters = [new RegExp("^" + job_name + "\.ptf$"),
                           new RegExp("^" + job_name + "\.d3plot$"),
                           new RegExp("^" + job_name + "\.fz$"),
                           new RegExp("^d3plot$"),
                           new RegExp("^Zd3plot$"),
                           new RegExp("^" + job_name + ".*\.ptf$"),
                           new RegExp("^" + job_name + ".*\.d3plot$"),
                           new RegExp(".*\.ptf$"),
                           new RegExp(".*\.d3plot$"),
                           new RegExp(".*\.fz$"),
                           new RegExp(".*\.Zd3plot$")];
            break;

        
        case "THF":
            var filters = [new RegExp("^" + job_name + "\.thf$"),
                          new RegExp("^" + job_name + "\.d3thdt$"),
                          new RegExp("^d3thdt$"),
                          new RegExp("^" + job_name + ".*\.thf$"),
                          new RegExp("^" + job_name + ".*\.d3thdt$"),
                          new RegExp(".*\.thf$"),
                          new RegExp(".*\.d3thdt$")];
            break;

        
        case "BINOUT":
            var filters = [new RegExp("^" + job_name + "\.binout.*$"),
                          new RegExp("^binout.*$"),
                          new RegExp("^" + job_name + ".*\.binout.*$"),
                          new RegExp(".*\.binout.*$")];
            break;
    

        case "OTF":
            var filters = [new RegExp("^" + job_name + "\.otf$"),
                           new RegExp("^" + job_name + "\.d3hsp$"),
                           new RegExp("^d3hsp$"),
                           new RegExp("^" + job_name + ".*\.otf$"),
                           new RegExp("^" + job_name + ".*\.d3hsp$"),
                           new RegExp(".*\.otf$"),
                           new RegExp(".*\.d3hsp$")];
            break;

        default:
            break;
    }

    var filelist = [];
    var filestore = [];
    for(var i = 0; i < filters.length; i++)
    {
        if (WhichProgram() == "reporter") {
            filelist = File.FindFiles(dir, "*", false);
        }
        else
        {
            filelist = File.FindFiles(dir);
        }
        for (var j = 0; j < filelist.length; j++)
        {
            if (filters[i].test(filelist[j]) == true)
            {
                filestore.push(filelist[j]);
            }
        }    
        if(filestore.length > 0)
        {
            filestore.sort();
            var filename = filestore[0].substring(Math.max(filestore[0].lastIndexOf("/"), filestore[0].lastIndexOf("\\")) + 1);
            break;
        }
    }

    if (filestore.length == 0)
        return null;
  
    var absolute_filename = dir + "/" + filename;

    return absolute_filename;
}

/* Returns a string indicating which program the script is being run from */
function WhichProgram() 
{
	if(typeof Xrefs === "function") return "primer";
	else if(typeof Graph === "function") return "this";
	else if(typeof QueryDataPresent === "function") return "d3plot";
    else if(typeof Template === "function") return "reporter";
	else return null;
}
