function DriveMapLst(filepath)
{      
// Get the filename of the LST file
    let fname_lst_orig = template.ExpandVariablesInString(filepath);

// Create a new file for the updated file by appending "_DRIVE_MAPPED"
// We may delete this at the end if we didn't need to map any drives.

    let fname_lst_map = fname_lst_orig + "_DRIVE_MAPPED";

    let f_lst_map = new File(fname_lst_map, File.WRITE);

    if (!File.Exists(fname_lst_map)) 
    {
        Window.Error("", "Could not open file to map drives in LST file");
        return false;
    }

// Read through original and copy to "_DRIVE_MAPPED" file,
// mapping filenames if needed.
    let mapped = false;

    if (File.Exists(fname_lst_orig) && File.IsFile(fname_lst_orig)) 
    {
        let map_name;
        let line;
        let list;
        let diff;

        let f_lst_orig = new File(fname_lst_orig, File.READ);

        while ((line = f_lst_orig.ReadLine()) != File.EOF) 
        {
            if (line[0] != '$') 
            {
// Lines with no '$' are comma separated -> <fname>,<template_name>,<zone_name>,...
// Try to map the drive of the filename in the first column.

                list = line.split(",");

                map_name = File.DriveMapFilename(list[0], Include.NATIVE);

// If the mapped name is different from the original, set the <mapped> flag to true so we know not to 
// delete the "_DRIVE_MAPPED" file. Also, update list[0] with the new name.
//
// Don't do this if the only difference is '/'s converted to '\' or vice-versa.

                diff = false;

                if (map_name.length != list[0].length) diff = true;

                if (!diff) 
                {
                    for (let i = 0; i < map_name.length; i++) 
                    {
                        if (map_name[i] != list[0][i]) 
                        {
                            if (map_name[i] == '\\' && list[0][i] == '/') continue;
                            if (map_name[i] == '/' && list[0][i] == '\\') continue;
                            diff = true;
                        }
                    }
                }

                if (diff) 
                {
                    list[0] = map_name;
                    mapped = true;
                }

// Replace original name with mapped name in the line
                line = list[0];
                for (let i = 1; i < list.length; i++) 
                {
                    line += "," + list[i];
                }
            }

// Write line to "_DRIVE_MAPPED" file
            f_lst_map.Write(line + "\n");
        }
    } 
    else 
    {
        Window.Error("", "Given .lst file does not exist or is not recognised as a file.");
        return false;
    }

// Close the "_DRIVE_MAPPED" file and delete it if nothing was mapped
    f_lst_map.Close();
    if (!mapped) File.Delete(fname_lst_map);

    return true;
}
