// Constants used through out the script

var REG_DT     = 0.00001; // dt for regularising curves (in seconds)
var HIC_WINDOW = 0.036;      // HIC time Window (in seconds)

// Reporter variables

if(File.Exists(fname_csv) && File.IsFile(fname_csv))
{
	var line;
	var oGlblData = new Object();

	var f_vars = do_common_single_analysis_setup(oGlblData);

	// For each body region, do the calculation, writing results to the variables file.
	// 2 here denotes two dummies: driver and rear passenger
	// Third argument false for nij flag
	do_head_rating_calc(f_vars, 2, false);
  
	do_chest_3_sensors_rating_calc(f_vars, 1);

	do_abdomen_rating_calc(f_vars, 1);

	do_pubic_symphysis_rating_calc(f_vars, 1);
    
	// do_pelvis_rating_calc can handle both driver and passenger dummy
	// so we have added an extra flag to process only passenger dummy
	// third argument represents the flag for passenger dummy only
	do_pelvis_rating_calc(f_vars, 2, true);
      
	f_vars.Close();
}

function calculate_unit_constants()
{
// Calculate constants based on the model units

  var len  = oGlblData.unit_length;
  var mass = oGlblData.unit_mass;
  var time = oGlblData.unit_time;
  
  oGlblData.len_factor  = 1.0;
  oGlblData.mass_factor = 1.0;
  oGlblData.time_factor = 1.0;
  
// Factors to convert from metres, kgs to model units
  
       if(len == "m")    len_factor = 1.0;
  else if(len == "cm")   len_factor = 100.0;
  else if(len == "mm")   len_factor = 1000.0;
  else if(len == "inch") len_factor = 39.37008;
  else if(len == "ft")   len_factor = 3.28084;
  
       if(mass == "tonne") mass_factor = 0.001;
  else if(mass == "kg")    mass_factor = 1.0;
  else if(mass == "lb")    mass_factor = 2.204586;
  else if(mass == "slug")  mass_factor = 0.06852178;
  else if(mass == "gram")  mass_factor = 1000.0;
  
       if(time == "s")   time_factor = 1.0;
  else if(time == "ms")  time_factor = 1000.0;
  else if(time == "us")  time_factor = 1000000.0;

  oGlblData.len_factor  = len_factor;
  oGlblData.mass_factor = mass_factor;
  oGlblData.time_factor = time_factor;
  
// Gravity constant in model units (9.81 m/s^2)
  
  oGlblData.g_constant = 9.81 * len_factor / (time_factor*time_factor);
  
// Factor to divide force by to convert to kN

  oGlblData.kn_factor = 1000 * (mass_factor * len_factor / (time_factor * time_factor));
  
// Factor to divide moment by to convert to Nm

  oGlblData.nm_factor = mass_factor * len_factor * len_factor / (time_factor * time_factor);
  
// Factor to divide length by to convert to mm

  oGlblData.mm_factor = len_factor / 1000;
  
}
  


function write_missing_result_variables(f, missing)
{
  if(missing)
  {
    var name  = "MISSING_RESULTS_MESSAGE";
    var value = "Unable to find results for RESULTS_DIR/DEFAULT_JOB";
    var desc  = "Could not find any results";
    var type  = "String";
    
    f.Writeln(name + "," + value + "," + desc + "," + type);
  }
  else
  {
    var name  = "MISSING_RESULTS_MESSAGE";
    var value = "";
    var desc  = "Blank as no results were missing";
    var type  = "String";
    
    f.Writeln(name + "," + value + "," + desc + "," + type);
  }
}


function draw_constant_datums(good_limit)
{
// Creates datum lines to show ratings


// Delete any that might already exist

  if(Datum.Exists("GOOD"))     Datum.Delete("GOOD");
  if(Datum.Exists("ADEQUATE")) Datum.Delete("ADEQUATE");
  if(Datum.Exists("WEAK"))     Datum.Delete("WEAK");
  
// Create new ones and colour in
  
  var d_good = new Datum("GOOD",     Datum.CONSTANT_Y, good_limit);
  
  d_good.line_colour = EuroNCAPColour.GREEN;
  
  if(good_limit > 0)
  {
    d_good.fill_colour_below = EuroNCAPColour.GREEN;
    d_good.fill_colour_above = EuroNCAPColour.RED;
  }
  else
  {
    d_good.fill_colour_above = EuroNCAPColour.GREEN;
    d_good.fill_colour_below = EuroNCAPColour.RED;
  }
}
