/// <reference path="C:/SOURCE14/this_dir/this_js_api/this.intellisense.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common1.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common_EuroNCAP.js" />

// Euro NCAP: Technical Bulletin TB 027 v1.1.1 -- https://cdn.euroncap.com/media/58240/tb-027-compatiblity-assessment-v111.pdf
// C-NCAP: Management Regulation 2021 Edition -- https://www.c-ncap.org.cn/cms/picture/357347311580393472.pdf

var limits = {};
limits.EuroNCAP = {};
limits.CNCAP = {};

limits.EuroNCAP["2020"] = {};  // Compatibility assessment: values per Technical Bulletin TB 027 v1.1.1
                               // -- checked by Adam Jaffe, Feb 2022
                               // Occupant assessment: values per ____________
                               // -- checked by Ru Li, 2021
limits.EuroNCAP["2023"] = {};  // Compatibility assessment: all values except MAX_TOTAL_PENALTY same as 2020
                               // -- checked by Adam Jaffe, Feb 2022
                               // Occupant assessment: VALUES NOT INCLUDED

limits.CNCAP["2022"] = {};  // Compatibility assessment: values per C-NCAP Management Regulation 2021 Edition
                            // -- checked by Adam Jaffe, Feb 2022
                            // Occupant assessment: values per ______________
                            // -- checked by Ru Li, 2021
limits.CNCAP["2023"] = {};  // Compatibility assessment: all values except MAX_TOTAL_PENALTY same as 2022
                            // -- checked by Adam Jaffe, Feb 2022
                            // Occupant assessment: VALUES NOT INCLUDED


/* EuroNCAP */

// Constants used throughout the script

limits.EuroNCAP["2020"].REG_DT     = 0.00001; // dt for regularising curves (in seconds)
limits.EuroNCAP["2020"].HIC_WINDOW = 0.015;   // HIC time window (in seconds)
limits.EuroNCAP["2020"].TMS_PERIOD = 0.003;   // 3ms period (in seconds)

limits.EuroNCAP["2023"].REG_DT     = 0.00001; // dt for regularising curves (in seconds)

//// MPDB compatibility assessment constants
limits.EuroNCAP["2020"].MAX_TOTAL_PENALTY = 4.0;  // maximum points penalty for SD + OLC + bottoming out

limits.EuroNCAP["2023"].MAX_TOTAL_PENALTY = 8.0;  // maximum points penalty for SD score when OLC score is minimum

// Barrier deformation standard deviation constants
limits.EuroNCAP["2020"].SD_PENALTY_MIN_OLC = 2.0;      // maximum points penalty for SD score when OLC score is minimum
limits.EuroNCAP["2020"].SD_PENALTY_MAX_OLC = 6.0;      // maximum points penalty for SD score when OLC score is maximum
limits.EuroNCAP["2020"].SD_SCALE_MIN = 50;             // mm - lower bound of sliding scale
limits.EuroNCAP["2020"].SD_SCALE_MAX = 150;            // mm - upper bound of sliding scale
limits.EuroNCAP["2020"].SD_MAX_INTRUSION = 633;        // mm - maximum intrusion depth when calculating standard deviation (per Protocol spreadsheet)
limits.EuroNCAP["2020"].EVAL_AREA_LOWER_BORDER = 250;  // mm above ground level
limits.EuroNCAP["2020"].EVAL_AREA_UPPER_BORDER = 650;  // mm above ground level
limits.EuroNCAP["2020"].EVAL_AREA_EDGE_BORDER = 200;   // mm from edge on driver side
limits.EuroNCAP["2020"].EVAL_AREA_WIDTH_FRAC = 0.45;   // fraction of vehicle width which defines evaluation area width

limits.EuroNCAP["2023"].SD_PENALTY_MIN_OLC = 2.0;      // maximum points penalty for SD score when OLC score is minimum
limits.EuroNCAP["2023"].SD_PENALTY_MAX_OLC = 6.0;      // maximum points penalty for SD score when OLC score is maximum
limits.EuroNCAP["2023"].SD_SCALE_MIN = 50;             // mm - lower bound of sliding scale
limits.EuroNCAP["2023"].SD_SCALE_MAX = 150;            // mm - upper bound of sliding scale
limits.EuroNCAP["2023"].SD_MAX_INTRUSION = 633;        // mm - maximum intrusion depth when calculating standard deviation (per Protocol spreadsheet)
limits.EuroNCAP["2023"].EVAL_AREA_LOWER_BORDER = 250;  // mm above ground level
limits.EuroNCAP["2023"].EVAL_AREA_UPPER_BORDER = 650;  // mm above ground level
limits.EuroNCAP["2023"].EVAL_AREA_EDGE_BORDER = 200;   // mm from edge on driver side
limits.EuroNCAP["2023"].EVAL_AREA_WIDTH_FRAC = 0.45;   // fraction of vehicle width which defines evaluation area width

// Occupant load criterion constants
limits.EuroNCAP["2020"].OLC_PENALTY = 2.0;        // points penalty for OLC score at or above scale maximum
limits.EuroNCAP["2020"].OLC_SCALE_MIN = 25;       // g - lower bound of sliding scale
limits.EuroNCAP["2020"].OLC_SCALE_MAX = 40;       // g - upper bound of sliding scale
limits.EuroNCAP["2020"].OLC_FFT_T1_DISP = 0.065;  // m - t1 is end of free-flight-phase of virtual dummy on the barrier along this displacement
limits.EuroNCAP["2020"].OLC_FFT_T2_DISP = 0.235;  // m - t2 is end of the restraining-phase of virtual dummy on the barrier along this displacement
limits.EuroNCAP["2020"].OLC_G = 9.81;             // m/s2 - protocol definition of 1g

limits.EuroNCAP["2023"].OLC_PENALTY = 2.0;        // points penalty for OLC score at or above scale maximum
limits.EuroNCAP["2023"].OLC_SCALE_MIN = 25;       // g - lower bound of sliding scale
limits.EuroNCAP["2023"].OLC_SCALE_MAX = 40;       // g - upper bound of sliding scale
limits.EuroNCAP["2023"].OLC_FFT_T1_DISP = 0.065;  // m - t1 is end of free-flight-phase of virtual dummy on the barrier along this displacement
limits.EuroNCAP["2023"].OLC_FFT_T2_DISP = 0.235;  // m - t2 is end of the restraining-phase of virtual dummy on the barrier along this displacement
limits.EuroNCAP["2023"].OLC_G = 9.81;             // m/s2 - protocol definition of 1g

// Bottoming out constants
limits.EuroNCAP["2020"].BOTTOMING_OUT_PENALTY = 2.0;   // points penalty for bottoming out
limits.EuroNCAP["2020"].NUM_ROWS = 28;
limits.EuroNCAP["2020"].NUM_COLUMNS = 50;
limits.EuroNCAP["2020"].BOTTOMING_OUT_LIMIT = 630;     // mm
limits.EuroNCAP["2020"].BOTTOMING_OUT_SHAPE = [2, 2];  // shape of area which defines 'bottoming out', e.g. a 2x2 square at 20mm spacing = 40mmX40mm area

limits.EuroNCAP["2023"].BOTTOMING_OUT_PENALTY = 2.0;   // points penalty for bottoming out
limits.EuroNCAP["2023"].NUM_ROWS = 28;
limits.EuroNCAP["2023"].NUM_COLUMNS = 50;
limits.EuroNCAP["2023"].BOTTOMING_OUT_LIMIT = 630;     // mm
limits.EuroNCAP["2023"].BOTTOMING_OUT_SHAPE = [2, 2];  // shape of area which defines 'bottoming out', e.g. a 2x2 square at 20mm spacing = 40mmX40mm area

//// MPDB OCCUPANT assessment constants
// Head assessment constants

limits.EuroNCAP["2020"].PEAK_HEAD_ACCN_SOFT = 80.0;       // 80g - soft contact

limits.EuroNCAP["2020"].HIC_LO_LIMIT = 500.0;
limits.EuroNCAP["2020"].HIC_HI_LIMIT = 700.0;

limits.EuroNCAP["2020"].TMS_LO_LIMIT   = 72.0;
limits.EuroNCAP["2020"].TMS_HI_LIMIT   = 80.0;
limits.EuroNCAP["2020"].TMS_LO_LIMIT_2 = 65.0;  // } Different 3ms limits for driver 
limits.EuroNCAP["2020"].TMS_HI_LIMIT_2 = 80.0;  // } if no steering wheel airbag present

limits.EuroNCAP["2020"].HEAD_FA_DISP_LO_LIMIT   = 90;   // 90mm  rearward displacement
limits.EuroNCAP["2020"].HEAD_FA_DISP_HI_LIMIT   = 110;  // 110mm rearward displacement
limits.EuroNCAP["2020"].HEAD_LAT_DISP_LO_LIMIT  = 90;   // 90mm  lateral displacement
limits.EuroNCAP["2020"].HEAD_LAT_DISP_HI_LIMIT  = 110;  // 110mm lateral displacement
limits.EuroNCAP["2020"].HEAD_VERT_DISP_LO_LIMIT = 72;   // 72mm  upward displacement
limits.EuroNCAP["2020"].HEAD_VERT_DISP_HI_LIMIT = 88;   // 88mm  upward displacement

limits.EuroNCAP["2020"].STEERING_WHEEL_LO_SCORE = -1.0;
limits.EuroNCAP["2020"].STEERING_WHEEL_HI_SCORE = 0.0;

limits.EuroNCAP["2020"].HEAD_LO_SCORE   = 0.0;
limits.EuroNCAP["2020"].HEAD_HI_SCORE   = 4.0;


// Neck assessment constants for driver and passenger

limits.EuroNCAP["2020"].NECK_SHR_ADJ_FAC = 17.78;   // Factor to multiply shear by to adjust bending moment

limits.EuroNCAP["2020"].NECK_LO_SCORE   = 0.0;
limits.EuroNCAP["2020"].NECK_HI_SCORE   = 4.0;

// Neck limit curves for driver
limits.EuroNCAP["2020"].NECK_SHR_DR_GOOD     = 1.9;
limits.EuroNCAP["2020"].NECK_SHR_DR_ADEQUATE = 2.2333;
limits.EuroNCAP["2020"].NECK_SHR_DR_MARGINAL = 2.5666;
limits.EuroNCAP["2020"].NECK_SHR_DR_WEAK     = 3.1;

limits.EuroNCAP["2020"].NECK_TEN_DR_GOOD     = 2.7;
limits.EuroNCAP["2020"].NECK_TEN_DR_ADEQUATE = 2.9;
limits.EuroNCAP["2020"].NECK_TEN_DR_MARGINAL = 3.1;
limits.EuroNCAP["2020"].NECK_TEN_DR_WEAK     = 3.3;

limits.EuroNCAP["2020"].NECK_MOM_DR_GOOD     = -42.0;
limits.EuroNCAP["2020"].NECK_MOM_DR_ADEQUATE = -47.0;
limits.EuroNCAP["2020"].NECK_MOM_DR_MARGINAL = -52.0;
limits.EuroNCAP["2020"].NECK_MOM_DR_WEAK     = -57.0;

// Neck shear limit curves for passenger
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_TIME     = new Array(4);
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_GOOD     = new Array(4);
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_ADEQUATE = new Array(4);
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_MARGINAL = new Array(4);
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_WEAK     = new Array(4);

limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_TIME[0] = 0.0;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_TIME[1] = 0.025;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_TIME[2] = 0.035;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_TIME[3] = 0.045;
  
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_GOOD[0] = 1.9;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_GOOD[1] = 1.2; 
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_GOOD[2] = 1.2;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_GOOD[3] = 1.1;

limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_ADEQUATE[0] = 2.3;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_ADEQUATE[1] = 1.3;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_ADEQUATE[2] = 1.3;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_ADEQUATE[3] = 1.1;
  
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_MARGINAL[0] = 2.7;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_MARGINAL[1] = 1.4;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_MARGINAL[2] = 1.4;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_MARGINAL[3] = 1.1;
 
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_WEAK[0] = 3.1;   
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_WEAK[1] = 1.5; 
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_WEAK[2] = 1.5;
limits.EuroNCAP["2020"].NECK_SHR_PASS_EXC_WEAK[3] = 1.100001;

// Neck tension limit curves for passenger
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_TIME     = new Array(3);
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_GOOD     = new Array(3);
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_ADEQUATE = new Array(3);
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_MARGINAL = new Array(3);
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_WEAK     = new Array(3);

limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_TIME[0] = 0.0;
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_TIME[1] = 0.035;
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_TIME[2] = 0.060;

limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_GOOD[0] = 2.7;
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_GOOD[1] = 2.3;
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_GOOD[2] = 1.1;

limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_ADEQUATE[0] = 2.9; 
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_ADEQUATE[1] = 2.5;
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_ADEQUATE[2] = 1.1;

limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_MARGINAL[0] = 3.1; 
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_MARGINAL[1] = 2.7;
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_MARGINAL[2] = 1.1;

limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_WEAK[0] = 3.3;
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_WEAK[1] = 2.9;
limits.EuroNCAP["2020"].NECK_TEN_PASS_EXC_WEAK[2] = 1.100001;

limits.EuroNCAP["2020"].NECK_MOM_PASS_GOOD     = 42.0;
limits.EuroNCAP["2020"].NECK_MOM_PASS_ADEQUATE = 47.0;
limits.EuroNCAP["2020"].NECK_MOM_PASS_MARGINAL = 52.0;
limits.EuroNCAP["2020"].NECK_MOM_PASS_WEAK     = 57.0;

// Chest assessment

// V7 and earlier dummies use a linear conversion: D = A*theta

limits.EuroNCAP["2020"].CHEST_V7_ROT_TO_COM_FACTOR = -139.0;   // Factor to convert chest transducer rotation to compression (mm)
limits.EuroNCAP["2020"].CHEST_LSTC_HIII_50TH_MALE_DETAILED_190217_BETA_ROT_TO_COM_FACTOR = -146.0;   // Factor to convert chest transducer rotation to compression (mm)

// V8 dummies use a 3rd order polynomial conversion D = A*theta^3 - B*theta^2 - C*theta

limits.EuroNCAP["2020"].CHEST_V8_ROT_TO_COM_FACTOR_A =   25.13;   // First polynomial factor to convert chest transducer rotation to compression (mm)
limits.EuroNCAP["2020"].CHEST_V8_ROT_TO_COM_FACTOR_B =  -35.77;   // Second polynomial factor to convert chest transducer rotation to compression (mm)
limits.EuroNCAP["2020"].CHEST_V8_ROT_TO_COM_FACTOR_C = -136.26;   // Third polynomial factor to convert chest transducer rotation to compression (mm)

limits.EuroNCAP["2020"].CHEST_VC_A = 1.3;           // Viscous Criterion A constant (for m/s)
limits.EuroNCAP["2020"].CHEST_VC_B = 0.229;         // Viscous Criterion B constant (for m/s)
limits.EuroNCAP["2020"].CHEST_VC_METHOD = "ECER95"; // Viscous Criterion calculation method

limits.EuroNCAP["2020"].PASS_CHEST_COM_GOOD     = 22.00;  // 22mm
limits.EuroNCAP["2020"].PASS_CHEST_COM_ADEQUATE = 28.67;  // 28.67mm
limits.EuroNCAP["2020"].PASS_CHEST_COM_MARGINAL = 35.33;  // 35.33mm
limits.EuroNCAP["2020"].PASS_CHEST_COM_WEAK     = 42.00;  // 42mm

limits.EuroNCAP["2020"].DR_CHEST_COM_GOOD     = 35.00;  // 35mm
limits.EuroNCAP["2020"].DR_CHEST_COM_ADEQUATE = 43.33;  // 43.33mm
limits.EuroNCAP["2020"].DR_CHEST_COM_MARGINAL = 51.67;  // 51.67mm
limits.EuroNCAP["2020"].DR_CHEST_COM_WEAK     = 60.00;  // 60mm

// for driver - abdomen left/right compression
limits.EuroNCAP["2020"].DR_ABDOMEN_COM_WEAK = 88.00; // 88mm

limits.EuroNCAP["2020"].CHEST_VC_GOOD     = 0.5;   // 0.50 m/s
limits.EuroNCAP["2020"].CHEST_VC_ADEQUATE = 0.67;  // 0.67 m/s
limits.EuroNCAP["2020"].CHEST_VC_MARGINAL = 0.83;  // 0.83 m /s
limits.EuroNCAP["2020"].CHEST_VC_WEAK     = 1.0;   // 1.00 m/s

limits.EuroNCAP["2020"].CHEST_A_PILLAR_FA_DISP_GOOD     = 100;     // 100mm  rearward displacement
limits.EuroNCAP["2020"].CHEST_A_PILLAR_FA_DISP_ADEQUATE = 133.33;  // 133.33mm  rearward displacement
limits.EuroNCAP["2020"].CHEST_A_PILLAR_FA_DISP_MARGINAL = 166.67;  // 166.67mm  rearward displacement
limits.EuroNCAP["2020"].CHEST_A_PILLAR_FA_DISP_WEAK     = 200;     // 200mm rearward displacement

limits.EuroNCAP["2020"].CHEST_A_PILLAR_LO_SCORE = -2.0;
limits.EuroNCAP["2020"].CHEST_A_PILLAR_HI_SCORE = 0.0;

limits.EuroNCAP["2020"].CHEST_LO_SCORE = 0.0;
limits.EuroNCAP["2020"].CHEST_HI_SCORE = 4.0;

// Knee, Femur and Pelvis assessments

limits.EuroNCAP["2020"].ACETABULUM_COM_GOOD = 3.28;        // 3.28 kN
limits.EuroNCAP["2020"].ACETABULUM_COM_ADEQUATE = 3.5533;  // 3.5533 kN
limits.EuroNCAP["2020"].ACETABULUM_COM_MARGINAL = 3.8267;  // 3.8267 kN
limits.EuroNCAP["2020"].ACETABULUM_COM_WEAK = 4.10;        // 4.10 kN

// Femur limit curves

limits.EuroNCAP["2020"].FEMUR_COM_EXC_TIME     = new Array(2);
limits.EuroNCAP["2020"].FEMUR_COM_EXC_GOOD     = new Array(2);
limits.EuroNCAP["2020"].FEMUR_COM_EXC_ADEQUATE = new Array(2);
limits.EuroNCAP["2020"].FEMUR_COM_EXC_MARGINAL = new Array(2);
limits.EuroNCAP["2020"].FEMUR_COM_EXC_WEAK     = new Array(2);

limits.EuroNCAP["2020"].FEMUR_COM_EXC_TIME[0] = 0.0;
limits.EuroNCAP["2020"].FEMUR_COM_EXC_TIME[1] = 0.010;

limits.EuroNCAP["2020"].FEMUR_COM_EXC_GOOD[0] = 3.8;
limits.EuroNCAP["2020"].FEMUR_COM_EXC_GOOD[1] = 3.8;

limits.EuroNCAP["2020"].FEMUR_COM_EXC_ADEQUATE[0] = 5.56;
limits.EuroNCAP["2020"].FEMUR_COM_EXC_ADEQUATE[1] = 5.05;

limits.EuroNCAP["2020"].FEMUR_COM_EXC_MARGINAL[0] = 7.31;
limits.EuroNCAP["2020"].FEMUR_COM_EXC_MARGINAL[1] = 6.31;

limits.EuroNCAP["2020"].FEMUR_COM_EXC_WEAK[0] = 9.07;
limits.EuroNCAP["2020"].FEMUR_COM_EXC_WEAK[1] = 7.56;

limits.EuroNCAP["2020"].KNEE_DISP_GOOD     =  6.0;
limits.EuroNCAP["2020"].KNEE_DISP_ADEQUATE =  9.0;
limits.EuroNCAP["2020"].KNEE_DISP_MARGINAL = 12.0;
limits.EuroNCAP["2020"].KNEE_DISP_WEAK     = 15.0;

limits.EuroNCAP["2020"].KNEE_FEMUR_PELVIS_LO_SCORE = 0.0;
limits.EuroNCAP["2020"].KNEE_FEMUR_PELVIS_HI_SCORE = 4.0;

// Lower leg, foot and ankle assessments

limits.EuroNCAP["2020"].TIBIA_COM_GOOD     = 2.0;
limits.EuroNCAP["2020"].TIBIA_COM_ADEQUATE = 4.0;
limits.EuroNCAP["2020"].TIBIA_COM_MARGINAL = 6.0;
limits.EuroNCAP["2020"].TIBIA_COM_WEAK     = 8.0;

limits.EuroNCAP["2020"].TIBIA_INDEX_GOOD     = 0.4;
limits.EuroNCAP["2020"].TIBIA_INDEX_ADEQUATE = 0.7;
limits.EuroNCAP["2020"].TIBIA_INDEX_MARGINAL = 1.0;
limits.EuroNCAP["2020"].TIBIA_INDEX_WEAK     = 1.3;

limits.EuroNCAP["2020"].TIBIA_MRC = 225;    // Tibia index critical moment = 225Nm
limits.EuroNCAP["2020"].TIBIA_FZC = 35.9;   // Tibia index critical force  = 35.9kN

limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_VERT_DISP_GOOD     = 72.0;
limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_VERT_DISP_ADEQUATE = 77.33;
limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_VERT_DISP_MARGINAL = 82.67;
limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_VERT_DISP_WEAK     = 88.0;

limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_VERT_DISP_LO_SCORE = -1.0;
limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_VERT_DISP_HI_SCORE = 0;

limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_FA_DISP_GOOD     = 100.0;
limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_FA_DISP_ADEQUATE = 133.33;
limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_FA_DISP_MARGINAL = 166.67;
limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_FA_DISP_WEAK     = 200.0;

limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_FA_DISP_LO_SCORE = 0.0;
limits.EuroNCAP["2020"].LOWER_LEG_PEDAL_FA_DISP_HI_SCORE = 4.0;

limits.EuroNCAP["2020"].LOWER_LEG_FOOT_AND_ANKLE_LO_SCORE = 0.0;
limits.EuroNCAP["2020"].LOWER_LEG_FOOT_AND_ANKLE_HI_SCORE = 4.0;


/* C-NCAP */

// Constants used throughout the script
limits.CNCAP["2022"].REG_DT = 0.00001; // dt for regularising curves (in seconds)
limits.CNCAP["2023"].REG_DT = 0.00001;

//// MPDB compatibility assessment constants
limits.CNCAP["2022"].MAX_TOTAL_PENALTY = 3.0;  // maximum points penalty for SD + OLC + bottoming out (used to generate scale factor)
limits.CNCAP["2023"].MAX_TOTAL_PENALTY = 6.0; 

// Barrier deformation standard deviation constants
limits.CNCAP["2022"].SD_PENALTY_MIN_OLC = 2.0;      // maximum points penalty for SD score when OLC score is minimum (scaled during scoring)
limits.CNCAP["2022"].SD_PENALTY_MAX_OLC = 2.0;      // maximum points penalty for SD score when OLC score is maximum (scaled during scoring)
limits.CNCAP["2022"].SD_SCALE_MIN = 50;             // mm - lower bound of sliding scale
limits.CNCAP["2022"].SD_SCALE_MAX = 150;            // mm - upper bound of sliding scale
limits.CNCAP["2022"].SD_MAX_INTRUSION = Infinity;   // mm - maximum intrusion depth when calculating standard deviation (none defined in protocol)
limits.CNCAP["2022"].EVAL_AREA_LOWER_BORDER = 250;  // mm above ground level
limits.CNCAP["2022"].EVAL_AREA_UPPER_BORDER = 650;  // mm above ground level
limits.CNCAP["2022"].EVAL_AREA_EDGE_BORDER = 200;   // mm from edge on driver side
limits.CNCAP["2022"].EVAL_AREA_WIDTH_FRAC = 0.45;   // fraction of vehicle width which defines evaluation area width

limits.CNCAP["2023"].SD_PENALTY_MIN_OLC = 2.0;      // maximum points penalty for SD score when OLC score is minimum
limits.CNCAP["2023"].SD_PENALTY_MAX_OLC = 2.0;      // maximum points penalty for SD score when OLC score is maximum
limits.CNCAP["2023"].SD_SCALE_MIN = 50;             // mm - lower bound of sliding scale
limits.CNCAP["2023"].SD_SCALE_MAX = 150;            // mm - upper bound of sliding scale
limits.CNCAP["2023"].SD_MAX_INTRUSION = Infinity;   // mm - maximum intrusion depth when calculating standard deviation (none defined in protocol)
limits.CNCAP["2023"].EVAL_AREA_LOWER_BORDER = 250;  // mm above ground level
limits.CNCAP["2023"].EVAL_AREA_UPPER_BORDER = 650;  // mm above ground level
limits.CNCAP["2023"].EVAL_AREA_EDGE_BORDER = 200;   // mm from edge on driver side
limits.CNCAP["2023"].EVAL_AREA_WIDTH_FRAC = 0.45;   // fraction of vehicle width which defines evaluation area width

// Occupant load criterion constants
limits.CNCAP["2022"].OLC_PENALTY = 2.0;        // points penalty for OLC score at or above scale maximum (scaled during scoring)
limits.CNCAP["2022"].OLC_SCALE_MIN = 25;       // g - lower bound of sliding scale
limits.CNCAP["2022"].OLC_SCALE_MAX = 40;       // g - upper bound of sliding scale
limits.CNCAP["2022"].OLC_FFT_T1_DISP = 0.065;  // m - t1 is end of free-flight-phase of virtual dummy on the barrier along this displacement
limits.CNCAP["2022"].OLC_FFT_T2_DISP = 0.235;  // m - t2 is end of the restraining-phase of virtual dummy on the barrier along this displacement
limits.CNCAP["2022"].OLC_G = 9.81;             // m/s2 - definition of 1g (unstated in protocol)

limits.CNCAP["2023"].OLC_PENALTY = 2.0;        // points penalty for OLC score at or above scale maximum
limits.CNCAP["2023"].OLC_SCALE_MIN = 25;       // g - lower bound of sliding scale
limits.CNCAP["2023"].OLC_SCALE_MAX = 40;       // g - upper bound of sliding scale
limits.CNCAP["2023"].OLC_FFT_T1_DISP = 0.065;  // m - t1 is end of free-flight-phase of virtual dummy on the barrier along this displacement
limits.CNCAP["2023"].OLC_FFT_T2_DISP = 0.235;  // m - t2 is end of the restraining-phase of virtual dummy on the barrier along this displacement
limits.CNCAP["2023"].OLC_G = 9.81;             // m/s2 - definition of 1g (unstated in protocol)

// Bottoming out constants
limits.CNCAP["2022"].BOTTOMING_OUT_PENALTY = 2.0;   // points penalty for bottoming out (scaled during scoring)
limits.CNCAP["2022"].NUM_ROWS = 28;
limits.CNCAP["2022"].NUM_COLUMNS = 50;
limits.CNCAP["2022"].BOTTOMING_OUT_LIMIT = 630;     // mm
limits.CNCAP["2022"].BOTTOMING_OUT_SHAPE = [2, 3];  // shape of area which defines 'bottoming out', e.g. a 2x3 rectangle at 20mm spacing = 40mmX60mm area

limits.CNCAP["2023"].BOTTOMING_OUT_PENALTY = 2.0;   // points penalty for bottoming out
limits.CNCAP["2023"].NUM_ROWS = 28;
limits.CNCAP["2023"].NUM_COLUMNS = 50;
limits.CNCAP["2023"].BOTTOMING_OUT_LIMIT = 630;     // mm
limits.CNCAP["2023"].BOTTOMING_OUT_SHAPE = [2, 3];  // shape of area which defines 'bottoming out', e.g. a 2x3 rectangle at 20mm spacing = 40mmX60mm area

// Barrier intrusion height constants
limits.CNCAP["2022"].NO_ATTENUATION_PENALTY = 1.0;  // points penalty for no attenuation
limits.CNCAP["2022"].ATTENUATION_LIMIT = 480;       // mm - compression depth which triggers penalty if no attenuation trend is observed
limits.CNCAP["2022"].ATTENUATION_SHAPE = [2, 3];    // shape of area which defines intrusion at height, e.g. a 2x3 rectangle at 20mm spacing = 40mmX60mm area

limits.CNCAP["2023"].NO_ATTENUATION_PENALTY = 1.0;  // points penalty for no attenuation
limits.CNCAP["2023"].ATTENUATION_LIMIT = 480;       // mm - compression depth which triggers penalty if no attenuation trend is observed
limits.CNCAP["2023"].ATTENUATION_SHAPE = [2, 3];    // shape of area which defines intrusion at height, e.g. a 2x3 rectangle at 20mm spacing = 40mmX60mm area


//// MPDB OCCUPANT assessment constants
limits.CNCAP["2022"].REG_DT = 0.00001; // dt for regularising curves (in seconds)

// Need double check
limits.CNCAP["2022"].HIC_WINDOW = 0.015; // Need double check
limits.CNCAP["2022"].TMS_PERIOD = 0.003; // Need double check

// Head assessment constants
// No hard/soft contact definition in CNCAP
// for both driver and passenger
limits.CNCAP["2022"].HIC_LO_LIMIT = 500.0;  
limits.CNCAP["2022"].HIC_HI_LIMIT = 700.0;
limits.CNCAP["2022"].TMS_LO_LIMIT = 72.0;
limits.CNCAP["2022"].TMS_HI_LIMIT = 80.0;

// Modifier for Driver only
limits.CNCAP["2022"].HEAD_FA_DISP_LO_LIMIT = 90; // 90mm rearward displacement
limits.CNCAP["2022"].HEAD_FA_DISP_HI_LIMIT = 110; // 110mm rearward displacement
limits.CNCAP["2022"].HEAD_LAT_DISP_LO_LIMIT = 90; // 90mm lateral displacement
limits.CNCAP["2022"].HEAD_LAT_DISP_HI_LIMIT = 110; // 110mm lateral displacement
limits.CNCAP["2022"].HEAD_VERT_DISP_LO_LIMIT = 72; // 72mm upward displacement
limits.CNCAP["2022"].HEAD_VERT_DISP_HI_LIMIT = 88; // 88mm upward displacement
limits.CNCAP["2022"].STEERING_WHEEL_LO_SCORE = -1.0;
limits.CNCAP["2022"].STEERING_WHEEL_HI_SCORE = 0.0;

limits.CNCAP["2022"].HEAD_LO_SCORE = 0.0;
limits.CNCAP["2022"].HEAD_HI_SCORE = 4.0;

// Neck assessment constants for driver and passenger
limits.CNCAP["2022"].NECK_SHR_ADJ_FAC = 17.78; // Factor to multiply shear by to adjust bending moment

limits.CNCAP["2022"].NECK_LO_SCORE = 0.0;
limits.CNCAP["2022"].NECK_HI_SCORE = 4.0;


// Neck limit curves 
// for driver
limits.CNCAP["2022"].NECK_SHR_DR_GOOD = 1.9;  // 1.9kN
limits.CNCAP["2022"].NECK_SHR_DR_ADEQUATE = 2.2333;
limits.CNCAP["2022"].NECK_SHR_DR_MARGINAL = 2.5666;
limits.CNCAP["2022"].NECK_SHR_DR_WEAK = 3.1;

limits.CNCAP["2022"].NECK_TEN_DR_GOOD = 2.7;   // 2.7kN
limits.CNCAP["2022"].NECK_TEN_DR_ADEQUATE = 2.9;
limits.CNCAP["2022"].NECK_TEN_DR_MARGINAL = 3.1;
limits.CNCAP["2022"].NECK_TEN_DR_WEAK = 3.3;

limits.CNCAP["2022"].NECK_MOM_DR_GOOD = 42.0;  // 42N-m
limits.CNCAP["2022"].NECK_MOM_DR_ADEQUATE = 47.0;
limits.CNCAP["2022"].NECK_MOM_DR_MARGINAL = 52.0;
limits.CNCAP["2022"].NECK_MOM_DR_WEAK = 57.0;

// for passenger
limits.CNCAP["2022"].NECK_SHR_PASS_GOOD = 1.2;  // 1.2kN
limits.CNCAP["2022"].NECK_SHR_PASS_ADEQUATE = 1.45;
limits.CNCAP["2022"].NECK_SHR_PASS_MARGINAL = 1.7;
limits.CNCAP["2022"].NECK_SHR_PASS_WEAK = 1.95;

limits.CNCAP["2022"].NECK_SHR_PASS_WEAK_OVERALL = 2.7;

// Neck tension limit curves for passenger
limits.CNCAP["2022"].NECK_TEN_PASS_GOOD = 1.7;  // 1.7kN
limits.CNCAP["2022"].NECK_TEN_PASS_ADEQUATE = 2.01; 
limits.CNCAP["2022"].NECK_TEN_PASS_MARGINAL = 2.31; 
limits.CNCAP["2022"].NECK_TEN_PASS_WEAK = 2.62;

limits.CNCAP["2022"].NECK_TEN_PASS_WEAK_OVERALL = 2.9;

// Neck extension moment limit curves for passenger
limits.CNCAP["2022"].NECK_MOM_PASS_GOOD = 36;  // 36N-m
limits.CNCAP["2022"].NECK_MOM_PASS_ADEQUATE = 40.33; 
limits.CNCAP["2022"].NECK_MOM_PASS_MARGINAL = 44.67; 
limits.CNCAP["2022"].NECK_MOM_PASS_WEAK = 49;

limits.CNCAP["2022"].NECK_MOM_PASS_WEAK_OVERALL = 57;

// Chest assessment
// V6 and earlier dummies use a linear conversion: D = A*theta
limits.CNCAP["2022"].CHEST_V7_ROT_TO_COM_FACTOR = -139.0; // Factor to convert chest transducer rotation to compression (mm)
limits.CNCAP["2022"].CHEST_V2_LSTC_ROT_TO_COM_FACTOR = -104.0; // Factor to convert chest transducer rotation to compression (mm)
// V7 dummies use a 3rd order polynomial conversion D = A*theta^3 - B*theta^2 - C*theta
limits.CNCAP["2022"].CHEST_V7_ROT_TO_COM_FACTOR_A = -15.61; // First polynomial factor to convert chest transducer rotation to compression (mm)
limits.CNCAP["2022"].CHEST_V7_ROT_TO_COM_FACTOR_B = 33.84; // Second polynomial factor to convert chest transducer rotation to compression (mm)
limits.CNCAP["2022"].CHEST_V7_ROT_TO_COM_FACTOR_C = 81.53; // Third polynomial factor to convert chest transducer rotation to compression (mm)
limits.CNCAP["2022"].CHEST_VC_A = 1.3; // Viscous Criterion A constant (for m/s)
limits.CNCAP["2022"].CHEST_VC_B = 0.229; // Viscous Criterion B constant (for m/s)
limits.CNCAP["2022"].CHEST_VC_METHOD = "ECER95"; // Viscous Criterion calculation method

// for driver - compression of 4 ribs
limits.CNCAP["2022"].DR_CHEST_COM_GOOD = 35.00;  // 35mm
limits.CNCAP["2022"].DR_CHEST_COM_ADEQUATE = 43.33; 
limits.CNCAP["2022"].DR_CHEST_COM_MARGINAL = 51.67; 
limits.CNCAP["2022"].DR_CHEST_COM_WEAK = 60.00;

// for driver - abdomen left/right compression
limits.CNCAP["2022"].DR_ABDOMEN_COM_WEAK = 88.00;  // 88mm

// for passenger - compression of 4 ribs
limits.CNCAP["2022"].PASS_CHEST_COM_GOOD = 18.00;  // 18mm
limits.CNCAP["2022"].PASS_CHEST_COM_ADEQUATE = 26.00; 
limits.CNCAP["2022"].PASS_CHEST_COM_MARGINAL = 34.00; 
limits.CNCAP["2022"].PASS_CHEST_COM_WEAK = 42.00;

// for passenger - VC
limits.CNCAP["2022"].CHEST_VC_GOOD = 0.5;  // 0.5m/s
limits.CNCAP["2022"].CHEST_VC_ADEQUATE = 0.67; 
limits.CNCAP["2022"].CHEST_VC_MARGINAL = 0.83; 
limits.CNCAP["2022"].CHEST_VC_WEAK = 1.0;

// Modifier for Driver only
limits.CNCAP["2022"].CHEST_A_PILLAR_FA_DISP_GOOD = 100; // 100mm rearward displacement
limits.CNCAP["2022"].CHEST_A_PILLAR_FA_DISP_ADEQUATE = 133.33; // 133.33mm rearward displacement
limits.CNCAP["2022"].CHEST_A_PILLAR_FA_DISP_MARGINAL = 166.67; // 166.67mm rearward displacement
limits.CNCAP["2022"].CHEST_A_PILLAR_FA_DISP_WEAK = 200; // 200mm rearward displacement
limits.CNCAP["2022"].CHEST_A_PILLAR_LO_SCORE = -2.0;
limits.CNCAP["2022"].CHEST_A_PILLAR_HI_SCORE = 0.0; 

limits.CNCAP["2022"].CHEST_LO_SCORE = 0.0;
limits.CNCAP["2022"].CHEST_HI_SCORE = 4.0;

// Knee, Femur and Pelvis assessments
// Pelvis
// for driver 
limits.CNCAP["2022"].ACETABULUM_COM_GOOD = 3.28; // 3.28 kN
limits.CNCAP["2022"].ACETABULUM_COM_ADEQUATE = 3.5533; // 3.5533 kN
limits.CNCAP["2022"].ACETABULUM_COM_MARGINAL = 3.8267; // 3.8267 kN
limits.CNCAP["2022"].ACETABULUM_COM_WEAK = 4.10; // 4.10 kN
// for passenger
// no need check

// Femur
// for driver
limits.CNCAP["2022"].FEMUR_COM_EXC_TIME = new Array(2);
limits.CNCAP["2022"].FEMUR_COM_EXC_GOOD = new Array(2);
limits.CNCAP["2022"].FEMUR_COM_EXC_ADEQUATE = new Array(2);
limits.CNCAP["2022"].FEMUR_COM_EXC_MARGINAL = new Array(2);
limits.CNCAP["2022"].FEMUR_COM_EXC_WEAK = new Array(2);
limits.CNCAP["2022"].FEMUR_COM_EXC_TIME[0] = 0.0;  //0.0s
limits.CNCAP["2022"].FEMUR_COM_EXC_TIME[1] = 0.010;
limits.CNCAP["2022"].FEMUR_COM_EXC_GOOD[0] = 3.8;  // 3.8kN
limits.CNCAP["2022"].FEMUR_COM_EXC_GOOD[1] = 3.8;
limits.CNCAP["2022"].FEMUR_COM_EXC_ADEQUATE[0] = 5.56;
limits.CNCAP["2022"].FEMUR_COM_EXC_ADEQUATE[1] = 5.05;
limits.CNCAP["2022"].FEMUR_COM_EXC_MARGINAL[0] = 7.31;
limits.CNCAP["2022"].FEMUR_COM_EXC_MARGINAL[1] = 6.31;
limits.CNCAP["2022"].FEMUR_COM_EXC_WEAK[0] = 9.07;
limits.CNCAP["2022"].FEMUR_COM_EXC_WEAK[1] = 7.56;

// for passenger
limits.CNCAP["2022"].FEMUR_COM_PASS_GOOD = 2.6; // 2.6kN
limits.CNCAP["2022"].FEMUR_COM_PASS_ADEQUATE = 3.8;
limits.CNCAP["2022"].FEMUR_COM_PASS_MARGINAL = 5.0;
limits.CNCAP["2022"].FEMUR_COM_PASS_WEAK = 6.2;

// Knee
// for driver
limits.CNCAP["2022"].KNEE_DISP_GOOD = 6.0;  // 6.0mm
limits.CNCAP["2022"].KNEE_DISP_ADEQUATE = 9.0;
limits.CNCAP["2022"].KNEE_DISP_MARGINAL = 12.0;
limits.CNCAP["2022"].KNEE_DISP_WEAK = 15.0;
// for passenger
// no need check

limits.CNCAP["2022"].KNEE_FEMUR_PELVIS_LO_SCORE = 0.0;
limits.CNCAP["2022"].KNEE_FEMUR_PELVIS_HI_SCORE = 4.0;


// Lower leg, foot and ankle assessments
// Lower leg
// for driver
limits.CNCAP["2022"].TIBIA_COM_GOOD = 2.0;  // 2.0kN
limits.CNCAP["2022"].TIBIA_COM_ADEQUATE = 4.0;
limits.CNCAP["2022"].TIBIA_COM_MARGINAL = 6.0;
limits.CNCAP["2022"].TIBIA_COM_WEAK = 8.0;

limits.CNCAP["2022"].TIBIA_INDEX_GOOD = 0.4;  // no unit
limits.CNCAP["2022"].TIBIA_INDEX_ADEQUATE = 0.7;
limits.CNCAP["2022"].TIBIA_INDEX_MARGINAL = 1.0;
limits.CNCAP["2022"].TIBIA_INDEX_WEAK = 1.3;

limits.CNCAP["2022"].TIBIA_MRC = 225; // Tibia index critical moment = 225Nm
limits.CNCAP["2022"].TIBIA_FZC = 35.9; // Tibia index critical force = 35.9kN
// for passenger
// no need check

// foot and ankle
// no for both driver and passenger
// only modifier for Driver
// Vertical (upward) displacement of panel
limits.CNCAP["2022"].LOWER_LEG_PEDAL_VERT_DISP_GOOD = 72.0;  // 72.0mm
limits.CNCAP["2022"].LOWER_LEG_PEDAL_VERT_DISP_ADEQUATE = 77.33;
limits.CNCAP["2022"].LOWER_LEG_PEDAL_VERT_DISP_MARGINAL = 82.67;
limits.CNCAP["2022"].LOWER_LEG_PEDAL_VERT_DISP_WEAK = 88.0;
limits.CNCAP["2022"].LOWER_LEG_PEDAL_VERT_DISP_LO_SCORE = -1.0;
limits.CNCAP["2022"].LOWER_LEG_PEDAL_VERT_DISP_HI_SCORE = 0;
// Horizontal (backward) displacement of panel

// Pedal modifier for CNCAP under the situation of being non-blocked.
// the situation of being blocked is considered within the script of REPORTER_TEMPLATE file. The script_10 "Calculate lower leg score"
limits.CNCAP["2022"].LOWER_LEG_PEDAL_FA_DISP_GOOD     = 100.0;  // 100.0mm
limits.CNCAP["2022"].LOWER_LEG_PEDAL_FA_DISP_ADEQUATE = 133.33;
limits.CNCAP["2022"].LOWER_LEG_PEDAL_FA_DISP_MARGINAL = 166.67;
limits.CNCAP["2022"].LOWER_LEG_PEDAL_FA_DISP_WEAK     = 200.0;

limits.CNCAP["2022"].LOWER_LEG_PEDAL_FA_DISP_LO_SCORE = -1;
limits.CNCAP["2022"].LOWER_LEG_PEDAL_FA_DISP_HI_SCORE = 0;


limits.CNCAP["2022"].LOWER_LEG_FOOT_AND_ANKLE_LO_SCORE = 0.0;
limits.CNCAP["2022"].LOWER_LEG_FOOT_AND_ANKLE_HI_SCORE = 4.0;

// Rename object for use in this_MPDB_Impact_common.js
var MPDB = limits[template_reg][template_year];

// this_common_EuroNCAP.js still requires variables not in object
var PEAK_HEAD_ACCN_SOFT     = MPDB.PEAK_HEAD_ACCN_SOFT;
var PEAK_HEAD_ACCN_LO_LIMIT = MPDB.TMS_LO_LIMIT; // MPDB uses 3ms resultant acceleration rather than peak, so just plot that on the HIC curve instead
var PEAK_HEAD_ACCN_HI_LIMIT = MPDB.TMS_HI_LIMIT; // MPDB uses 3ms resultant acceleration rather than peak, so just plot that on the HIC curve instead

