//GlobalFunctions.js
//this script creates the functions which are then accessible in the global scope and can be called in any later REPORTER scripts

var t = Template.GetCurrent();

// reset STRUCTURAL_DOWNGRADE value
Variable.GetFromName(t, "STRUCTURAL_DOWNGRADE").value = 0;

function ChangeStructuralDowngrade(increment) {
    //this script changes the structural rating if it needs to be downgraded
    var t_tmp = Template.GetCurrent();
    var struc_downgrade = Variable.GetFromName(t_tmp, "STRUCTURAL_DOWNGRADE");
    var downgrade_levels = parseInt(struc_downgrade.value) + increment;
    if (downgrade_levels >= 0 && downgrade_levels <= 3) {
        // downgrading can only be 0, 1, 2 or 3 levels
        struc_downgrade.value = downgrade_levels;
        DowngradeStructuralRating(downgrade_levels);
    }
}

function DowngradeStructuralRating(downgrade_levels) {
    //get "STRUCTURAL_RATING" REPORTER variable
    var t_tmp = Template.GetCurrent();
    var struc_rating = Variable.GetFromName(t_tmp, "STRUCTURAL_RATING");

    //set number of downgrade levels to new value
    struc_rating.value = t_tmp.GetVariableValue("B_PILLAR_RATING");

    for (var i = 0; i < downgrade_levels; i++) {
        if (struc_rating.value == "MARGINAL") struc_rating.value = "POOR";
        if (struc_rating.value == "ACCEPTABLE") struc_rating.value = "MARGINAL";
        if (struc_rating.value == "GOOD") struc_rating.value = "ACCEPTABLE";
    }
}
