/// <reference path="C:/SOURCE14/this_dir/this_js_api/this.intellisense.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common1.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common_IIHS.js" />


// Constants used throughout the script

var REG_DT     = 0.00001; // dt for regularising curves (in seconds)
var HIC_WINDOW = 0.015;   // HIC time window (in seconds)
var TMS_PERIOD = 0.003;   // 3ms period (in seconds)


// Structural assessment

var FOOTREST_INTRUSION_GOOD       = 15;
var FOOTREST_INTRUSION_ACCEPTABLE = 22.5;
var FOOTREST_INTRUSION_MARGINAL   = 30;

var LEFT_TOEPAN_INTRUSION_GOOD       = 15;
var LEFT_TOEPAN_INTRUSION_ACCEPTABLE = 22.5;
var LEFT_TOEPAN_INTRUSION_MARGINAL   = 30;

var CENTRE_TOEPAN_INTRUSION_GOOD       = 15;
var CENTRE_TOEPAN_INTRUSION_ACCEPTABLE = 22.5;
var CENTRE_TOEPAN_INTRUSION_MARGINAL   = 30;

var RIGHT_TOEPAN_INTRUSION_GOOD       = 15;
var RIGHT_TOEPAN_INTRUSION_ACCEPTABLE = 22.5;
var RIGHT_TOEPAN_INTRUSION_MARGINAL   = 30;

var BRAKE_PEDAL_INTRUSION_GOOD       = 15;
var BRAKE_PEDAL_INTRUSION_ACCEPTABLE = 22.5;
var BRAKE_PEDAL_INTRUSION_MARGINAL   = 30;

var LEFT_INST_PANEL_INTRUSION_GOOD       = 5;
var LEFT_INST_PANEL_INTRUSION_ACCEPTABLE = 10;
var LEFT_INST_PANEL_INTRUSION_MARGINAL   = 15;

var RIGHT_INST_PANEL_INTRUSION_GOOD       = 5;
var RIGHT_INST_PANEL_INTRUSION_ACCEPTABLE = 10;
var RIGHT_INST_PANEL_INTRUSION_MARGINAL   = 15;

var DOOR_INTRUSION_GOOD       = 5;
var DOOR_INTRUSION_ACCEPTABLE = 10;
var DOOR_INTRUSION_MARGINAL   = 15;



if(File.Exists(fname_csv) && File.IsFile(fname_csv))
{
	// Do the common setup of assigning values to the oGlblData object,
	// setting the T/HIS graph up and reading in the model.

	var oGlblData = new Object();

	var f_vars = do_common_single_analysis_setup(oGlblData);

	// For each body region, do the calculation, writing results to the variables file.
	// 1 here denotes the number of dummies

	do_structural_rating_calc(f_vars);

	f_vars.Close();
}



function do_structural_rating_calc(f)
{
	// Calculates the structural values and writes them into the Reporter csv variables file <f>.


	// 8 Structural measurements
	var trans = oGlblData.clutch_pedal_intrusion_spring_x;   // for the Manual transmission and If the input has the Clutch pedal information
	for(var pass=0; pass<9; pass++)
	{
		var springs   = new Array(3);
		var structure = "";

		if(pass == 0)
		{
			springs[0] = oGlblData.footrest_intrusion_spring_x;
			springs[1] = oGlblData.footrest_intrusion_spring_y;
			springs[2] = oGlblData.footrest_intrusion_spring_z;

			structure = "Footrest";
		}
		else if(pass == 1)
		{
			springs[0] = oGlblData.left_toepan_intrusion_spring_x;
			springs[1] = oGlblData.left_toepan_intrusion_spring_y;
			springs[2] = oGlblData.left_toepan_intrusion_spring_z;

			structure = "Left_Toepan";
		}
		else if(pass == 2)
		{
			springs[0] = oGlblData.centre_toepan_intrusion_spring_x;
			springs[1] = oGlblData.centre_toepan_intrusion_spring_y;
			springs[2] = oGlblData.centre_toepan_intrusion_spring_z;

			structure = "Centre_Toepan";
		}
		else if(pass == 3)
		{
			springs[0] = oGlblData.right_toepan_intrusion_spring_x;
			springs[1] = oGlblData.right_toepan_intrusion_spring_y;
			springs[2] = oGlblData.right_toepan_intrusion_spring_z;

			structure = "Right_Toepan";
		}
		else if(pass == 4)
		{
			springs[0] = oGlblData.brake_pedal_intrusion_spring_x;
			springs[1] = oGlblData.brake_pedal_intrusion_spring_y;
			springs[2] = oGlblData.brake_pedal_intrusion_spring_z;

			structure = "Brake_Pedal";
		}
		else if(pass == 5 && trans != 0 )
		{
			springs[0] = oGlblData.clutch_pedal_intrusion_spring_x;
			springs[1] = oGlblData.clutch_pedal_intrusion_spring_y;
			springs[2] = oGlblData.clutch_pedal_intrusion_spring_z;

			structure = "Clutch_Pedal";
		}
		else if(pass == 6)
		{
			springs[0] = oGlblData.left_inst_panel_intrusion_spring_x;

			structure = "Left_Inst_Panel";
		}
		else if(pass == 7)
		{
			springs[0] = oGlblData.right_inst_panel_intrusion_spring_x;

			structure = "Right_Inst_Panel";
		}
		else if(pass == 8)
		{
			springs[0] = oGlblData.door_intrusion_spring_x;

			structure = "Door";
		}


		var output_data = {};

		output_data.int = new OutputData(structure + " Intrusion", images_dir + "/" + structure + "_Intrusion");

		if( (pass < 6 && ((springs[0] != undefined)   ||
						(springs[1] != undefined)   ||
						(springs[2] != undefined))) ||
				(pass >= 6 && (springs[0] != undefined)) )
		{

			var c_fa = read_data("SPRING TR", 0, springs[0], "ET");

			if(pass < 6)  // Get Y and Z displacements
			{
				var c_lat  = read_data("SPRING TR", 0, springs[1], "ET");
				var c_vert = read_data("SPRING TR", 0, springs[2], "ET");
			}

			if(!c_fa || (pass < 6 && (!c_lat || !c_vert)))
			{
				write_blank_images(output_data, "NO DATA FOR SPRINGS");
			}
			else
			{
				// Remove all curves and datums

				remove_all_curves_and_datums();

				// Convert to mm

				var c_fa_cm = Operate.Div(c_fa, oGlblData.cm_factor);

				if(pass < 6)
				{
					var c_lat_cm  = Operate.Div(c_lat,  oGlblData.cm_factor);
					var c_vert_cm = Operate.Div(c_vert, oGlblData.cm_factor);
				}

				// Get final displacements

				var p = c_fa_cm.GetPoint(c_fa_cm.npoints);
				var fa_disp = p[1];

				if(pass < 6)
				{
					var p = c_lat_cm.GetPoint(c_lat_cm.npoints);
					var lat_disp = p[1];

					var p = c_vert_cm.GetPoint(c_vert_cm.npoints);
					var vert_disp = p[1];

					// Resultant displacement - use all three if X is rearward (-ve)
					//                          otherwise only use Y and Z.
					var res_disp;

					if(fa_disp < 0.0)
					{
						res_disp = Math.sqrt(fa_disp   * fa_disp  + 
								lat_disp  * lat_disp +
								vert_disp * vert_disp);
					}
					else
					{
						res_disp = Math.sqrt(lat_disp  * lat_disp +
								vert_disp * vert_disp);
					}
				}

				// Set label and style

				set_labels(c_fa_cm, "Fore/Aft Intrusion (-ve rearward)", "Time (" + oGlblData.unit_time + ")", "Intrusion (cm)");
				set_line_style(c_fa_cm, Colour.RED);
				output_data.int.curveList.push(c_fa_cm.id);

				if(pass < 6)
				{
					set_labels(c_lat_cm, "Lateral Intrusion", "Time (" + oGlblData.unit_time + ")", "Intrusion (cm)");
					set_line_style(c_lat_cm, Colour.BLUE);
					output_data.int.curveList.push(c_lat_cm.id);

					set_labels(c_vert_cm, "Vertical Intrusion (+ve upward)", "Time (" + oGlblData.unit_time + ")", "Intrusion (cm)");
					set_line_style(c_vert_cm, Colour.GREEN);
					output_data.int.curveList.push(c_vert_cm.id);
				}

				// Create image/curve

				write_image(output_data.int.title, output_data.int.fname);
				
				write_curve("cur", output_data.int.curveList, output_data.int.fname);
				write_curve("csv", output_data.int.curveList, output_data.int.fname);

				// Calculate ratings


				var rating = "GOOD";

				if(pass == 0) rating = IIHS_get_rating(res_disp, FOOTREST_INTRUSION_GOOD,      FOOTREST_INTRUSION_ACCEPTABLE,      FOOTREST_INTRUSION_MARGINAL);
				if(pass == 1) rating = IIHS_get_rating(res_disp, LEFT_TOEPAN_INTRUSION_GOOD,   LEFT_TOEPAN_INTRUSION_ACCEPTABLE,   LEFT_TOEPAN_INTRUSION_MARGINAL);
				if(pass == 2) rating = IIHS_get_rating(res_disp, CENTRE_TOEPAN_INTRUSION_GOOD, CENTRE_TOEPAN_INTRUSION_ACCEPTABLE, CENTRE_TOEPAN_INTRUSION_MARGINAL);
				if(pass == 3) rating = IIHS_get_rating(res_disp, RIGHT_TOEPAN_INTRUSION_GOOD,  RIGHT_TOEPAN_INTRUSION_ACCEPTABLE,  RIGHT_TOEPAN_INTRUSION_MARGINAL);
				if(pass == 4) rating = IIHS_get_rating(res_disp, BRAKE_PEDAL_INTRUSION_GOOD,   BRAKE_PEDAL_INTRUSION_ACCEPTABLE,   BRAKE_PEDAL_INTRUSION_MARGINAL);
				if(pass == 5) rating = IIHS_get_rating(res_disp, BRAKE_PEDAL_INTRUSION_GOOD,   BRAKE_PEDAL_INTRUSION_ACCEPTABLE,   BRAKE_PEDAL_INTRUSION_MARGINAL);
				if(pass == 6) rating = IIHS_get_rating(-fa_disp, LEFT_INST_PANEL_INTRUSION_GOOD,  LEFT_INST_PANEL_INTRUSION_ACCEPTABLE,  LEFT_INST_PANEL_INTRUSION_MARGINAL);
				if(pass == 7) rating = IIHS_get_rating(-fa_disp, RIGHT_INST_PANEL_INTRUSION_GOOD, RIGHT_INST_PANEL_INTRUSION_ACCEPTABLE, RIGHT_INST_PANEL_INTRUSION_MARGINAL);
				if(pass == 8) rating = IIHS_get_rating(-fa_disp, DOOR_INTRUSION_GOOD,             DOOR_INTRUSION_ACCEPTABLE,             DOOR_INTRUSION_MARGINAL);


				// Write variables

				write_variable(f, "STRUCTURAL_" + structure.toUpperCase() + "_X", fa_disp.toFixed(2), structure + " X Intrusion", "General");

				if(pass < 6)
				{
					write_variable(f, "STRUCTURAL_" + structure.toUpperCase() + "_Y",         lat_disp.toFixed(2),  structure + " Y Intrusion",         "General");
					write_variable(f, "STRUCTURAL_" + structure.toUpperCase() + "_Z",         vert_disp.toFixed(2), structure + " Z Intrusion",         "General");
					write_variable(f, "STRUCTURAL_" + structure.toUpperCase() + "_RESULTANT", res_disp.toFixed(2),  structure + " resultant Intrusion", "General");
				}

				write_variable(f, "STRUCTURAL_" + structure.toUpperCase() + "_RATING", rating, structure + " Intrusion Rating", "General");
			}
		}
		else
		{
			write_blank_images(output_data, "NO SPRING ID DEFINED FOR");
		}

	}
}



