var GREEN_COL  = '#52B442';   // Green
var YELLOW_COL = '#FCE702';   // Yellow
var ORANGE_COL = '#F79800';   // Orange
var RED_COL    = '#F40000';   // Red

// Draw images of 
//
//   1. Coloured in driver and passenger
//   2. Structure graph for driver compartment and passenger compartment
//
// and save to file

var template = Template.GetCurrent();

var structure_only = parseFloat(template.GetVariableValue("STRUCTURE_ONLY"));

//THIS IS USED TO DETERMINE IF SOB OR ODB
var post_end_header = template.GetVariableValue("POST_END_HEADER");

if (!post_end_header || post_end_header=='')
{
    LogError('"POST_END_HEADER" is not defined or null and cannot be used to determine analysis type');
    Exit();

}

//case insensitive regular expression to test if 'SOB' occurs in POST_END_HEADER
if (/SOB/i.test(post_end_header)) 
{
    if (!structure_only)
    {
        //only draw occupant images for full template - not required for structure only

        draw_occupant("SOB_DRIVER");
        draw_occupant("SOB_PASSENGER");
    }

    draw_driver_structural_graph();
    draw_passenger_structural_graph();
}
//case insensitive regular expression to test if 'ODB' occurs in POST_END_HEADER
else if (/ODB/i.test(post_end_header))  
{
    //only draw occupant images for full template - not required for structure only
    if (!structure_only) draw_occupant("ODB_DRIVER");
    draw_ODB_driver_structural_graph();
}
else
{
    LogError('"POST_END_HEADER" does not contain either ODB or SOB so cannot be used to determine analysis type');
    Exit();
}


function graphPointsToImageCoords(points, x_start, x_end, number_of_x_axis_gaps, y_start, y_end, y_axis_range )
{
    ///points is an array x, y, x1, y1, x2, y2 ... in graph coords (labels on x axis are at x = 0, 1, 2, 3 etc... )
    var coords = [];

    for (var i = 0; i<points.length; i++)
    {
        if (i%2 == 0)
        {
            //then x coord
            //start from left side i.e. x_start
            var x_width = x_end - x_start; //x_end is > x_start as x = 0 at left of image
            var x_current = points[i];

            var x = x_start + x_width*x_current/number_of_x_axis_gaps;
            coords.push(x);
        }
        else
        {
            //y coord
            //start from the bottom i.e. y_end
            var y_height = y_end - y_start; //y_end is > y_start as y = 0 at top of image
            var y_current = points[i];

            var y = y_end - y_height*y_current/y_axis_range;
            coords.push(y);
        }
    }

    return coords

}

function draw_ODB_driver_structural_graph(){

    var B_Res = parseFloat(template.GetVariableValue("STRUCTURAL_BRAKE_PEDAL_RESULTANT"));      
    var C_Res = parseFloat(template.GetVariableValue("STRUCTURAL_CLUTCH_PEDAL_RESULTANT"));
    
    // If the Brake resultant is Greater than Clutch for Manual transmission the text in the image will Brake Pedal
    var pedal_text, pedal_value;
    if((B_Res >= C_Res) || (isNaN(C_Res))){
        pedal_value = B_Res; 
        pedal_text = "Brake pedal";
    } 
    else
    {
        pedal_value = C_Res;
        pedal_text = "Clutch pedal"
    }

    var x_axis_labels = [
                        "Footrest",
                        "Left Toepan",
                        "Centre toepan",
                        "Right toepan",
                        pedal_text,
                        "Left Inst. panel",
                        "Right Inst. panel",
                        "Door"
                            ]

    // Values
    
    var values = new Array(8);
    
    values[0] = parseFloat(template.GetVariableValue("STRUCTURAL_FOOTREST_RESULTANT"));
    values[1] = parseFloat(template.GetVariableValue("STRUCTURAL_LEFT_TOEPAN_RESULTANT"));
    values[2] = parseFloat(template.GetVariableValue("STRUCTURAL_CENTRE_TOEPAN_RESULTANT"));
    values[3] = parseFloat(template.GetVariableValue("STRUCTURAL_RIGHT_TOEPAN_RESULTANT"));
    values[4] = parseFloat(template.GetVariableValue("STRUCTURAL_BRAKE_PEDAL_RESULTANT"));

    // Instrument panel and Door - only use X displacement - rearward is negative, so change sign

    values[5] = -parseFloat(template.GetVariableValue("STRUCTURAL_LEFT_INST_PANEL_X"));
    values[6] = -parseFloat(template.GetVariableValue("STRUCTURAL_RIGHT_INST_PANEL_X"));
    values[7] = -parseFloat(template.GetVariableValue("STRUCTURAL_DOOR_X"));

    // If negative, just set to zero

    if(values[5] < 0.0) values[5] = 0.0;
    if(values[6] < 0.0) values[6] = 0.0;
    if(values[7] < 0.0) values[7] = 0.0;

    var filename = "structural_rating.png";

    var pointsList = [
        [0,0,    7,0,                7,40, 0,40],//good
        [0,15,   4,15,   5,5,  7,5,  7,40, 0,40],//acceptable
        [0,22.5, 4,22.5, 5,10, 7,10, 7,40, 0,40],//marginal
        [0,30,   4,30,   5,15, 7,15, 7,40, 0,40] //poor
    ]
  
    draw_structural_graph(filename, pointsList, x_axis_labels, values);

}

function draw_driver_structural_graph(){

    var B_Res = parseFloat(template.GetVariableValue("STRUCTURAL_BRAKE_PEDAL_RESULTANT"));      
    var C_Res = parseFloat(template.GetVariableValue("STRUCTURAL_CLUTCH_PEDAL_RESULTANT"));
    
    // If the Brake resultant is Greater than Clutch for Manual transmission the text in the image will Brake Pedal
    var pedal_text, pedal_value;
    if((B_Res >= C_Res) || (isNaN(C_Res))){
        pedal_value = B_Res; 
        pedal_text = "Brake pedal";
    } 
    else
    {
        pedal_value = C_Res;
        pedal_text = "Clutch pedal"
    }

    var x_axis_labels = [
                        "Lower hinge pillar",
                        "Footrest",
                        "Left Toepan",
                        pedal_text,
                        "Parking brake pedal",
                        "Rocker panel (lat)",
                        "Steering column (long)",
                        "Upper hinge pillar",
                        "Upper dash",
                        "Instrument panel",
                            ]

    var values = new Array(10);

    values[0] =  parseFloat(template.GetVariableValue("STRUCTURAL_DRIVER_LOWER_HINGE_PILLAR_RESULTANT"));
    values[1] =  parseFloat(template.GetVariableValue("STRUCTURAL_DRIVER_FOOTREST_RESULTANT"));
    values[2] =  parseFloat(template.GetVariableValue("STRUCTURAL_DRIVER_LEFT_TOEPAN_RESULTANT"));
    values[3] =  pedal_value;
    values[4] =  parseFloat(template.GetVariableValue("STRUCTURAL_PARKING_BRAKE_PEDAL_RESULTANT"));
    values[5] =  parseFloat(template.GetVariableValue("STRUCTURAL_ROCKER_PANEL_Y_AVERAGE"));
    values[6] = -parseFloat(template.GetVariableValue("STRUCTURAL_STEERING_COLUMN_X")); // X displacement - rearward is negative, so take absolute
    values[7] =  parseFloat(template.GetVariableValue("STRUCTURAL_DRIVER_UPPER_HINGE_PILLAR_RESULTANT"));
    values[8] =  parseFloat(template.GetVariableValue("STRUCTURAL_DRIVER_UPPER_DASH_RESULTANT"));
    values[9] =  parseFloat(template.GetVariableValue("STRUCTURAL_LEFT_INSTRUMENT_PANEL_RESULTANT"));
    
    // If negative, just set to zero
    
    if(values[6] < 0.0) values[6] = 0.0;

    var filename = "Driver_structural_rating.png";

    var pointsList = [
        [0,0, 9,0, 9,40, 0,40], //good
        [0,15, 4,15, 5,5, 6,5, 7,7.5, 9,7.5, 9,40, 0,40],//acceptable
        [0,22.5, 4,22.5, 5,10, 6,10, 7,12.5, 9,12.5, 9,40, 0,40],//marginal
        [0,30, 4,30, 5,15, 6,15, 7,17.5, 9,17.5, 9,40, 0,40]//poor
    ]
  
    draw_structural_graph(filename, pointsList, x_axis_labels, values);

}


function draw_passenger_structural_graph(){
    
    var x_axis_labels = [   "Lower hinge pillar",
                            "Footrest",
                            "Right Toepan",
                            "Center Toepan",
                            "Rocker Panel (lat) ",
                            "Center Dash",
                            "Upper Hinge Pillar",
                            "Upper Dash",
                            "Right Lower Dash"
                        ];

  var values = new Array(9);
  
  values[0] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_LOWER_HINGE_PILLAR_RESULTANT"));
  values[1] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_FOOTREST_RESULTANT"));
  values[2] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_RIGHT_TOEPAN_RESULTANT"));
  values[3] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_CENTER_TOEPAN_RESULTANT"));
  values[4] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_ROCKER_PANEL_Y_AVERAGE"));
  values[5] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_CENTER_DASH_RESULTANT"));
  values[6] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_UPPER_HINGE_PILLAR_RESULTANT"));
  values[7] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_UPPER_DASH_RESULTANT"));
  values[8] =  parseFloat(template.GetVariableValue("STRUCTURAL_PASSENGER_RIGHT_LOWER_DASH_RESULTANT"));

  var filename = "Passenger_structural_rating.png";

  var pointsList = [
    [0,0, 8,0, 8,40, 0,40], //good
    [0,15, 3,15, 4,5, 5,7.5, 8,7.5, 8,40, 0,40],//acceptable
    [0,22.5, 3,22.5, 4,10, 5,12.5, 8,12.5, 8,40, 0,40],//marginal
    [0,30, 3,30, 4,15, 5,17.5, 8,17.5, 8,40, 0,40]//poor
]

  draw_structural_graph(filename, pointsList, x_axis_labels, values);

}


function draw_structural_graph(filename, pointsList, x_axis_labels, values)
{
// Get the default directory where we will write the images
  var dir = template.GetVariableValue("IMAGES_DIR");
  var scaling = 2;//use this to increase image resolution

  var width  = 600*scaling;
  var height = 450*scaling;
  var padding = 5*scaling;
  var x_border = 20*scaling;
  var y_border = 30*scaling;
  var tick_length = 3*scaling;
  
  var y_axis_range = 40;
  var y_axis_tick_spacing = 5
  
  var img = new Image(width, height);
    
  img.lineWidth = 1.5*scaling;
  var font_height_in_pixels = 7*scaling;
  img.fontSize  = pixelsToFontSize(font_height_in_pixels);
  img.font      = "Segoe UI";

  
  var x_start = padding+x_border;
  var x_end   = width-x_start;
  var y_start = padding+y_border;
  var y_end   = height-y_start;//331;


// Y axis marks and values
  img.fontJustify = Reporter.JUSTIFY_LEFT;
  var x_mark = x_start-tick_length;
  var x_text = padding; //Y axis text is 1 unit away from tick end
  var y      = y_start;
  var y_text_offset = Math.round(font_height_in_pixels/2); //offset down half height of text so centred on tick
  
  var number_of_y_axis_gaps = (y_axis_range/y_axis_tick_spacing);
  for(var i=0; i<=number_of_y_axis_gaps; i++)
  {
    var text = y_axis_range - (i*y_axis_tick_spacing);
    
    img.Text(x_text, y+y_text_offset, text.toString());
    img.Line(x_mark, y , x_start, y);
    
    y += (y_end - y_start) / number_of_y_axis_gaps;
  }
  
// X axis marks and values
  
  var x_mark = x_start;
  var x_text = padding;//x_start; x_start is same as Y axis x_start for first label
  var y_mark = y_end;
  var y_text = y_mark+tick_length+Math.round(1.5*font_height_in_pixels);

  var number_of_x_axis_gaps = x_axis_labels.length-1;

  for(var i=0; i<=number_of_x_axis_gaps; i++)
  {

    if (i==0) img.fontJustify = Reporter.JUSTIFY_LEFT;
    else if (i==number_of_x_axis_gaps) img.fontJustify = Reporter.JUSTIFY_RIGHT;
    else img.fontJustify = Reporter.JUSTIFY_CENTRE;    

    if (i!=0) x_text = x_mark
    if (i==number_of_x_axis_gaps) x_text = x_end+x_border;

    img.Text(x_text, Math.round(y_text+ 1.5*font_height_in_pixels*((i+1)%2)), x_axis_labels[i]);    //test is alternatively offset by 10 units for every odd label
    img.Line(x_mark, y_mark, x_mark, Math.round(y_mark + tick_length + 0.6*font_height_in_pixels*( (i+1)%2 ) ) ); //ticks are either 2 (even) or 7 (odd) units long
    
    x_mark += (x_end - x_start) / number_of_x_axis_gaps;
  }


// GOOD Zone
var coords_good = graphPointsToImageCoords(pointsList[0], x_start, x_end, number_of_x_axis_gaps, y_start, y_end, y_axis_range )
img.fillColour = GREEN_COL;
img.Polygon(coords_good);

// ACCEPTABLE Zone
var coords_acceptable = graphPointsToImageCoords(pointsList[1], x_start, x_end, number_of_x_axis_gaps, y_start, y_end, y_axis_range )
img.fillColour = YELLOW_COL;
img.Polygon(coords_acceptable);

// MARGINAL Zone

var coords_marginal = graphPointsToImageCoords(pointsList[2], x_start, x_end, number_of_x_axis_gaps, y_start, y_end, y_axis_range )
img.fillColour = ORANGE_COL;
img.Polygon(coords_marginal);

// POOR Zone
var coords_poor = graphPointsToImageCoords(pointsList[3], x_start, x_end, number_of_x_axis_gaps, y_start, y_end, y_axis_range )
img.fillColour = RED_COL;
img.Polygon(coords_poor);
  
// Grid lines - don't draw over top of zone boundaries
  
  var x = x_start;
  
  img.lineColour = '#647382';//'white';// 'black'//'f3f7fb';
  //img.lineWidth = 1.5;//2*scaling;
  img.lineStyle = Reporter.LINE_DASH;
  

  //draw vertical grid lines
  for(var i=1; i<number_of_x_axis_gaps; i++)
  {
    x += (x_end - x_start) / number_of_x_axis_gaps;
    img.Line(x,y_start, x,y_end);
  }

  var y = y_start;
  
  //draw horizontal grid lines
  //
  for(var i=1; i<number_of_y_axis_gaps; i++)
  {
    y += (y_end - y_start) / number_of_y_axis_gaps;
    
    img.Line(x_start, y, x_end, y);
  }

  // Outline
  //the lines have already been drawn in the polygons but we redraw with no fill (i.e. Polyline) 
  //so that we cover gridlines where they overlap
  img.lineColour = "black";
  img.lineStyle = Reporter.LINE_SOLID;
  img.Polyline(coords_good);
  img.Polyline(coords_acceptable);
  img.Polyline(coords_marginal);
  img.Polyline(coords_poor);
  
// Values
  
  img.lineColour = "blue";
  img.fillColour = "blue";
  img.lineWidth = 3*scaling;
  img.lineStyle = Reporter.LINE_SOLID;

  var square_width = 4*scaling;
  var shw = square_width/2; //square half width
  var x = x_start;
  
  for(var i=0; i<values.length; i++)
  {
    if(isNaN(values[i])) values[i] = 0.0;
    
    if(values[i] > y_axis_range)  // Off the top of the graph - draw an arrow
    {
      y = y_start;
      img.Line(x,y, x,y+15*scaling);
      img.Line(x,y, x-3*scaling,y+5*scaling);
      img.Line(x,y, x+3*scaling,y+5*scaling);
    }
    else  // On the graph - draw a square
    {
      y = y_end - values[i] * (y_end-y_start) / y_axis_range;
      //img.Polygon(x-shw,y-shw, x-shw,y+shw, x+shw,y+shw, x+shw,y-shw);
      img.Rectangle(x-shw,y-shw, x+shw,y+shw);
    }

    x += (x_end - x_start)/number_of_x_axis_gaps;
    LogPrint(" x = " + x + " i " + i );
  }

// Write out image

  img.Save(dir + "/" + filename, Image.PNG);
}

function draw_occupant(analysis)
{
    // Get the default directory where we will write the image

    var template = Template.GetCurrent();
    var dir = template.GetVariableValue("IMAGES_DIR");

    var dummy, dummy2, filename;
    if (analysis == "SOB_PASSENGER")
    {
        dummy = "PASSENGER_";
        dummy2 = dummy;
        filename = dir + "/" + "Passenger_Plot.png";
    }
    else if (analysis == "SOB_DRIVER")
    {
        dummy = "DRIVER_";
        dummy2 = dummy;
        filename = dir + "/" + "Driver_Plot.png";
    }
    else if (analysis == "ODB_DRIVER")
    {
        dummy = "DRIVER_";
        dummy2 = ''; //dummy2 is blank for ODB as some REPORTER variables do not have 'DRIVER_' prefix
        filename = dir + "/" + "plot.png";
    }
    else
    {
        LogError("Analysis type ('"+analysis+"') not supported");
        Exit();
    }

    var img = new Image(190, 342);

    img.lineWidth  = 1;
    img.lineColour = "black";

    var fill_colour;
    var score;

    // Head

    score = template.GetVariableValue(dummy2 + "HEAD_OVERALL_RATING");
    fill_colour = get_fill_colour(score);

    draw_head(img, fill_colour);

    // Neck

    score = template.GetVariableValue(dummy2 + "NECK_OVERALL_RATING");
    fill_colour = get_fill_colour(score);

    draw_neck(img, fill_colour);

    // Chest

    score = template.GetVariableValue(dummy2 + "CHEST_RATING");
    fill_colour = get_fill_colour(score);
    draw_chest(img, fill_colour);

    // Abdomen - not coloured in

    draw_abdomen(img);

    // Right femur

    if (analysis == "ODB_DRIVER")
    {
        // ODB - worst out of femur compression, femur compression exceedence and knee displacement
        var scores = new Array(2);
        scores[0] = template.GetVariableValue("RIGHT_FEMUR_COMPRESSION_RATING");
        scores[1] = template.GetVariableValue("RIGHT_FEMUR_COMPRESSION_EXCEEDED_RATING");
        scores[2] = template.GetVariableValue("RIGHT_KNEE_DISPLACEMENT_RATING");

        score = get_lowest_score(scores);
    }
    else
    {
        // SOB
        score = template.GetVariableValue(dummy + "RIGHT_KTH_RATING");
    }

    fill_colour = get_fill_colour(score);
    draw_right_femur(img, fill_colour);

    // Left femur
    if (analysis == "ODB_DRIVER")
    {
        // ODB - worst out of femur compression, femur compression exceedence and knee displacement
        var scores = new Array(2);
        scores[0] = template.GetVariableValue("LEFT_FEMUR_COMPRESSION_RATING");
        scores[1] = template.GetVariableValue("LEFT_FEMUR_COMPRESSION_EXCEEDED_RATING");
        scores[2] = template.GetVariableValue("LEFT_KNEE_DISPLACEMENT_RATING");
    }
    else
    {
        // SOB
        score = template.GetVariableValue(dummy + "LEFT_KTH_RATING");
    }
 
    fill_colour = get_fill_colour(score);
    draw_left_femur(img, fill_colour);

    // Right tibia - worst out of upper and lower tibia index, tibia compression and knee displacement

    var scores = new Array(3);
    scores[0] = template.GetVariableValue(dummy + "RIGHT_UPPER_TIBIA_INDEX_RATING");
    scores[1] = template.GetVariableValue(dummy + "RIGHT_LOWER_TIBIA_INDEX_RATING");
    scores[2] = template.GetVariableValue(dummy + "RIGHT_TIBIA_COMPRESSION_RATING");
    if (analysis != "ODB_DRIVER") scores.push(template.GetVariableValue(dummy + "RIGHT_KNEE_DISPLACEMENT_RATING"));
        
    score = get_lowest_score(scores);

    fill_colour = get_fill_colour(score);
    draw_right_tibia(img, fill_colour);

    // Left tibia - worst out of upper and lower tibia index, tibia compression and knee displacement

    var scores = new Array(3);
    scores[0] = template.GetVariableValue(dummy + "LEFT_UPPER_TIBIA_INDEX_RATING");
    scores[1] = template.GetVariableValue(dummy + "LEFT_LOWER_TIBIA_INDEX_RATING");
    scores[2] = template.GetVariableValue(dummy + "LEFT_TIBIA_COMPRESSION_RATING");
    if (analysis != "ODB_DRIVER") scores.push(template.GetVariableValue(dummy + "LEFT_KNEE_DISPLACEMENT_RATING"));

    score = get_lowest_score(scores);

    fill_colour = get_fill_colour(score);
    draw_left_tibia(img, fill_colour);

    // Right foot

    score = template.GetVariableValue(dummy + "RIGHT_FOOT_ACCELERATION_RATING");
    fill_colour = get_fill_colour(score);
    draw_right_foot(img, fill_colour);

    // Left foot

    score = template.GetVariableValue(dummy + "LEFT_FOOT_ACCELERATION_RATING");
    fill_colour = get_fill_colour(score);
    draw_left_foot(img, fill_colour);


    if (analysis == "SOB_PASSENGER")
    {
        // Right arm - not coloured in

        draw_right_arm_pass(img)

        // Left arm - not coloured in

        draw_left_arm_pass(img)
    }
    else //is DRIVER
    {    
        // Right arm - not coloured in

        draw_right_arm(img)

        // Left arm - not coloured in

        draw_left_arm(img)

        // Steering wheel for driver

        draw_steering_wheel(img);
    }

    // Seatbelt

    draw_seatbelt(img);

    // Write out image

    img.Save(filename, Image.PNG);

}

function get_fill_colour(score)
{
       if(score == "POOR")       return RED_COL;
  else if(score == "MARGINAL")   return ORANGE_COL;
  else if(score == "ACCEPTABLE") return YELLOW_COL;
  else                           return GREEN_COL
}


function get_lowest_score(scores)
{
  score = "GOOD";

  for(var i=0; i<scores.length; i++)
  {
         if(scores[i] == "POOR")                                                     score = "POOR";
    else if(scores[i] == "MARGINAL"   && (score == "GOOD" || score == "ACCEPTABLE")) score = "MARGINAL";
    else if(scores[i] == "ACCEPTABLE" && (score == "GOOD"))                          score = "ACCEPTABLE";
  }
  
  return score;
}


function draw_head(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(94,0, 102,0, 112,8, 116,20, 116,32, 114,46, 106,54, 102,58, 94,60, 86,58, 82,54, 74,46, 72,32, 72,20, 76,8, 86,0);
}


function draw_neck(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(94,60, 102,58, 106,54, 112,50, 112,64, 106,68, 102,70, 94,72, 86,70, 82,68, 76,64, 76,50, 82,54, 86,58);
}

function draw_chest(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(94,72, 102,70, 106,68, 112,64, 132,64, 144,66, 144,72, 140,78, 136,82, 136,136, 126,138, 94,138, 62,138, 52,136, 52,82, 48,78, 44,72, 44,66, 56,64, 76,64, 82,68, 86,70);
}

function draw_abdomen(img)
{
  img.fillColour = "#ffffff";
  img.Polygon(94,138, 126,138, 124,174, 104,176, 94,176, 84,176, 64,174, 62,138);
}

function draw_right_arm(img)
{
  img.fillColour = "#ffffff";

  img.Polygon(44,72, 38,78, 24,124, 22,140, 34,124, 44,116, 52,112, 52,82, 48,78);
  img.Polygon(22,140, 24,146, 30,152, 38,152, 44,146, 46,134, 56,132, 62,126, 62,120, 56,116, 44,116, 34,124);

}

function draw_right_arm_pass(img)
{
  img.fillColour = "#ffffff";

    img.Polygon(44,72, 38,78, 18,136, 26,130, 38,136, 42,142, 52,120, 52,82, 48,78);
    img.Polygon(18,136, 18,160, 20,180, 30,182, 42,196, 50,202, 56,202, 60,194, 60,182, 46,170, 32,168, 40,150, 42,142, 38,136, 26,130);

}

function draw_left_arm(img)
{
  img.fillColour = "#ffffff";

  img.Polygon(144,72, 150,78, 164,124, 166,140, 154,124, 144,116, 136,112, 136,82, 140,78);
  img.Polygon(166,140, 164,146, 158,152, 150,152, 144,146, 142,134, 132,132, 126,126, 126,120, 132,116, 144,116, 154,124);
}

function draw_left_arm_pass(img)
{
  img.fillColour = "#ffffff";

    img.Polygon(144,72, 150,78, 170,136, 162,130, 150,136, 146,142, 136,120, 136,82, 140,78);
    img.Polygon(170,136, 170,160, 168,180, 158,182, 146,196, 138,202, 132,202, 128,194, 128,182, 142,170, 156,168, 148,150, 146,142, 150,136, 162,130);
}

function draw_right_femur(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(94,176, 84,176, 62,174, 18,190, 14,198, 14,208, 18,210, 26,210, 34,218, 46,228, 72,224, 94,218);
}

function draw_left_femur(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(94,176, 104,176, 124,174, 170,190, 174,198, 174,208, 170,210, 162,210, 154,218, 142,228, 116,224, 94,218);
}

function draw_right_tibia(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(44,228, 44,250, 40,268, 36,288, 30,290, 20,286, 16,260, 12,240, 12,216, 16,208, 26,210, 34,218);
}

function draw_left_tibia(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(144,228, 144,250, 148,268, 152,288, 158,290, 168,286, 172,260, 176,240, 176,216, 172,208, 162,210, 154,218);
}

function draw_right_foot(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(38,288, 44,310, 38,314, 36,318, 34,332, 28,338, 10,338, 2,332, 0,324, 8,314, 16,298, 20,286, 30,290, 36,288);
}

function draw_left_foot(img, fill_colour)
{
  img.fillColour = fill_colour;
  img.Polygon(150,288, 144,310, 150,314, 152,318, 154,332, 160,338, 178,338, 186,332, 188,324, 180,314, 172,298, 168,286, 158,290, 152,288);
}

function draw_steering_wheel(img)
{
  img.lineColour= "#000000";
  img.lineWidth = 10;
  var oldLineCapStyle = img.lineCapStyle;
  img.lineCapStyle = Reporter.CAP_ROUND;
  img.Polyline(94,84, 112,86, 124,94, 134,102, 140,112, 140,122, 134,132, 124,140, 112,148, 94,150, 76,148, 64,140, 54,132, 48,122, 48,112, 54,102, 64,94, 76,86, 94,84);
  img.lineCapStyle = oldLineCapStyle;
}

function draw_seatbelt(img)
{
  img.lineColour= "#000000";
  img.lineWidth = 14;
  
  img.Polyline(34,50, 136,162);
  img.Polyline(130,166, 56,166);
}
