

// Script
// module:FALSE, using use function for now

var REPORTER;

var THIS_COLOURS_array = [Colour.WHITE, Colour.RED, Colour.GREEN, Colour.BLUE, Colour.CYAN,
    Colour.MAGENTA, Colour.YELLOW, Colour.ORANGE, Colour.TURQUOISE, Colour.INDIGO,
    Colour.LIME, Colour.SKY, Colour.PINK, Colour.BLACK, Colour.PALE_YELLOW,
    Colour.GOLD, Colour.OLIVE, Colour.DARK_MAGENTA, Colour.MEDIUM_GREEN, Colour.MEDIUM_BLUE,
    Colour.HOT_PINK, Colour.LIGHT_PINK, Colour.SEA_GREEN, Colour.MAROON, Colour.DARK_GREEN,
    Colour.PURPLE, Colour.NAVY, Colour.DARK_GREY, Colour.MEDIUM_GREY, Colour.LIGHT_GREY];


var THIS_LINESTYLES_array = [LineStyle.SOLID, LineStyle.DASH, LineStyle.DASH5, LineStyle.DASH2, LineStyle.DASH3,
    LineStyle.DASH4, LineStyle.DASH6];


var THIS_LINEWIDTHS_array = [LineWidth.FINE, LineWidth.NORMAL, LineWidth.W3, LineWidth.BOLD,
    LineWidth.W5, LineWidth.W6, LineWidth.W7, LineWidth.HEAVY, LineWidth.W9, LineWidth.W10];


function do_work(data)
{
    if (!REPORTER) 
    {
        REPORTER = false;
        Message("Here is Reporter status, expecting this to be false: ");
        Message(REPORTER);
    }


    if (!data) 
    {
        Message("No ptf model read");
    }


    var m = Model.Read(data);
    Message(m);

    var my_flag = AllocateFlag();
    ClearFlag(my_flag);



    var filename = json_dir + "/" + json_job + ".json";
    Message(filename)

    function read_json(filename)
    {
        if (File.Exists(filename))    //File.Exists occurs in the whole JavaScript Oasys Suite even in reporter
        {
            let file = new File(filename, File.READ);    //creates a new file object this can be for reading an existing file   //Q - what is the constructor and why is this in the constructor
            let json = "";          //creating a variable called json
            let line;                 //creating a variable called line
            // @ts-ignore      //Q - This ignores errors one line below it.
            while ((line = file.ReadLine()) != File.EOF)   //stop the while loop when the variable line returns the flag File.EOF (that is a File constant)
            {
                json += line;   //string from line gets added to json variable.   Q - Won't this be a long line?

            }
            file.Close();       //closes a file opened by a File object - Q - Why is this important? Will anything bad happen if we don't close it?

            let data = JSON.parse(json); //turns the JSON string contained in the variable called json into a JavaScript object, this is stored in the variable data
            // @ts-ignore
   
            return data; // prints out data 

        }
        else
        {
            Message("File does not exist!");
            return null;
        }

    }

    var data = read_json(filename);  //call the function!!!!!!!



    //PART 2 : Get the parts id into an array

    let length_true_force = data.parts.filter(x => x.forces).map(y => y.pid).sort((a, b) => (a - b));  //filter creates a new array with all the elements that passed the test of forces being true
    //map creates an array zoning in from all the details of the part to just the pid aka part id 
    //sort sorts the numbers in ascending order e.g. 2,4,5,6,7 

    Message("Here is the filename");
    Message(filename);

    Message("Here is the array length_true_force:");
    Message(length_true_force);


    for (let index = 0; index < length_true_force.length; index++)
    { //length_true_force.length is for example 5
        var id = length_true_force[index]; //accesses the part id 

        m.SetFlag(my_flag, Entity.ICFD_DRAG_DATA, -id); //SetFlag(flag, entity_type, item, end)
        //+ve fo internal number, -ve for external item label

    }


    if (m.QueryDataPresent(Component.FPX, Entity.ICFD_DRAG_DATA, -1))
    {
        var FPX_array = m.GetDataFlagged(my_flag, Component.FPX);
    } //Get the X Pressure Drag

    if (m.QueryDataPresent(Component.FVX, Entity.ICFD_DRAG_DATA, -1))
    {
        var FVX_array = m.GetDataFlagged(my_flag, Component.FVX);
    } //Get the X Viscous Drag

    if (m.QueryDataPresent(Component.FPY, Entity.ICFD_DRAG_DATA, -1))
    {
        var FPY_array = m.GetDataFlagged(my_flag, Component.FPY);
    } //Get the Y Pressure Drag

    if (m.QueryDataPresent(Component.FVY, Entity.ICFD_DRAG_DATA, -1))
    {
        var FVY_array = m.GetDataFlagged(my_flag, Component.FVY);
    } //Get the Y Viscous Drag

    if (m.QueryDataPresent(Component.FPZ, Entity.ICFD_DRAG_DATA, -1))
    {
        var FPZ_array = m.GetDataFlagged(my_flag, Component.FPZ);
    } //Get the Z Pressure Drag

    if (m.QueryDataPresent(Component.FVZ, Entity.ICFD_DRAG_DATA, -1))
    {
        var FVZ_array = m.GetDataFlagged(my_flag, Component.FVZ);
    } //Get the Z Viscous Drag


    var j = 0;
    for (let index = 0; index < length_true_force.length; index++)
    {
        var id = length_true_force[index];
        var line_colour = THIS_COLOURS_array[j];
        Message(line_colour);

        var crvFPX = FPX_array.find(crv => crv.entity_id == id);
        let crvFVX = FVX_array.find(crv => crv.entity_id == id);

        let crvFPY = FPY_array.find(crv => crv.entity_id == id);
        let crvFVY = FVY_array.find(crv => crv.entity_id == id);

        let crvFPZ = FPZ_array.find(crv => crv.entity_id == id);
        let crvFVZ = FVZ_array.find(crv => crv.entity_id == id);



        Message(id);


        var p = Operate.Add(crvFPX, crvFVX);
        var q = Operate.Add(crvFPY, crvFVY);
        var r = Operate.Add(crvFPZ, crvFVZ);

        p.label = "Part " + id + " - X Component";
        q.label = "Part " + id + " - Y Component";
        r.label = "Part " + id + " - Z Component";

        var temp_array = [p, q, r];
        for (let k = 0; k < 3; k++) 
        {
            var line_style = THIS_LINESTYLES_array[k];
            Message(line_style);
            temp_array[k].colour = line_colour;
            temp_array[k].style = line_style;
        }
    
        j++


        //         Flag temporary time-domain curves => to be deleted later
        FPX_array.forEach(crv => { crv.SetFlag(my_flag); });
        FVX_array.forEach(crv => { crv.SetFlag(my_flag); });
        FPY_array.forEach(crv => { crv.SetFlag(my_flag); });
        FVY_array.forEach(crv => { crv.SetFlag(my_flag); });
        FPZ_array.forEach(crv => { crv.SetFlag(my_flag); });
        FVZ_array.forEach(crv => { crv.SetFlag(my_flag); });

        Plot();

        //         Remove temporary curves, so only p, q and r remain now
        Curve.RemoveFlaggedFromGraph(my_flag);

    }

    let g = Graph.GetFromID(1); //Get the first graph

    g.legend_layout = Graph.LEGEND_AUTO;    //Auto layout
    g.num_legend_columns = Graph.LEGEND_3_COLUMN;  //3 Columns


    DialogueInput("au"); // autoscale plot




    ReturnFlag(my_flag);

    if (REPORTER)
    {
        generate_reporter_image(default_dir, image_filename, images_dir);
    }

}




function generate_reporter_image(default_dir, image_filename, images_dir)
{

    //Write image file. 
    DialogueInput("/image", "png24", `${images_dir}/${image_filename}`, "graph", "1");

}

DialogueInput("/DEFAULT BA WHITE");   //WHITE BACKGROUND 
DialogueInput("/DEFAULT FO BLACK");   //Black gridlines 
DialogueInput("/DEFAULT MP OFF"); //turns off M2 label in legend
DialogueInput("/DE", "GR", "TH", "1"); 
