var REPORTER = true;
var json_dir_var = Variable.GetFromName(template, "JSON_DIR");
var json_job_var = Variable.GetFromName(template, "JSON_JOB");
var json_dir = "";
var json_job = "";
var table_name_str = "input_table";
var input_tables = [];
json_dir = json_dir_var.value;
json_job = json_job_var.value;

var data = read_json(json_dir + "/" + json_job + ".json");


fill_table();


/**
 * Reads a json file line by line and assigns this as data
 * @param {*} filename 
 * @returns 
 */
function read_json(filename)
{
    if (File.Exists(filename))    //File.Exists occurs in the whole JavaScript Oasys Suite even in reporter
    {
        let file = new File(filename, File.READ);    //creates a new file object this can be for reading an existing file 
        let json = "";          //creating a variable called json
        let line;                 //creating a variable called line
        while ((line = file.ReadLine()) != File.EOF)   //stop the while loop when the variable line returns the flag File.EOF (that is a File constant)
        {
            json += line;   //string from line gets added to json variable.
        }
        file.Close();       //closes a file opened by a File object - 

        let data = JSON.parse(json); //turns the JSON string contained in the variable called json into a JavaScript object, this is stored in the variable data
        return data; 

    }
    else
    {
        LogError("JSON File does not exist! The icfd_setup_data.json file does not exist in your chosen folder.");
        return null;
    }

}


function fill_table()
{
    var template_obj = Template.GetCurrent(); //Gets current template and then to be bundled into an object which can be manipulated.

    //need to get the page
    var page_obj = template_obj.GetPage(1); //GetPage was in the template member function
    //Index starts from 0!!

    //Get the table as an item so manipulations like adding new rows and adding property values to cells can be performed
    //used let to avoid clashes in the global variables of other script names
    //Needed to define page
    var table_obj = Item.GetFromName(page_obj, table_name_str); //no longer have to use 'Item.' every time after declaring table_obj

    table_obj.MergeCells(0, 2, 1, 3);

    
    for (let index = table_obj.rows - 1; index >= 2; index--)
    {



        table_obj.DeleteRow(index);

    }

    //Count Number of rows
    var row_count = 0; 
    for (let i = 0; i < data.parts.length; i++) 
    {
        row_count++;
        
    }

    var max_row = 15; //15 is the maximum new rows allowed to be created per page
    var page_count = Math.ceil(row_count / max_row); //amount of pages to be created

    var page = page_obj;
    for (let i = 0; i < (page_count - 1); i++) 
    {
        page = page.Duplicate();
        page.name = "Summary of input parameters (continued)";
        var items = page.GetAllItems();

        for(let j = 0; j < items.length; j++) //
        {
            if (items[j].name.substr(0, table_name_str.length) == table_name_str) //seeing if this is the header
            {
                input_tables.push(items[j]); //if it is table then push the item 'table' to the empty summary_tables array
            }
            
      
        }
        
        
    }

    var page_count = 0;

    for (let i = 0; i < data.parts.length; i++)
    {
        //Automate creating all the variable names for each part
        let pid_var_name = "pid" + i;    
        let type_var_name = "type" + i;
        let vx_var_name = "vx" + i;
        let vy_var_name = "vy" + i;
        let vz_var_name = "vz" + i;
        let p_var_name = "p" + i;
        let nlayers_var_name = "nlayers" + i;
        let forces_var_name = "forces" + i;

        //Automate the adding of variables into reporter
        //realised I neded template object to create the variables in
        new Variable(template_obj, pid_var_name, "", data.parts[i].pid);
        new Variable(template_obj, type_var_name, "", data.parts[i].type);
        new Variable(template_obj, vx_var_name, "", data.parts[i].vx);
        new Variable(template_obj, vy_var_name, "", data.parts[i].vy);
        new Variable(template_obj, vz_var_name, "", data.parts[i].vz);
        new Variable(template_obj, p_var_name, "", data.parts[i].p);
        new Variable(template_obj, nlayers_var_name, "", data.parts[i].nlayers);
        var temp_value;
        if (data.parts[i].forces.toString() == "false")
        {
            temp_value = "";
        }

        else if (data.parts[i].forces.toString() == "true")
        {
            temp_value = "Yes";
        }

        new Variable(template_obj, forces_var_name, "", temp_value);

        var row = i + 2;

        if (i > (max_row - 1)) 
        {
            page_count = Math.floor(i/max_row); //new page
            table_obj = input_tables[page_count - 1]; //taking relevant table
            var row = i + 2 - max_row*page_count;
        }
         

        //Automate the creation of a new row
        table_obj.y -=6;
        table_obj.y2 -=6;
        table_obj.InsertRow(); //no index given so that a row is added to the bottom of the table

        var table_fill_colour = Colour.RGB(243, 247, 251);
        table_obj.SetCellProperties({ text: "%" + type_var_name + "%",      textColour: Colour.Black(), fillColour: table_fill_colour }, row, 0);
        table_obj.SetCellProperties({ text: "%" + pid_var_name + "%",       textColour: Colour.Black(), fillColour: table_fill_colour }, row, 1);
        table_obj.SetCellProperties({ text: "%" + vx_var_name + "%",        textColour: Colour.Black(), fillColour: table_fill_colour }, row, 2);
        table_obj.SetCellProperties({ text: "%" + vy_var_name + "%",        textColour: Colour.Black(), fillColour: table_fill_colour }, row, 3);
        table_obj.SetCellProperties({ text: "%" + vz_var_name + "%",        textColour: Colour.Black(), fillColour: table_fill_colour }, row, 4);
        table_obj.SetCellProperties({ text: "%" + p_var_name + "%",         textColour: Colour.Black(), fillColour: table_fill_colour }, row, 5);
        table_obj.SetCellProperties({ text: "%" + nlayers_var_name + "%",   textColour: Colour.Black(), fillColour: table_fill_colour }, row, 6);
        table_obj.SetCellProperties({ text: "%" + forces_var_name + "%",    textColour: Colour.Black(), fillColour: table_fill_colour }, row, 7);

    }
}

