var template = Template.GetCurrent();
var page = template.GetPage(0);

var script = Item.GetFromName(page,"ScriptOnLoad");

// Check if the template is launched in batch mode or not and create BATCH_MODE variable
if (Batch())
    var batch_mode = new Variable(template, "BATCH_MODE", "true if Template is launched in batch mode else it will be false", "true", "General", true);
else
    var batch_mode = new Variable(template, "BATCH_MODE", "true if Template is launched in batch mode else it will be false", "false", "General", true);



var tpl_args = new Array();

var KWD_FILE = 0;
var JSON_FILE = 1;
var RES_DIR  = 2;
var IMG_DIR  = 3;

add_tpl_arg(KWD_FILE,   "KEYWORD_FILE", false);
add_tpl_arg(JSON_FILE,  "JSON_FILE",    false);
add_tpl_arg(RES_DIR,    "RESULTS_DIR",  true);
add_tpl_arg(IMG_DIR,    "IMAGES_DIR",   true);

if(Batch())
{
    if(!get_template_args()) finish_script(false, "Report will not be generated.");
}


// Now ask questions to get the information needed for the template

// Get *.k* file and set %DEFAULT_DIR% and %DEFAULT_JOB%

if (!get_keyword_file()) finish_script(false, "Keyword file not selected. Report will not be generated.");

//Get *.json* file and set %JSON_DIR% and %JSON_JOB%

if (!get_json_file()) finish_script(false, "JSON file not selected. Report will not be generated.");

// Get the results directory

if (!get_results_directory()) finish_script(false, "Results directory not selected. Report will not be generated.");

// Get a directory to write images/curves in

if (!get_images_directory()) finish_script(false, "Images directory not selected. Report will not be generated.");



// Get here and we should have all the required information, so generate the template.

finish_script(true, "");

Exit();



function get_keyword_file()
{
    // Gets the keyword file and sets %DEFAULT_DIR% and %DEFAULT_JOB%

    var file;

    // If in batch, it should have been defined in an arguments file
    // If interactive, then ask the user

    if (Batch())
    {
        file = tpl_args[KWD_FILE].value;
    }
    else
    {
        //.KEY FILE
        //Prompt user to select .key file

        var ans = Window.Message("Select *.k* file", "Please select the Ansys LS-DYNA keyword file of the job you want to post-process.", Window.OK | Window.CANCEL);
        if (ans == Window.CANCEL) finish_script(false, "Report will not be generated.");
        file = Window.GetFile("*.k*");

        if (file == null)
        {
            Window.Message("Select '.k' file", "Keyword file not selected. Report will not be generated.");
            Exit();
        }
    }

    // User pressed cancel

    if(!file) return false;

    // Got a file, so set %DEFAULT_DIR% and %DEFAULT_JOB%

    var dirs;

    dirs = file.split("/");
    if(dirs.length == 1) dirs = file.split("\\");   // Windows path

    // Assemble %DEFAULT_DIR% and get %DEFAULT_JOB%

    var div = Math.max(file.lastIndexOf("/"), file.lastIndexOf("\\")); 
    var default_dir = file.substring(0, div)
    var default_job = file.substring(div + 1, file.lastIndexOf("."));


    // Assign to Reporter variables

    var variables = Variable.GetAll(template);

    for(var i=0; i<variables.length; i++)
    {
        if(variables[i].name == "DEFAULT_DIR") variables[i].value = default_dir;
        if(variables[i].name == "DEFAULT_JOB") variables[i].value = default_job;
    }  

    return true;
}


function get_json_file()
{
    // Gets the JSON file and sets %JSON_DIR% and %JSON_JOB%

    var file;

    // If in batch, it should have been defined in an arguments file
    // If interactive, then ask the user

    if(Batch())
    {
        file = tpl_args[JSON_FILE].value;
    }
    else
    {
        //.KEY FILE
        //Prompt user to select .key file

        var ans = Window.Message("Select JSON file", "Select the JSON file created by the ICFD Setup tool in PRIMER.", Window.OK | Window.CANCEL);
        if (ans == Window.CANCEL) finish_script(false, "Report will not be generated.");
        file = Window.GetFile(".json");

        if (file == null)
        {
            Window.Message("Select JSON file directory", "JSON File not selected. Report will not be generated.");
            Exit();
        }
    }


    // User pressed cancel

    if(!file) return false;

    // Got a file, so set %JSON_DIR% and %JSON_JOB%

    var dirs;


    // Assemble %JSON_DIR% and get %JSON_JOB%

    var div_json = Math.max(file.lastIndexOf("/"), file.lastIndexOf("\\")); 
    var json_dir = file.substring(0, div_json);
    var json_job = file.substring(div_json + 1, file.lastIndexOf("."));

    // Check JSON file exists (might have invalid file in Batch mode)

    var json_check = json_dir + "/" + json_job + ".json";
    if (!File.Exists(json_check))
    {
        finish_script(false, "Report will not be generated. Could not locate JSON file: " + json_check);
    }

    // Assign to Reporter variables

    var variables = Variable.GetAll(template);

    for(var i=0; i<variables.length; i++)
    {
        if(variables[i].name == "JSON_DIR") variables[i].value = json_dir;
        if(variables[i].name == "JSON_JOB") variables[i].value = json_job;
    }  

    return true;
}


function get_results_directory()
{
    // Gets a Results directory and sets %RESULTS_DIR% and %RESULTS_FILENAME%

    var default_dir = template.GetVariableValue("DEFAULT_DIR");
    var default_job = template.GetVariableValue("DEFAULT_JOB");
    var dir;

    // If in batch, it may have been defined in an arguments file, otherwise just use DEFAULT_DIR
    // If interactive, then ask the user

    if(Batch())
    {
        if(tpl_args[RES_DIR].defined) dir = tpl_args[RES_DIR].value;
        else                          dir = default_dir;
    }
    else
    {
        // Start directory selector in %DEFAULT_DIR%

        var ans = Window.Message("Select results directory.", "Please select the directory containing the analysis results.", Window.OK | Window.CANCEL);
        if (ans == Window.CANCEL) finish_script(false, "Report will not be generated.");
        dir = Window.GetDirectory(default_dir);
    }

    // User pressed cancel

    if(!dir) return false;

    // Search for a valid results file and set %RESULTS_FILENAME%

    LogPrint("Results directory: " + dir);
    LogPrint("Searching for results files...");
    var file_absolute = find_lsdyna_files(dir, default_job, "PTF");
    if (file_absolute == null)
    {
        finish_script(false, "Report will not be generated. Could not locate results files: " + dir);
    }
    var results_filename = file_absolute.substr(Math.max(file_absolute.lastIndexOf("/"), file_absolute.lastIndexOf("\\")) + 1);
    LogPrint("Found results file: " + results_filename);
        
    // Assign to Reporter variables

    var variables = Variable.GetAll(template);

    for(var i=0; i<variables.length; i++)
    {
        if(variables[i].name == "RESULTS_DIR")      variables[i].value = dir;
        if(variables[i].name == "RESULTS_FILENAME") variables[i].value = results_filename;
    }

    return true;
}


function get_images_directory()
{
    // Gets an Images directory and sets %IMAGES_DIR%

    var default_dir = template.GetVariableValue("DEFAULT_DIR");
    var dir;

    if(Batch())
    {
        if(tpl_args[IMG_DIR].defined) dir = tpl_args[IMG_DIR].value;
        else                          dir = default_dir;

        // It's possible that a directory could be defined that doesn't exist
        // If so, try to make it and if that fails, just set it to default_dir

        var dir_exists = false;

        if(File.IsDirectory(dir))
        {
            dir_exists = true;
        }
        else
        {
            var dirs = GetDirs(dir);
            var new_dir = "";
            for(var i=0; i<dirs.length; i++)
            {
                new_dir += dirs[i] + "/";

                if(File.IsDirectory(new_dir)) continue;  // Already exists

                dir_exists = File.Mkdir(new_dir);
                if(!dir_exists) break;  // Didn't create the directory for some reason
            }
        }

        // If it still doesn't exist just set it to default_dir

        if(!dir_exists) dir = default_dir;
    }
    else
    {
        // Start directory selector in %DEFAULT_DIR%

        var ans = Window.Message("Select output directory.", "Please select a directory to write images/curves to.", Window.OK | Window.CANCEL);
        if (ans == Window.CANCEL) finish_script(false, "Report will not be generated.");
        dir = Window.GetDirectory(default_dir);
    }

    // User pressed cancel

    if(!dir) return false;

    // Assign to Reporter variable

    var variables = Variable.GetAll(template);

    for(var i=0; i<variables.length; i++)
    {
        if(variables[i].name == "IMAGES_DIR") variables[i].value = dir;
    }

    return true;
}


function finish_script(can_generate, msg)
{
    // Common function for finishing the script

    // Generate template if we have all the required information
    if(can_generate)
    {
        //Set this script inactive so when we call template.Generate() below we don't generate this script again
        script.active = false;
        template.Generate();
    }
    else
    {
        if(Batch()) LogError(msg);
        else Window.Message("", msg);
    }

    // Exit from script
    Exit();
}


function add_tpl_arg(index, name, optional)
{
    // Adds an argument object to the <tpl_args> array 

    tpl_args[index] = new Object();
    tpl_args[index].name = name;
    tpl_args[index].value = "";
    tpl_args[index].defined = false;
    tpl_args[index].optional = optional;
}


function get_template_args()
{
    // Get arguments in the file specified by the variable <TEMPLATE_ARGS>
    // Returns true if everything defined correctly, false if not.

    // Check that <TEMPLATE_ARGS> exists.

    var args_fname = template.GetVariableValue("TEMPLATE_ARGS");

    if(args_fname == null)
    {
        var msg = "TEMPLATE_ARGS variable not defined.\n\n"
            + "To run the template in batch you need to specify a file with the data required to "
            + "run the template using the -varTEMPLATE_ARGS='fname' option.\n\n"
            + "The file should contain the following:\n\n"

        LogError(msg);

        for(var i=0; i<tpl_args.length; i++)
        {
            msg = tpl_args[i].name + ",'value'   "

            if(tpl_args[i].optional) msg += "[optional]";

            LogError(msg);
        }

        return false;
    }

    // Check that the file exists

    if(!File.Exists(args_fname))
    {
        var msg = "TEMPLATE_ARGS filename '" + args_fname + "' does not exist.\n\n"
            + "Unable to continue.";

        LogError(msg);

        return false;
    }

    // Check that it is a file

    if(!File.IsFile(args_fname))
    {
        var msg = "TEMPLATE_ARGS filename '" + args_fname + "' is not a file.\n\n"
            + "Unable to continue.";

        LogError(msg);

        return false;
    }  

    // Open the file

    f_args = new File(args_fname, File.READ);

    // Try to read the arguments - looking for comma separated <arg_name>,<arg_value> pairs

    var line;

    while( (line = f_args.ReadLongLine() ) != File.EOF)
    {
        var list = line.split(",");

        var name = list[0].toUpperCase();

        if(list[1] != undefined)
        {
            for(var i=0; i<tpl_args.length; i++)
            {
                if(tpl_args[i].name == name)
                {
                    tpl_args[i].value   = list[1];
                    tpl_args[i].defined = true;
                }
            }
        }
    }

    // Close the file

    f_args.Close();

    // Check that we got all the compulsory arguments

    var did_not_get = new Array();

    for(var i=0; i<tpl_args.length; i++)
    {
        if(!tpl_args[i].optional && !tpl_args[i].defined)
        {
            did_not_get.push(tpl_args[i].name);
        }
    }

    if(did_not_get.length > 0)
    {
        var msg = "The following argument(s) were missing from " + args_fname + ":\n\n";

        for(var i=0; i<did_not_get.length; i++)
        {
            msg += did_not_get[i] + "\n";
        }

        LogError(msg);

        return false;
    }

    // Got the all the required arguments so return true

    return true;

}


function GetDirs(strFilepath)
{
    // Extracts the directories from a file path

    var strDir = "";

    // Return blank string if path not defined
    if (strFilepath == undefined)
    {
        Warning("<strFilepath> undefined in <GetDirs>");
        return strDir;
    }

    // Get the folders from strFilepath - try Windows first "\" or "/"
    var strFolders = strFilepath.split(/\\|\//);

    // Try Unix "/" if that didn't split the path 
    if(strFolders[0] == strFolders) strFolders = strFilepath.split("/");

    return strFolders;
}


function find_lsdyna_files(dir, job_name, type)
// Searches a directory for filenames matching either Arup or LSTC filename conventions.
// Searches for files in directory <dir> of type <type>, possibly containing
// <job_name>, and returns the first match in the priority lists below.
{
    var filters = [];

    switch (type)
    {
        case "KEY":
            var filters = [new RegExp("^" + job_name + "\.key$"),
                           new RegExp("^" + job_name + "\.k$"),
                           new RegExp("^" + job_name + ".*\.key$"),
                           new RegExp("^" + job_name + ".*\.k$"),
                           new RegExp(".*\.key$"),
                           new RegExp(".*\.k$")];

            break;

        case "PTF":
            var filters = [new RegExp("^" + job_name + "\.ptf$"),
                           new RegExp("^" + job_name + "\.d3plot$"),
                           new RegExp("^" + job_name + "\.fz$"),
                           new RegExp("^d3plot$"),
                           new RegExp("^Zd3plot$"),
                           new RegExp("^" + job_name + ".*\.ptf$"),
                           new RegExp("^" + job_name + ".*\.d3plot$"),
                           new RegExp(".*\.ptf$"),
                           new RegExp(".*\.d3plot$"),
                           new RegExp(".*\.fz$"),
                           new RegExp(".*\.Zd3plot$")];
            break;

        
        case "THF":
            var filters = [new RegExp("^" + job_name + "\.thf$"),
                          new RegExp("^" + job_name + "\.d3thdt$"),
                          new RegExp("^d3thdt$"),
                          new RegExp("^" + job_name + ".*\.thf$"),
                          new RegExp("^" + job_name + ".*\.d3thdt$"),
                          new RegExp(".*\.thf$"),
                          new RegExp(".*\.d3thdt$")];
            break;

        
        case "BINOUT":
            var filters = [new RegExp("^" + job_name + "\.binout.*$"),
                          new RegExp("^binout.*$"),
                          new RegExp("^" + job_name + ".*\.binout.*$"),
                          new RegExp(".*\.binout.*$")];
            break;
    

        case "OTF":
            var filters = [new RegExp("^" + job_name + "\.otf$"),
                           new RegExp("^" + job_name + "\.d3hsp$"),
                           new RegExp("^d3hsp$"),
                           new RegExp("^" + job_name + ".*\.otf$"),
                           new RegExp("^" + job_name + ".*\.d3hsp$"),
                           new RegExp(".*\.otf$"),
                           new RegExp(".*\.d3hsp$")];
            break;

        default:
            break;
    }

    var filelist = [];
    var filestore = [];
    for(var i = 0; i < filters.length; i++)
    {
        filelist = File.FindFiles(dir, "*", false); // Extra arguments used in REPORTER only
        for (var j = 0; j < filelist.length; j++)
        {
            if (filters[i].test(filelist[j]) == true)
            {
                filestore.push(filelist[j]);
            }
        }    
        if(filestore.length > 0)
        {
            filestore.sort();
            var filename = filestore[0].substring(Math.max(filestore[0].lastIndexOf("/"), filestore[0].lastIndexOf("\\")) + 1);
            break;
        }
    }

    if (filestore.length == 0)
        return null;
  
    var absolute_filename = dir + "/" + filename;

    return absolute_filename;
}

