var workflow_data = read_json(json_dir + "/" + json_job + ".json");

var js_path = JSPath(arguments[0]); //arguments[0] gives us js path including the filename. The function JSPath gets rid of filename

start_icfd_cut_section_workflow(workflow_data);


function read_json(filename)
{
    if (File.Exists(filename))    //File.Exists occurs in the whole JavaScript Oasys Suite even in reporter
    {
        let file = new File(filename, File.READ);    //creates a new file object this can be for reading an existing file 
        let json = "";          //creating a variable called json
        let line;                 //creating a variable called line
        while ((line = file.ReadLine()) != File.EOF)   //stop the while loop when the variable line returns the flag File.EOF (that is a File constant)
        {
            json += line;   //string from line gets added to json variable.
        }
        file.Close();       //closes a file opened by a File object - 

        let data = JSON.parse(json); //turns the JSON string contained in the variable called json into a JavaScript object, this is stored in the variable data
        return data; 

    }
    else
    {
        Message("JSON File does not exist! JSON file and the key file should be in the folder selected from the ICFD setup tool.");
        return null;
    }

}






function start_icfd_cut_section_workflow(workflow_data)
{
    
    //Had to use a set file as a Temporary solution to changing the Component from ICV Fluid pressure to ICV Fluid velocity
    
    if (typeof REPORTER === 'undefined') 
    {
        DialogueInput("/UTILITIES", "SETTINGS_FILE", "READ", js_path + "/" + "fluid_velocity.set");

    } 
    else 
    {
        DialogueInput("/UTILITIES", "SETTINGS_FILE", "READ", template_dir + "/scripts/ICFD/d3plot/" + "fluid_velocity.set");

    }


    var y_cut = workflow_data.data.cut_section_position;
    Message("Cut section y-coordinate: " + y_cut);
    DialogueInput("");

    //Automating the cut section focus
    DialogueInput("/CUT_SECTION", "ON", "CREATE", "Y_CONSTANT_Y_PLANE", y_cut, "DEFORMED_MODEL");


    //Changing the view
    DialogueInput("/+XZ");
    //Changing to Contour Plot
    DialogueInput("/CT");
    //Changing the framerate of the animation
    DialogueInput("/IMAGES FRAME_RATE 20");

    DialogueInput("/DISPLAY_OPTIONS WINDOW PART_SCREEN");

    DialogueInput("/AC");


    Window.Theme(Window.THEME_LIGHT);

    Exit()

}



function JSPath(args_zero) //function that calculates the angle between two 2D or 3D vectors "a" and "b".
{
    //The following lines define (separately) the path and filename of the JavaScript, for use in relative file mapping etc.:
    var js_split = args_zero.split("/"); //split into directories (forward slash)
    if(js_split.length==1) js_split = args_zero.split("\\"); //split into directories (Windows backward slash)
    var js_path = js_split[0] + "/";
    for(var i=1; i<(js_split.length-1); i++) js_path = js_path + js_split[i] + "/"; //assembles path (without filename) of JavaScript
    return js_path;
}
