// Create energy curves

// read in total, interal, kinetic and hourglass energy

// 1. Setup the graph

// T/HIS graph setup now requires model units to determine x-axis precision.
// We don't know units for General model so set to seconds to give 3 decimal places.
let oGlblData = {unit_time:"s"};

setup_this_graph();

// 2. Read the model in into T/His

var res_file = results_dir + "/" + default_job;


DialogueInput("/MODEL READ", res_file);

if(!Model.Exists(1))
{
    ErrorMessage("Cannot find model results: " + res_file);
    Exit();
}

//3. Read the data for the energy curves
energy_balance();


function energy_balance() 
{
    var te = read_data("Global", 1, "M1", "TE");
    var ie = read_data("Global", 1, "M1", "IE");
    var ke = read_data("Global", 1, "M1", "KE");
    var hg = read_data("Global", 1, "M1", "HG");

    var output_data = {};
    output_data.energy = new OutputData("Energy Balance", images_dir + "/" + "Energy_Balance");

    if(!te || !ie || !ke || !hg)
    { 
        create_blank_image("NO DATA FOR ENERGY", output_data.energy.fname);    
    }

    else 
    {
        write_image(output_data.energy.title, output_data.energy.fname);
        output_data.energy.curveList.push(te.id);
        output_data.energy.curveList.push(ie.id);
        output_data.energy.curveList.push(ke.id);
        output_data.energy.curveList.push(hg.id);
        write_curve("cur", output_data.energy.curveList, output_data.energy.fname);
        write_curve("csv", output_data.energy.curveList, output_data.energy.fname);
    }
}
