/// <reference path="C:/SOURCE14/this_dir/this_js_api/this.intellisense.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common1.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common_EuroNCAP.js" />


// Constants used through out the script

var REG_DT     = 0.00001; // dt for regularising curves (in seconds)
var HIC_WINDOW = 0.015;      // HIC time Window (in seconds)
 
// Head assessment constants

var PEAK_HEAD_ACCN_HI_LIMIT = 80.0;  //The upper limit for head acceleration
var HIC_HI_LIMIT            = 700.00;

var HEAD_HI_SCORE  = 4.0;
var HEAD_LO_SCORE  = 0.0;

// Abdomen assessment constants

var ABDOMEN_COMPRESSION_GOOD     = 47.0;  // The abdominal compression limit in mm
var ABDOMEN_COMPRESSION_ADEQUATE = 53.0;  // The abdominal compression limit in mm
var ABDOMEN_COMPRESSION_MARGINAL = 59.0;  // The abdominal compression limit in mm
var ABDOMEN_COMPRESSION_WEAK     = 65.0;  // The abdominal compression limit in mm

var ABDOMEN_HI_SCORE = 4.0;
var ABDOMEN_LO_SCORE = 0.0;

//Pelvis assessment constants

var PELVIS_GOOD     = 1.7;
var PELVIS_ADEQUATE = 2.067;
var PELVIS_MARGINAL = 2.433;
var PELVIS_WEAK     = 2.8;

var PELVIS_HI_SCORE = 4.0;
var PELVIS_LO_SCORE = 0.0;

//Chest assessment constants

var CHEST_VC_A      = 1.0;      // Viscous Criterion A constant (for m/s)
var CHEST_VC_B      = 0.14;     // Viscous Criterion B constant (for m/s)
var CHEST_VC_METHOD = "ECER95"; // Viscous Criterion calculation method

var CHEST_COMPRESSION_GOOD     = 28;    // The compression limit for the chest in mm
var CHEST_COMPRESSION_ADEQUATE = 35.333; // The compression limit for the chest in mm
var CHEST_COMPRESSION_MARGINAL = 42.667; // The compression limit for the chest in mm
var CHEST_COMPRESSION_WEAK     = 50;    // The compression limit for the chest in mm

var CHEST_COMPRESSION_CAPPING_LIMIT = 55;  // Capping limit is 55mm

var CHEST_TOP_HI_SCORE = 4.0;
var CHEST_TOP_LO_SCORE = 0.0;

var CHEST_MID_HI_SCORE = 4.0;
var CHEST_MID_LO_SCORE = 0.0;

var CHEST_BOTTOM_HI_SCORE = 4.0;
var CHEST_BOTTOM_LO_SCORE = 0.0;

var CHEST_VC_LIMIT = 1.0;  // 1m/s

// Shoulder

var SHOULDER_FORCE_LIMIT = 3.0;  // 3kN



if(File.Exists(fname_csv) && File.IsFile(fname_csv))
{
// Do the common setup of assigning values to the oGlblData object,
// setting the T/HIS graph up and reading in the model.

  var oGlblData = new Object();

  var f_vars = do_common_single_analysis_setup(oGlblData);

// For each body region, do the calculation, writing results to the variables file.

  do_head_rating_calc(f_vars);
     
  do_pelvis_rating_calc(f_vars);
      
  do_abdomen_rating_calc(f_vars);
  
  do_chest_rating_calc(f_vars);
  
  do_shoulder_calc(f_vars);
    
  f_vars.Close();
}


function do_head_rating_calc (f)
{
//Calculates the head score and writes relevant values
//into the Reporter csv variables file <f>.

  var node = oGlblData.head_node;
  var node_y = oGlblData.head_node_y;
  var node_z = oGlblData.head_node_z;

  var capping_limit = "FALSE";
  
  var output_data = {};

  output_data.acc = new OutputData("Head Acceleration", images_dir + "/Head_Acceleration");
  
  if(node !=undefined)
  {
    // Read in acceleration X, Y and Z
    var one_node = true;

    // If nodes for three accelerometer positions defined, use all three, otherwise, read all components from same node
    if(node_y != undefined && node_z != undefined && node_y != 0 && node_z != 0)
    {
        var c_acc = read_xyz_accelerations(1, node, node_y, node_z);
        one_node = false;
    }
    else
    {
        var c_acc = read_xyz_accelerations(1, node);
    }

    // Check that the curves read in - i.e. the node id and component are valid
    // Create a blank image to let the user know.
    
    // Generate a relevant message for the blank image depending on which acceleration data are missing
    if(!c_acc.ax || !c_acc.ay || !c_acc.az)
    {
        var blank_image_msg;
        // If only one node supplied, just report that node ID
        if(one_node) blank_image_msg = "NO ACCEL DATA (NODE " + node + ") ";
        // else report each of the node IDs that were invalid
        else
        {
            var acc_comp_lst = [];
            var acc_id_lst = [];
            if(!c_acc.ax)
            {
                acc_comp_lst.push(" X");
                acc_id_lst.push(" "+node);
            }
            if(!c_acc.ay)
            {
                acc_comp_lst.push(" Y");
                acc_id_lst.push(" "+node_y);
            }
            if(!c_acc.az)
            {
                acc_comp_lst.push(" Z");
                acc_id_lst.push(" "+node_z);
            }
            blank_image_msg = "NO" + acc_comp_lst + " ACCEL DATA (NODE(s) " + acc_id_lst + ") ";
        }
        create_blank_image(blank_image_msg + output_data.acc.title, output_data.acc.fname);
    }
    else
    {
// Convert to g from model units
    
      var c_g = convert_xyz_acc_to_g(c_acc);
    
// C1000 filter (convert to seconds first)

      var c_gx_c1000 = convert_to_s_and_filter(c_g.gx, Operate.C1000, REG_DT);
      var c_gy_c1000 = convert_to_s_and_filter(c_g.gy, Operate.C1000, REG_DT);
      var c_gz_c1000 = convert_to_s_and_filter(c_g.gz, Operate.C1000, REG_DT);

// Vector combine

      var c_vec_g = Operate.Vec(c_gx_c1000, c_gy_c1000, c_gz_c1000);
    
// Remove all curves and datums

      remove_all_curves_and_datums();
    
// Convert from seconds back to model time

      c_vec_g = Operate.Mux(c_vec_g, oGlblData.time_factor);
    
// Get peak aceleration (in g)
    
      DialogueInput("/AU");
      var peak_accn = c_vec_g.ymax;
    
// Get HIC15 value
    
      var hic = Operate.Hic(c_vec_g, HIC_WINDOW, 1.0);
     
// Set label and style

      set_labels(c_vec_g, "Head Acceleration Magnitude", "Time (" + oGlblData.unit_time + ")", "Acceleration (g)");
      set_line_style(c_vec_g, Colour.BLACK);

// Draw limit curves => up to final time

      var p = c_vec_g.GetPoint(c_vec_g.npoints);
      draw_head_limits(p[0], output_data.acc);

// Create image and curve files

      write_image(output_data.acc.title, output_data.acc.fname);
	  
	  output_data.acc.curveList.push(c_vec_g.id);
	  write_curve("cur", output_data.acc.curveList, output_data.acc.fname);
	  write_curve("csv", output_data.acc.curveList, output_data.acc.fname);

// Remove all curves and datums

      remove_all_curves_and_datums();

// Calculate Head points

      var peak_accn_score = 0.0;
      var hic_score       = 0.0;

      if (peak_accn < PEAK_HEAD_ACCN_HI_LIMIT)
      {
        peak_accn_score = HEAD_HI_SCORE;
      }
      
      if (hic < HIC_HI_LIMIT)
      {
        hic_score = HEAD_HI_SCORE;
      }
    
//Peak head acceleration value and score
      
      write_variable(f, "HEAD_PEAK_ACCN",       peak_accn.toFixed(3),       "Peak head acceleration value", "String");
      write_variable(f, "HEAD_PEAK_ACCN_SCORE", peak_accn_score.toFixed(3), "Peak head acceleration score", "String");

      
//HIC value and score
      
      write_variable(f, "HEAD_HIC15",       hic.toFixed(3),       "HIC15 value", "String");
      write_variable(f, "HEAD_HIC15_SCORE", hic_score.toFixed(3), "HIC15 score", "String");
    
// Capping limit should be applied to overall score if these are zero
          
      if(peak_accn_score == 0.0 || hic_score == 0.0) capping_limit = "TRUE";
      
      write_variable(f, "HEAD_CAPPING_LIMIT", capping_limit, "Head capping limit", "String");
    }
  }
  else
  {
// No NODE defined-variables should be set to blank by the first script in this template.
// Create a blank image to let the user know.
     
    write_blank_images(output_data, "NO NODE ID DEFINED FOR");
  }
}

