/// <reference path="C:/SOURCE14/this_dir/this_js_api/this.intellisense.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common1.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common_EuroNCAP.js" />


// Constants used throughout the script

var REG_DT     = 0.00001; // dt for regularising curves (in seconds)
var HIC_WINDOW = 0.015;   // HIC time window (in seconds)
var TMS_PERIOD = 0.003;   // 3ms period (in seconds)

// Head assessment constants

var PEAK_HEAD_ACCN_SOFT = 80.0;       // 80g - soft contact

var PEAK_HEAD_ACCN_LO_LIMIT = 80.0;   // 80g  } limits if no steering wheel airbag present
var PEAK_HEAD_ACCN_HI_LIMIT = 120.0;  // 120g }

var HIC_LO_LIMIT = 500.0;
var HIC_HI_LIMIT = 700.0;

var TMS_LO_LIMIT   = 72.0;
var TMS_HI_LIMIT   = 80.0;
var TMS_LO_LIMIT_2 = 65.0;  // } Different 3ms limits for driver 
var TMS_HI_LIMIT_2 = 80.0;  // } if no steering wheel airbag present

var HEAD_FA_DISP_LO_LIMIT   = 90;   // 90mm  rearward displacement
var HEAD_FA_DISP_HI_LIMIT   = 110;  // 110mm rearward displacement
var HEAD_LAT_DISP_LO_LIMIT  = 90;   // 90mm  lateral displacement
var HEAD_LAT_DISP_HI_LIMIT  = 110;  // 110mm lateral displacement
var HEAD_VERT_DISP_LO_LIMIT = 72;   // 72mm  upward displacement
var HEAD_VERT_DISP_HI_LIMIT = 88;   // 88mm  upward displacement

var STEERING_WHEEL_LO_SCORE = -1.0;
var STEERING_WHEEL_HI_SCORE = 0.0;

var HEAD_LO_SCORE   = 0.0;
var HEAD_HI_SCORE   = 4.0;
var HEAD_HI_SCORE_2 = 2.0;  // High score limited to 2.0 for driver if no steering wheel airbag


// Neck assessment constants

var NECK_SHR_ADJ_FAC = 17.78;   // Factor to multiply shear by to adjust bending moment

// Neck shear limit curves

var NECK_SHR_EXC_TIME     = new Array(4);
var NECK_SHR_EXC_GOOD     = new Array(4);
var NECK_SHR_EXC_ADEQUATE = new Array(4);
var NECK_SHR_EXC_MARGINAL = new Array(4);
var NECK_SHR_EXC_WEAK     = new Array(4);

NECK_SHR_EXC_TIME[0] = 0.0;     NECK_SHR_EXC_GOOD[0] = 1.9;   NECK_SHR_EXC_ADEQUATE[0] = 2.3;   NECK_SHR_EXC_MARGINAL[0] = 2.7;   NECK_SHR_EXC_WEAK[0] = 3.1;
NECK_SHR_EXC_TIME[1] = 0.025;   NECK_SHR_EXC_GOOD[1] = 1.2;   NECK_SHR_EXC_ADEQUATE[1] = 1.3;   NECK_SHR_EXC_MARGINAL[1] = 1.4;   NECK_SHR_EXC_WEAK[1] = 1.5;
NECK_SHR_EXC_TIME[2] = 0.035;   NECK_SHR_EXC_GOOD[2] = 1.2;   NECK_SHR_EXC_ADEQUATE[2] = 1.3;   NECK_SHR_EXC_MARGINAL[2] = 1.4;   NECK_SHR_EXC_WEAK[2] = 1.5;
NECK_SHR_EXC_TIME[3] = 0.045;   NECK_SHR_EXC_GOOD[3] = 1.1;   NECK_SHR_EXC_ADEQUATE[3] = 1.1;   NECK_SHR_EXC_MARGINAL[3] = 1.1;   NECK_SHR_EXC_WEAK[3] = 1.100001;

// Neck tension limit curves

var NECK_TEN_EXC_TIME     = new Array(3);
var NECK_TEN_EXC_GOOD     = new Array(3);
var NECK_TEN_EXC_ADEQUATE = new Array(3);
var NECK_TEN_EXC_MARGINAL = new Array(3);
var NECK_TEN_EXC_WEAK     = new Array(3);

NECK_TEN_EXC_TIME[0] = 0.0;     NECK_TEN_EXC_GOOD[0] = 2.7;  NECK_TEN_EXC_ADEQUATE[0] = 2.9;  NECK_TEN_EXC_MARGINAL[0] = 3.1;  NECK_TEN_EXC_WEAK[0] = 3.3;
NECK_TEN_EXC_TIME[1] = 0.035;   NECK_TEN_EXC_GOOD[1] = 2.3;  NECK_TEN_EXC_ADEQUATE[1] = 2.5;  NECK_TEN_EXC_MARGINAL[1] = 2.7;  NECK_TEN_EXC_WEAK[1] = 2.9;
NECK_TEN_EXC_TIME[2] = 0.060;   NECK_TEN_EXC_GOOD[2] = 1.1;  NECK_TEN_EXC_ADEQUATE[2] = 1.1;  NECK_TEN_EXC_MARGINAL[2] = 1.1;  NECK_TEN_EXC_WEAK[2] = 1.100001;

var NECK_MOM_GOOD     = -42.0;
var NECK_MOM_ADEQUATE = -47.0;
var NECK_MOM_MARGINAL = -52.0;
var NECK_MOM_WEAK     = -57.0;

var NECK_LO_SCORE   = 0.0;
var NECK_HI_SCORE   = 4.0;


// Chest assessment

// V7 and earlier dummies use a linear conversion: D = A*theta

var CHEST_V7_ROT_TO_COM_FACTOR = -139.0;   // Factor to convert chest transducer rotation to compression (mm)

var CHEST_LSTC_HIII_50TH_MALE_DETAILED_190217_BETA_ROT_TO_COM_FACTOR = -146.0;   // Factor to convert chest transducer rotation to compression (mm)

// V8 dummies use a 3rd order polynomial conversion D = A*theta^3 - B*theta^2 - C*theta

var CHEST_V8_ROT_TO_COM_FACTOR_A =   25.13;   // First polynomial factor to convert chest transducer rotation to compression (mm)
var CHEST_V8_ROT_TO_COM_FACTOR_B =  -35.77;   // Second polynomial factor to convert chest transducer rotation to compression (mm)
var CHEST_V8_ROT_TO_COM_FACTOR_C = -136.26;   // Third polynomial factor to convert chest transducer rotation to compression (mm)


var CHEST_VC_A = 1.3;           // Viscous Criterion A constant (for m/s)
var CHEST_VC_B = 0.229;         // Viscous Criterion B constant (for m/s)
var CHEST_VC_METHOD = "ECER95"; // Viscous Criterion calculation method

var CHEST_COM_GOOD     = 22.00;  // 22mm
var CHEST_COM_ADEQUATE = 28.67;  // 28.67mm
var CHEST_COM_MARGINAL = 35.33;  // 35.33mm
var CHEST_COM_WEAK     = 42.00;  // 50mm

var CHEST_VC_GOOD     = 0.5;   // 0.50 m/s
var CHEST_VC_ADEQUATE = 0.67;  // 0.67 m/s
var CHEST_VC_MARGINAL = 0.83;  // 0.83 m /s
var CHEST_VC_WEAK     = 1.0;   // 1.00 m/s

var CHEST_A_PILLAR_FA_DISP_GOOD     = 100;     // 100mm  rearward displacement
var CHEST_A_PILLAR_FA_DISP_ADEQUATE = 133.33;  // 133.33mm  rearward displacement
var CHEST_A_PILLAR_FA_DISP_MARGINAL = 166.67;  // 166.67mm  rearward displacement
var CHEST_A_PILLAR_FA_DISP_WEAK     = 200;     // 200mm rearward displacement

var CHEST_A_PILLAR_LO_SCORE = -2.0;
var CHEST_A_PILLAR_HI_SCORE = 0.0;

var CHEST_LO_SCORE = 0.0;
var CHEST_HI_SCORE = 4.0;


// Knee, Femur and Pelvis assessments

// Femur limit curves

var FEMUR_COM_EXC_TIME     = new Array(2);
var FEMUR_COM_EXC_GOOD     = new Array(2);
var FEMUR_COM_EXC_ADEQUATE = new Array(2);
var FEMUR_COM_EXC_MARGINAL = new Array(2);
var FEMUR_COM_EXC_WEAK     = new Array(2);

FEMUR_COM_EXC_TIME[0] = 0.0;     FEMUR_COM_EXC_GOOD[0] = 3.8;  FEMUR_COM_EXC_ADEQUATE[0] = 5.56;  FEMUR_COM_EXC_MARGINAL[0] = 7.31;  FEMUR_COM_EXC_WEAK[0] = 9.07;
FEMUR_COM_EXC_TIME[1] = 0.010;   FEMUR_COM_EXC_GOOD[1] = 3.8;  FEMUR_COM_EXC_ADEQUATE[1] = 5.05;  FEMUR_COM_EXC_MARGINAL[1] = 6.31;  FEMUR_COM_EXC_WEAK[1] = 7.56;

var KNEE_DISP_GOOD     =  6.0;
var KNEE_DISP_ADEQUATE =  9.0;
var KNEE_DISP_MARGINAL = 12.0;
var KNEE_DISP_WEAK     = 15.0;

var KNEE_FEMUR_PELVIS_LO_SCORE = 0.0;
var KNEE_FEMUR_PELVIS_HI_SCORE = 4.0;

// Lower leg, foot and ankle assessments

var TIBIA_COM_GOOD     = 2.0;
var TIBIA_COM_ADEQUATE = 4.0;
var TIBIA_COM_MARGINAL = 6.0;
var TIBIA_COM_WEAK     = 8.0;

var TIBIA_INDEX_GOOD     = 0.4;
var TIBIA_INDEX_ADEQUATE = 0.7;
var TIBIA_INDEX_MARGINAL = 1.0;
var TIBIA_INDEX_WEAK     = 1.3;

var TIBIA_MRC = 225;    // Tibia index critical moment = 225Nm
var TIBIA_FZC = 35.9;   // Tibia index critical force  = 25.8kN

var LOWER_LEG_PEDAL_VERT_DISP_GOOD     = 72.0;
var LOWER_LEG_PEDAL_VERT_DISP_ADEQUATE = 77.33;
var LOWER_LEG_PEDAL_VERT_DISP_MARGINAL = 82.67;
var LOWER_LEG_PEDAL_VERT_DISP_WEAK     = 88.0;

var LOWER_LEG_PEDAL_VERT_DISP_LO_SCORE = -1.0;
var LOWER_LEG_PEDAL_VERT_DISP_HI_SCORE = 0;


var LOWER_LEG_PEDAL_FA_DISP_GOOD     = 100.0;
var LOWER_LEG_PEDAL_FA_DISP_ADEQUATE = 133.33;
var LOWER_LEG_PEDAL_FA_DISP_MARGINAL = 166.67;
var LOWER_LEG_PEDAL_FA_DISP_WEAK     = 200.0;

var LOWER_LEG_PEDAL_FA_DISP_LO_SCORE = 0.0;
var LOWER_LEG_PEDAL_FA_DISP_HI_SCORE = 4.0;

var LOWER_LEG_FOOT_AND_ANKLE_LO_SCORE = 0.0;
var LOWER_LEG_FOOT_AND_ANKLE_HI_SCORE = 4.0;

