/// <reference path="C:/SOURCE14/this_dir/this_js_api/this.intellisense.js" />
/// <reference path="C:/SOURCE14/reporter_dir/library/templates/scripts/this_common1.js" />

// Common functions for EuroNCAP Legform templates
var zone;

// Now try to open LST files 

	if( (File.Exists(fname_lower) && File.IsFile(fname_lower)) ||
			(File.Exists(fname_upper) && File.IsFile(fname_upper)) )
{

    Message("FIRST GATE!");

	// Read the LST files and store the data

	var oGlblData = new Object();
	var data = new Array();

	for(var i=0; i<2; i++)
	{
		var fname;

		if(i==0) fname = fname_lower;
		if(i==1) fname = fname_upper;

		if( !File.Exists(fname) || !File.IsFile(fname) ) continue;

		// ------------------------------------------------------------------------------------------------
		// If models were built with the *CASE option then the LST file should contain:
		//
		//    MASTER_KEY_FILE,,,,                                       { this is the master keyword file that gets run }
		//    $case1:KEY_FILE,TEMPLATE,ZONE,X-COORD,Y-COORD             {   Case 1 keyword file                         }
		//    $case2:KEY_FILE,TEMPLATE,ZONE,X-COORD,Y-COORD             {   Case 2 keyword file                         }
		//    $case3:KEY_FILE,TEMPLATE,ZONE,X-COORD,Y-COORD             {   Case 3 keyword file                         }
		//    $case<n>:KEY_FILE,TEMPLATE,ZONE,X-COORD,Y-COORD     {   Case n keyword file                         }
		//
		// Lines starting with '$case<n>:' will have a fake KEY_FILE, but it will be in the form
		// <directory>/A_2_0.key, so we can use them to get the row and columns for each case.
		//
		// The results for each case will be in the same directory as the MASTER_KEY_FILE.
		//
		// The actual filenames of the results files for each case will depend on the format that they
		// were written out in.  We can try both and use the one that exists on the filesystem.
		//
		//   LSTC (default)        ARUP
		//   -------------         -----
		//   case1.d3thdt          case1.<master_key_file>.thf
		//   case2.d3thdt          case2.<master_key_file>.thf
		//   case3.d3thdt          case3.<master_key_file>.thf
		//
		// So we can construct a keyword file for each case which we store on the oData object.
		// T/His will then find the correct results files:
		//
		//   case1.key     or     case1.<master_key_file>.key
		//   case2.key            case2.<master_key_file>.key
		//   case3.key            case3.<master_key_file>.key
		// ------------------------------------------------------------------------------------------------

		// We need to detect if this is a *CASE LST file, so we know what to do when we read the file
		// If it is then get the directory where the results will be

		var case_option = is_lst_case_option(fname);

		var case_res_dir     = "";
		var case_master_file = "";

		if(case_option)
		{
			case_res_dir     = get_case_res_dir(fname);
			case_master_file = get_case_master_file(fname);
		}

		// Now read the LST file and store the data

		var f_lst = new File(fname, File.READ);

		var line;

		while ( (line = f_lst.ReadLine()) != undefined)
		{
			// Lines beginning with '$' are comments or 
			// beams or xsections to read data for in T/His
			//
			// or if they begin with '$case<id>:' they are lines for *CASE models

			if(line[0] == '$')
			{
				var list = line.split(",");
				var name = list[0].toLowerCase();

				if(list[1] != undefined)
				{
					if(case_option && 
							line[1] == "c" && line[2] == "a" && line[3] == "s" && line[4] == "e")
					{
						// *CASE model data
						// $case<id>:KEY_FILE,TEMPLATE,ZONE,X-COORD,Y-COORD

						// Get case id

						var case_id = "";
						var j = 5;
						while(line[j] != ":")
						{
							case_id += line[j];
							j++;
						}

						// Split the line

						var list = line.split(",");

						// Store an object with the data into the <data> array. (Must have at least three columns of data)

						if(list.length >= 3)
						{
							if ( check_zone_name(list[2],i) )
							{
								var oData = new Object();

								oData.res_file  = get_case_key_file(case_res_dir, case_master_file, case_id);
								oData.zone      = zone;    // 3rd column

								data.push(oData);
							}
						}
					}
					else
					{
						switch(name)
						{
							case "$unit_length":                 { oGlblData.unit_length                  = list[1];            break; }        
							case "$unit_mass":                   { oGlblData.unit_mass                    = list[1];            break; }
							case "$unit_time":                   { oGlblData.unit_time                    = list[1];            break; }

							case "$beam_femur1_id":              { oGlblData.beam_femur1_id               = parse_id(list[1]);  break; }
							case "$beam_femur2_id":              { oGlblData.beam_femur2_id               = parse_id(list[1]);  break; }

							case "$xsection_femur_upper_id":     { oGlblData.xsection_femur_upper_id      = parse_id(list[1]);  break; }
							case "$xsection_femur_centre_id":    { oGlblData.xsection_femur_centre_id     = parse_id(list[1]);  break; }
							case "$xsection_femur_lower_id":     { oGlblData.xsection_femur_lower_id      = parse_id(list[1]);  break; }

							case "$xsection_tibia_upper_id":     { oGlblData.xsection_tibia_upper_id      = parse_id(list[1]);  break; }
							case "$xsection_tibia_mid_upper_id": { oGlblData.xsection_tibia_mid_upper_id  = parse_id(list[1]);  break; }
							case "$xsection_tibia_mid_lower_id": { oGlblData.xsection_tibia_mid_lower_id  = parse_id(list[1]);  break; }
							case "$xsection_tibia_lower_id":     { oGlblData.xsection_tibia_lower_id      = parse_id(list[1]);  break; }

							case "$spring_pcl_id":               { oGlblData.spring_pcl_id                = parse_id(list[1]);  break; }
							case "$spring_acl_id":               { oGlblData.spring_acl_id                = parse_id(list[1]);  break; }
							case "$spring_mcl_id":               { oGlblData.spring_mcl_id                = parse_id(list[1]);  break; }
						}
					}
				}
			}
			else // Filenames (colum 1) and zones (column 3)
			{
				if(!case_option)  // Ignore if it's a lst file for *CASE models - this is the line for the master file
				{

					// Split the line

					var list = line.split(",");

					// Store an object with the data into the <data> array. (Must have at least three columns of data)

					if(list.length >= 3)
					{
						if ( check_zone_name(list[2],i) )
						{							
							var oData = new Object();

							oData.res_file  = list[0];
							oData.zone      = zone;    // 3rd column

							data.push(oData);
						}
					}
				}
			}
		}

		f_lst.Close();
	}

	// Open a csv file in the %IMAGES_DIR% to write variables to, for Reporter to pick up

	f_vars = new File(images_dir + "/this_vars.csv", File.WRITE);

	// Setup graph

	setup_this_graph();

	// Initialise variables to hold upper and lower scores

	oGlblData.upper_score = 0.0;
	oGlblData.lower_score = 0.0;

	oGlblData.upper_num = 0;
	oGlblData.lower_num = 0;

	oGlblData.upper_min_col = 0;
	oGlblData.lower_min_col = 0;
	oGlblData.upper_max_col = 0;
	oGlblData.lower_max_col = 0;

	// Read the model in into T/His and do the calculations
	for(var i=0; i<data.length; i++)
	{
		if( (File.Exists(data[i].res_file) && File.IsFile (data[i].res_file)) ||
				case_option)
		{
			if(data[i].zone.substring(0,1).toUpperCase() == "U") do_upper_legform_calc(f_vars, data[i].zone);
			else if(data[i].zone.substring(0,1).toUpperCase() == "L") do_lower_legform_calc(f_vars, data[i].zone);
		}
	}

	// Write out values for overall scores

	if(oGlblData.upper_num > 0) oGlblData.upper_score = 6.0 * oGlblData.upper_score / oGlblData.upper_num;
	if(oGlblData.lower_num > 0) oGlblData.lower_score = 6.0 * oGlblData.lower_score / oGlblData.lower_num;

	var total_legform = oGlblData.upper_score + oGlblData.lower_score;

	write_variable(f_vars, "UPPER_LEGFORM_TOTAL", oGlblData.upper_score.toFixed(3), "Upper Legform Score", "String");
	write_variable(f_vars, "LOWER_LEGFORM_TOTAL", oGlblData.lower_score.toFixed(3), "Lower Legform Score", "String");
	write_variable(f_vars, "TOTAL_LEGFORM",       total_legform.toFixed(3),         "Total Legform Score", "String");

	write_variable(f_vars, "UPPER_MIN_COL",       oGlblData.upper_min_col,          "Minimum column for upper leg", "String");
	write_variable(f_vars, "UPPER_MAX_COL",       oGlblData.upper_max_col,          "Maximum column for upper leg", "String");
	write_variable(f_vars, "LOWER_MIN_COL",       oGlblData.lower_min_col,          "Minimum column for lower leg", "String");
	write_variable(f_vars, "LOWER_MAX_COL",       oGlblData.lower_max_col,          "Maximum column for lower leg", "String");

	f_vars.Close();
}








function do_upper_legform_calc(f, zone)
{
	// Calculates the scores for upper leg <zone> and writes relevant values
	//into the Reporter variable file <f>.

	// Get the results file for this <zone>

	var res_file;

	for(var i=0; i<data.length; i++)
	{
		if(data[i].zone == zone) res_file = data[i].res_file;
	}

	// Read in the model

	DialogueInput("/MODEL READ", res_file);

	// Make sure any units set in T/HIS (e.g. via preferences) are unset

	unset_this_units(1);
	
	// check if the model time units and input time units are consistent
	// If the units are not defined/valid then we cannot go any further.  

	if(!check_unit_values())
	{
	write_unit_vars(f_vars, false);
	Exit();
	}

	// Write the unit data to the variables file

	write_unit_vars(f_vars, true);

	// Calculate constants now we have unit data and store on <oGlblData> object

	calculate_unit_constants();

	var u_assess_score = 999.0;

	// Zone name for reporter variables (replace '-' with 'MINUS_'

	var zone_for_var = zone.replace('-', 'MINUS_');

	// Read in force 1 and 2

	for (var i=0; i<2; i++)
	{
		if (i==0) beam = oGlblData.beam_femur1_id;
		else      beam = oGlblData.beam_femur2_id;

		// Check data components are available for this beam, if not create a blank image

		if(beam != undefined)
		{
			// Read in beam forces

			var c_force = read_data("BEAM BASIC", 0, beam, "NX");

			if(i == 0)
			{
				var c_f1 = c_force;

				if(c_f1)
				{
					var c_f1      = Operate.Dix(c_f1, oGlblData.time_factor); // Convert to seconds
					var c_f1      = Operate.Div(c_f1, oGlblData.kn_factor);   // Convert to kN
					var c_f1_c180 = Operate.C180(c_f1, REG_DT);               // C180 filter
				}
			}
			else
			{
				var c_f2 = c_force;

				if(c_f2)
				{
					var c_f2      = Operate.Dix(c_f2, oGlblData.time_factor);  // Convert to seconds
					var c_f2      = Operate.Div(c_f2, oGlblData.kn_factor);    // Convert to kN
					var c_f2_c180 = Operate.C180(c_f2, REG_DT);                // C180 filter
				}
			}
		}
	}

	var f_sum       = 0.0;
	var f_sum_score = 0.0;

	var output_data = {};

	output_data.sum = new OutputData(zone + " Sum of Forces", images_dir + "/" + zone + "_Sum_Force");

	if(c_f1_c180 && c_f2_c180)
	{
		// Combine both the force curves into a total force curve

		var all_curves = new Array();

		all_curves[0] = c_f1_c180;
		all_curves[1] = c_f2_c180;

		var c_sum_f = Operate.Sum(all_curves);

		// Get the sum of forces value and score

		DialogueInput("/AU");
		var results = get_constant_limit_results(c_sum_f, FEMUR_FORCE_GOOD, FEMUR_FORCE_WEAK, FEMUR_LO_SCORE, FEMUR_HI_SCORE);

		f_sum_score = results[0];
		f_sum       = results[1];

		// Remove all curves and datums

		remove_all_curves_and_datums();

		// Convert from seconds back to model time

		c_sum_f = Operate.Mux(c_sum_f, oGlblData.time_factor);

		// Set label and style

		set_labels(c_sum_f, "Femur Sum of Forces", "Time (" + oGlblData.unit_time + ")", "Force (kN)");
		set_line_style(c_sum_f, Colour.BLACK);

		// Draw force limit datums

		draw_constant_datums(FEMUR_FORCE_GOOD, FEMUR_FORCE_ADEQUATE, FEMUR_FORCE_MARGINAL, FEMUR_FORCE_WEAK);

		// Create image and curve files

		write_image(output_data.sum.title, output_data.sum.fname, c_sum_f, FEMUR_FORCE_WEAK);

		output_data.sum.curveList.push(c_sum_f.id);
		write_curve("cur", output_data.sum.curveList, output_data.sum.fname);
		write_curve("csv", output_data.sum.curveList, output_data.sum.fname);
	}
	else
	{
		// No BEAM defines-variables should be set to blank by the first script in this template.
		// Create a blank image to let the user know.

		write_blank_images(output_data, "INVALID/NO BEAM ID DEFINED FOR");
	}

	remove_all_curves_and_datums();

	// Bending moments

	var f_upperbend        = 0.0;
	var f_centrebend       = 0.0;
	var f_lowerbend        = 0.0;
	var f_upperbend_score  = 0.0;
	var f_centrebend_score = 0.0;
	var f_lowerbend_score  = 0.0;

	for (i=0; i<3; i++)
	{    
		if      (i == 0) { xsection = oGlblData.xsection_femur_upper_id;  }
		else if (i == 1) { xsection = oGlblData.xsection_femur_centre_id; }
		else             { xsection = oGlblData.xsection_femur_lower_id;  }

		if(xsection != undefined)
		{
			// Read in x section moments

			var c_my = read_data("SECTION", 0, xsection, "MY");

			if(c_my)
			{
				var c_my = Operate.Dix(c_my, oGlblData.time_factor);  // Convert to seconds
				var c_my = Operate.Div(c_my, oGlblData.nm_factor);    // Convert to Nm
				var c_my = Operate.C180(c_my, REG_DT);                // C180 filter
				var c_my = Operate.Abs(c_my);                         // Absolute value

				var results = get_constant_limit_results(c_my, FEMUR_BENDING_MOMENT_GOOD, FEMUR_BENDING_MOMENT_WEAK, FEMUR_LO_SCORE, FEMUR_HI_SCORE);

				if (i == 0)
				{
					//Get Peak value and score

					var c_xu = c_my;

					f_upperbend_score = results[0];
					f_upperbend       = results[1];
				}
				else if (i == 1)
				{
					//Get Peak value and score

					var c_xc = c_my;

					f_centrebend_score = results[0];
					f_centrebend       = results[1];
				}
				else 
				{
					//Get Peak value and score

					var c_xl = c_my;

					f_lowerbend_score = results[0];
					f_lowerbend       = results[1];
				}
			}
		}
	}

	var output_data = {};

	output_data.mom = new OutputData(zone + " Femur Bending Moments", images_dir + "/" + zone + "_Femur_Bending_Moment");

	if(c_xu && c_xc && c_xl)
	{

		// Convert lines back to original time

		c_xu_s = Operate.Mux(c_xu, oGlblData.time_factor);
		c_xc_s = Operate.Mux(c_xc, oGlblData.time_factor);
		c_xl_s = Operate.Mux(c_xl, oGlblData.time_factor);

		// Set line style

		set_labels(c_xu_s, "Femur Upper Bending Moment", "Time (" + oGlblData.unit_time + ")", "Bending Moment (Nm)");
		set_line_style(c_xu_s, Colour.BLUE);

		set_labels(c_xc_s, "Femur Centre Bending Moment", "Time (" + oGlblData.unit_time + ")", "Bending Moment (Nm)");
		set_line_style(c_xc_s, Colour.MAGENTA);

		set_labels(c_xl_s, "Femur Lower Bending Moment", "Time (" + oGlblData.unit_time + ")", "Bending Moment (Nm)");
		set_line_style(c_xl_s, Colour.BLACK);

		// Remove all curves and datums

		remove_all_curves_and_datums();

		// Draw moment limit datums

		draw_constant_datums(FEMUR_BENDING_MOMENT_GOOD, FEMUR_BENDING_MOMENT_ADEQUATE, FEMUR_BENDING_MOMENT_MARGINAL, FEMUR_BENDING_MOMENT_WEAK);

		// Create image and curve files of all three bending moments

		c_xu_s.AddToGraph();
		c_xc_s.AddToGraph();
		c_xl_s.AddToGraph();

		write_image(output_data.mom.title, output_data.mom.fname, [ c_xu_s, c_xc_s, c_xl_s ], FEMUR_BENDING_MOMENT_WEAK)

			output_data.mom.curveList.push(c_xu_s.id, c_xc_s.id, c_xl_s.id);
		write_curve("cur", output_data.mom.curveList, output_data.mom.fname);
		write_curve("csv", output_data.mom.curveList, output_data.mom.fname);
	}
	else
	{
		// No Xsection defined-variables should be set to blank by the first script in this template.
		// Create a blank image to let the user know.

		write_blank_images(output_data, "MISSING/INVALID XSECTION ID DEFINED FOR");
	}

	// Delete model

	DialogueInput("/MODEL DELETE ALL");

	//Write out values, calculating the assessemnt values and the colour to go with it

	//Femur Upper Bending moments VALUES and SCORES

	write_variable(f, "FEMUR_UPPER_BENDING_" + zone_for_var,        f_upperbend.toFixed(2),        "Femur Upper Bend Value " + zone,  "String");
	write_variable(f, "FEMUR_UPPER_BENDING_SCORE_" + zone_for_var,  f_upperbend_score.toFixed(3),  "Femur Upper Bend Score " + zone,  "String");

	write_variable(f, "FEMUR_CENTRE_BENDING_" + zone_for_var,       f_centrebend.toFixed(2),       "Femur Centre Bend Value " + zone, "String");
	write_variable(f, "FEMUR_CENTRE_BENDING_SCORE_" + zone_for_var, f_centrebend_score.toFixed(3), "Femur Centre Bend Score " + zone, "String");

	write_variable(f, "FEMUR_LOWER_BENDING_" + zone_for_var,        f_lowerbend.toFixed(2),        "Femur Lower Bend Value " + zone,  "String");
	write_variable(f, "FEMUR_LOWER_BENDING_SCORE_" + zone_for_var,  f_lowerbend_score.toFixed(3),  "Femur Lower Bend Score " + zone,  "String");

	// Femur U1 Sum of forces kN VALUES

	write_variable(f, "FEMUR_FORCE_" + zone_for_var,        f_sum.toFixed(2),        "Femur Sum of Forces Value " + zone,  "String");
	write_variable(f, "FEMUR_FORCE_SCORE_" + zone_for_var,  f_sum_score.toFixed(3),  "Femur Sum of Forces Score " + zone,  "String");

	var f_assess_score = Math.min(f_upperbend_score, f_centrebend_score, f_lowerbend_score, f_sum_score);

	write_variable(f, "UPPER_ASSESS_SCORE_" + zone_for_var,  f_assess_score.toFixed(3),  "Femur Assessment Score " + zone,  "String");

	// Add to overall score stored on oGlblData and increment number of points so we can average

	oGlblData.upper_score += f_assess_score;

	oGlblData.upper_num++;

	// Get the column number for this point and store it if it's greater or less than the current max/min
	// <zone> = U_<num>.  So get the string from the second character on.

	var col = parseInt(zone.substr(2));

	if(!isNaN(col))
	{
		if(col < 0) oGlblData.upper_min_col = Math.min(oGlblData.upper_min_col, col);
		else        oGlblData.upper_max_col = Math.max(oGlblData.upper_max_col, col);
	}
}



function do_lower_legform_calc(f, zone)
{
	// Calculates the scores for the <zone> and writes relevant values
	// into the Reporter variable file <f>.


	var res_file;

	for(var i=0; i<data.length; i++)
	{
		if(data[i].zone == zone) res_file = data[i].res_file;
	}

	DialogueInput("/MODEL READ", res_file);

	// Make sure any units set in T/HIS (e.g. via preferences) are unset

	unset_this_units(1);
	
	// check if the model time units and input time units are consistent
	// If the units are not defined/valid then we cannot go any further.  

	if(!check_unit_values())
	{
	write_unit_vars(f_vars, false);
	Exit();
	}

	// Write the unit data to the variables file

	write_unit_vars(f_vars, true);

	// Calculate constants now we have unit data and store on <oGlblData> object

	calculate_unit_constants();

	var total_elongation_score = 999.0;
	var total_mom_score = 999.0;

	// Zone name for reporter variables (replace '-' with 'MINUS_'

	var zone_for_var = zone.replace('-', 'MINUS_');

	// Cruciate ligaments elongation - MCL, ACL and PCL

	for(var pass = 0; pass < 3; pass++)
	{  
		var spring, acro, good, adqt, mgnl, weak;

		if(pass == 0)
		{
			spring = oGlblData.spring_mcl_id;
			acro = "MCL";
			good = MCL_ELONGATION_GOOD;
			adqt = MCL_ELONGATION_ADEQUATE;
			mgnl = MCL_ELONGATION_MARGINAL;
			weak = MCL_ELONGATION_WEAK;
		}
		else if(pass == 1)
		{
			spring = oGlblData.spring_acl_id;
			acro = "ACL";
			good = ACL_ELONGATION_GOOD;
			adqt = ACL_ELONGATION_ADEQUATE;
			mgnl = ACL_ELONGATION_MARGINAL;
			weak = ACL_ELONGATION_WEAK;
		}
		else if(pass == 2)
		{
			spring = oGlblData.spring_pcl_id;
			acro = "PCL";
			good = PCL_ELONGATION_GOOD;
			adqt = PCL_ELONGATION_ADEQUATE;
			mgnl = PCL_ELONGATION_MARGINAL;
			weak = PCL_ELONGATION_WEAK;
		}

		var disp       = 0.0;
		var disp_score = 0.0;

		var output_data = {};

		output_data.disp = new OutputData(zone + " " + acro + " Displacement", images_dir + "/" + zone + "_" + acro + "_Displacement");

		if (spring != undefined)
		{
			var c_disp = read_data("SPRING TRANS", 0, spring, "ET");

			// Check that the curve read in - i.e. the spring id and component are valid
			// Create a blank image to let the user know.

			if(!c_disp)
			{
				write_blank_images(output_data, "NO DATA FOR SPRING " + spring);
			}
			else
			{
				var c_disp      = Operate.Dix(c_disp, oGlblData.time_factor);     // Convert to seconds
				var c_disp_c180 = Operate.C180(c_disp, REG_DT);                   // C180 filter
				var c_disp      = Operate.Div(c_disp_c180, oGlblData.mm_factor);  // Convert to mm

				remove_all_curves_and_datums();

				// Convert back from seconds to model time

				c_disp = Operate.Mux(c_disp, oGlblData.time_factor);

				// Set line style and label graph

				set_labels(c_disp, acro + " Displacement", "Time (" + oGlblData.unit_time + ")", "Displacement (mm)");
				set_line_style(c_disp, Colour.BLACK);

				// Draw acceleration limit datums

				draw_constant_datums(good, adqt, mgnl, weak);

				// Create image and curve files       

				write_image(output_data.disp.title, output_data.disp.fname, c_disp, weak);

				output_data.disp.curveList.push(c_disp.id);
				write_curve("cur", output_data.disp.curveList, output_data.disp.fname);
				write_curve("csv", output_data.disp.curveList, output_data.disp.fname);

				// Get value and score

				DialogueInput("/AU");
				var results = get_constant_limit_results(c_disp, good, weak, LOW_LO_SCORE, LOW_HI_SCORE);

				disp_score = results[0];
				disp       = results[1];
			}
		}
		else
		{
			// No Spring defined-variables should be set to blank by the first script in this template.
			// Create a blank image to let the user know

			write_blank_images(output_data, "NO NODE ID DEFINED FOR");
		}

		// Values and scores

		write_variable(f, "LOWER_TIBIA_" + acro + "_ELONGATION_" + zone_for_var, disp.toFixed(2), "Tibia " + acro + " Elongation " + zone, "String");

		// Score is PASS or FAIL for MCL/ACL

		if(pass == 1 || pass == 2)
		{
			if(disp_score > 0.0)
				write_variable(f, "LOWER_TIBIA_" + acro + "_ELONGATION_SCORE_" + zone_for_var, "PASS", "Tibia " + acro + " Elongation Score " + zone, "String");
			else
				write_variable(f, "LOWER_TIBIA_" + acro + "_ELONGATION_SCORE_" + zone_for_var, "FAIL", "Tibia " + acro + " Elongation Score " + zone, "String");
		}
		else
		{
			write_variable(f, "LOWER_TIBIA_" + acro + "_ELONGATION_SCORE_" + zone_for_var, disp_score.toFixed(3), "Tibia " + acro + " Elongation Score " + zone, "String");
		}

		// Running total for overall score

		total_elongation_score = Math.min(total_elongation_score, disp_score);
	}


	// Bending moments - upper, mid-upper, mid-lower and lower

	for(var pass = 0; pass < 4; pass++)
	{  
		var xsec, acro, good, adqt, mgnl, weak;

		if(pass == 0) { xsec = oGlblData.xsection_tibia_upper_id;      acro = "Upper";     }
		else if(pass == 1) { xsec = oGlblData.xsection_tibia_mid_upper_id;  acro = "Mid_Upper"; }
		else if(pass == 2) { xsec = oGlblData.xsection_tibia_mid_lower_id;  acro = "Mid_Lower"; }
		else if(pass == 3) { xsec = oGlblData.xsection_tibia_lower_id;      acro = "Lower";     }

		var mom       = 0.0;
		var mom_score = 0.0;

		var output_data = {};

		output_data.mom = new OutputData(zone + " " + acro + " Tibia Moment", images_dir + "/" + zone + "_" + acro + "_Moment");

		if (xsec != undefined)
		{
			var c_mom = read_data("SECTION", 0, xsec, "MX");

			// Check that the curve read in - i.e. the xsec id and component are valid
			// Create a blank image to let the user know.

			if(!c_mom)
			{
				write_blank_images(output_data, "NO DATA FOR XSEC " + xsec);
			}
			else
			{
				c_mom = Operate.Dix(c_mom, oGlblData.time_factor);  // Convert to seconds
				c_mom = Operate.Div(c_mom, oGlblData.nm_factor);    // Convert to Nm
				c_mom = Operate.C180(c_mom, REG_DT);                // C180 filter

				c_mom = Operate.Mul(c_mom, -1);                     // Multiply by -1

				remove_all_curves_and_datums();

				// Convert back from seconds to model time

				c_mom = Operate.Mux(c_mom, oGlblData.time_factor);

				// Set line style and label graph

				set_labels(c_mom, acro + " Tibia Moment", "Time (" + oGlblData.unit_time + ")", "Moment (Nm)");
				set_line_style(c_mom, Colour.BLACK);

				// Draw datums

				draw_constant_datums(TIBIA_BENDING_MOMENT_GOOD, TIBIA_BENDING_MOMENT_ADEQUATE, TIBIA_BENDING_MOMENT_MARGINAL, TIBIA_BENDING_MOMENT_WEAK);

				// Create image and curve files       

				write_image(output_data.mom.title, output_data.mom.fname, c_mom, TIBIA_BENDING_MOMENT_WEAK);

				output_data.mom.curveList.push(c_mom.id);
				write_curve("cur", output_data.mom.curveList, output_data.mom.fname);
				write_curve("csv", output_data.mom.curveList, output_data.mom.fname);

				// Get value and score

				DialogueInput("/AU");
				var results = get_constant_limit_results(c_mom, TIBIA_BENDING_MOMENT_GOOD, TIBIA_BENDING_MOMENT_WEAK, LOW_LO_SCORE, LOW_HI_SCORE);

				mom_score = results[0];
				mom       = results[1];
			}
		}
		else
		{
			// No Xsec defined-variables should be set to blank by the first script in this template.
			// Create a blank image to let the user know

			write_blank_images(output_data, "NO XSEC ID DEFINED FOR");
		}

		// Values and scores

		write_variable(f, "LOWER_TIBIA_" + acro.toUpperCase() + "_MOMENT_" + zone_for_var,        mom.toFixed(2),       "Tibia " + acro + " Moment " + zone,       "String");
		write_variable(f, "LOWER_TIBIA_" + acro.toUpperCase() + "_MOMENT_SCORE_" + zone_for_var,  mom_score.toFixed(3), "Tibia " + acro + " Moment Score " + zone, "String");

		// Running total for overall score

		total_mom_score = Math.min(total_mom_score, mom_score);
	}

	// Delete model

	DialogueInput("/MODEL DELETE ALL");

	// Lower Leg Assessment SCORE - sum of moment score and elongation score

	var l_assess_score = total_mom_score + total_elongation_score;

	write_variable(f, "LOWER_ASSESS_SCORE_" + zone_for_var,  l_assess_score.toFixed(3), "Lower Legform Assessment Score " + zone,  "String");

	// Add to overall score stored on oGlblData and increment number of points so we can average

	oGlblData.lower_score += l_assess_score;

	oGlblData.lower_num++;

	// Get the column number for this point and store it if it's greater or less than the current max/min
	// <zone> = L_<num>.  So get the string from the second character on.

	var col = parseInt(zone.substr(2));

	if(!isNaN(col))
	{
		if(col < 0) oGlblData.lower_min_col = Math.min(oGlblData.lower_min_col, col);
		else        oGlblData.lower_max_col = Math.max(oGlblData.lower_max_col, col);
	}
}

// zone_name should follow the format U/L_<integer>
// zone_index = 0 for lower and 1 for upper
function check_zone_name(zone_name, zone_index)
{
	var list = zone_name.split("_");

	if (zone_index==0 && zone_name[0].toUpperCase() != 'L')
	{
		if (batch_mode == "false")
		{
			var ans = Window.Warning("Warning", "Lower legform gridpoint should start with L instead " + zone_name 
			+ " starts with " + zone_name[0].toUpperCase() + ". Do you want to correct it else this grid point will be skipped.", 
			Window.YES|Window.NO);
			
			if (ans == Window.YES)
				zone_name='L_'+list[1];
			else
				return false;
		}
		else
		{
			WarningMessage("Warning: Lower legform gridpoint should start with L instead " + zone_name 
			+ " starts with " + zone_name[0].toUpperCase() + ". This grid point will be skipped.");
			return false;
		}
	}
	else if (zone_index==1 && zone_name[0].toUpperCase() != 'U')
	{
		if (batch_mode == "false")
		{
			var ans = Window.Warning("Warning", "Upper legform gridpoint should start with U instead " + zone_name 
			+ " starts with " + zone_name[0].toUpperCase() + ". Do you want to correct it else this grid point will be skipped.", 
			Window.YES|Window.NO);
			
			if (ans == Window.YES)
				zone_name='U_'+list[1];
			else
				return false;
		}
		else
		{
			WarningMessage("Warning: Upper legform gridpoint should start with U instead " + zone_name 
			+ " starts with " + zone_name[0].toUpperCase() + ". This grid point will be skipped.");
			return false;
		}
	}
			
	if (isNaN(parseInt(list[1])))
	{
		if (batch_mode == "false")
		{
			if (zone_index == 0)
				Window.Warning("Warning", zone_name + " does not follow the format L_<integer>. This grid point will be skipped");
			else if (zone_index == 1)
				Window.Warning("Warning", zone_name + " does not follow the format U_<integer>. This grid point will be skipped");
		}
		else 
		{
			if (zone_index == 0)
				WarningMessage("Warning: "+ zone_name + " does not follow the format L_<integer>. This grid point will be skipped");
			else if (zone_index == 1)
				WarningMessage("Warning: "+ zone_name + " does not follow the format U_<integer>. This grid point will be skipped");
		}
		return false;
	}
	
	zone = zone_name;
	return true;
}


