// Ask user if they want to save the generated report, in what format and where
// Don't bother if in batch mode. The user can specify how to save it on the command line

if(Batch()) Exit();

var options = [
               {text:"Reporter report (*.orr)",type:"checkbox",value:"",selected:true},
               {text:"PDF (*.pdf)",type:"checkbox",value:"",selected:false},
               {text:"HTML (*.html)",type:"checkbox",value:"",selected:false},
               {text:"Powerpoint (*.pptx)",type:"checkbox",value:"",selected:false},
               {text:"",type:"label",value:""}
              ];

var iret = Window.GetOptions("Save Report", "Select how you would like to save the report and press OK.\nPress Cancel if you don't want to save it.\n", options);


// Pressed OK and at least one option selected, so get a filename
if(iret && (options[0].selected ||
            options[1].selected || 
            options[2].selected ||
            options[3].selected))
{
  var template = Template.GetCurrent();
  var dir = template.GetVariableValue("DEFAULT_DIR");

  Window.Message("Select file", "Please select a filename to save the report.");
  var file = Window.GetFile("*", true, dir);

// User pressed cancel

  if(!file) Exit();
  
// Got a filename. First strip off the extension if there is one and then
// save according to options selected by user.

if (file.indexOf("\\") > -1)
{
    var name_only = file.substr(file.lastIndexOf("\\") + 1);
}
else
{
    var name_only = file.substr(file.lastIndexOf("/") + 1);
}
if (name_only.lastIndexOf('.') != -1)
{
    file = file.substr(0, file.lastIndexOf('.'));
}
  
  template.view = Reporter.VIEW_PRESENTATION;

// Make sure images have generated

  var pages = template.GetAllPages();

  for(var i=0; i<pages.length; i++)
  {
    var items = pages[i].GetAllItems();
    
    for(var j=0; j<items.length; j++)
    {
      if(items[j].type == Item.IMAGE_FILE)
      {
        items[j].Generate();
      }
    }
  }

  if(options[0].selected) template.SaveAs(file + ".orr");
  if(options[1].selected) template.Pdf(file + ".pdf");
  if(options[2].selected) template.Html(file + ".html");
  if(options[3].selected) template.Ppt(file + ".pptx");
  
}