
// Make some objects inactive so that they don't get generated when we generate the whole template

var template = Template.GetCurrent();

// Check if the template is launched in batch mode or not and create BATCH_MODE variable
if (Batch())
    var batch_mode = new Variable(template, "BATCH_MODE", "true if Template is launched in batch mode else it will be false", "true", "General", true);
else
    var batch_mode = new Variable(template, "BATCH_MODE", "true if Template is launched in batch mode else it will be false", "false", "General", true);

var page1 = template.GetPage(0);
//var page2 = template.GetPage(1);

var iOnLoad          = Item.GetFromName(page1, "Script to run on loading template");    // This script
var iPrimer          = Item.GetFromName(page1, "Primer get model information");         // Primer object
var iPrimer_Zones    = Item.GetFromName(page1, "Primer_Zones");                         // Create zones.ptf
var iGlobal          = Item.GetFromName(page1, "global functions");                     // Global functions used in drawing fonts etc.
var iFindLsDynaFiles = Item.GetFromName(page1, "find_lsdyna_files");                    // Find LS-DYNA files function

iFindLsDynaFiles.Generate();

iOnLoad.active = false;
iPrimer.active = false;
iPrimer_Zones.active = false;
iGlobal.active = false;
iFindLsDynaFiles.active = false;

// Reporter temp directory

var reporter_temp = template.GetVariableValue("REPORTER_TEMP");

// CSV file name in %REPORTER_TEMP% directory

var reporter_temp_csv_fname = reporter_temp + "/" + template.GetVariableValue("CSV_DEFAULT_NAME");

// No Data file name

var no_data_fname = reporter_temp + "/" + template.GetVariableValue("NO_DATA_FILE");

// Header and Footer that encloses post *END data

var post_end_header = template.GetVariableValue("POST_END_HEADER");
var post_end_footer = template.GetVariableValue("POST_END_FOOTER");

// Reset %CSV_MODEL_INFO_FILE%

reset_csv_variable();

// If we are running in batch mode and the variable TEMPLATE_ARGS has been defined then 
// we will need to read the file and it's contents to define the things that the template needs.

/* START DOC
<template name="EuroNCAP_Far_Side_2020">
  <batch_example>
    <description><p>The template can be run in batch with the following command:</p>
                 <ul>
                 <li><i>reporter.exe</i> -batch -file=<i>template_name</i> -varTEMPLATE_ARGS=<i>args_filename</i></li>
                 </ul>
                 <p>Where <i>args_filename</i> is a file containing arguments to pass to the template in comma
                    separated 'arg_name','arg_value' pairs, e.g.
                 </p>
                 <ul>
                 <li>KEYWORD_FILE,C:\my_model.key</li>
                 <li>CSV_FILE,C:\data.csv</li>
                 <li>etc...</li>
                 </ul>
    </description>
  </batch_example>
  <batch_arg>
    <name>KEYWORD_FILE</name>
    <description>Model keyword filename.</description>
  </batch_arg>
  <batch_arg>
    <name>CSV_FILE (optional)</name>
    <description>Filename of the CSV file containing the extra data (entity IDs, etc). If this is not specified
    the data needs to be specified in the keyword file as post *END data.</description>
  </batch_arg>
  <batch_arg>
    <name>RESULTS_DIR (optional)</name>
    <description>Directory to look for results. If this is not specified the template will look for results in
    the same directory as the keyword file.</description>
  </batch_arg>
  <batch_arg>
    <name>IMAGES_DIR (optional)</name>
    <description>Directory to write images/curves to. If this is not specified the template will write images/curves in
    the same directory as the keyword file.</description>
  </batch_arg>
</template>
* END DOC */

var tpl_args = new Array();

var KWD_FILE = 0;
var CSV_FILE = 1;
var RES_DIR  = 2;
var IMG_DIR  = 3;
var EXC_FILE = 4;

add_tpl_arg(KWD_FILE, "KEYWORD_FILE",   false);
add_tpl_arg(CSV_FILE, "CSV_FILE",       true);
add_tpl_arg(RES_DIR,  "RESULTS_DIR",    true);
add_tpl_arg(IMG_DIR,  "IMAGES_DIR",     true);
add_tpl_arg(EXC_FILE, "SIDE_EXCURSION_FILE", false);

if(Batch())
{
    if(!get_template_args()) finish_script(false, "Report will not be generated.");
}


// Now ask questions to get the information needed for the template

// Get *.k* file and set %DEFAULT_DIR% and %DEFAULT_JOB%
  
if (!get_keyword_file()) finish_script(false, "Keyword file not selected. Report will not be generated.");


// Check if this contains post end data and then ask if they want to use it

var post_end_data = new Array();

if(check_for_post_end_data(post_end_data))
{
// Keyword file contains post end data (now stored in <post_end_data>.
       
    var answer = post_end_data_message();

    if(answer == Window.YES)
    {
// Write data to a csv file in REPORTER_TEMP directory then set %CSV_MODEL_INFO_FILE% to point to it
        
        write_csv(post_end_data);
    }
    else
    {
// Ask if they have a csv file with information instead

    var answer = ask_for_csv_data_message();
    
    if(answer == Window.YES)
    {
// Get csv file set %CSV_MODEL_INFO_FILE%
  
        if(!get_csv_file()) finish_script(false, "csv file not selected. Report will not be generated.");  
    }
    else
    {
// No csv file. Start Primer to get the info.

      start_primer();
    }
  }
}
else
{
// Tell them no post end data found with file, ask if they have a csv file with information

  var answer = no_post_end_data_message();
    
  if(answer == Window.YES)
  {
// Get csv file set %CSV_MODEL_INFO_FILE%
  
    if(!get_csv_file()) finish_script(false, "csv file not selected. Report will not be generated.");  
  }
  else
  {
// No csv file. Start Primer to get the info.

    start_primer();
  }
}

// Get excursion distance from corresponding side impact (MDB or Pole)

if(!get_excursion_file()) finish_script(false, "excursion file not selected. Report will not be generated.");

// Get the results directory

if(!get_results_directory()) finish_script(false, "Results directory not selected. Report will not be generated.");

if(!get_results_file()) finish_script(false, "Unable to find results file(s). Report will not be generated.");

// Get a directory to write images/curves in

if(!get_images_directory()) finish_script(false, "Images directory not selected. Report will not be generated.");

// This block of the code throws a message to the user informing that Primer would be launched 
// to create the zone.ptf
// We need to suppress this message if run in batch mode
// Then we generate the primer object which creates the zone.ptf

// The following line can be uncommented to have a pop-up message before Primer is launched
//if (!Batch())
//    Window.Information(" ", "PRIMER will be launched generate zones.ptf", Window.OK);

iPrimer_Zones.active = true;
iPrimer_Zones.Generate();
iPrimer_Zones.active = false;

// The following line can be uncommented to have a pop-up message after the completion of zones.ptf creation
//if (!Batch())
//    Window.Information(" ", "zones.ptf created successfully", Window.OK );

// Get here and we should have all the required information, so generate the template.

finish_script(true, "");

Exit();


function check_for_post_end_data(post_end_data)
{
// Look in the selected keyword file for any post *END data stored
// as *PRIMER_USER_DATA in the form:
//
// *PRIMER_USER_DATA
// <possible other data>
//         .
//         .
// <possible other data>
// <post_end_header>                      -+
// VARIABLE_NAME,VARIABLE_VALUE            |
// VARIABLE_NAME,VARIABLE_VALUE            | 
//         .                               | -> We want this data
//         .                               |
//         .                               |
// <post_end_footer>                      -+
// <possible other data>
//         .
//         .
// <possible other data>
//
// Returns <true> if it exists, returning it in the array <post_end_data>
// Returns <false> otherwise
  
// Get selected keyword name

  var variables = Variable.GetAll(template);
  
  var default_dir, default_job;
  
  for(var i=0; i<variables.length; i++)
  {
    if(variables[i].name == "DEFAULT_DIR") default_dir = variables[i].value;
    if(variables[i].name == "DEFAULT_JOB") default_job = variables[i].value;
  }  

// Try to open it

  var fname = default_dir + "/" + default_job;
  
  var fkey = new File(fname, File.READ);

// Look for <post_end_header> and read data up to <post_end_footer>
  
  var line;
  var store = false;
  
  while(  (line = fkey.ReadLine()) != File.EOF)
  { 
    if( line == post_end_footer) store = false;
    
    if(store) post_end_data.push(line);
  
    if( line == post_end_header) store = true;
  }

  if(fkey) fkey.Close();

// If it exists return true

  if(post_end_data.length > 0) return true;
  else                         return false;
}


function get_keyword_file()
{
// Gets the keyword file and sets %DEFAULT_DIR% and %DEFAULT_JOB%
  
    var file;

// If in batch, it should have been defined in an arguments file
// If interactive, then ask the user

    if(Batch())
    {
        file = tpl_args[KWD_FILE].value;
    }
    else
    {
        var ans = Window.Message("Select *.k* file", "Please select the Ansys LS-DYNA keyword file of the job you want to post-process.", Window.OK|Window.CANCEL);
        if (ans == Window.OK)
            file = Window.GetFile("*.k*");
    }
  
// User pressed cancel

    if(!file) return false;
  
// Got a file, so set %DEFAULT_DIR% and %DEFAULT_JOB%

    var dirs;

    dirs = file.split("/");
    if(dirs.length == 1) dirs = file.split("\\");   // Windows path
  
// Assemble %DEFAULT_DIR% and get %DEFAULT_JOB%

    var default_dir = dirs[0] + "/";
    for(var i=1; i<(dirs.length-1); i++) default_dir += dirs[i] + "/";

    var default_job = dirs[dirs.length-1];
 
// Assign to Reporter variables

    var variables = Variable.GetAll(template);

    for(var i=0; i<variables.length; i++)
    {
        if(variables[i].name == "DEFAULT_DIR") variables[i].value = default_dir;
        if(variables[i].name == "DEFAULT_JOB") variables[i].value = default_job;
    }

    return true;
}



function get_csv_file()
{
// Gets a csv file and sets %CSV_MODEL_INFO_FILE%

  var file;

// If in batch, it should have been defined in an arguments file
// If interactive, then ask the user

  if(Batch())
  {
    file = tpl_args[CSV_FILE].value;
  }
  else
  {
// Start file selector in %DEFAULT_DIR%

    var default_dir = template.GetVariableValue("DEFAULT_DIR");

    Window.Message("Select *.csv file", "Please select the csv file with the model information.");
    file = Window.GetFile("*.csv", false, default_dir);
  }
  
// User pressed cancel

  if(!file) return false;
  
// Assign to Reporter variable

  var variables = Variable.GetAll(template);

  for(var i=0; i<variables.length; i++)
  {
    if(variables[i].name == "CSV_MODEL_INFO_FILE") variables[i].value = file;
  }

  return true;
}

function get_excursion_file()
{
// Gets a excursion file and sets %SIDE_EXCURSION_FILE%

  var file;

// If in batch, it should have been defined in an arguments file
// If interactive, then ask the user

  if(Batch())
  {
    file = tpl_args[EXC_FILE].value;
  }
  else
  {
// Start file selector in %DEFAULT_DIR%

    var default_dir = template.GetVariableValue("DEFAULT_DIR");

    var ans = Window.Message("Select *.csv file", "Please select the csv file with the side excursion information.",  Window.OK | Window.CANCEL);
    if (ans == Window.OK){
        file = Window.GetFile("*.csv", false, default_dir);
    }
  }
  
// User pressed cancel

  if(!file) return false;
  
// Assign to Reporter variable

  var variables = Variable.GetAll(template);

  for(var i=0; i<variables.length; i++)
  {
    if(variables[i].name == "SIDE_EXCURSION_FILE") variables[i].value = file;
  }

  return true;
}


function get_results_directory()
{
// Gets a Results directory and sets %RESULTS_DIR%
  
  var default_dir = template.GetVariableValue("DEFAULT_DIR");
  var dir;

// If in batch, it may have been defined in an arguments file, otherwise just use DEFAULT_DIR
// If interactive, then ask the user

  if(Batch())
  {
    if(tpl_args[RES_DIR].defined) dir = tpl_args[RES_DIR].value;
    else                          dir = default_dir;
  }
  else
  {
// Start directory selector in %DEFAULT_DIR%

    var ans = Window.Message("Select results directory.", "Please select the directory containing the analysis results.", Window.OK | Window.CANCEL);
    if (ans == Window.OK)
        dir = Window.GetDirectory(default_dir);
    }
  
// User pressed cancel

  if(!dir) return false;
  
// Assign to Reporter variable

  var variables = Variable.GetAll(template);

  for(var i=0; i<variables.length; i++)
  {
    if(variables[i].name == "RESULTS_DIR") variables[i].value = dir;
  }

  return true;
}

function get_results_file()
{
// Gets results filename for D3PLOT item(s)

    var results_dir = template.GetVariableValue("RESULTS_DIR");
    var default_job = template.GetVariableValue("DEFAULT_JOB");
        
// Determine results filename
    let results_file = find_lsdyna_files(results_dir, default_job, "PTF");
    if (results_file == null) return false;
            
  
// Assign to Reporter variable

    var variables = Variable.GetAll(template);

    for(var i=0; i<variables.length; i++)
    {
        if(variables[i].name == "RESULTS_FILE") variables[i].value = results_file;
    }

    return true;
}


function get_images_directory()
{
// Gets an Images directory and sets %IMAGES_DIR%

  var default_dir = template.GetVariableValue("DEFAULT_DIR");
  var dir;
  
  if(Batch())
  {
    if(tpl_args[IMG_DIR].defined) dir = tpl_args[IMG_DIR].value;
    else                          dir = default_dir;
    
// It's possible that a directory could be defined that doesn't exist
// If so, try to make it and if that fails, just set it to default_dir
  
    var dir_exists = false;
    
    if(File.IsDirectory(dir))
    {
      dir_exists = true;
    }
    else
    {
      var dirs = GetDirs(dir);
      var new_dir = "";
      for(var i=0; i<dirs.length; i++)
      {
        new_dir += dirs[i] + "/";

        if(File.IsDirectory(new_dir)) continue;  // Already exists

        dir_exists = File.Mkdir(new_dir);
        if(!dir_exists) break;  // Didn't create the directory for some reason
      }
    }

// If it still doesn't exist just set it to default_dir

    if(!dir_exists) dir = default_dir;
  }
  else
  {
// Start directory selector in %DEFAULT_DIR%

        ans = Window.Message("Select images directory.", "Please select a directory to write images/curves to.", Window.OK | Window.CANCEL);
        if (ans == Window.OK )
            dir = Window.GetDirectory(default_dir);
    }
  
// User pressed cancel

  if(!dir) return false;
  
// Assign to Reporter variable

  var variables = Variable.GetAll(template);

  for(var i=0; i<variables.length; i++)
  {
    if(variables[i].name == "IMAGES_DIR") variables[i].value = dir;
  }

  return true;
}


function write_csv(data)
{
// Writes <data> to csv file %REPORTER_TEMP%/%CSV_DEFAULT_NAME%
// and sets %CSV_MODEL_INFO_FILE% to point to it

  var fname = reporter_temp_csv_fname;

  var f = new File(fname, File.WRITE);

  if(File.Exists(fname))
  {
    for(var i=0; i<data.length; i++)
    {
      f.Write(data[i] + "\n");
    }
  
    f.Close();
    
    var variables = Variable.GetAll(template);

    for(var i=0; i<variables.length; i++)
    {
      if(variables[i].name == "CSV_MODEL_INFO_FILE") variables[i].value = fname;
    }
  }
  else
  {
    Window.Error("", "Could not write csv file.");
  }
}


function reset_csv_variable()
{
// Resets %CSV_MODEL_INFO_FILE% variable

  var variables = Variable.GetAll(template);

  for(var i=0; i<variables.length; i++)
  {
    if(variables[i].name == "CSV_MODEL_INFO_FILE") variables[i].value = "";
  }
}


function start_primer()
{
// Generates the Primer object so the user can select the required information
    
// If we're in batch mode, then the keyword file specified in the TEMPLATE_ARGS file doesn't
// contain post *END data and a csv file wasn't specified either. Don't start Primer, just let
// the user know why the template won't generate.
    
    if(Batch()) finish_script(false, "Keyword file doesn't contain any post *END data and you have not specified a csv file either.\n\n"
                                   + "Report will not be generated.");
    
//  Not in batch so let the user know that Primer's starting
    
    start_primer_message();

// On return if the file %NO_DATA_FILE% exists then
// the user must have pressed cancel, so tell the user and don't generate

    if(File.Exists(no_data_fname))
    {
      File.Delete(no_data_fname);
      finish_script(false, "You did not select all the required data. Report will not be generated.");
    }
    else
    {
// OK => set the %CSV_MODEL_INFO_FILE% variable to point to %REPORTER_TEMP%/%CSV_DEFAULT_NAME%

      var variables = Variable.GetAll(template);

      for(var i=0; i<variables.length; i++)
      {
        if(variables[i].name == "CSV_MODEL_INFO_FILE") variables[i].value = reporter_temp_csv_fname;
      }
    }
}


function post_end_data_message()
{
// Tells the user the keyword file has post end data in the selected keyword file
// and asks if they want to use it.
//
// Returns Window.YES or Window.NO.
  
// If in batch mode and a csv file wasn't specified in the arguments file then return Window.YES
// Otherwise return Window.NO
//
// If in interactive mode ask the user if they want to use it.
  
    var answer;

    if(Batch())
    {
        if(!tpl_args[CSV_FILE].defined) answer = Window.YES;
        else                            answer = Window.NO;
    }
    else 
    {
        var msg;

        msg =   "In order to extract the required data the template requires information such as Node IDs, Beam IDs, the model unit system, etc.\n\n"
          + "This information can be stored either as post *END data in the master keyword file or in a .csv file.  Your keyword file already "
          + "has this information stored as post *END data.\n\n"
          + "Do you want to use the post *END data?";
          
        answer = Window.Message("Post *END data", msg, Window.YES | Window.NO);
    }

    return answer;
}


function no_post_end_data_message()
{
// Tells the user there is not post end data in the selected keyword file
// and asks if they have a csv file instead.
//
// Returns Window.YES or Window.NO.

// If in batch mode and a csv file wasn't specified in the arguments file then return Window.NO
// Otherwise return Window.YES
//
// If in interactive mode ask the user if they want to use it.
  
    var answer;

    if(Batch())
    {
        if(!tpl_args[CSV_FILE].defined) answer = Window.NO;
        else                            answer = Window.YES;
    }
    else 
    {
        var msg;

        msg =   "In order to extract the required data the template requires information such as Node IDs, Beam IDs, the model unit system, etc.\n\n"
          + "This information can be stored either as post *END data in the master keyword file or in a .csv file.  Your keyword file does "
          + "not appear to have it stored as post *END data.\n\n"
          + "Do you have a .csv file with this information?";
          
        answer = Window.Message("csv file", msg, Window.YES | Window.NO);
    }

    return answer;
}


function ask_for_csv_data_message()
{
// Asks the user if they want to select a csv file

// If in batch mode and a csv file wasn't specified in the arguments file then return Window.NO
// Otherwise return Window.YES
//
// If in interactive mode ask the user if they want to select one.
  
  var answer;
  
  if(Batch())
  {
    if(!tpl_args[CSV_FILE].defined) answer = Window.NO;
    else                            answer = Window.YES;
  }
  else 
  {
    var msg = "Do you have a .csv file with the information?"
          
    answer = Window.Message("csv file", msg, Window.YES | Window.NO);
  }
  
  return answer;
}

function start_primer_message()
{
// Tells the user that because they haven't got a csv file and there's no post *END data
// Primer will be started to select the information required.

    var msg = "Primer will be started so you can select the required information."
        
    ans = Window.Message("Starting Primer...", msg, Window.OK|Window.CANCEL);
    
// Generate Primer object. This will run a script that reads in the model and then gets the user
// to select the required information.  This will then be saved either as post *END data or in
// a csv file.  In either case a csv file should get written to temp.csv
 
    if (ans == Window.OK)
    {
        iPrimer.active = true;
        iPrimer.Generate();
        iPrimer.active = false;
    }
    else 
    {
        finish_script(false, "Required information not provided. Report will not be generated.");
    }
}


function finish_script(can_generate, msg)
{
// Common function for finishing the script

// Generate template if we have all the required information
  
  if(can_generate)
  {
    template.Generate();
  }
  else
  {
    if(Batch()) LogError(msg);
    else        Window.Message("", msg);
  }
  
// Reactivate buttons on modifiers page

//  reactivate_modifier_buttons();
  
// Exit from script
  
  Exit();
}


function reactivate_modifier_buttons()
{
// Make the buttons on the Modifiers page active again so they can be used

  iSetModifier.active = true;
}


function add_tpl_arg(index, name, optional)
{
// Adds an argument object to the <tpl_args> array 

  tpl_args[index]          = new Object();
  tpl_args[index].name     = name;
  tpl_args[index].value    = "";
  tpl_args[index].defined  = false;
  tpl_args[index].optional = optional;
}


function get_template_args()
{
// Get arguments in the file specified by the variable <TEMPLATE_ARGS>
// Returns true if everything defined correctly, false if not.

// Check that <TEMPLATE_ARGS> exists.
  
  var args_fname = template.GetVariableValue("TEMPLATE_ARGS");
  
  if(args_fname == null)
  {
    var msg = "TEMPLATE_ARGS variable not defined.\n\n"
            + "To run the template in batch you need to specify a file with the data required to "
            + "run the template using the -varTEMPLATE_ARGS='fname' option.\n\n"
            + "The file should contain the following:\n\n"
    
    LogError(msg);
    
    for(var i=0; i<tpl_args.length; i++)
    {
      msg = tpl_args[i].name + ",'value'   "
      
      if(tpl_args[i].optional) msg += "[optional]";
      
      LogError(msg);
    }
    
    return false;
  }

// Check that the file exists
  
  if(!File.Exists(args_fname))
  {
    var msg = "TEMPLATE_ARGS filename '" + args_fname + "' does not exist.\n\n"
            + "Unable to continue.";
    
    LogError(msg);
    
    return false;
  }
  
// Check that it is a file
  
  if(!File.IsFile(args_fname))
  {
    var msg = "TEMPLATE_ARGS filename '" + args_fname + "' is not a file.\n\n"
            + "Unable to continue.";
    
    LogError(msg);
    
    return false;
  }  

// Open the file
  
  f_args = new File(args_fname, File.READ);
  
// Try to read the arguments - looking for comma separated <arg_name>,<arg_value> pairs

  var line;
  
  while( (line = f_args.ReadLongLine() ) != File.EOF)
  {
    var list = line.split(",");
    
    var name = list[0].toUpperCase();

    if(list[1] != undefined)
    {
      for(var i=0; i<tpl_args.length; i++)
      {
        if(tpl_args[i].name == name)
        {
          tpl_args[i].value   = list[1];
          tpl_args[i].defined = true;
        }
      }
    }
  }

// Close the file

  f_args.Close();
  
// Check that we got all the compulsory arguments
  
  var did_not_get = new Array();
  
  for(var i=0; i<tpl_args.length; i++)
  {
    if(!tpl_args[i].optional && !tpl_args[i].defined)
    {
      did_not_get.push(tpl_args[i].name);
    }
  }

  if(did_not_get.length > 0)
  {
    var msg = "The following argument(s) were missing from " + args_fname + ":\n\n";
    
    for(var i=0; i<did_not_get.length; i++)
    {
      msg += did_not_get[i] + "\n";
    }
    
    LogError(msg);
    
    return false;
  }

// Got the all the required arguments so return true

  return true;

}


function GetDirs(strFilepath)
{
// Extracts the directories from a file path

  var strDir = "";

// Return blank string if path not defined
  if (strFilepath == undefined)
  {
    Warning("<strFilepath> undefined in <GetDirs>");
    return strDir;
  }
  
// Get the folders from strFilepath - try Windows first "\" or "/"
  var strFolders = strFilepath.split(/\\|\//);

// Try Unix "/" if that didn't split the path 
  if(strFolders[0] == strFolders) strFolders = strFilepath.split("/");

  return strFolders;
}

