//reporter_Far_Side_Calculate_Score
var template = Template.GetCurrent();


//HEAD

var head_score = parseFloat(template.GetVariableValue("HEAD_FINAL_SCORE"));

// NECK

var neck_upper_score = parseFloat(template.GetVariableValue("NECK_UPPER_SCORE"));
var neck_lower_score = parseFloat(template.GetVariableValue("NECK_LOWER_SCORE"));

var neck_score = Math.min(neck_upper_score,neck_lower_score);
var neck_score_variable = new Variable(template, "NECK_FINAL_SCORE", "Neck score (lower of upper and lower)", neck_score, "General", false, false);

// lower neck extension is only monitored in 2020-2022 so set value to pass/fail
SetPassFailLowerNeckExtension(Variable.GetFromName(template, "NECK_LOWER_EXTENSION_SCORE"));

// CHEST and ABDOMEN

var chest_score   = parseFloat(template.GetVariableValue("CHEST_MAX_COMPRESSION_SCORE"));
var abdomen_score = parseFloat(template.GetVariableValue("ABDOMEN_MAX_COMPRESSION_SCORE"));

var chest_abdomen_score = Math.min(chest_score, abdomen_score);
var chest_abdomen_variable = new Variable(template, "CHEST_ABDOMEN_FINAL_SCORE", "Chest and abdomen score (lower of the two)", chest_abdomen_score, "General", false, false);

// PELVIS and LUMBAR MODIFIER (0 OR -4)

var pelvis_and_lumbar_score = parseFloat(template.GetVariableValue("PELVIS_AND_LUMBAR_MODIFIER"));

SetPassFail(Variable.GetFromName(template, "PELVIS_FORCE_SCORE"));
SetPassFail(Variable.GetFromName(template, "LUMBAR_Y_FORCE_SCORE"));
SetPassFail(Variable.GetFromName(template, "LUMBAR_Z_FORCE_SCORE"));
SetPassFail(Variable.GetFromName(template, "LUMBAR_X_TORSION_SCORE"));




// TOTAL SCORE

var total_score = head_score + neck_score + chest_score + pelvis_and_lumbar_score

var total_score_variable = new Variable(template, "TOTAL_SCORE", "head + neck + chest & abdomen + pelvis & lumbar modifier", total_score, "General", false, false);


function SetPassFail(variable)
{
    if (parseFloat(variable.value) == 0)
    {
        variable.value = 'PASS';
    }
    else
    {
        variable.value = 'FAIL';
    }

}

function SetPassFailLowerNeckExtension(variable)
{
    if (parseFloat(variable.value) > 0)
    {
        variable.value = 'PASS';
    }
    else
    {
        variable.value = 'FAIL';
    }

}