// In this JavaScript we load stgart primer and read in the intrusion distance from the side excursion csv in order to
// 'draw' the head excursion bands in d3plot. This is achieved by creating NULL shell parts in primer to represent the
// zone bands in car model space (relative to the driver) and then saving the parts to a ptf file to read in to d3plot

// Read in the model
var m = Model.Read(default_dir + "/" + default_job);

// If unsuccessful, exit from the script

if (!m) {
    Window.Message("", "Could not read in model. Unable to continue");
    Exit();
}

//****************************************************************************************************** */
Println("Creating excursion zone bands");

if (File.Exists(fname_csv) && File.IsFile(fname_csv)) {
    var f_csv = new File(fname_csv, File.READ);
    var line;
    var oGlblData = new Object();
    oGlblData.intrusion_from_seat_center_y = undefined;

    oGlblData.cut_section_node_1 = undefined;

    oGlblData.shift_deform_node_1 = undefined;
    oGlblData.shift_deform_node_2 = undefined;
    oGlblData.shift_deform_node_3 = undefined;

    oGlblData.cutsection_thickness = undefined;
    oGlblData.vehicle_direction = undefined;

    // Read the CSV file and store the data

    while ((line = f_csv.ReadLine()) != undefined) {
        // Lines beginning with '$' are comments otherwise they should be of the form:
        //
        // variable_name,variable_value
        //

        if (line[0] != "$") {
            var list = line.split(",");
            var name = list[0].toLowerCase();

            if (list[1] != undefined) {
                switch (name) {
                    case "unit_length": {
                        oGlblData.unit_length = list[1];
                        break;
                    }
                    case "unit_mass": {
                        oGlblData.unit_mass = list[1];
                        break;
                    }
                    case "unit_time": {
                        oGlblData.unit_time = list[1];
                        break;
                    }

                    case "head_node": {
                        oGlblData.cut_section_node_1 = parse_num(
                            list[1],
                            false
                        );
                        break;
                    }

                    case "shift_deform_node_1": {
                        oGlblData.shift_deform_node_1 = parse_num(
                            list[1],
                            false
                        );
                        break;
                    }
                    case "shift_deform_node_2": {
                        oGlblData.shift_deform_node_2 = parse_num(
                            list[1],
                            false
                        );
                        break;
                    }
                    case "shift_deform_node_3": {
                        oGlblData.shift_deform_node_3 = parse_num(
                            list[1],
                            false
                        );
                        break;
                    }

                    case "ground_z": {
                        oGlblData.ground_z = parse_num(list[1], true);
                        break;
                    }
                    case "near_seat_centre_y": {
                        oGlblData.seat_centre_y = parse_num(list[1], true);
                        break;
                    }

                    case "intrusion_from_seat_center_y": {
                        oGlblData.intrusion_from_seat_center_y = parse_id(
                            list[1]
                        );
                        break;
                    }

                    case "cutsection_thickness": {
                        oGlblData.cutsection_thickness = parse_id(list[1]);
                        break;
                    }
                    case "vehicle_direction": {
                        oGlblData.vehicle_direction = list[1];
                        break;
                    } //"-X" or "+X"
                }
            }
        }
    }
    f_csv.Close();

    if (oGlblData.intrusion_from_seat_center_y == undefined) {
        if (
            File.Exists(fname_excursion_csv) &&
            File.IsFile(fname_excursion_csv)
        ) {
            var f_csv = new File(fname_excursion_csv, File.READ);
            var line;

            // Read the CSV file and store the data

            while ((line = f_csv.ReadLine()) != undefined) {
                // Lines beginning with '$' are comments otherwise they should be of the form:
                //
                // variable_name,variable_value
                //

                if (line[0] != "$") {
                    var list = line.split(",");
                    var name = list[0].toLowerCase();

                    if (list[1] != undefined) {
                        switch (name) {
                            case "intrusion_from_seat_center_y": {
                                oGlblData.intrusion_from_seat_center_y =
                                    parse_id(list[1]);
                                break;
                            }
                        }
                    }
                }
            }
            f_csv.Close();
        }
    }
}

//note this checks key names of oGlblData object
check_all_inputs_present([
    "intrusion_from_seat_center_y",
    "seat_centre_y", //i.e. y coordinate at middle of passenger seat
    "unit_length",
    "shift_deform_node_1",
    "shift_deform_node_2",
    "shift_deform_node_3",
    "cut_section_node_1",
    "vehicle_direction",
    "cutsection_thickness",
]);

/*

---> X  Car pointing in -ve X

        
                (O) barrier
                 |  
                \ /
                 v
  Y      /--OOOO---------OOOO---]    LHD CAR               
  ^     /<   [Near]        [ ]  |    near seat (passenger Y) > 0
  |     |                       |    +
  |     |                       |
  |     \<   [Driver]      [ ]  |
         \--OOOO---------OOOO---]

                        
        
  Y      /--OOOO---------OOOO---]   RHD CAR                       
  ^     /<   [Driver]     [ ]   |   near seat (passenger Y) < 0
  |     |                       |   -
  |     |                       |
  |     \<   [Near]        [ ]  |
         \--OOOO---------OOOO---]
                ^
               / \ 
                |
               (O) barrier


         

<--- X  Car pointing in +VE X
      
                (O) barrier
                 |  
                \ /
                 v
         /--OOOO---------OOOO---]   LHD CAR                      
  |     /<   [Near]        [ ]  |   near seat (passenger Y) < 0
  |     |                       |   -
  |     |                       |
  V     \<   [Driver]      [ ]  |
  Y      \--OOOO---------OOOO---]



         /--OOOO---------OOOO---]   RHD CAR                     
  |     /<   [Driver]     [ ]   |   near seat (passenger Y) > 0
  |     |                       |   +
  |     |                       |
  V     \<   [Near]        [ ]  |
  Y      \--OOOO---------OOOO---]
                ^
               / \ 
                |
               (O) barrier



*/

if (oGlblData.seat_centre_y > 0) {
    //Note the car is assumed to point in the -ve x direction
    //"right" means from the perspective of the analyst looking at the front of the vehicle (this is "left side for the occupants")

    //if the passenger seat (struck side seat a.k.a near seat) y coordinate is +ve
    //then the car is assumed to be struck from the vehicle right and intrusion is right to left (in the -ve y direction)
    //so to get intrusion_y coordinate add intrusion_from_seat_center_y to seat_y

    oGlblData.intrusion_y =
        oGlblData.seat_centre_y + oGlblData.intrusion_from_seat_center_y;
} else {
    //intrusion is from left to right when looking at the front of the vehicle (i.e. in the +ve y direction)

    oGlblData.intrusion_y =
        oGlblData.seat_centre_y - oGlblData.intrusion_from_seat_center_y;
}

var ptf_file = images_dir + "/zones.ptf";

if (File.Exists(ptf_file)) {
    Message(
        ptf_file + " exists so not deleting old ptfs before creating new ptf"
    );
    File.Delete(ptf_file);
    File.Delete(ptf_file + "01");
} else {
    Message(ptf_file + " does not exist so creating new ptf");
}

var m_first = Model.First();

var shift_deformed_node_1 = Node.GetFromID(
    m_first,
    oGlblData.shift_deform_node_1
);
var shift_deformed_node_2 = Node.GetFromID(
    m_first,
    oGlblData.shift_deform_node_2
);
var shift_deformed_node_3 = Node.GetFromID(
    m_first,
    oGlblData.shift_deform_node_3
);
var cut_section_node_1 = Node.GetFromID(m_first, oGlblData.cut_section_node_1);

//get unit conversion factor so it works for models not in mm too
calculate_unit_constants();

/**
 * z_top and z_bot determine the top and bottom z coordinate of the zone rectangles (shells) that
 * are created and used as a backdrop to show which zone the head reached in the far side analysis
 *
 * we are hard-coding the top of the zone rectangles (shells) to be at 4m above the head node
 * and the bottom to be at 5m below the head node.
 *
 * The assumption is that head is about 0.5m above the centre of the vehicle so
 * when we call "AC" (auto-centre) command in d3plot_EuroNCAP_Far_Side_2022_head_excursion_local.js
 * the vehicle should be approximately central in the image
 */
var head_node_initial_z = cut_section_node_1.z;

var z_bot = head_node_initial_z - 5 * oGlblData.len_factor;
var z_top = head_node_initial_z + 4 * oGlblData.len_factor;

if (oGlblData.cutsection_thickness == 0) oGlblData.cutsection_thickness = 10; //nominal 10mm thick
var thick_cut = oGlblData.cutsection_thickness * oGlblData.mm_factor;

var xsign = 1;
if (/pos/i.test(oGlblData.vehicle_direction)) var xsign = -1;

var x = cut_section_node_1.x + (xsign * thick_cut * 0.99) / 2; // issue with cut section if shells lie exactly on cut-section x hence '-1'
var y = oGlblData.seat_centre_y;
var y_excursion = oGlblData.intrusion_y; //start of red zone

//multiply by sign for the case when the car is struck from the left hand side

var sign = 1;
if (y_excursion < 0) sign = -1;

var y_red_orange = y;
var y_orange_yellow = y - 0.125 * oGlblData.len_factor * sign;
var y_yellow_green = y - 0.25 * oGlblData.len_factor * sign;

/** the width property controls how wide the zone total zone bands should be
 * i.e. left ande right side is +/- 0.5*width from vehicle centreline
 * ***setting this in combination with z_top and z_bot ensures consistent zoom/scale***
 * */
var width = 10 * oGlblData.len_factor * sign; //m

var boolRed = true;
var boolOrange = true;
var boolYellow = true;

if (Math.abs(y_excursion) <= Math.abs(y_yellow_green)) {
    //then no red, orange and yellow. Green starts at y_excursion
    var y_yellow_green = y_excursion;
    boolRed = false;
    boolOrange = false;
    boolYellow = false;
} else if (Math.abs(y_excursion) <= Math.abs(y_orange_yellow)) {
    //then no red and orange. Yellow starts at y_excursion
    var y_orange_yellow = y_excursion;
    boolRed = false;
    boolOrange = false;
} else if (Math.abs(y_excursion) <= Math.abs(y_red_orange)) {
    //then no red. Orange starts at y_excursion
    var y_red_orange = y_excursion;
    boolRed = false;
}

//***assume struck far side is at +ve y and driver/occupant is sat at -ve y such that they move in +ve y direcion***
//***assume mm */
//new model
var m = new Model();

//make dummy material

var mat = new Material(m, 1, "NULL");
mat.SetPropertyByName("RO", oGlblData.mass_factor);

//make dummy section

var section = new Section(m, 1, Section.SHELL, "NULL_SHELL");

//set section thickness to 1mm - just choose something small but non-zero so it shows up in the cut section
section.t1 = 0.001 * oGlblData.len_factor;
section.t2 = 0.001 * oGlblData.len_factor;
section.t3 = 0.001 * oGlblData.len_factor;
section.t4 = 0.001 * oGlblData.len_factor;

//make parts

var parts_list = [1, 5, 6, 7, 8]; //used in D3PLOT excursion plot to control which parts are visible
var shift_deformed_part = new Part(m, 1, 1, 1, "Shift Deformed");
if (boolRed) {
    var red_zone_part = new Part(m, 2, 1, 1, "RED ZONE");
    parts_list.push(2);
}
if (boolOrange) {
    var orange_zone_part = new Part(m, 3, 1, 1, "ORANGE ZONE");
    parts_list.push(3);
}
if (boolYellow) {
    var yellow_zone_part = new Part(m, 4, 1, 1, "YELLOW ZONE");
    parts_list.push(4);
}
var green_zone_part = new Part(m, 5, 1, 1, "GREEN ZONE");
var blue_center_line_part = new Part(m, 6, 1, 1, "BLUE CENTER-LINE");
var capping_zone_part = new Part(m, 7, 1, 1, "GREY CAPPING ZONE");
var white_zone_part = new Part(m, 8, 1, 1, "WHITE ZONE"); //used for consistent image scaling

//make nodes

var sdn1 = copyNodeToNewModelReturnNID(shift_deformed_node_1, m);
var sdn2 = copyNodeToNewModelReturnNID(shift_deformed_node_2, m);
var sdn3 = copyNodeToNewModelReturnNID(shift_deformed_node_3, m);
var csn4 = copyNodeToNewModelReturnNID(cut_section_node_1, m);

//shell nodes

//RED/ORANGE ZONE (seat centreline)
var n1 = new Node(m, 1, x, y_red_orange, z_bot);
var n2 = new Node(m, 2, x, y_red_orange, z_top);

//RED/CAPPING ZONE (excursion taken from previous side impact analysis)
//note if y_excursion < y then orange starts at y_excursion
//     if y_excursion < y -125 then no orange and yellow starts at y_excursion
//     if y_excursion < y -255 then no yellow and green starts at y_excursion

var n3 = new Node(m, 3, x, y_excursion, z_top);
var n4 = new Node(m, 4, x, y_excursion, z_bot);

//ORANGE/YELLOW ZONE
var n5 = new Node(m, 5, x, y_orange_yellow, z_bot);
var n6 = new Node(m, 6, x, y_orange_yellow, z_top);

//YELLOW/GREEN ZONE
var n7 = new Node(m, 7, x, y_yellow_green, z_bot);
var n8 = new Node(m, 8, x, y_yellow_green, z_top);

//GREEN ZONE (arbitrarily chosen to end at far seat centreline (assumed to be  -y))
var n9 = new Node(m, 9, x, -y, z_bot);
var n10 = new Node(m, 10, x, -y, z_top);

//BLUE CENTERLINE (10mm wide)
var blue_line_width = 0.01 * oGlblData.len_factor;
x_blue_line = x - 0.002 * oGlblData.len_factor; //offset blue line forewards by 2mm so that it is more visible
var n11 = new Node(m, 11, x_blue_line, -blue_line_width / 2, z_bot);
var n12 = new Node(m, 12, x_blue_line, -blue_line_width / 2, z_top);
var n13 = new Node(m, 13, x_blue_line, blue_line_width / 2, z_top);
var n14 = new Node(m, 14, x_blue_line, blue_line_width / 2, z_bot);

//Capping Zone (edge is 5m (width/2) from centreline) grey part
//***used for consistent zoom/scale***
var n15 = new Node(m, 15, x, width / 2, z_bot);
var n16 = new Node(m, 16, x, width / 2, z_top);

//right border (edge is 5m (width/2) from centreline) white part
//***used for consistent zoom/scale***
var n17 = new Node(m, 17, x, -width / 2, z_bot);
var n18 = new Node(m, 18, x, -width / 2, z_top);

//make shells
var s1 = new Shell(m, 1, shift_deformed_part.pid, sdn1, sdn2, csn4, csn4);
var s2 = new Shell(m, 2, shift_deformed_part.pid, sdn1, sdn3, csn4, csn4);
var s3 = new Shell(m, 3, shift_deformed_part.pid, sdn2, sdn3, csn4, csn4);
var s4 = new Shell(m, 4, shift_deformed_part.pid, sdn1, sdn2, sdn3, sdn3);

if (boolRed) var s5 = new Shell(m, 5, red_zone_part.pid, 1, 2, 3, 4);
if (boolOrange) var s6 = new Shell(m, 6, orange_zone_part.pid, 1, 5, 6, 2);
if (boolYellow) var s7 = new Shell(m, 7, yellow_zone_part.pid, 5, 7, 8, 6);
var s8 = new Shell(m, 8, green_zone_part.pid, 7, 9, 10, 8);
var s9 = new Shell(m, 9, blue_center_line_part.pid, 11, 12, 13, 14);
var s10 = new Shell(m, 10, capping_zone_part.pid, 3, 4, 15, 16);
var s11 = new Shell(m, 11, white_zone_part.pid, 9, 10, 18, 17);

m_first.Delete();

//write out pft file using temp macro
var write_ptf_macro_file = File.Mktemp();

var macro =
    `Window("Tools/Keywords").Button("Model Tab")
Window("Model functions").Button("Write")
In Window("WRITE TO FILE")
    .Radio("Filetype Radio") = "PTF / d3plot"
    .Textbox("File:") = "` +
    ptf_file +
    '"\n' +
    `    .Button("Apply")
End In
`;

Message("Writing macro to " + write_ptf_macro_file);
var f = new File(write_ptf_macro_file, File.WRITE);
f.Write(macro);
f.Close();

Message("Running macro " + write_ptf_macro_file);
PlayMacro(write_ptf_macro_file);
Message("Finish macro " + write_ptf_macro_file);

Println(
    "Exiting primer after successfully writing excursion zones to " + ptf_file
);

//*********************************functions************************************************************ */

function copyNodeToNewModelReturnNID(n, m) {
    var newNode = new Node(m, n.nid, n.x, n.y, n.z);

    return newNode.nid;
}

function parse_num(id, isFloat) {
    // Parse an id string.  Could be a number, name or blank

    var ret_id;

    // Is it a number

    if (!isNaN(id)) {
        if (isFloat) ret_id = parseInt(id);
        else ret_id = parseInt(id);

        if (ret_id != undefined && !isNaN(ret_id)) return ret_id;
    }

    // Get here and it's not a number or non-blank string so return undefined.

    return undefined;
}

function check_all_inputs_present(required_inputs) {
    for (var i = 0; i < required_inputs.length; i++) {
        var input = required_inputs[i];
        if (oGlblData[input] == undefined) {
            ErrorMessage("Could not find input for " + input);
            Exit();
        } else if (Array.isArray(oGlblData[input])) {
            if (oGlblData[input].length == 0) {
                ErrorMessage("Could not find input for " + input);
                Exit();
            }
        }
    }
}
