// memory: 1024
//
// ****************************************
//
// THINGS TO GET THE USER TO SPECIFY
//

var EuroNCAPColourGREEN = "R38G155B41";
var EuroNCAPColourYELLOW = "R255G204B0";
var EuroNCAPColourORANGE = "R255G151B0";
var EuroNCAPColourBROWN = "R117G63B42";
var EuroNCAPColourRED = "R224G7B0";
var D3PLOT_CAR_COLOUR = "R200G200B200";
var D3PLOT_HEAD_COLOUR = "BLUE";
var D3PLOT_BARRIER_COLOUR = "DARK_GREY";

var EuroNCAPColourREDorBROWN = EuroNCAPColourRED; //default (changes based on intrusion level and countermeasure status)

var Include_UBIN_Data = false;
if (Include_UBIN_Data) {
    var UBIN_vector_handle = CreateUbinComponent(
        "vector for local y_v2",
        U_NODE,
        U_VECTOR,
        REPLACE
    );
    var UBIN_vector_handle_n1n2 = CreateUbinComponent(
        "vector for n1n2_v2",
        U_NODE,
        U_VECTOR,
        REPLACE
    );
}

SetCurrentModel(1);

var image_file = images_dir + "/Head_Excursion.png";

if (File.Exists(fname_csv) && File.IsFile(fname_csv)) {
    var f_csv = new File(fname_csv, File.READ);
    var line;
    var oGlblData = new Object();
    oGlblData.head_parts = new Array();
    oGlblData.barrier_parts = new Array();

    oGlblData.countermeasure = undefined;

    oGlblData.intrusion_y = undefined;
    oGlblData.excursion_zone = undefined;

    oGlblData.cutsection_thickness = undefined;

    oGlblData.cut_section_method = "Constant X";

    // oGlblData.cut_section_node_1 = undefined;
    // oGlblData.cut_section_node_2 = undefined;
    // oGlblData.cut_section_node_3 = undefined;

    oGlblData.shift_deform_node_1 = undefined;
    oGlblData.shift_deform_node_2 = undefined;
    oGlblData.shift_deform_node_3 = undefined;

    oGlblData.intrusion_from_seat_center_y = undefined;
    oGlblData.seat_centre_y = undefined;
    oGlblData.occupant_seat_centre_y = undefined; //this is just for reference but not needed

    oGlblData.barrier = undefined;

    oGlblData.vehicle_direction = undefined;

    // Read the CSV file and store the data

    while ((line = f_csv.ReadLine()) != undefined) {
        // Lines beginning with '$' are comments otherwise they should be of the form:
        //
        // variable_name,variable_value
        //

        if (line[0] != "$") {
            var list = line.split(",");
            var name = list[0].toLowerCase();

            if (list[1] != undefined) {
                switch (name) {
                    case "unit_length": {
                        oGlblData.unit_length = list[1];
                        break;
                    }
                    case "unit_mass": {
                        oGlblData.unit_mass = list[1];
                        break;
                    }
                    case "unit_time": {
                        oGlblData.unit_time = list[1];
                        break;
                    }

                    case "countermeasure": {
                        oGlblData.countermeasure = list[1];
                        break;
                    } //"Yes" or "No"

                    case "cutsection_thickness": {
                        oGlblData.cutsection_thickness = parse_id(list[1]);
                        break;
                    }

                    case "head_node": {
                        oGlblData.cut_section_node_1 = parse_id(list[1]);
                        break;
                    }

                    case "shift_deform_node_1": {
                        oGlblData.shift_deform_node_1 = parse_id(list[1]);
                        break;
                    }
                    case "shift_deform_node_2": {
                        oGlblData.shift_deform_node_2 = parse_id(list[1]);
                        break;
                    }
                    case "shift_deform_node_3": {
                        oGlblData.shift_deform_node_3 = parse_id(list[1]);
                        break;
                    }

                    case "ground_z": {
                        oGlblData.ground_z = parse_id(list[1]);
                        break;
                    }
                    case "near_seat_centre_y": {
                        oGlblData.seat_centre_y = parse_id(list[1]);
                        break;
                    }

                    case "head_parts": {
                        oGlblData.head_parts.push(parse_id(list[1]));
                        break;
                    }
                    case "barrier_parts": {
                        oGlblData.barrier_parts.push(parse_id(list[1]));
                        break;
                    }

                    case "intrusion_from_seat_center_y": {
                        oGlblData.intrusion_from_seat_center_y = parse_id(
                            list[1]
                        );
                        break;
                    }
                    //not used
                    //case "seat_y":                                 { oGlblData.occupant_seat_centre_y                 = parse_id(list[1]);  break; } //opposite side from "near_seat_centre_y"
                    case "barrier": {
                        oGlblData.barrier = list[1];
                        break;
                    } //"Post" or "MDB"
                    case "vehicle_direction": {
                        oGlblData.vehicle_direction = list[1];
                        break;
                    } //"-X" or "+X"
                }
            }
        }
    }
    f_csv.Close();

    if (oGlblData.intrusion_y == undefined) {
        //oGlblData.intrusion_y should be defined in batch mode as the intrusion data should be present in master csv so no need to have this csv
        if (
            File.Exists(fname_excursion_csv) &&
            File.IsFile(fname_excursion_csv)
        ) {
            var f_csv = new File(fname_excursion_csv, File.READ);
            var line;

            // Read the CSV file and store the data

            while ((line = f_csv.ReadLine()) != undefined) {
                // Lines beginning with '$' are comments otherwise they should be of the form:
                //
                // variable_name,variable_value
                //

                if (line[0] != "$") {
                    var list = line.split(",");
                    var name = list[0].toLowerCase();

                    if (list[1] != undefined) {
                        switch (name) {
                            //case "max_intrusion_y":                        { oGlblData.intrusion_y                            = parse_id(list[1]);  break; } //not used as intrusion_y is calculated from seat_centre_y and intrusion_from_seat_center_y
                            case "intrusion_from_seat_center_y": {
                                oGlblData.intrusion_from_seat_center_y =
                                    parse_id(list[1]);
                                break;
                            }
                            //case "seat_y":                                 { oGlblData.occupant_seat_centre_y                 = parse_id(list[1]);  break; } //opposite side from "near_seat_centre_y"
                            case "barrier": {
                                oGlblData.barrier = list[1];
                                break;
                            } //"Post" or "MDB"
                        }
                    }
                }
            }
            f_csv.Close();
        }
    }

    check_all_inputs_present();

    // var JSON_global = JSON.stringify(oGlblData, null, 4);

    // var JSON_file = new File(default_dir+"GlobalObj.json", File.WRITE);

    // JSON_file.Write(JSON_global);
    // JSON_file.close;

    // Message('finished writing JSON');
    // Exit();
}

//convert countermeasure string to boolean
var countermeasure = false;
if (/yes/i.test(oGlblData.countermeasure)) countermeasure = true;
//oGlblData.countermeasure also written out to create a reporter variable called %COUNTERMEASURE" for use in template and in T/HIS script item

// Open a csv file in the %IMAGES_DIR% to write variables to, for Reporter to pick up

var f_vars = new File(images_dir + "/d3plot_vars.csv", File.WRITE);

// Check we have unit valid unit data and write a variable with the units used.
// If the units are not defined/valid then we cannot go any further.

if (!check_unit_values()) {
    write_unit_vars(f_vars, false);
    Exit();
}

// Write the unit data to the variables file

write_unit_vars(f_vars, true);

// Calculate constants now we have unit data and store on <oGlblData> object

calculate_unit_constants();

function check_all_inputs_present() {
    //required inputs
    var required_inputs = [
        "intrusion_from_seat_center_y",
        "seat_centre_y",
        "barrier",
        "unit_length",
        "barrier_parts",
        "head_parts",
        "shift_deform_node_1",
        "shift_deform_node_2",
        "shift_deform_node_3",
        "cutsection_thickness",
        // "cut_section_method",
        // "cut_section_node_1",
        "countermeasure",
        "vehicle_direction",
    ];

    for (var i = 0; i < required_inputs.length; i++) {
        var input = required_inputs[i];
        if (oGlblData[input] == undefined) {
            ErrorMessage("Could not find input for " + input);
            Exit();
        } else if (Array.isArray(oGlblData[input])) {
            if (oGlblData[input].length == 0) {
                ErrorMessage("Could not find input for " + input);
                Exit();
            }
        }
    }
}

function parse_id(id) {
    // Parse an id string.  Could be a number, name or blank

    var ret_id;

    // Is it a number

    if (!isNaN(id)) {
        ret_id = parseInt(id);

        if (ret_id != undefined && !isNaN(ret_id)) return ret_id;
    }

    // Not a number so return the string if it's not blank

    if (id.length > 0) {
        for (var i = 0; i < id.length; i++) {
            if (id[i] != " ") return id;
        }
    }

    // Get here and it's not a number or non-blank string so return undefined.

    return undefined;
}

var n1 = oGlblData.cut_section_node_1;
var n2 = oGlblData.cut_section_node_2;
var n3 = oGlblData.cut_section_node_3;

SetCurrentState(1);

if (oGlblData.cut_section_method != undefined) {
    if (oGlblData.cut_section_method == "Origin and Vectors") {
        if (n1 != undefined && n2 != undefined && n3 != undefined) {
            var n1_coords = GetData(BV, NODE, -n1);
            var n2_coords = GetData(BV, NODE, -n2);

            var origin = n1_coords;

            var x_axis = new Array(3);

            //x axis is n1 to n2 with y component set to zero
            //(TODO:may want to set z to zero too?)
            x_axis[0] = n2_coords[0] - n1_coords[0];
            x_axis[1] = 0.0;
            x_axis[2] = n2_coords[2] - n1_coords[2];

            var mag = Math.sqrt(
                x_axis[0] * x_axis[0] +
                    x_axis[1] * x_axis[1] +
                    x_axis[2] * x_axis[2]
            );

            x_axis[0] /= mag;
            x_axis[1] /= mag;
            x_axis[2] /= mag;

            var xy_plane = [0.0, 1.0, 0.0];

            var window = ALL;
            var or_and_v = new Array(9);

            or_and_v[0] = origin[0];
            or_and_v[1] = origin[1];
            or_and_v[2] = origin[2];
            or_and_v[3] = x_axis[0];
            or_and_v[4] = x_axis[1];
            or_and_v[5] = x_axis[2];
            or_and_v[6] = xy_plane[0];
            or_and_v[7] = xy_plane[1];
            or_and_v[8] = xy_plane[2];

            Message("OR_AND_V: " + or_and_v);

            SetCutSection(window, OR_AND_V, or_and_v); // Origin and vector
            SetCutSection(window, SPACE, BASIC); // Basic space
            SetCutSection(window, STATUS, ON); // Turn on
        }
    } else if (oGlblData.cut_section_method == "Three Nodes") {
        if (n1 != undefined && n2 != undefined && n3 != undefined) {
            var window = ALL;

            threeNodes = new Array(3);
            threeNodes[0] = -n1;
            threeNodes[1] = -n2;
            threeNodes[2] = -n3;
            SetCutSection(window, N3, threeNodes);

            SetCutSection(window, SPACE, BASIC); // Basic space
            SetCutSection(window, STATUS, ON); // Turn on
        }
    } else {
        if (n1 != undefined) {
            var window = ALL;

            var node_coord = GetData(BV, NODE, -n1);

            if (oGlblData.cut_section_method == "Constant X")
                SetCutSection(window, CONST_X, node_coord);
            else if (oGlblData.cut_section_method == "Constant Y")
                SetCutSection(window, CONST_Y, node_coord);
            else if (oGlblData.cut_section_method == "Constant Z")
                SetCutSection(window, CONST_Z, node_coord);

            SetCutSection(window, SPACE, BASIC); // Basic space
            SetCutSection(window, STATUS, ON); // Turn on
        }
    }
}
// Shift deform nodes

var n1 = oGlblData.shift_deform_node_1;
var n2 = oGlblData.shift_deform_node_2;
var n3 = oGlblData.shift_deform_node_3;

//If n1, n2 or n3 are not defined then skip this step
if (n1 != undefined && n2 != undefined && n3 != undefined)
    DialogueInput("/DEFORM SHIFT_DEFORMED DEFINE", n1, n2, n3);

function d3plot_write_variables(f) {
    write_variable(
        f,
        "GROUND_Z",
        oGlblData.ground_z,
        "Ground Z value",
        "Number"
    );
    write_variable(
        f,
        "NEAR_SEAT_CENTRE_Y",
        oGlblData.seat_centre_y,
        "Near seat Centre Y value",
        "Number"
    );
    write_variable(
        f,
        "INTRUSION_Y",
        oGlblData.intrusion_y,
        "Intrusion Y value (from near side)",
        "Number"
    );
    write_variable(
        f,
        "EXCURSION_ZONE",
        oGlblData.excursion_zone,
        "Excursion zone used for scoring band",
        "Number"
    );

    write_variable(
        f,
        "PEAK_STATE",
        oGlblData.peak_state,
        "Peak state",
        "Number"
    );
    write_variable(f, "PEAK_NODE", oGlblData.peak_node_id, "Node ID", "Number");

    write_variable(
        f,
        "EXCURSION_Y",
        oGlblData.excursion,
        "ABS Excursion Y",
        "Number"
    );
    write_variable(
        f,
        "EXCURSION_MAX",
        oGlblData.max_excursion,
        "Excursion max",
        "Number"
    );
    write_variable(
        f,
        "BARRIER",
        oGlblData.barrier,
        "Barrier (Post or MDB)",
        "String"
    );
    write_variable(
        f,
        "COUNTERMEASURE",
        oGlblData.countermeasure,
        "Adequate counter measure Far Side impact (Yes or No)",
        "String"
    );
}

function write_variable(f, name, value, desc, type) {
    // Writes variable to file <f>

    f.Writeln(name + "," + value + "," + desc + "," + type);
}

function write_unit_vars(f, valid) {
    // Writes variables for units to the variables file <f>

    var name = "MODEL_UNITS";
    var desc = "Model units";
    var type = "String";
    var value;

    if (valid)
        value =
            oGlblData.unit_length +
            "  " +
            oGlblData.unit_mass +
            "  " +
            oGlblData.unit_time;
    else value = "NOT DEFINED / INVALID. UNABLE TO POST-PROCESS RESULTS.";

    f.Writeln(name + "," + value + "," + desc + "," + type);
}

function calculate_unit_constants() {
    Message("**calculate_unit_constants**");
    // Calculate constants based on the model units

    var len = oGlblData.unit_length;
    var mass = oGlblData.unit_mass;
    var time = oGlblData.unit_time;

    oGlblData.len_factor = 1.0;
    oGlblData.mass_factor = 1.0;
    oGlblData.time_factor = 1.0;

    // Factors to convert from metres, kgs to model units

    var len_factor, mass_factor, time_factor;

    if (len == "m") len_factor = 1.0;
    else if (len == "cm") len_factor = 100.0;
    else if (len == "mm") len_factor = 1000.0;
    else if (len == "inch") len_factor = 39.37008;
    else if (len == "ft") len_factor = 3.28084;

    if (mass == "tonne") mass_factor = 0.001;
    else if (mass == "kg") mass_factor = 1.0;
    else if (mass == "lb") mass_factor = 2.204586;
    else if (mass == "slug") mass_factor = 0.06852178;
    else if (mass == "gram") mass_factor = 1000.0;

    if (time == "s") time_factor = 1.0;
    else if (time == "ms") time_factor = 1000.0;
    else if (time == "us") time_factor = 1000000.0;

    oGlblData.len_factor = len_factor;
    oGlblData.mass_factor = mass_factor;
    oGlblData.time_factor = time_factor;

    // Gravity constant in model units (9.81 m/s^2)

    oGlblData.g_constant = (9.81 * len_factor) / (time_factor * time_factor);

    // Factor to divide force by to convert to kN

    oGlblData.kn_factor =
        1000 * ((mass_factor * len_factor) / (time_factor * time_factor));

    // Factor to divide moment by to convert to Nm

    oGlblData.nm_factor =
        (mass_factor * len_factor * len_factor) / (time_factor * time_factor);

    // Factor to divide length by to convert to mm

    oGlblData.mm_factor = len_factor / 1000;

    // Factor to divide length by to convert to cm

    oGlblData.cm_factor = len_factor / 100;
}

function check_unit_values() {
    // Checks that the model units specified by the user are valid.
    // Returns false if not.

    // Valid lengths: m, cm, mm, inch, ft

    switch (oGlblData.unit_length) {
        case "m":
        case "cm":
        case "mm":
        case "inch":
        case "ft":
            break;

        default:
            return false;
    }

    // Valid mass: tonne, kg, lb, slug, gm

    switch (oGlblData.unit_mass) {
        case "tonne":
        case "kg":
        case "lb":
        case "slug":
        case "gm":
            break;

        default:
            return false;
    }

    // Valid time: s, ms, us

    switch (oGlblData.unit_time) {
        case "s":
        case "ms":
        case "us":
            break;

        default:
            return false;
    }

    return true;
}

//
// END OF THINGS TO BE SPECIFIED BY THE USER
//
// ****************************************

/*define intrusion y based on intrusion_from_seat_center_y

if intrusion_from_seat_center_y is > 0 then the intrusion does not reach the seat center
if intrusion_from_seat_center_y < 0 then the intrusion passes the seat center
*/

if (oGlblData.seat_centre_y > 0) {
    //left hand-drive vehicle pointing in -X direction
    //OR
    //right hand-drive vehicle pointing in +X direction

    //in both cases passenger seat (seat nearest barrier) is at a +ve Y coordinate and the dummy head moves in the +ve Y direction on impact
    var sign = 1;
    var head_moves_in = "head moves moves in +y direction";
    oGlblData.intrusion_y =
        oGlblData.seat_centre_y + oGlblData.intrusion_from_seat_center_y;
} else {
    //right hand-drive vehicle pointing in -X direction
    //OR
    //left hand-drive vehicle pointing in +X direction

    //in both cases passenger seat (seat nearest barrier) is at a -ve Y coordinate and the dummy head moves in the -ve Y direction on impact
    var sign = -1;
    var head_moves_in = "head moves moves in -y direction";
    oGlblData.intrusion_y =
        oGlblData.seat_centre_y - oGlblData.intrusion_from_seat_center_y;
}

if (oGlblData.intrusion_y != undefined) {
    var top; //variable to store the topology ouput of solid and shell elements
    var a; //variable to store the list of elements in the head part(s)

    // Get internal ids of head parts
    var internal_head_node_ids = Array();

    //for each head part get extract all the nodes and store in internal_head_node_ids Array
    for (var j = 0; j < oGlblData.head_parts.length; j++) {
        var external_part_label = oGlblData.head_parts[j];
        // Get a list of elements in current part
        if ((a = GetElemsInPart(-external_part_label))) {
            var nelems = a.nn;

            //get the nodes for each element and store in internal_head_node_ids Array
            for (var i = 0; i < nelems; i++) {
                top = GetTopology(a.type, a.list[i]);
                internal_head_node_ids = internal_head_node_ids.concat(top.top);
            }
        }
    }

    //get rid of duplicate node definitions to avoid checking the same nodes multiple times
    var internal_head_node_ids = internal_head_node_ids.filter(onlyUnique);

    //the origin is the first shift deform node and the relative Y distance is used to calculate the head excursion distance
    //the assumption is that the shift deform nodes do not deform themselves in the impact but they may move due to global
    //motion of the vehicle as a result of the impact.
    oGlblData.origin_y = GetData(BY, NODE, -n1);

    //we arbitrarily pick the first head node as the one to use to find the state of the maximum excursion
    //note that because the head will likely rotate the maximum head excursion may not be be fully captured
    //by the node chosen so we need to do a second search of neighbouring states once we have found the node with the maximum excursion
    //and iterate until true max is found

    var head_internal_node_id = internal_head_node_ids[0];

    state = 1;
    SetCurrentState(1);

    //get matrix to rotate n1->n2 vector to global y at initial state;
    //after first state car will start to move so we need to use a rotated 'local' y
    //which can be found by multiplying new n1->n2 vector by the roation matrix calculated below
    //local coordinate

    var v_n1n2 = getNormalisedVectorFromCoords(
        GetData(BV, NODE, -n1),
        GetData(BV, NODE, -n2)
    );

    //rotation matrix initially aligned with +ve y direction
    var rotation_matrix = getRotationMatrix(v_n1n2, [0, 1, 0]);

    var initial_local_datum = get_local_datum();

    Message("Local y = " + JSON.stringify(initial_local_datum.y_axis));
    var nstates = GetNumberOf(STATE);

    //initially set maximum excursion to large negative (we later calculate excursion working backwards from last state, but the assumption is max excursion is at or near last state)
    var max_excursion = -999999;
    var max_state = nstates;
    var threshold = 0.2;

    //for each state (work backwards from the end and break out when current_excursion is lower than max excursoin by > 20% of the distance from the middle of the car to the middle of the seat)
    for (var state = nstates; state >= 1; state--) {
        //Message("State " + state);
        SetCurrentState(state);
        current_local_datum = get_local_datum();
        var current_excursion = get_current_excursion_from_seat_cl(
            current_local_datum,
            head_internal_node_id,
            sign
        );

        if (current_excursion > max_excursion) {
            max_excursion = current_excursion;
            max_state = state;
            Message(
                "excursion for node " +
                    head_internal_node_id +
                    " at state " +
                    state +
                    " = " +
                    current_excursion
            );
        } else if (
            (max_excursion - current_excursion) /
                Math.abs(oGlblData.seat_centre_y) >
            threshold
        ) {
            Message(
                "Max State = " +
                    max_state +
                    " Current State = " +
                    state +
                    ": Max excursion = " +
                    max_excursion +
                    ": Current excursion = " +
                    current_excursion
            );
            break; //break out of loop as max excursion already found and it is a waste of compute to continue checking earlier states
        }
    }

    //now we have state at which maximum excursion occurs we set the state and we calculate excursion for all nodes in head
    Message(
        "Max excursion for N" +
            GetLabel(NODE, head_internal_node_id) +
            " found at state " +
            max_state
    );
    SetCurrentState(max_state);

    var local_datum = get_local_datum(); //this only changes with state so no need to recalculate each iteration of loop
    var peak_node_id = head_internal_node_id;

    //can start with n=1 (i.e. second node in list as we have already calculated the peak excursion for the the first node above)
    for (var n = 1; n < internal_head_node_ids.length; n++) {
        var current_excursion = get_current_excursion_from_seat_cl(
            local_datum,
            internal_head_node_ids[n],
            sign
        );

        if (current_excursion > max_excursion) {
            max_excursion = current_excursion;
            peak_node_id = internal_head_node_ids[n];
        }
    }

    //now we have the node which generate the peak excursion we need to check the surrounding states to be sure that
    //we have the true peak.

    //boolean used to determine if we have found the true pea
    var peak_found = false;

    // save the max state found above as it is overwritten below
    var peak_state = max_state;
    // we need to to this because this is used when we check in the other direction i.e. backwards in states

    while (peak_state < nstates && !peak_found) {
        //check the next above state for the 'peak node'
        state = peak_state + 1;

        SetCurrentState(state);
        var current_excursion = get_current_excursion_from_seat_cl(
            get_local_datum(),
            peak_node_id,
            sign
        );

        if (current_excursion > max_excursion) {
            max_excursion = current_excursion;
            peak_state = state;
        } else {
            peak_found = true;
        }
    }

    //now check in the other direction

    if (peak_state == 1) {
        WarningMessage(
            "Maximum excursion found at first state\nCheck that near seat center y is defined correctly and that dummy moves towards far side impact."
        );
        max_state = peak_state; //1
        peak_found = true;
        oGlblData.excursion = max_excursion;
    } else {
        peak_found = false;

        while (max_state > 1 && !peak_found) {
            //check the next below state for the 'peak node'
            state = max_state - 1;

            SetCurrentState(state);
            var current_excursion = get_current_excursion_from_seat_cl(
                get_local_datum(),
                peak_node_id,
                sign
            );

            if (current_excursion > max_excursion) {
                max_excursion = current_excursion;
                max_state = state;
                peak_state = state;
            } else {
                oGlblData.excursion = max_excursion;
                peak_found = true;
            }
        }
    }

    oGlblData.excursion_zone = get_excursion_zone(oGlblData.excursion);

    //peak_state will now be the true peak state

    //get excursion distance
    //present max_excursion value as distance from driver seat centreline rather than distance from occupant seat centreline
    //(we can assume driver_seat_centre_y = -oGlblData.seat_centre_y so distance is 2*Math.abs(oGlblData.seat_centre_y) then add the oGlblData.excursion
    //value s oGlblData.excursion is +ve if it is further from the driver
    oGlblData.max_excursion = 2 * oGlblData.seat_centre_y + oGlblData.excursion;

    if (oGlblData.excursion_zone != undefined) {
        SetCutSection(ALL, STATUS, OFF);
        oGlblData.peak_state = peak_state;
        SetCurrentState(peak_state);
        Message("Setting state to " + peak_state);
        oGlblData.peak_node_id = GetLabel(NODE, peak_node_id);
        d3plot_write_variables(f_vars);
        if (
            !oGlblData.barrier_parts ||
            oGlblData.barrier_parts[0] == 0 ||
            oGlblData.barrier_parts[0] == ""
        ) {
            var barrier_parts = false;
        } else {
            var barrier_parts = oGlblData.barrier_parts.join(" ");
        }

        var head_parts = oGlblData.head_parts.join(" ");

        f_vars.Close();

        //set up display to be shaded turn off header and clock
        DialogueInput("/SHADED");
        DialogueInput("DISPLAY", "HEADER_SWITCH", "OFF");
        DialogueInput("DISPLAY", "CLOCK_SWITCH", "OFF");
        DialogueInput("DISPLAY", "OD", "OFF"); //SET OVERLAY LINES TO OFF (LIKE PRESSING 'y' SHORTCUT)
        DialogueInput(
            "DISPLAY",
            "ENTITY",
            "BEAM",
            "OFF", //beam elements off
            "SPRING",
            "OFF", //spring elements off
            "X",
            "OFF" //cut section off
        );
        //turn off clock, header and display lines in model 2 too
        DialogueInput("CM 2", "DISPLAY", "HEADER_SWITCH", "OFF");
        DialogueInput("CM 2", "DISPLAY", "CLOCK_SWITCH", "OFF");
        DialogueInput("CM 2", "DISPLAY", "OD", "OFF"); //SET OVERLAY LINES TO OFF (LIKE PRESSING 'y' SHORTCUT)

        //set view in model 1 to be -YZ (assumes car points in -X direction)
        DialogueInput("CM 1");

        if (oGlblData.vehicle_direction == "negative X") {
            DialogueInput("/-YZ");
        } // car points in +X
        else {
            DialogueInput("/+YZ");
        }

        //set state to peak_state *this should already be done by SetCurrentState(peak_state) above
        //but this is just to make sure we display correct state as it could be overwritten by embedded dialogue input commands
        DialogueInput("/STATE", peak_state.toString());
        //need to call DialogueInput to set state again as the graphis did not update
        DialogueInput("/STATE", peak_state.toString());

        //auto center model 1
        DialogueInput("CM 1");
        DialogueInput("AC");

        //switch to model 2 for colouring zone parts
        SetCurrentModel(2);
        var nparts = GetNumberOf(PART); //in model 2

        /** set colours of zones */
        for (var i = 1; i <= nparts; i++) {
            //note part 1 is blanked so not important to set colour but had issue setting colour of first part called
            //"PART", "1", "BLACK", //so left this in so that colour of parts that matter are set properly
            switch (GetLabel(PART, i).toString()) {
                case "1":
                    DialogueInput("CM 2", "BLANK", "PART", "1");
                    break; //blank part 1 in model 2
                case "2":
                    DialogueInput(
                        "CM 2",
                        "PROPERTIES",
                        "COLOUR",
                        "PART",
                        "1",
                        "BLACK",
                        "PART",
                        "2",
                        EuroNCAPColourREDorBROWN
                    );
                    break;
                case "3":
                    DialogueInput(
                        "CM 2",
                        "PROPERTIES",
                        "COLOUR",
                        "PART",
                        "1",
                        "BLACK",
                        "PART",
                        "3",
                        EuroNCAPColourORANGE
                    );
                    break;
                case "4":
                    DialogueInput(
                        "CM 2",
                        "PROPERTIES",
                        "COLOUR",
                        "PART",
                        "1",
                        "BLACK",
                        "PART",
                        "4",
                        EuroNCAPColourYELLOW
                    );
                    break;
                case "5":
                    DialogueInput(
                        "CM 2",
                        "PROPERTIES",
                        "COLOUR",
                        "PART",
                        "1",
                        "BLACK",
                        "PART",
                        "5",
                        EuroNCAPColourGREEN
                    );
                    break;
                case "6":
                    DialogueInput(
                        "CM 2",
                        "PROPERTIES",
                        "COLOUR",
                        "PART",
                        "1",
                        "BLACK",
                        "PART",
                        "6",
                        "BLUE"
                    );
                    break;
                case "7":
                    DialogueInput(
                        "CM 2",
                        "PROPERTIES",
                        "COLOUR",
                        "PART",
                        "1",
                        "BLACK",
                        "PART",
                        "7",
                        "GREY"
                    );
                    break;
                case "8":
                    DialogueInput(
                        "CM 2",
                        "PROPERTIES",
                        "COLOUR",
                        "PART",
                        "1",
                        "BLACK",
                        "PART",
                        "8",
                        "WHITE"
                    );
                    break;
            }
        }

        //switch back to model 1
        SetCurrentModel(1);

        //call shaded again to force redraw as sometimes it was blank
        DialogueInput("CM 1", "SHADED");

        // set the colour of model 1 (i.e. car + occupant + barrier)
        DialogueInput(
            "CM 1",
            "PROPERTIES",
            "COLOUR",
            "PART",
            "ALL",
            D3PLOT_CAR_COLOUR
        );
        //then update colour of barrier to D3PLOT_BARRIER_COLOUR = "DARK_GREY"
        if (barrier_parts)
            DialogueInput(
                "CM 1",
                "PROPERTIES",
                "COLOUR",
                "PART",
                barrier_parts,
                D3PLOT_BARRIER_COLOUR
            );
        else
            Message(
                "No barrier parts provided. This may because none are prenent in the model."
            );
        //then update colour of head to D3PLOT_HEAD_COLOUR = "BLUE"
        DialogueInput(
            "CM 1",
            "PROPERTIES",
            "COLOUR",
            "PART",
            head_parts,
            D3PLOT_HEAD_COLOUR
        );

        if (oGlblData.cutsection_thickness == 0)
            oGlblData.cutsection_thickness = 10; //nominal 10mm thick
        var thick_cut = oGlblData.cutsection_thickness * oGlblData.mm_factor;

        DialogueInput("cut", "thick_cut", thick_cut.toString());
        DialogueInput("CM 2", "cut", "thick_cut", thick_cut.toString());

        /**
         * magnification of 5.5 was chosen by trial and error to make the head excursion large enough
         * note that the zone size is controlled by width, z_top and z_bot variables in primer_EuroNCAP_Far_Side_2022_zones.js
         * this assumes that none of the entitites in the vehicle model exceed the box defined by the
         * YZ rectangle: (width/2, z_top), (-width/2, z_top), (-width/2, z_bot), (width/2, z_bot)
         * Otherwise the autocentre will not produce a consistent view and some of the vehicle may be clipped
         */
        DialogueInput("MG", "5.5"); //zoom in magnification by 5.5x
        SetCutSection(ALL, STATUS, ON); //had issue with cut section

        //then write out image
        DialogueInput("/IMAGE WHITE_BACKGROUND ON", "PNG_24BIT", image_file);
        //SetCutSection(ALL, STATUS,   OFF); //had issue with cut section so turn it off before finishing

        Message(
            "Max excursion for N" +
                oGlblData.peak_node_id +
                " found at state " +
                max_state +
                " and was " +
                oGlblData.excursion +
                "mm from passenger seat C/L"
        );
    } else {
        ErrorMessage("Error, excursion zone could not be calculated");
        Exit();
    }
}

function onlyUnique(value, index, self) {
    return self.indexOf(value) === index;
}

// for each time step calculate the dot product of the head node displacement (just pick one for efficiency)
// and the vector that defines the cross car direction (note this can change because the car moves during the analysis too)
// assumption is that n1 and n2' define car x axis are the datum and Y offsett of n1 at t=0 (first state) is calculated
// as the Y_n1 - Y_seat_centre = Y_offset. After state 1, Y_offset is used as the datum and excursion is measured as
// Y distance perpendicular to n1 and n2' (note that n2' is coordinate of n2 rotated back to global X axis at t=0 )

function get_local_datum() {
    // var n1; //on far side door near seat (i.e. side not impacted)
    // var n2; //on far side door at another X coordinate and approximately same Y (i.e. side not impacted)
    // var n3; //used for shift deformed

    //note n1 and n2 are external node ids so must be -ve
    var n1_coords = GetData(CV, NODE, -n1);
    var n2_coords = GetData(CV, NODE, -n2);

    var origin_local = n1_coords;

    //local coordinate
    var v_n1n2 = getNormalisedVectorFromCoords(n1_coords, n2_coords);

    //y_axis_local is used to take dot product with to find excursion distance (relative to origin_local)
    var y_axis_local = vectorXmatrix(v_n1n2, rotation_matrix);

    var local = { origin: origin_local, y_axis: y_axis_local };

    if (Include_UBIN_Data) {
        PutUbinData(UBIN_vector_handle_n1n2, NODE, -n1, 0, v_n1n2, state);
        PutUbinData(UBIN_vector_handle, NODE, -n1, 0, y_axis_local, state);
    }

    return local;
}

function getNormalisedVectorFromCoords(n1_coords, n2_coords) {
    var v_n1n2 = new Array(3);

    //calculate n1->n2 vector
    for (var i = 0; i < 3; i++) v_n1n2[i] = n2_coords[i] - n1_coords[i];

    var mag = magnitude(v_n1n2);

    //normalise n1->n2 vector
    for (var i = 0; i < 3; i++) v_n1n2[i] /= mag;

    return v_n1n2;
}

function get_current_excursion_from_seat_cl(
    local,
    head_internal_node_id,
    sign
) {
    var head_node_coords = GetData(CV, NODE, head_internal_node_id);

    //vector from current n1 to current head node
    var origin_vector = [
        head_node_coords[0] - local.origin[0],
        head_node_coords[1] - local.origin[1],
        head_node_coords[2] - local.origin[2],
    ];

    var distance_of_head_from_origin_in_local_y = dot(
        local.y_axis,
        origin_vector
    );

    /*   Example of vector sum

            <<--------------------LOCAL Y-----------------

            Seat       Head   C/L    First shift deformed node
            350        100     0             -700
            x           H      |              N1
                        <_______________________   distance_of_head_from_origin_in_local_y
                        +
                                _______________>   oGlblData.origin_y
                        -
            <__________________                    oGlblData.seat_centre_y       
                        *
                        1                          sign              
                  
                        ==
            ____________>        
            
            ((100-(-700)) + (-700) - (350)) * 1 = -250 => Yellow/Green Zone boundary


            <<--------------------LOCAL Y-----------------

                       C/L  Head   Seat     First shift deformed node (intentionally picked on barrier side to confirm it still works)
                        0    -100  -350     -600
                        |      H     x       N1
                               <______________    distance_of_head_from_origin_in_local_y
                        +
                        ______________________>   oGlblData.origin_y
                        -
                        _____________>            oGlblData.seat_centre_y       
                        *
                       -1                         sign              
                  
                        ==
                               ______>        
                 
            ((-100-(-600)) + (-600) - (-350)) * -1 = -250 => Yellow/Green Zone boundary


    */

    //note that return value is +ve if head excursion passes seat centreline and -ve if it does not
    //i.e. the smaller (more negative) the return value, the less the head moves towards the barrier side
    return (
        (distance_of_head_from_origin_in_local_y +
            oGlblData.origin_y -
            oGlblData.seat_centre_y) *
        sign
    );
}

function get_excursion_zone(excursion) {
    //get excursion line reference
    //excursion is relative to seat centre y
    //a positive excursion value is worse than negative because it means head goes past seat centreline

    excursion = excursion / oGlblData.mm_factor; //convert to mm so that comparison is consistent
    Message("get_excursion_zone => excursion in mm = " + excursion);
    var red_excursion_line_from_passenger_seat_centre_y =
        oGlblData.intrusion_from_seat_center_y;
    var orange_excursion_line_from_passenger_seat_centre_y = 0;
    var yellow_excursion_line_from_passenger_seat_centre_y = -125;
    var green_excursion_line_from_passenger_seat_centre_y = -250;

    // protocol specifies that red band should be brown if the side intrusion is >125mm outboard from seat cl and the vehicle has suitable countermeasure
    if (
        countermeasure &&
        red_excursion_line_from_passenger_seat_centre_y > 125
    ) {
        Message(
            "Red band is higher as it is >125mm from seat centreline and vehicle has countermeasures so colour zone brown"
        );
        EuroNCAPColourREDorBROWN = EuroNCAPColourBROWN;
    }

    if (excursion > red_excursion_line_from_passenger_seat_centre_y) {
        return "CAPPING";
    } else if (excursion > orange_excursion_line_from_passenger_seat_centre_y) {
        // if > 0
        if (
            countermeasure &&
            red_excursion_line_from_passenger_seat_centre_y > 125
        ) {
            Message(
                "Red band is higher as it is >125mm from seat centreline and vehicle has countermeasures so colour zone brown"
            );
            return "BROWN"; //"RED_GT125";
        }

        return "RED"; //countermeasure = false or RED_LT125
    } else if (excursion > yellow_excursion_line_from_passenger_seat_centre_y) {
        return "ORANGE";
    } else if (excursion > green_excursion_line_from_passenger_seat_centre_y) {
        return "YELLOW";
    } else {
        return "GREEN";
    }
}

//matrix operations:

/*
getRotationMatrix function is based on logic from the following stackexchange question:
https://math.stackexchange.com/questions/180418/calculate-rotation-matrix-to-align-vector-a-to-vector-b-in-3d/897677#897677

the rotation matrix is used to rotate the n1->n2 vector used to define the shift deform to the global y axis at the first state.
the same rotation matrix is then used to calculate the local y axis which is the assumed direction to measure excursion in.

e.g. if the car rotates on impact it will not be correct/meaningful to calculate the y displacement of the head nodes as the excursion will be in
the 'cross-car' direction which is what we call local y because the initial cross car direction is assumed to be the same as global y (i.e. the car is pointing in the x direction)

*/

function getRotationMatrix(a, b) {
    // var a = [1, 1, 1];
    // var b = [Math.sqrt(0.5), Math.sqrt(0.5), 0];//[0,0,1];

    var v = cross(a, b);
    var s = magnitude(v);
    var c = dot(a, b);
    var vx = [
        [0, -v[2], v[1]],
        [v[2], 0, -v[0]],
        [-v[1], v[0], 0],
    ];
    var I = [
        [1, 0, 0],
        [0, 1, 0],
        [0, 0, 1],
    ];
    var mult = (1 - c) / (s * s);
    var w = [
        [mult, 0, 0],
        [0, mult, 0],
        [0, 0, mult],
    ];
    var r = matrix3x3Add([
        I,
        vx,
        multiplyMatrices(w, multiplyMatrices(vx, vx)),
    ]);
    var rotated_vector = vectorXmatrix(a, r);
    Message("rotation_matrix  = " + JSON.stringify(r));
    Message("b_rotated  = " + JSON.stringify(rotated_vector));
    Message("b_original = " + JSON.stringify(b));
    return r;
}

function vectorXmatrix(v, m) {
    if (m[0][0] == null) {
        //if the matrix has null elements then original n1->n2 vector was parallel to global Y
        //so no rotation required and just return v
        Message(
            "Warning: First element in matrix is null which will occur if the choice of n1->n2 is parallel to global y. "
        );
        Message(
            "The normalised n1->n2 vector will therefore be used so we return it (v)."
        );
        return v;
    }
    var result = [0, 0, 0];
    for (var row = 0; row < 3; row++) {
        for (var i = 0; i < 3; i++) {
            result[row] += m[row][i] * v[i];
        }
    }

    return result;
}

function matrix3x3Add(matrices) {
    var totalMatrix = Array(3);

    for (var matrix = 0; matrix < matrices.length; matrix++) {
        for (var row = 0; row < 3; row++) {
            if (matrix == 0) totalMatrix[row] = [0, 0, 0];
            for (var column = 0; column < 3; column++) {
                totalMatrix[row][column] += matrices[matrix][row][column];
            }
        }
    }

    return totalMatrix;
}

function multiplyMatrices(m1, m2) {
    var result = [];
    for (var i = 0; i < m1.length; i++) {
        result[i] = [];
        for (var j = 0; j < m2[0].length; j++) {
            var sum = 0;
            for (var k = 0; k < m1[0].length; k++) {
                sum += m1[i][k] * m2[k][j];
            }
            result[i][j] = sum;
        }
    }
    return result;
}

function cross(A, B) {
    var a1, a2, a3, b1, b2, b3;
    [a1, a2, a3] = A;
    [b1, b2, b3] = B;
    return [a2 * b3 - a3 * b2, a3 * b1 - a1 * b3, a1 * b2 - a2 * b1];
}

function dot(A, B) {
    var a1, a2, a3, b1, b2, b3;
    [a1, a2, a3] = A;
    [b1, b2, b3] = B;
    return a1 * b1 + a2 * b2 + a3 * b3;
}

function magnitude(A) {
    var mag = Math.sqrt(A[0] * A[0] + A[1] * A[1] + A[2] * A[2]);

    return mag;
}
