/* Reporter js script to write a variable file
   Dan Woods 15/01/2025

PROGRAM::write_variable_file_csv.js
DESC::Write variables to a CSV file
FOLDER::Variables
RETURN::text
ARG::Variable file name::%DEFAULT_DIR%/reporter_variables.csv
-ARG::Comma separated list of variables without enclosing "%" [to skip variables prepend list with -] (optional)
END_INFO
*/

if (arguments.length == 0)
    throw Error("no variable file argument\n");

var var_file = new File(File.DriveMapFilename(arguments[0], Include.NATIVE), File.WRITE);

// Find if writing a subset of variables
var remove = false;
var list = new Array();

if (arguments.length == 2)
{
    var text = arguments[1];
    if (text.match(/^\-/))
    {
        remove = true;
        text = text.replace(/^./, "");
    }
    else if (text.match(/^\+/))
    {
        text = text.replace(/^./, "");
    }

    var list = text.split(",");
    for (var i=0; i<list.length; i++)
    {
        list[i] = list[i].replace(/^%/, "");
        list[i] = list[i].replace(/%$/, "");
        list[i] = list[i].toUpperCase();
    }
}

// Write variables
var variables = Variable.GetAll( Template.GetCurrent() ); 
// Sort by name
variables.sort((a, b) => {
  const nameA = a.name.toUpperCase(); // ignore upper and lowercase
  const nameB = b.name.toUpperCase(); // ignore upper and lowercase
  if (nameA < nameB) {
    return -1;
  }
  if (nameA > nameB) {
    return 1;
  }

  // names must be equal
  return 0;
});

for (var i=0; i<variables.length; i++)
{
    if (list.length)
    {
        var found = false;

        for (j=0; j<list.length; j++)
        {
            if (variables[i].name == list[j])
            {
                found = true;
                break;
            }
        }

// If removing variables and in list skip it
        if (remove && found) continue;

// If adding variables and not in list skip it
        if (!remove && !found) continue;
    }

    var_file.Write(variables[i].name +
                   "," + variables[i].description +
                   "," + variables[i].value + "\n");
}

var_file.Close();

//function to sort variables by name
