/* Reporter script to obtain total mass from OTF file
   Miles Thornton 8/3/2004

PROGRAM::total_mass.js
DESC::Total mass in analysis
FOLDER::OTF or d3hsp file/Mass info
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(test_filename)) otf_filename = test_filename;
  else break;
}

var line;
var match_regex = new RegExp("t o t a l  m a s s\\s+=\\s+(.*)");
var result;
var mass;

var otf_file = new File(otf_filename, File.READ);

while ((line = otf_file.FindLineContaining("t o t a l  m a s s")) != File.EOF) {
  if ((result = line.match(match_regex)) != null) {
    mass = result[1];
    mass = mass.replace(/^\s+/, ""); // remove white space
    mass = mass.replace(/\s+$/, "");

    output(mass);
    break;
  }
}

otf_file.Close();
