/* Reporter script to obtain title from OTF file
   Miles Thornton 8/3/2004

PROGRAM::title_otf.js
DESC::Analysis title
FOLDER::OTF or d3hsp file
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(test_filename)) otf_filename = test_filename;
  else break;
}

var otf_file = new File(otf_filename, File.READ);
var line;
var lastline;
var search_regex = new RegExp("code input version");
var mass;

while ((line = otf_file.ReadLine()) != File.EOF) {
  if (line.search(search_regex) != -1) {
    lastline = lastline.replace(/^\s+/, ""); // remove white space
    lastline = lastline.replace(/\s+$/, "");

    if (lastline.length == 0) output("no title");
    else output(lastline);
    break;
  }

  lastline = line;
}

otf_file.Close();
