/* Reporter js script to obtain title from keyword file
   Miles Thornton 9/3/2005

PROGRAM::title.js
DESC::Analysis title
FOLDER::Keyword file
RETURN::text
ARG::Keyword file name::%DEFAULT_DIR%/%DEFAULT_JOB%.key
END_INFO
*/

if (arguments.length == 0)
    throw Error("no keyword file argument\n");

var read_title   = false;
var read_include = 0;
var read_include_path = 0;
var finished     = false;
var include_path_regex          = new RegExp("^\\*INCLUDE_PATH");
var include_path_relative_regex = new RegExp("^\\*INCLUDE_PATH_RELATIVE");
var include_regex               = new RegExp("^\\*INCLUDE");
var title_regex                 = new RegExp("^\\*TITLE");
var comment_regex               = new RegExp("^\\$");
var append_regex                = new RegExp(" \\+$");
var line;

var key_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
    key_filename = File.SimplifyName(key_filename);

var root_directory = File.Directory(key_filename);

var key_file = new File(key_filename, File.READ);

var key_stack = new Array(key_file);
var include_stack = new Array();
var include_paths = new Array();
include_paths.push(root_directory);

while (key_stack.length != 0)
{
    if (finished)
    {
        key_stack[key_stack.length-1].Close();
        key_stack.pop();
        continue;
    }

// Find keyword
    while ( (line = key_stack[key_stack.length-1].FindLineStarting("*") ) != File.EOF)
    {
        if (finished)
            break;
        else if (line.search(include_path_relative_regex) != -1)
            LogWarning(line+" cards are not supported by the Analysis Title Library Program.");
        else if (line.search(include_path_regex) != -1)
            read_include_path++;
        else if (line.search(include_regex) != -1)
            read_include++;
        else if (line.search(title_regex) != -1)
            read_title = true;

// Read include file path
        if (read_include_path)
        { 
            var include_path = "";
            while (true)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 Exit();
                else if (line.search(comment_regex) != -1) continue;

                if (read_include_path == 1) line = line.replace(/^\s+/, ""); // remove leading white space on first line
                line = line.replace(/\s+$/, "");                             // remove trailing white space

                if (line.search(append_regex) != -1)
                {
                    include_path += line.substr(0, line.length-2);
                    read_include_path++;
                    continue;
                }

                include_path += line;

                include_path = File.DriveMapFilename(include_path, Include.NATIVE);
                include_path = File.SimplifyName(include_path);      

                if(!File.IsDirectory(include_path))
                {
                    LogWarning("Include path "+include_path+" could not be found. It won't be included in searches for a *TITLE card.");
                }
                else
                {
                    include_paths.push(include_path);
                }

                read_include_path = 0;
                break;
            }
        }
// Read include file
        else if (read_include)
        { 
            var include_file = "";
            while (true)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 Exit();
                else if (line.search(comment_regex) != -1) continue;

                if (read_include == 1) line = line.replace(/^\s+/, "");   // remove leading white space on first line
                line = line.replace(/\s+$/, "");                          // remove trailing white space

                if (line.search(append_regex) != -1)
                {
                    include_file += line.substr(0, line.length-2);
                    read_include++;
                    continue;
                }

                include_file += line;

                if (File.IsAbsolute(include_file))
                {
                    include_file = File.DriveMapFilename(include_file, Include.NATIVE);
                    include_file = File.SimplifyName(include_file);      

                    if(!File.Exists(include_file))
                    {
                        LogWarning("Include file "+include_file+" could not be found. It won't be searched for a *TITLE card.");
                    }
                    else if(!File.IsFile(include_file))
                    {
                        LogWarning("Include file "+include_file+" is not a file. It won't be searched for a *TITLE card.");
                    }
                    else
                    {
                        key_file = new File(include_file, File.READ);
                        key_stack.push(key_file);
                    }
                }
                else
                {
                    var found_file = false;
                    for (var i = 0; i < include_paths.length; i++)
                    {
                        var abs_include_file = include_paths[i] + "/" + include_file;
                        abs_include_file = File.ConvertSeparators(abs_include_file);
                        abs_include_file = File.SimplifyName(abs_include_file);      

                        if(File.Exists(abs_include_file) && File.IsFile(abs_include_file))
                        {
                            key_file = new File(abs_include_file, File.READ);
                            key_stack.push(key_file);
                            found_file = true;
                            break;
                        }
                    }
                    if (!found_file)
                    {
                        LogWarning("Include file "+include_file+" could not be found. It won't be searched for a *TITLE card.");
                    }
                }

                read_include = 0;
                break;
            }
        }
        else if (read_title)
        {
            while (true)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 Exit();
                else if (line.search(comment_regex) != -1) continue;

                line = line.replace(/^\s+/, "");	// remove white space
                line = line.replace(/\s+$/, "");

                output(line);
                read_title = false;
                finished = true;
                break;
            }
        }
    }

    key_stack[key_stack.length-1].Close();
    key_stack.pop();
}

if (!finished) output("no title");
