/* Reporter js script to obtain smallest timestep from otf file
   Miles Thornton 8/3/2005

PROGRAM::smallest_timestep.js
DESC::Smallest initial timestep
FOLDER::OTF or d3hsp file/Timestep info
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(test_filename)) otf_filename = test_filename;
  else break;
}

var timestep_regex = new RegExp("element.+timestep");
var timestep;
var line;
var finished = false;

var otf_file = new File(otf_filename, File.READ);

while ((line = otf_file.FindLineContaining("100 smallest")) != File.EOF) {
  while ((line = otf_file.FindLineMatching(timestep_regex)) != File.EOF) {
    line = otf_file.ReadLine();
    if (line == File.EOF) break;

    var fields = line.split(/\s+/);
    timestep = fields.pop();
    output(timestep);
    finished = true;
    break;
  }

  if (finished) break;
}

otf_file.Close();
