/* Reporter script to reset temporary variables

PROGRAM::reset_temporary_variables.js
DESC::Reset all temporary variables to a specified value
FOLDER::Variables
RETURN::text
-ARG::Reset value (empty string by default)
END_INFO
*/

// Resets the values of all temporary variables in the template to an empty string

var template = Template.GetCurrent();
var variables = Variable.GetAll(template);
var num_var = variables.length;

if (arguments.length > 0) LogPrint("Resetting temporary variables to " + arguments[0] + "...");
else LogPrint("Resetting temporary variables to empty string...");
var count = 0;

// Loop through all variables in template
for (var i = 0; i < num_var; i++)
{
    if (variables[i].temporary)
    {
// If reset value provided, reset to the value
		if (arguments.length > 0) variables[i].value = arguments[0];
// Else reset value of temporary variable to empty string
		else variables[i].value = "";
// Count the number of variables reset
        count++;
    }
}

LogPrint("Reset " + count + " temporary variables.");
Exit();
