/* Reporter script to read variables from a csv file (data in rows)
   Chris Arrcher   30/11/2012

PROGRAM::read_variables_from_csv_rows.js
DESC::Read variables from a CSV file (data in rows)
FOLDER::Variables
RETURN::text
ARG::Variable filename::%DEFAULT_DIR%/variables.csv
ARG::Row for variable name::1
ARG::Row for variable value::2
ARG::Row for variable description::3
ARG::Row for variable type::4
ARG::Row for variable read-only information::5
END_INFO
*/

if (arguments.length < 3)
    throw Error("Wrong number of arguments to read_variables_from_csv_rows.js. Expected at least 3 but got " +
                arguments.length +
                "\n");

var skipped = {
                CURRENT_PAGE:1,
                DATE:1,
                DEFAULT_DIR:1,
                DEFAULT_JOB:1,
                REPORTER_HOME:1,
                REPORTER_TEMP:1,
                TOTAL_PAGES:1,
                USER_HOME:1,
                USER_NAME:1
              };

var line;
var row = 0;
var name        = new Array();
var value       = new Array();
var description = new Array();
var type        = new Array();
var readonly    = new Array();

var fileIn = new File(File.DriveMapFilename(arguments[0], Include.NATIVE), File.READ);

while ( (line = fileIn.ReadLine() ) != File.EOF)
{
    var fields = line.split(/\s*,\s*/);
    
    row++;

// Name (required)
    if(row == arguments[1])
    {
        for(var f=0; f<fields.length; f++) name[f] = fields[f];
    }

// Value (required)
    if(row == arguments[2])
    {
        for(var f=0; f<fields.length; f++) value[f] = fields[f];
    }

// Description (optional)
    if(row == arguments[3])
    {
        for(var f=0; f<fields.length; f++) description[f] = fields[f];
    }

// Type (optional)
    if(row == arguments[4])
    {
        for(var f=0; f<fields.length; f++) type[f] = fields[f];
    }

// Readonly (optional)
    if(row == arguments[5])
    {
        for(var f=0; f<fields.length; f++)
        {
          readonly[f] = false;
        
          var str = fields[f];
          str = str.toLowerCase();
          
          if(str.match("true")) readonly[f] = true;
        }
    }
}

fileIn.Close();

// Set defaults for optional rows if not defined
if(row < arguments[5])
{
    for(var f=0; f<name.length; f++)
    {
        readonly[f] = false;
        
        if(row < arguments[4]) type[f] = "";
        if(row < arguments[3]) description[f] = "";
    }
}

// Create the variables
for(var f=0; f<name.length; f++)
{
    if(skipped[name[f]] != undefined) continue;
  
    var nvar = new Variable(Template.GetCurrent(), name[f], description[f], value[f], type[f], readonly[f]);
}


