/* Reporter script to read variables from a csv file
   Gavin Newlands   26/5/2010

PROGRAM::read_variables_from_csv.js
DESC::Read variables from a CSV file
FOLDER::Variables
RETURN::text
ARG::Variable filename::%DEFAULT_DIR%/variables.csv
ARG::Column for variable name::1
ARG::Column for variable value::2
ARG::Column for variable description::3
ARG::Column for variable type::4
ARG::Column for variable read-only information::5
END_INFO
*/

if (arguments.length < 3)
    throw Error("Wrong number of arguments to read_variables_from_csv.js. Expected at least 3 but got " +
                arguments.length +
                "\n");

var skipped = {
                CURRENT_PAGE:1,
                DATE:1,
                DEFAULT_DIR:1,
                DEFAULT_JOB:1,
                REPORTER_HOME:1,
                REPORTER_TEMP:1,
                TOTAL_PAGES:1,
                USER_HOME:1,
                USER_NAME:1
              };

var line;

var fileIn = new File(File.DriveMapFilename(arguments[0], Include.NATIVE), File.READ);

while ( (line = fileIn.ReadLine() ) != File.EOF)
{
    var fields = line.split(/\s*,\s*/);

// Name (required)
    if(fields[arguments[1]-1] == undefined) continue;
    var name = fields[arguments[1]-1];

    if (skipped[name] != undefined) continue;

// Value (required)
    if(fields[arguments[2]-1] == undefined) continue;
    var value = fields[arguments[2]-1]

// Description (optional)
    var description = "";
    if(fields[arguments[3]-1] != undefined) description = fields[arguments[3]-1];

// Type (optional)
    var type = "";
    if(fields[arguments[4]-1] != undefined) type = fields[arguments[4]-1];

// Readonly (optional)
    var readonly = false;

    if(fields[arguments[5]-1] != undefined)
    {
        var str = fields[arguments[5]-1];
        str = str.toLowerCase();

        if(str.match("true")) readonly = true;
    }

// Create the variable
    var nvar = new Variable(Template.GetCurrent(), name, description, value, type, readonly);
}

fileIn.Close();
