/* Reporter script to read a variables file
   Miles Thornton   22/7/2008

PROGRAM::read_variable_file.js
DESC::Read a REPORTER variables file
FOLDER::Variables
RETURN::text
ARG::Variable filename::%DEFAULT_DIR%/reporter_variables
END_INFO
*/

if (arguments.length == 0)
    throw Error("no variable file argument\n");

var skipped = {
                CURRENT_PAGE:1,
                DATE:1,
                TIME:1,
                DEFAULT_DIR:1,
                DEFAULT_JOB:1,
                REPORTER_HOME:1,
                REPORTER_TEMP:1,
                TOTAL_PAGES:1,
                USER_HOME:1,
                USER_NAME:1,
                TEMPLATE_DIR:1
              };

var regex1 = new RegExp("VAR\\s+([^!#]*)[!#]?\\s+DESCRIPTION=['\"](.*)['\"]\\s+VALUE=['\"](.*)['\"]");
var regex2 = new RegExp("VAR\\s+([^!#]*)[!#]?\\s+VALUE=['\"](.*)['\"]\\s+DESCRIPTION=['\"](.*)['\"]");
var regex3 = new RegExp("VAR\\s+([^!#]*)[!#]?\\s+VALUE=['\"](.*)['\"]");

var line;

var fileIn = new File(File.DriveMapFilename(arguments[0], Include.NATIVE), File.READ);

while ( (line = fileIn.ReadLine() ) != File.EOF)
{
    if ( (result = line.match(regex1) ) != null)
    {
// Skip variable if required
        if (skipped[result[1]] != undefined) continue;

// Create new variable for each line in variables file
        var nvar = new Variable(Template.GetCurrent(), result[1], result[2], result[3]);
    }
    else if ( (result = line.match(regex2) ) != null)
    {
// Skip variable if required
        if (skipped[result[1]] != undefined) continue;

// Create new variable for each line in variables file
        var nvar = new Variable(Template.GetCurrent(), result[1], result[3], result[2]);
    }
    else if ( (result = line.match(regex3) ) != null)
    {
// Skip variable if required
        if (skipped[result[1]] != undefined) continue;

// Create new variable for each line in variables file
        var nvar = new Variable(Template.GetCurrent(), result[1], "", result[2]);
    }
}

fileIn.Close();
