/* Reporter js script to read a PRIMER error file
   Miles Thornton 11/1/2013

PROGRAM::read_error_file.js
DESC::Read PRIMER error file
FOLDER::Errors
RETURN::text
ARG::Error file name::%DEFAULT_DIR%/%DEFAULT_JOB%.check
ARG::Variable to write total errors to::TOTAL_ERRORS
ARG::Variable to write total warnings to::TOTAL_WARNINGS
ARG::List errors and warnings::true
EXPAND_ARGS::false
END_INFO
*/

var fields;
var line;
var category;
var type;
var count;
var nerrors = 0;
var nwarnings = 0;

var category_regex = new RegExp("^(.+)\\s+(ERROR|WARNING)$");
var count_regex    = new RegExp("^(.+)\\s+\\((\\d+)\\)$");
var var_regex      = new RegExp("^(\\w+)$");

if (arguments.length != 4)
    throw Error("Wrong number of arguments to read_error_file.js. Expected 4 but got " + arguments.length + "\n");

// Check that error file exists
var error_filename = Template.GetCurrent().ExpandVariablesInString(arguments[0]);
    error_filename = File.DriveMapFilename(error_filename, Include.NATIVE);
    error_filename = File.SimplifyName(error_filename);
if (!File.Exists(error_filename) ) throw Error("Error file '" + error_filename + "' (" + arguments[0] + ") does not exist");

// Check that x,y,z and value variables are sensible
if ( (fields = arguments[1].match(var_regex) ) === null) throw Error("Bad error variable '" + arguments[1] + "'");
if ( (fields = arguments[2].match(var_regex) ) === null) throw Error("Bad warning variable '" + arguments[2] + "'");


var error_file = new File(error_filename, File.READ);

// Find keyword
while ( (line = error_file.ReadLine() ) != File.EOF)
{
    line.replace(/\s+$/, "");

    LogPrint(line);
    if ( (fields = line.match(category_regex)) != null)
    {
        category = fields[1];
        type     = fields[2];
    }
    else if ( (fields = line.match(count_regex)) != null)
    {
        if      (type == "ERROR"   && nerrors   == 0)
        {
            if (arguments[3] != false) output("ERRORS\n------\n");
        }
        else if (type == "WARNING" && nwarnings == 0)
        {
            if (arguments[3] != false && nerrors != 0) output("\n");
            if (arguments[3] != false                ) output("WARNINGS\n--------\n");
        }

        count = parseInt(fields[2]);
        if (arguments[3] != false) output(category+": "+ fields[1] + "  ("+count+")\n");

        if      (type == "ERROR"  ) nerrors   += count;
        else if (type == "WARNING") nwarnings += count;
    }
}

var v = new Variable(Template.GetCurrent(), arguments[1], "Total number of errors",   nerrors.toString(),   "Number");
var v = new Variable(Template.GetCurrent(), arguments[2], "Total number of warnings", nwarnings.toString(), "Number");
