/* Reporter js script to obtain precision from OTF file
   Miles Thornton 2/3/2005

PROGRAM::precision.js
DESC::Analysis precision
FOLDER::OTF or d3hsp file
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

var otf_file = new File(
  File.DriveMapFilename(arguments[0], Include.NATIVE),
  File.READ
);
var line;
var match_regex = new RegExp("Precision\\s+:\\s+(.+)\\s+\\|");
var result;

while ((line = otf_file.FindLineContaining("Precision")) != File.EOF) {
  if ((result = line.match(match_regex)) != null) {
    output(result[1]);
    break;
  }
}

otf_file.Close();
