// Utility functions for:
// pedestrian_zone_area_from_csv.js
// pedestrian_zone_area_from_variables.js

export function ArrayMax() {           //finds maximum value from an array of arguments (either a single array ref, or a list of numbers) 

    var max = (-1 * Number.MAX_VALUE);  //need a starting point - smallest possible #
//    //LogPrint (arguments.length,"\n");
    for (var i=0; i < arguments.length; i++) {
        if (arguments[i] instanceof Array) {
            var argumentarray = arguments[i];   
            for (var i=0; i < argumentarray.length; i++) {   //split array argument, go through 1 by 1
                var MaxSoFar = max;                     
                var competitor = argumentarray[i];      //take next number
                max = Math.max(MaxSoFar,competitor);    //compare with highest so far, winner stays on.
            }
        }
        
        else if (typeof(arguments[i]) == "number") {
            var MaxSoFar = max;
            var competitor = arguments[i];      //same as above, when input is numbers.
            max = Math.max(MaxSoFar,competitor);
        }
        
        else { LogError("error with ArrayMax function"); }
        
    }
    return max;
}




//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//


export function ArrayMin() {           //finds minimum value from an array of arguments (either a single array ref, or a list of numbers) 

    var min = (Number.MAX_VALUE);  //need a starting point - largest possible #
    for (var i=0; i < arguments.length; i++) {
        if (arguments[i] instanceof Array) {
            var argumentarray = arguments[i];   
            for (var j=0; j < argumentarray.length; j++) {   //split array argument, go through 1 by 1
                var MinSoFar = min;                     
                var competitor = argumentarray[j];      //take next number
                min = Math.min(MinSoFar,competitor);    //compare with highest so far, winner stays on.
            }
        }
        
        else if (typeof(arguments[i]) == "number") {
            var MinSoFar = min;
            var competitor = arguments[i];      //same as above, when input is numbers.
            min = Math.min(MinSoFar,competitor);
        }
        
        else { LogError("error with ArrayMin function"); }
        
    }

    return min;
}



//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function arrayPosition(array, val)  {
    for (var i=0; i < array.length; i++) {
        if (array[i] == val)  {
            return i;
        }
    }
    return -1;
}

    

 

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
   
export function pointInPolygon(pointXval,pointYval,polygonXcoords,polygonYcoords) {
                // Returns true if point is inside the polygon, false if outside. If point is  
                // exactly on an edge, may return true or false. See http://alienryderflex.com/polygon/

  var i = 0;
  var j = 0;
  var sides = polygonXcoords.length;
  var oddNODES = "false" ;

  for (i=0; i<sides; i++) {
    j = i + 1; 
    if (j==sides) {
        j=0;
    }
    if ( ((polygonYcoords[i] < pointYval) && (polygonYcoords[j] >= pointYval)) ||  ((polygonYcoords[j]<pointYval) && (polygonYcoords[i]>=pointYval)) ) {
        
      if (polygonXcoords[i]+(pointYval-polygonYcoords[i])/(polygonYcoords[j]-polygonYcoords[i])*(polygonXcoords[j]-polygonXcoords[i])<pointXval) {
          
        if (oddNODES == "true") {
            oddNODES = "false";
        }
        else oddNODES = "true";
        }
    }
  }
  return oddNODES; 
} 


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function triangleInterpolate(x,y,x1,y1,val1,x2,y2,val2,x3,y3,val3)  {
                    // based on shape functions, interpolates to anywhere within a triangle based on the values at each vertex.
                    // x, y is middle point; A,B and C define triangle.
            //i think maybe triangle must be defined anti-clockwise - at least, when I tried with tris defined clockwise, L1+L2+L3 became -1, and HICS were massively negative. 
                //UPDATE: have added clause to deal with wrongly defined tris :) 
    var length_a = Math.sqrt(squared(x2-x3) + squared(y2-y3));
                                                //length a, or BC
    var length_c = Math.sqrt(squared(x1-x2) + squared(y1-y2));
                                                //length c, or AB
    var angle = angleABCrad(x1,y1,x2,y2,x3,y3);

    var area = .5 * length_a * length_c * Math.sin(angle);      // 1/2 a.b.sinC

    var a1 = x2*y3 - x3*y2;
    var a2 = x3*y1 - x1*y3;
    var a3 = x1*y2 - x2*y1;
    var b1 = y2 - y3;
    var b2 = y3 - y1;
    var b3 = y1 - y2;
    var c1 = x3 - x2;
    var c2 = x1 - x3;
    var c3 = x2 - x1;

    var L1 = (a1 + b1*x + c1*y)/(2*area);
    var L2 = (a2 + b2*x + c2*y)/(2*area);
    var L3 = (a3 + b3*x + c3*y)/(2*area);

    if ( L1+L2+L3 > 1.01 || L1+L2+L3 < 0.99 )  {
        if (( L1+L2+L3 > -1.01 && L1+L2+L3 < -0.99 )) {  //if sum is equal to -1, try reversing triangle and starting again
            return (triangleInterpolate(x,y,x2,y2,val2,x1,y1,val1,x3,y3,val3));
        }
        else {
            LogWarning ("ERROR with shape function ... L1 + L2 + L3 which should be equal to 1 is equal to ",(L1+L2+L3));
        }
    }
    var interpolation = (L1*val1 + L2*val2 + L3*val3);
    return interpolation;
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function squared(a) {           //note to self: " ^2 " does not square things! use Math.power(x,2) or this function for tidiness
    return (a*a)
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function angleABCrad(Ax,Ay,Bx,By,Cx,Cy)  {         //returns angle /_ABC in degrees
    var length_a = Math.sqrt(squared(Bx-Cx) + squared(By-Cy));
                                                //length a, or BC

    var length_b = Math.sqrt(squared(Ax-Cx) + squared(Ay-Cy));
                                                //length b, or AC
    
    var length_c = Math.sqrt(squared(Ax-Bx) + squared(Ay-By));
                                                //length c, or AB

    var angleRAD = Math.acos( (squared(length_a) + squared(length_c) - squared(length_b)) / (2 * length_a * length_c) );
                                                //cosine rule
    return angleRAD;
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function areaTriangle(Ax,Ay,Bx,By,Cx,Cy)  {
    var length_a = Math.sqrt(squared(Bx-Cx) + squared(By-Cy));
                                                //length a, or BC

    var length_b = Math.sqrt(squared(Ax-Cx) + squared(Ay-Cy));
                                                //length b, or AC
    
    var angleC = angleABCrad(Bx,By,Cx,Cy,Ax,Ay);

    var area = 0.5 * length_a * length_b * Math.sin(angleC);    // area = 1/2 a.b.sinC

    return area;
}
    
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function smallestX(a,b)  {        // order function, increasing X. In event of tie, smallest y comes first.
    if (a["x"] == b["x"])  {            //if tied
        return ( a["y"] - b["y"] );     //go for smallest y
    }
    else {                              
        return ( a["x"] - b["x"] );     //else go for smallest x
    }
    
}
    
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function smallestY(a,b)  {        // order function, increasing Y. In event of tie, smallest x comes first.
    if (a["y"] == b["y"])  {            //if tied
        return ( a["x"] - b["x"] );     //go for smallest x
    }
    else {                              
        return ( a["y"] - b["y"] );     //else go for smallest y
    }
    
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function isLeftTurn(x1,y1,x2,y2,x3,y3)  {               // after travelling from 1 to 2, does 2 -> 3 represent turning left?
    var crossproduct =  ((x2-x1)*(y3-y1)) - ((y2-y1)*(x3-x1));
    if (crossproduct >= 0) {     // crossproduct > 0 is left turn, < 0 right turn, 0 collinear
        return "true";
    }
    else { return "false" };
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function isInCircumcircle(Ax,Ay,Bx,By,Cx,Cy,Dx,Dy)  {   // Determines if point Dx,Dy is within circumcircle of triangle
                                                        // A,B,C (labelled COUNTERCLOCKWISE)
    
    var det = -1 * (((squared(Ax)+squared(Ay)) * ( -Cx*Dy + Dx*Cy + Bx*Dy - Dx*By + Cx*By - Bx*Cy )) 
                  + ((squared(Bx)+squared(By)) * ( +Cx*Dy - Dx*Cy + Dx*Ay - Ax*Dy + Ax*Cy - Cx*Ay ))  
                  + ((squared(Cx)+squared(Cy)) * ( +Dx*By - Bx*Dy + Ax*Dy - Dx*Ay + Bx*Ay - Ax*By ))  
                  + ((squared(Dx)+squared(Dy)) * ( +Bx*Cy - Cx*By + Cx*Ay - Ax*Cy + Ax*By - Bx*Ay )));
                    //determinant of matrix  _                         _ 
                    //                      | Ax  Ay   (Ax^2 + Ay^2)  1 |    see http://en.wikipedia.org/wiki/Delaunay_triangulation    
                    //                      | Bx  By   (Bx^2 + By^2)  1 | 
                    //                      | Cx  Cy   (Cx^2 + Cy^2)  1 | 
                    //                      | Dx  Dy   (Dx^2 + Dy^2)  1 | 
                    //                       -                         -
    if (det > determinant_tolerance ) {
        return "true";
    }
    else if (det < (-1*determinant_tolerance) ) {
        return "false";
    }
    else {               //if exactly on circumcircle, det = 0
        return "on edge";
    }
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//


export function increasingangle(a,b)  {        // order function, orders array of coords by angle they and point point0_X,point0_Y make with X axis.
    
    // define angle A //
    if ( a["x"] - point0_X  == 0 && a["y"] - point0_Y  == 0 ) {
        return -1;      //if point A is point 0, we want it appearing first
    }
    else if ((a["x"] - point0_X) == 0)  {       //to avoid DIV/0 errors
        var angleA = Math.PI/2;
    }
    else if ((a["y"] - point0_Y) == 0)  {       //to avoid DIV/0 errors
        var angleA = 0;
    }
    else {
        if(a["x"] > point0_X)  {
            var angleA = Math.atan((a["y"] - point0_Y )/(a["x"] - point0_X));    //simple soh cah toa
        }
        else {
            var angleA = Math.PI + Math.atan(((a["y"] - point0_Y )/(a["x"] - point0_X))); //if greater than 90 degs (pi/2 rads)
        }
    }

    // define angle B //
    if ( b["x"] - point0_X  == 0 && b["y"] - point0_Y  == 0 ) {
        return 1;      //if point B is point 0, we want it appearing first
    }
    else if ((b["x"] - point0_X) == 0)  {       //to avoid DIV/0 errors
        var angleB = Math.PI/2;
    }
    else if ((b["y"] - point0_Y) == 0)  {       //to avoid DIV/0 errors
        var angleB = 0;
    }
    else {
        if(b["x"] > point0_X)  {
            var angleB = Math.atan((b["y"] - point0_Y )/(b["x"] - point0_X));    //simple soh cah toa
        }
        else {
            var angleB = Math.PI + Math.atan(((b["y"] - point0_Y )/(b["x"] - point0_X)));  //if greater than 90degs
        }
    }
    
    if (angleA == angleB)  {
        return Math.sqrt(squared(a["x"] - point0_X)+squared(a["y"] - point0_Y)) - Math.sqrt(squared(b["x"] - point0_X)+squared(b["y"] - point0_Y)); //specify an arbitary rule for when angles are equal
    }                                                                                                                   //otherwise can have collinear points going back on themselves, causes hull 
    else {                                                                                                              //to go in on itself
        return (angleA - angleB);          //compare angles       
    }
}     


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function increasingnumber(a,b) {    //order function, orders array of numbers 
    return (a - b);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function arrayFirstPosition(array, val)  {      //returns position of first instance of "val" in array.
    for (var i=0; i < array.length; i++) {
        if (array[i] == val || (array[i] > val + tolerance && array[i] < val - tolerance))  {   // based on "tolerance", defined in this prog.
            return i;
        }
    }
    return -1;
}
  
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function sumOfArray(array) {           //sums all the elements in an array (must all be numbers)
    var total = 0;
//    if (array.length != undefined) {
        for (var i = 0; i < array.length; i++)  {
            if (isFinite(array[i])) {        //avoid NaNs
                total = total + array[i];
            }
        }
//    }
    return total;
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function perimCutsX (a,XPerimCoords, YPerimCoords)  {   //returns an array  of the points at which x = a cuts the perimeter. 
                                                        //each element in array is an array of ["x"] and ["y"]
    return perimMultipleIntersections(a,0,a,1,XPerimCoords, YPerimCoords); // define an arbitrary short line along x = a line.
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function perimCutsY (a,XPerimCoords, YPerimCoords)  {   //returns an array  of the points at which y = a cuts the perimeter. 
                                                        //each element in array is an array of ["x"] and ["y"]
    return perimMultipleIntersections(0,a,1,a,XPerimCoords, YPerimCoords); // define an arbitrary short line along y = a line.
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function perimMultipleIntersections(Ax,Ay,Bx,By,XPerimCoords, YPerimCoords) {    //returns an array of coordinates of where the perimeter intersects the infinite line passing thru AB
                                                                      //returns an array/object, with ["x"] and ["y"] values
    
    var intersections = new Array();
    var intersection;  //in case we dont find any.
    loop_perimIntersection:
    for (var i = 0; i < XPerimCoords.length; i++)  {
        j = i+1;
        if (j == XPerimCoords.length) {  //looping round at end
            j = 0;
        }
        var ix = XPerimCoords[i];
        var iy = YPerimCoords[i];
        var jx = XPerimCoords[j];
        var jy = YPerimCoords[j];
        
        if (  ( ix>Ax+tolerance && ix>Bx+tolerance && jx>Ax+tolerance && jx>Bx+tolerance ) || ( ix<Ax-tolerance && ix<Bx-tolerance && jx<Ax-tolerance && jx<Bx-tolerance ) || ( iy>Ay+tolerance && iy>By+tolerance && jy>Ay+tolerance && jy>By+tolerance ) || ( iy<Ay-tolerance && iy<By-tolerance && jy<Ay-tolerance && jy<By-tolerance )  )  {
            continue loop_perimIntersection;            //if line i->j is entirely to left, right, above or below points A & B, ignore it.
        }                                               //tolerance already defined

        //find intersection     lines expressed as y = mx + c
        //define line equations
        if ((ix-jx) != 0)  {    //so long's ij is not vertical line         
            var m_ij = (iy-jy) / (ix-jx);   //gradient
            var c_ij = (iy - (m_ij * ix));  //constant
        } 
        if ((Ax-Bx) != 0)  {    //so long's AB is not vertical line                 
            var m_AB = (Ay-By) / (Ax-Bx);    //gradient 
            var c_AB = (Ay - (m_AB * Ax));   //constant
        }
        
        //solve to find intersection            ==>at this point only  a possible intersection, as it may not lie between bounds of lines.
        if ((Ax-Bx) != 0 && (ix-jx) != 0)  {
            if ( Math.abs(m_AB) - Math.abs(m_ij) <=0.01  &&  Math.abs(m_AB) - Math.abs(m_ij) >= -0.01  ) {  continue loop_perimIntersection; }
            else {
                var possibleIntersectionX = (c_ij - c_AB) / (m_AB - m_ij);
                var possibleIntersectionY = (m_ij * possibleIntersectionX) + c_ij;
            }
        }
        //what to do if a line is vertical 
        else {
            if ((ix-jx) == 0)  {        //if ij is vertical 
                var possibleIntersectionX = ix;     //or jx, as all points on line have same x
                var possibleIntersectionY = (m_AB * possibleIntersectionX) + c_AB;  //calculate y from other (non-vertical) line
            }
            if ((Ax-Bx) == 0)  {        //if AB is vertical 
                var possibleIntersectionX = Ax;      //or Bx, as all points on line have same x
                var possibleIntersectionY = (m_ij * possibleIntersectionX) + c_ij;  //calculate y from other (non-vertical) line 
            }
        }

        //check this intersection lies on the lines
        var onBothLines = 1;        //assume intersection point lies on both line unless told otherwise
        //check on line AB
        if (Bx > Ax)  {
        if ( possibleIntersectionX < Ax - tolerance || possibleIntersectionX > Bx + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (Bx < Ax)  {
            if ( possibleIntersectionX > Ax + tolerance || possibleIntersectionX < Bx - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionX - Ax) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        if (By > Ay)  {
            if ( possibleIntersectionY < Ay - tolerance || possibleIntersectionY > By + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (By < Ay)  {
            if ( possibleIntersectionY > Ay + tolerance || possibleIntersectionY < By - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionY - Ay) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        //check on line ij
        if (jx > ix)  {
            if ( possibleIntersectionX < ix - tolerance || possibleIntersectionX > jx + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (jx < ix)  {
            if ( possibleIntersectionX > ix + tolerance || possibleIntersectionX < jx - tolerance ) {
                onBothLines = 0;
            }
        }       
            else {  //else must be equal 
            if ( Math.abs(possibleIntersectionX - ix) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        if (jy > iy)  {
            if ( possibleIntersectionY < iy - tolerance || possibleIntersectionY > jy + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (jy < iy)  {
            if ( possibleIntersectionY > iy + tolerance || possibleIntersectionY < jy - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionY - iy) > tolerance )  {
                onBothLines = 0;
            }
        } 
        
        if (onBothLines == 1)  {
                            //if x of point lies between Ax and Bx, and ditto y, ditto ij        
            var intersection = new Array();
            var intersection = { x:possibleIntersectionX, y:possibleIntersectionY};            
            intersections.push(intersection);
            continue loop_perimIntersection;       //loop round for next one
        }

    } 
    //check we have no duplicates (may arise when corner of square sits on corner of perimeter, so lies on 2 distinct perim lines.
    if (intersections.length > 0)  {
        innerloop:
        for (var j = 0; j < intersections.length; j++)  {
            if (intersections.length > 1)  {
                var k = j + 1;
                if (k == intersections.length) { var k = 0 } //looping around
                if ( (intersections[j]["x"] > intersections[k]["x"] - tolerance && intersections[j]["x"] < intersections[k]["x"] + tolerance) && (intersections[j]["y"] > intersections[k]["y"] - tolerance && intersections[j]["y"] < intersections[k]["y"] + tolerance) )
                    intersections.splice(j,1);  //if 2 consecutive coords are equal, delete one of 'em.
//                    var j = j -1;       //and adjust j accordingly
            }
            else break innerloop;
        }
    }
        
    
    return intersections;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//


export function perimIntersection(Ax,Ay,Bx,By,XPerimCoords,YPerimCoords) {    //returns coordinate of point where the perimeter intersects the line AB
                                                                      //returns an array/object, with ["x"] and ["y"] values
    var intersection;  //in case we dont find any.

    loop_perimIntersection1:
    for (var i = 0; i < XPerimCoords.length; i++)  {
        j = i+1;
        if (j == XPerimCoords.length) {  //looping round at end
            j = 0;
        }
        var ix = XPerimCoords[i];
        var iy = YPerimCoords[i];
        var jx = XPerimCoords[j];
        var jy = YPerimCoords[j];
    
        
        if (  ( ix>Ax+tolerance && ix>Bx+tolerance && jx>Ax+tolerance && jx>Bx+tolerance ) || ( ix<Ax-tolerance && ix<Bx-tolerance && jx<Ax-tolerance && jx<Bx-tolerance ) || ( iy>Ay+tolerance && iy>By+tolerance && jy>Ay+tolerance && jy>By+tolerance ) || ( iy<Ay-tolerance && iy<By-tolerance && jy<Ay-tolerance && jy<By-tolerance )  )  {
            continue loop_perimIntersection1;            //if line i->j is entirely to left, right, above or below points A & B, ignore it.
        }                                               //tolerance already defined

        //find intersection     lines expressed as y = mx + c
        //define line equations
        if ((ix-jx) != 0)  {    //so long's ij is not vertical line         
            var m_ij = (iy-jy) / (ix-jx);   //gradient
            var c_ij = (iy - (m_ij * ix));  //constant
        } 
        if ((Ax-Bx) != 0)  {    //so long's AB is not vertical line                 
            var m_AB = (Ay-By) / (Ax-Bx);    //gradient 
            var c_AB = (Ay - (m_AB * Ax));   //constant
        }
        
        //solve to find intersection            ==>at this point only  a possible intersection, as it may not lie between bounds of lines.
        if ((Ax-Bx) != 0 && (ix-jx) != 0)  {
            if ( Math.abs(m_AB) - Math.abs(m_ij) <=0.01  &&  Math.abs(m_AB) - Math.abs(m_ij) >= -0.01  ) { continue loop_perimIntersection1; }
            else {
                var possibleIntersectionX = (c_ij - c_AB) / (m_AB - m_ij);
                var possibleIntersectionY = (m_ij * possibleIntersectionX) + c_ij;
            }
        }
        //what to do if a line is vertical 
        else {
            if ((Ax-Bx) == 0 && (ix-jx) == 0) { continue loop_perimIntersection1; }
            else if ((ix-jx) == 0)  {        //if ij is vertical 
                var possibleIntersectionX = ix;     //or jx, as all points on line have same x
                var possibleIntersectionY = (m_AB * possibleIntersectionX) + c_AB;  //calculate y from other (non-vertical) line
            }
            else if ((Ax-Bx) == 0)  {        //if AB is vertical 
                var possibleIntersectionX = Ax;      //or Bx, as all points on line have same x
                var possibleIntersectionY = (m_ij * possibleIntersectionX) + c_ij;  //calculate y from other (non-vertical) line 
                
            }
        }

        //check this intersection lies on the lines
        var onBothLines = 1;        //assume intersection point lies on both line unless told otherwise
        //check on line AB
        if (Bx > Ax)  {
        if ( possibleIntersectionX < Ax - tolerance || possibleIntersectionX > Bx + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (Bx < Ax)  {
            if ( possibleIntersectionX > Ax + tolerance || possibleIntersectionX < Bx - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionX - Ax) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        if (By > Ay)  {
            if ( possibleIntersectionY < Ay - tolerance || possibleIntersectionY > By + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (By < Ay)  {
            if ( possibleIntersectionY > Ay + tolerance || possibleIntersectionY < By - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionY - Ay) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        //check on line ij
        if (jx > ix)  {
            if ( possibleIntersectionX < ix - tolerance || possibleIntersectionX > jx + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (jx < ix)  {
            if ( possibleIntersectionX > ix + tolerance || possibleIntersectionX < jx - tolerance ) {
                onBothLines = 0;
            }
        }       
            else {  //else must be equal 
            if ( Math.abs(possibleIntersectionX - ix) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        if (jy > iy)  {
            if ( possibleIntersectionY < iy - tolerance || possibleIntersectionY > jy + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (jy < iy)  {
            if ( possibleIntersectionY > iy + tolerance || possibleIntersectionY < jy - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionY - iy) > tolerance )  {
                onBothLines = 0;
            }
        } 
        
        if (onBothLines == 1)  {    //if x of point lies between Ax and Bx, and ditto y, ditto ij  
            var intersection = new Array();
            var intersection = { x:possibleIntersectionX, y:possibleIntersectionY};            
            break loop_perimIntersection1;       //when we've found it, we can stop iterating.
        }

    } 
    return intersection;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
export function distancePoint2Line(Ax,Ay,Bx,By,Cx,Cy)  {
                            //calculates shortest distance from line AB to point C //always positive
    var ACdotAB = ( (Bx-Ax)*(Cx-Ax) + (By-Ay)*(Cy-Ay) );           //dot product AC.AB
    var lengthAB = Math.sqrt( squared(Bx-Ax)+squared(By-Ay) );
    var r = (ACdotAB / squared(lengthAB));
    if (lengthAB == 0)  {
        return -1;     //avoids DIV/0 errors  
    }
    if (r > 1 + (tolerance/lengthAB)  || r < -(tolerance/lengthAB) ) {     //if r >1 or < 0 then point not on line AB (but we include up to "tolerance" away form an end..
        return -1;
    }

    var s = ((Ay-Cy)*(Bx-Ax) - (Ax-Cx)*(By-Ay))/squared(lengthAB);
    var length = Math.abs(s*lengthAB);

    return length;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function distanceToPerim(Cx,Cy,XPerimCoords,YPerimCoords)  {
                                                    //calculates distance from point C to closest bit of perim. 
    var possibles = new Array();

    for (var i = 0; i < XPerimCoords.length; i++)  { //loop thru all lines of perim
        j = i+1;
        if (j == XPerimCoords.length) {  //looping round at end
            j = 0;
        }
        var ix = XPerimCoords[i];
        var iy = YPerimCoords[i];
        var jx = XPerimCoords[j];
        var jy = YPerimCoords[j];
        
        if (distancePoint2Line(ix,iy,jx,jy,Cx,Cy) != -1) { //so long's something was found
            possibles.push(distancePoint2Line(ix,iy,jx,jy,Cx,Cy));       //add to array
        }
    }
    if (possibles.length > 0) {
        return ArrayMin(possibles);
    }
    else return -1;
}
        
        
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//


export function howManyIntersections(Ax,Ay,Bx,By,XPerimCoords, YPerimCoords) {    //returns the number of points where the perimeter intersects the line AB
                                                                      //returns an array/object, with ["x"] and ["y"] values

    var intersections = 0;  //in case we dont find any.
    loop_perimIntersection2:
    for (var i = 0; i < XPerimCoords.length; i++)  {
        j = i+1;
        if (j == XPerimCoords.length) {  //looping round at end
            j = 0;
        }
        var ix = XPerimCoords[i];
        var iy = YPerimCoords[i];
        var jx = XPerimCoords[j];
        var jy = YPerimCoords[j];
        
        if (  ( ix>Ax+tolerance && ix>Bx+tolerance && jx>Ax+tolerance && jx>Bx+tolerance ) || ( ix<Ax-tolerance && ix<Bx-tolerance && jx<Ax-tolerance && jx<Bx-tolerance ) || ( iy>Ay+tolerance && iy>By+tolerance && jy>Ay+tolerance && jy>By+tolerance ) || ( iy<Ay-tolerance && iy<By-tolerance && jy<Ay-tolerance && jy<By-tolerance )  )  {
            continue loop_perimIntersection2;            //if line i->j is entirely to left, right, above or below points A & B, ignore it.
        }                                               //tolerance already defined

        //find intersection     lines expressed as y = mx + c
        //define line equations
        if ((ix-jx) != 0)  {    //so long's ij is not vertical line         
            var m_ij = (iy-jy) / (ix-jx);   //gradient
            var c_ij = (iy - (m_ij * ix));  //constant
        } 
        if ((Ax-Bx) != 0)  {    //so long's AB is not vertical line                 
            var m_AB = (Ay-By) / (Ax-Bx);    //gradient 
            var c_AB = (Ay - (m_AB * Ax));   //constant
        }
        
        //solve to find intersection            ==>at this point only  a possible intersection, as it may not lie between bounds of lines.
        if ((Ax-Bx) != 0 && (ix-jx) != 0)  {
            if ( Math.abs(m_AB) - Math.abs(m_ij) <=0.01  &&  Math.abs(m_AB) - Math.abs(m_ij) >= -0.01  ) { continue loop_perimIntersection2; }  //then they are parallel
            else {
                var possibleIntersectionX = (c_ij - c_AB) / (m_AB - m_ij);
                var possibleIntersectionY = (m_ij * possibleIntersectionX) + c_ij;
            }
        }
        //what to do if a line is vertical 
         else {
            if ((Ax-Bx) == 0 && (ix-jx) == 0) { continue loop_perimIntersection2; }
            else if ((ix-jx) == 0)  {        //if ij is vertical 
                var possibleIntersectionX = ix;     //or jx, as all points on line have same x
                var possibleIntersectionY = (m_AB * possibleIntersectionX) + c_AB;  //calculate y from other (non-vertical) line
            }
            else if ((Ax-Bx) == 0)  {        //if AB is vertical 
                var possibleIntersectionX = Ax;      //or Bx, as all points on line have same x
                var possibleIntersectionY = (m_ij * possibleIntersectionX) + c_ij;  //calculate y from other (non-vertical) line 
            }
            
        }

        //check this intersection lies on the lines
        var onBothLines = 1;        //assume intersection point lies on both lines unless told otherwise
        //check on line AB
        if (Bx > Ax)  {
        if ( possibleIntersectionX < Ax - tolerance || possibleIntersectionX > Bx + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (Bx < Ax)  {
            if ( possibleIntersectionX > Ax + tolerance || possibleIntersectionX < Bx - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionX - Ax) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        if (By > Ay)  {
            if ( possibleIntersectionY < Ay - tolerance || possibleIntersectionY > By + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (By < Ay)  {
            if ( possibleIntersectionY > Ay + tolerance || possibleIntersectionY < By - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionY - Ay) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        //check on line ij
        if (jx > ix)  {
            if ( possibleIntersectionX < ix - tolerance || possibleIntersectionX > jx + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (jx < ix)  {
            if ( possibleIntersectionX > ix + tolerance || possibleIntersectionX < jx - tolerance ) {
                onBothLines = 0;
            }
        }       
            else {  //else must be equal 
            if ( Math.abs(possibleIntersectionX - ix) > tolerance )  {
                onBothLines = 0;
            }
        }
        
        if (jy > iy)  {
            if ( possibleIntersectionY < iy - tolerance || possibleIntersectionY > jy + tolerance ) {
                onBothLines = 0;
            }
        }
        else if (jy < iy)  {
            if ( possibleIntersectionY > iy + tolerance || possibleIntersectionY < jy - tolerance ) {
                onBothLines = 0;
            }
        }
        else {  //else must be equal 
            if ( Math.abs(possibleIntersectionY - iy) > tolerance )  {
                onBothLines = 0;
            }
        } 
        
        if (onBothLines == 1)  {
                            //if x of point lies between Ax and Bx, and ditto y, ditto ij        
            intersections++;
            continue loop_perimIntersection2;     
        }

    } 
    return intersections;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function intersection2lines(Ax,Ay,Bx,By,ix,iy,jx,jy) {    //returns the points where the line ij intersects the line AB
                                                    //returns a single array/object, with ["x"] and ["y"] values
    
    var intersection;
    if (  ( ix>Ax+tolerance && ix>Bx+tolerance && jx>Ax+tolerance && jx>Bx+tolerance ) || ( ix<Ax-tolerance && ix<Bx-tolerance && jx<Ax-tolerance && jx<Bx-tolerance ) || ( iy>Ay+tolerance && iy>By+tolerance && jy>Ay+tolerance && jy>By+tolerance ) || ( iy<Ay-tolerance && iy<By-tolerance && jy<Ay-tolerance && jy<By-tolerance )  )  {
        return -1;  //if lines have entirely separated minimum rectangles (ie no chance of crossing)
    }                                               //tolerance already defined

    //find intersection     lines expressed as y = mx + c
    //define line equations
    if ((ix-jx) != 0)  {    //so long's ij is not vertical line         
        var m_ij = (iy-jy) / (ix-jx);   //gradient
        var c_ij = (iy - (m_ij * ix));  //constant
    } 
    if ((Ax-Bx) != 0)  {    //so long's AB is not vertical line                 
        var m_AB = (Ay-By) / (Ax-Bx);    //gradient 
        var c_AB = (Ay - (m_AB * Ax));   //constant
    }
        
    //solve to find intersection            ==>at this point only  a possible intersection, as it may not lie between bounds of lines.
    if ((Ax-Bx) != 0 && (ix-jx) != 0)  {
        if ( Math.abs(m_AB) - Math.abs(m_ij) <=0.01  &&  Math.abs(m_AB) - Math.abs(m_ij) >= -0.01  ) { return -1; }  //then they are parallel
        else {
            var possibleIntersectionX = (c_ij - c_AB) / (m_AB - m_ij);
            var possibleIntersectionY = (m_ij * possibleIntersectionX) + c_ij;
         }
    }
    //what to do if a line is vertical 
     else {
        if ((Ax-Bx) == 0 && (ix-jx) == 0) { return -1; }
        else if ((ix-jx) == 0)  {        //if ij is vertical 
            var possibleIntersectionX = ix;     //or jx, as all points on line have same x
            var possibleIntersectionY = (m_AB * possibleIntersectionX) + c_AB;  //calculate y from other (non-vertical) line
         }
        else if ((Ax-Bx) == 0)  {        //if AB is vertical 
            var possibleIntersectionX = Ax;      //or Bx, as all points on line have same x
            var possibleIntersectionY = (m_ij * possibleIntersectionX) + c_ij;  //calculate y from other (non-vertical) line 
        }
            
    }

    //check this intersection lies on the lines
    var onBothLines = 1;        //assume intersection point lies on both lines unless told otherwise
    //check on line AB
    if (Bx > Ax)  {
        if ( possibleIntersectionX < Ax - tolerance || possibleIntersectionX > Bx + tolerance ) {
            onBothLines = 0;
        }
    }
    else if (Bx < Ax)  {
        if ( possibleIntersectionX > Ax + tolerance || possibleIntersectionX < Bx - tolerance ) {
            onBothLines = 0;
        }
    }
    else {  //else must be equal 
        if ( Math.abs(possibleIntersectionX - Ax) > tolerance )  {
            onBothLines = 0;
        }
    }
    
    if (By > Ay)  {
        if ( possibleIntersectionY < Ay - tolerance || possibleIntersectionY > By + tolerance ) {
            onBothLines = 0;
        }
    }
    else if (By < Ay)  {
        if ( possibleIntersectionY > Ay + tolerance || possibleIntersectionY < By - tolerance ) {
            onBothLines = 0;
        }
    }
    else {  //else must be equal 
        if ( Math.abs(possibleIntersectionY - Ay) > tolerance )  {
            onBothLines = 0;
        }
    }
        
    //check on line ij
    if (jx > ix)  {
        if ( possibleIntersectionX < ix - tolerance || possibleIntersectionX > jx + tolerance ) {
            onBothLines = 0;
        }
    }
    else if (jx < ix)  {
        if ( possibleIntersectionX > ix + tolerance || possibleIntersectionX < jx - tolerance ) {
            onBothLines = 0;
        }
    }       
    else {  //else must be equal 
        if ( Math.abs(possibleIntersectionX - ix) > tolerance )  {
            onBothLines = 0;
        }
    }
    
    if (jy > iy)  {
        if ( possibleIntersectionY < iy - tolerance || possibleIntersectionY > jy + tolerance ) {
            onBothLines = 0;
        }
    }
    else if (jy < iy)  {
        if ( possibleIntersectionY > iy + tolerance || possibleIntersectionY < jy - tolerance ) {
            onBothLines = 0;
        }
    }
    else {  //else must be equal 
        if ( Math.abs(possibleIntersectionY - iy) > tolerance )  {
            onBothLines = 0;
        }
    } 
        
    if (onBothLines == 1)  {
                    //if x of point lies between Ax and Bx, and ditto y, ditto ij        
        intersection =  {x:possibleIntersectionX,y:possibleIntersectionY}; 
    }

    return intersection;
}




//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function rectangleInterpolate(x,y,Ax,Ay,Aval,Bx,By,Bval,Cx,Cy,Cval,Dx,Dy,Dval) {  //interpolates to anywhere within a rectangle based on the values at each vertex.
                    // x, y is middle point; A,B C and D define rectangle 

//                                 must be:   A   B
//
//                                            C   D

                    //  We assume rectangle edges lie parallel to x & y axes.
                    
    var fractionAB = (x-Ax)/(Bx - Ax);  //interpolate horizontally between A and B
    var interpolatnAB = Aval + (fractionAB * (Bval - Aval));
    var fractionCD = (x-Cx)/(Dx - Cx);  //interpolate horizontally between C and D    
    var interpolatnCD = Cval + (fractionCD * (Dval - Cval));

    var fractionAB_CD = (y-Cy)/(Ay-Cy);        //interpolate vertically between our 2 interpolated points.
    var interpolatn = interpolatnCD + (fractionAB_CD * (interpolatnAB - interpolatnCD));
    
    return interpolatn;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

export function centroidify(Ax,Ay,Bx,By,Cx,Cy)  {
    xCoord = (Ax+Bx+Cx)/3;      // average x
    yCoord = (Ay+By+Cy)/3;      // and y
    centroid = { x:xCoord, y:yCoord };
    return centroid;
}

//========================================//

export function interpolationPoint(Ax,Ay,Aval,Bx,By,Bval,testVal)  { //returns coordinate of point where val = testVal along line AB. Linear interpolation.

    var fractionAB = ((Math.abs(Aval - testVal)) / (Math.abs(Bval - Aval)));     //find where on line it lies
    var Xcoord = (Ax + (fractionAB * (Bx - Ax))); //find x coord 
    var Ycoord = (Ay + (fractionAB * (By - Ay))); //find y coord 
    var coordinate = { x:Xcoord, y:Ycoord };
    return coordinate;

}

//========================================//

export function triangleWeb(point1x,point1y,point2x,point2y,pointEx,pointEy,startingAtAorBorCorD) {    //point 1 and 2 are AB,BD,DC or CA of quad.
    //final argument can be "A","B","C" or "D" - tells us which corner we start on

//=========================================================================================================================================================

// == | WEB OF TRIANGLES FOR AREA TAKE II | == //                                       //saves us redefining (for example) AB_intersect, A_on_perim etc.
            //used for absolutely any quad.

            // -- for each triangle of our quad: 
                // -- we will draw a web coming from centre point where perim & contour cut, out to every corner/side intersection of tri.
                    // -- for each triangle in this web, if the centroid is in perim and HIC <val, we count the area.
    
//=========================================================================================================================================================

//  First and foremost; see if there's any shortcut from a more simple quad situation.

// Maybe all of tri is inside perimeter
    if (pointInPolygon(point1x,point1y,XPerimCoords,YPerimCoords) == "true" && pointInPolygon(point2x,point2y,XPerimCoords,YPerimCoords) == "true" && pointInPolygon(pointEx,pointEy,XPerimCoords,YPerimCoords) == "true" ) {
        areas[val].push(areaContourInTri);     //then we can just push the calculated contour area no probs.
        return;    //and skip out of this sub. 
    }
    
// Maybe none of tri has a count-able HIC
    else if(flagSaddleScenario == "all_non-countableHIC") {
        return; //just skip
    }
    
    else {      //otherwise some is in perim, some is outside, we have the figure it out the hard way.
        
//============================================================================================================//
// first, find centre point of intersection of contour and perim line (or discover that they don't intersect)  //
//============================================================================================================//
        //declare some variables
        var Ax = undefined;
        var Ay = undefined;        //perim line is gonna be defined by coordinates (Ax,Ay) and (Bx,By)
        var Bx = undefined;
        var By = undefined; 
        var ix = undefined;        //contour line is gonna be defined by coordinates (ix,iy) and (jx,jy)         
        var iy = undefined;
        var jx = undefined;
        var jy = undefined;

//================================//
//== DEFINE PERIM LINE THRU TRI ==//
//================================//

        // depending which point we start at, retrieve vals for _12_interpolation, 1_on_perim etc..
                    //to save recauculating these, we can just dig for the values - so long's we know which tri we're dealing with (is ABE or BDE etc).
        if (startingAtAorBorCorD == "A") {              //if we start at A, then point1 is A and point2 is B etc.
            if (AB_interpolationX != undefined) {
                var _12_interpolationX = AB_interpolationX;
                var _12_interpolationY = AB_interpolationY;
            }
            if (EA_interpolation != undefined) {
                var _1E_interpolationX = EA_interpolation["x"];
                var _1E_interpolationY = EA_interpolation["y"];
            }
            if (BE_interpolation != undefined) {
                var _2E_interpolationX = BE_interpolation["x"];
                var _2E_interpolationY = BE_interpolation["y"];
            }
            var HIC_1 = HIC_A;
            var HIC_2 = HIC_B;
        }
        else if (startingAtAorBorCorD == "B") {         //ditto rotated 90deg
            if (BD_interpolationX != undefined) {
                var _12_interpolationX = BD_interpolationX;
                var _12_interpolationY = BD_interpolationY;
            }
            if (EB_interpolation != undefined) {
                var _1E_interpolationX = EB_interpolation["x"];
                var _1E_interpolationY = EB_interpolation["y"];
            }
            if (DE_interpolation != undefined) {
                var _2E_interpolationX = DE_interpolation["x"];
                var _2E_interpolationY = DE_interpolation["y"];
            }
            var HIC_1 = HIC_B;
            var HIC_2 = HIC_D;
        }
        else if (startingAtAorBorCorD == "D") {         //ditto rotated another 90deg
            if (DC_interpolationX != undefined) {
                var _12_interpolationX = DC_interpolationX;
                var _12_interpolationY = DC_interpolationY;
            }
            if (ED_interpolation != undefined) {
                var _1E_interpolationX = ED_interpolation["x"];
                var _1E_interpolationY = ED_interpolation["y"];
            }
            if (CE_interpolation != undefined) {
                var _2E_interpolationX = CE_interpolation["x"];
                var _2E_interpolationY = CE_interpolation["y"];
            }
            var HIC_1 = HIC_D;
            var HIC_2 = HIC_C;
        }
        else if (startingAtAorBorCorD == "C") {         //ditto rotated another 90deg
            if (CA_interpolationX != undefined) {
                var _12_interpolationX = CA_interpolationX;
                var _12_interpolationY = CA_interpolationY;
            }
            if (EC_interpolation != undefined) {
                var _1E_interpolationX = EC_interpolation["x"];
                var _1E_interpolationY = EC_interpolation["y"];
            }
            if (AE_interpolation != undefined) {
                var _2E_interpolationX = AE_interpolation["x"];
                var _2E_interpolationY = AE_interpolation["y"];
            }
            var HIC_1 = HIC_C;
            var HIC_2 = HIC_A;
        }
        //THESE ONES CAN BE EXTRACTED FROM OUR ARRAYS 
        areaInPerim = areaInPerimVersion[startingAtAorBorCorD];
        var _1_on_PerimFlag = _1_on_PerimFlagVersion[startingAtAorBorCorD];
        var _12_flagPerim = _12_flagPerimVersion[startingAtAorBorCorD]; 
        var _2_on_PerimFlag = _2_on_PerimFlagVersion[startingAtAorBorCorD]; 
        var _2E_flagPerim = _2E_flagPerimVersion[startingAtAorBorCorD]; 
        var _1E_flagPerim = _1E_flagPerimVersion[startingAtAorBorCorD];
        var _12_intersect = _12_intersectVersion[startingAtAorBorCorD];
        var _1E_intersect = _1E_intersectVersion[startingAtAorBorCorD];
        var _2E_intersect = _2E_intersectVersion[startingAtAorBorCorD];
        var _1_on_PerimFlag = _1_on_PerimFlagVersion[startingAtAorBorCorD];
        var _2_on_PerimFlag =  _2_on_PerimFlagVersion[startingAtAorBorCorD];
//=======================
//== now that we know where perim cuts, we can define the straight line it forms thru triangle.
//=======================
    // define line AB (perim) then:
   
        var d = 0; //flags if we find any intersects or perim on corners
        if ( _1_on_PerimFlag == 1 )  {
            Ax = point1x;         //if point on perim, define as one end of line (pointA)
            Ay = point1y;
            d++;
        }    
        if (_12_flagPerim == 1)  {
            if (d == 0) {   //then if we dont already have a point A, use this
                Ax = _12_intersect["x"];         //if intersect exists, define as one end of line (pointA)
                Ay = _12_intersect["y"];
                d++;
            }
            else { 
                Bx = _12_intersect["x"];        //else this can be point B
                By = _12_intersect["y"];
            }
        }
        if ( _2_on_PerimFlag == 1 )  {
            if (d == 0) {   //then if we dont already have a point A, use this
                Ax = point2x;         
                Ay = point2y;
                d++;
            }
            else {
                Bx = point2x;       //else can be pointB
                By = point2y;
            }
        }   
        if (_2E_flagPerim == 1 )   {        //if exists
            if (d == 0) {   //then if we dont already have a point A, use this
                Ax = _2E_intersect["x"]; 
                Ay = _2E_intersect["y"];
                d++;
            }
            else {
                Bx = _2E_intersect["x"];     //else this can be point B
                By = _2E_intersect["y"];
            }
        }  
        if ( E_on_PerimFlag == 1 )  {
            if (d == 0) {   //then if we dont already have a point A, use this
                Ax = pointEx;         
                Ay = pointEy;
                d++;
            }
            else {
                Bx = pointEx;       //else can be pointB
                By = pointEy;
            }
        }   
        if ( _1E_flagPerim == 1 )   {        //wasn't liking 'if (typeof(DC_intersect["x"]) != "undefined")'
            if (d == 0) {
                Ax = _1E_intersect["x"];     //ditto
                Ay = _1E_intersect["y"];
                d++;
            }
            else {
                Bx = _1E_intersect["x"];
                By = _1E_intersect["y"];
            }
        }   
            
        var areaTRIANGLE = areaTriangle(point1x,point1y,point2x,point2y,pointEx,pointEy);
            
//==================================//
//== DEFINE CONTOUR LINE THRU TRI ==//
//==================================//
        // define line ij (CONTOUR)

        //this is easy as we already stored them when we did our saddle contour calcs
        var ix = pointI["x"];
        var iy = pointI["y"];   //areaContour is also already defined
        var jx = pointJ["x"];
        var jy = pointJ["y"];

//==================================//
//== DEFINE POINT OF INTERSECTION ==//
//==================================//
        var intersection2 = undefined; //empty it from last time.
        
        intersection2 = intersection2lines(Ax,Ay,Bx,By,ix,iy,jx,jy);     //see sub 
       
       // Now, we have 2 options - either an intersection is found, in which case we create our web of triangles, or the 2 lines don't cross, in 
       // which case we just play with the relative areas of in-perim and HIC < val.
        
//========================//
//== IF NO INTERSECTION ==//
//========================//
        if (intersection2 == undefined || intersection2["x"] == undefined || isNaN(intersection2["x"]) == true)   {       //if no intersection
            middleOflineAB = {  x:((Ax+Bx)/2), y:((Ay+By)/2)  };            //then take centre of line AB
                             //and we will test to see if it lies within polygon of count-able HIC (HIC < val).
        
        //define polygon of area of contour to be counted.      
                
            var toTest = { x:ix, y:iy };      //We will later lest this point to see if point i (and hence line ij) is inside perim.            
        
            switch (flagSaddleScenario)  {          //define the polygon of contour that we're counting (area of HIC < val)
                case "AB_AEquad":                 //NB a "quad" flag means the quad was coloured in, but that means we want the COUNT the tri, not the quad
                    var polyX = [pointAx,AB_interpolationX,AE_interpolation["x"]];        
                    var polyY = [pointAy,AB_interpolationY,AE_interpolation["y"]];        
                break;                                                        //just go thru the different options we have, according to flagSaddleScenario
                case "AB_AEtri":
                    var polyX = [pointBx,AB_interpolationX,AE_interpolation["x"],pointEx];        
                    var polyY = [pointBy,AB_interpolationY,AE_interpolation["y"],pointEy];        
                break;                                                          //etc
                case "AB_BEquad":
                    var polyX = [pointBx,AB_interpolationX,BE_interpolation["x"]];        
                    var polyY = [pointBy,AB_interpolationY,BE_interpolation["y"]];           
                break;                                                                  //etc
                case "AB_BEtri":
                    var polyX = [pointAx,AB_interpolationX,BE_interpolation["x"],pointEx];        
                    var polyY = [pointAy,AB_interpolationY,BE_interpolation["y"],pointEy];        
                break;                                                                              //etc
                case "BD_BEquad" :
                    var polyX = [pointBx,BD_interpolationX,BE_interpolation["x"]];        
                    var polyY = [pointBy,BD_interpolationY,BE_interpolation["y"]];        
                break;
                case "BD_BEtri":
                    var polyX = [pointDx,BD_interpolationX,BE_interpolation["x"],pointEx];        
                    var polyY = [pointDy,BD_interpolationY,BE_interpolation["y"],pointEy];        
                break;
                case "BD_DEquad":
                    var polyX = [pointDx,BD_interpolationX,DE_interpolation["x"]];        
                    var polyY = [pointDy,BD_interpolationY,DE_interpolation["y"]];        
                break;
                case "BD_DEtri":
                    var polyX = [pointBx,BD_interpolationX,DE_interpolation["x"],pointEx];        
                    var polyY = [pointBy,BD_interpolationY,DE_interpolation["y"],pointEy];        
                break;
                case "DC_DEquad":
                    var polyX = [pointDx,DC_interpolationX,DE_interpolation["x"]];        
                    var polyY = [pointDy,DC_interpolationY,DE_interpolation["y"]];        
                break;
                case "DC_DEtri":
                    var polyX = [pointCx,DC_interpolationX,DE_interpolation["x"],pointEx];        
                    var polyY = [pointCy,DC_interpolationY,DE_interpolation["y"],pointEy];        
                break;
                case "DC_CEquad":
                    var polyX = [pointCx,DC_interpolationX,CE_interpolation["x"]];        
                    var polyY = [pointCy,DC_interpolationY,CE_interpolation["y"]];        
                break;
                case "DC_CEtri":
                    var polyX = [pointDx,DC_interpolationX,CE_interpolation["x"],pointEx];        
                    var polyY = [pointDy,DC_interpolationY,CE_interpolation["y"],pointEy];        
                break;
                case "CA_CEquad":
                    var polyX = [pointCx,CA_interpolationX,CE_interpolation["x"]];       
                    var polyY = [pointCy,CA_interpolationY,CE_interpolation["y"]];        
                break;
                case "CA_CEtri":
                    var polyX = [pointAx,CA_interpolationX,CE_interpolation["x"],pointEx];        
                    var polyY = [pointAy,CA_interpolationY,CE_interpolation["y"],pointEy];        
                break;
                case "CA_AEquad":
                    var polyX = [pointAx,CA_interpolationX,AE_interpolation["x"]];        
                    var polyY = [pointAy,CA_interpolationY,AE_interpolation["y"]];        
                break;
                case "CA_AEtri":
                    var polyX = [pointCx,CA_interpolationX,AE_interpolation["x"],pointEx];        
                    var polyY = [pointCy,CA_interpolationY,AE_interpolation["y"],pointEy];        
                break;
                case "AE_BEquad":
                    var polyX = [pointEx,AE_interpolation["x"],BE_interpolation["x"]];        
                    var polyY = [pointEy,AE_interpolation["y"],BE_interpolation["y"]];        
                break;
                case "AE_BEtri":
                    var polyX = [pointAx,AE_interpolation["x"],BE_interpolation["x"],pointBx];        
                    var polyY = [pointAy,AE_interpolation["y"],BE_interpolation["y"],pointBy];        
                break;
                case "BE_DEquad":
                    var polyX = [pointEx,DE_interpolation["x"],BE_interpolation["x"]];        
                    var polyY = [pointEy,DE_interpolation["y"],BE_interpolation["y"]];        
                break;
                case "BE_DEtri":
                    var polyX = [pointBx,BE_interpolation["x"],DE_interpolation["x"],pointDx];        
                    var polyY = [pointBy,BE_interpolation["y"],DE_interpolation["y"],pointDy];        
                break;
                case "DE_CEquad":
                    var polyX = [pointEx,CE_interpolation["x"],DE_interpolation["x"]];        
                    var polyY = [pointEy,CE_interpolation["y"],DE_interpolation["y"]];        
                break;
                case "DE_CEtri":
                    var polyX = [pointDx,DE_interpolation["x"],CE_interpolation["x"],pointCx];        
                    var polyY = [pointDy,DE_interpolation["y"],CE_interpolation["y"],pointCy];        
                break;
                case "CE_AEquad":
                    var polyX = [pointEx,AE_interpolation["x"],CE_interpolation["x"]];        
                    var polyY = [pointEy,AE_interpolation["y"],CE_interpolation["y"]];        
                break;
                case "CE_AEtri":
                    var polyX = [pointCx,CE_interpolation["x"],AE_interpolation["x"],pointAx,];        
                    var polyY = [pointCy,CE_interpolation["y"],AE_interpolation["y"],pointAy];        
                break;
                case "all_countableHIC":        //if all of tri has correct HIC, all we need to do is take perim area & get out of here!
                    areas[val].push(areaInPerim);
                    return;
                break;
                default: 
                    return;
                break;
            }

//===============================//
//== DECIDE WHICH AREA WE WANT ==//
//===============================//
            // Depending on the situation, and how the areas of good HIC and in-perim-ness lie with respect to each other,
            // we may want perim area only, tri area only, or just the bit between the two lines.
           
        //PERIM LINE ENTIRELY OUTSIDE OF COUNTABLE HIC AREA?
            if (pointInPolygon(middleOflineAB["x"],middleOflineAB["y"],polyX,polyY) == "false")  {  //if perim line is entirely outside of the contour area we're counting
                myCentreOfPolygon = {x:(sumOfArray(polyX)/polyX.length), y:(sumOfArray(polyY)/polyY.length) }; //then we test whether centre of this (contour) area is 
                if (pointInPolygon(myCentreOfPolygon["x"],myCentreOfPolygon["y"],XPerimCoords,YPerimCoords) == "true" )  { //inside perim or not.
                    areas[val].push(areaContourInTri);   // If inside, add area of tri to array (we calculated this area outside sub, when finding contours)
                    return;     //and skip out of sub.
                }               
                else {
                    return;     //or else whole area is outside perim, so area = 0. Skip out of sub.
                }
            }            
        //PERIM LINE INSIDE COUNTABLE HIC?
            //Now, need to work out which bit of area we want.
            else if (pointInPolygon(toTest["x"],toTest["y"],XPerimCoords,YPerimCoords) == "true" )  {  // if contour line is inside perim.
                area = - areaTRIANGLE + areaContourInTri + areaInPerim;    //then we want to count
                areas[val].push(area);            // the bit inbetween the 2 lines  (remember we know perim line is inside area of low HIC)
                return;
            }
            else {
                areas[val].push(areaInPerim);   //otherwise we just want the perim area calculated previously. (as bit in between 2 lines must be outside perim)
                return;
            }
        }
//==============================//
//== IF AN INTERSECTION FOUND ==//
//==============================//
        else {      //else an intersection WAS found, so...
            var webArray = new Array(); //to store coords of all edge points we want to connect to (corners and intersection points)
            var coordinate; //temporary storage for coords to ensure standard array format.

    //========================================================================================================================================//
    //==     We go round edge of tri, starting at point 1, adding corners and any perim intersections/HIC interpolation points we might     ==//
    //==  come across, in order we find them. Then web is created out from intersection of perim/contour, to each of these points in turn   ==//
    //========================================================================================================================================//
//==//==//==// point 1 to point 2
            coordinate = { x:point1x, y:point1y };      //add point 1
            webArray.push(coordinate);
            
            if ( _12_intersect != undefined && typeof(_12_interpolationX) == "undefined") {
                coordinate = { x:_12_intersect["x"], y:_12_intersect["y"] };
                webArray.push(coordinate);      // If there is only one point of intersection/interpolation on line 12
            }                                   // Add it to array.
            else if ( _12_intersect == undefined && typeof(_12_interpolationX) != "undefined") {
                coordinate = { x:_12_interpolationX, y:_12_interpolationY };
                webArray.push(coordinate);      //whichever it is
            }
            else if ( _12_intersect != undefined && typeof(_12_interpolationX) != "undefined") {        //if theres both
                //to work out which we reach first, must calculate distance from 1. (we don't know orientation of tri so cannot use just x/y vals to tell us.
                var lengthToIntersect = Math.sqrt(squared(_12_intersect["x"]-point1x)+squared(_12_intersect["y"]-point1y));
                var lengthToInterpolation = Math.sqrt(squared(_12_interpolationX-point1x)+squared(_12_interpolationY-point1y));
                if(lengthToIntersect < lengthToInterpolation) {     //if we reach intersect before interpolation point
                    coordinate = { x:_12_intersect["x"], y:_12_intersect["y"] };
                    webArray.push(coordinate);          //add this first, 
                    coordinate = { x:_12_interpolationX, y:_12_interpolationY };
                    webArray.push(coordinate);          //then the other
                }
                else {      //else we must reach interpolation point first and intersection second
                    coordinate = { x:_12_interpolationX, y:_12_interpolationY };
                    webArray.push(coordinate);        //add that first, 
                    coordinate = { x:_12_intersect["x"], y:_12_intersect["y"] };
                    webArray.push(coordinate);        //then the other 
                }       
            }
//==//==//==// point 2 to point E
            coordinate = { x:point2x, y:point2y };      //add point 2 
            webArray.push(coordinate);

            if (_2E_intersect != undefined && typeof(_2E_interpolationX) == "undefined") {
                coordinate = { x:_2E_intersect["x"], y:_2E_intersect["y"] };
                webArray.push(coordinate);      // If there is only one point of intersection/interpolation on line 2E
            }                                   // Add it to array.
            else if (_2E_intersect == undefined && typeof(_2E_interpolationX) != "undefined") {
                coordinate = { x:_2E_interpolationX, y:_2E_interpolationY };
                webArray.push(coordinate);      //whichever it is
            }
            else if ( _2E_intersect != undefined && typeof(_2E_interpolationX) != "undefined") {        //if theres both
                var lengthToIntersect = Math.sqrt(squared(_2E_intersect["x"]-point2x)+squared(_2E_intersect["y"]-point2y)); //calculate which we reach first
                var lengthToInterpolation = Math.sqrt(squared(_2E_interpolationX-point2x)+squared(_2E_interpolationY-point2y));
                if(lengthToIntersect < lengthToInterpolation) {     //if we reach intersect before interpolation point
                    coordinate = { x:_2E_intersect["x"], y:_2E_intersect["y"] };
                    webArray.push(coordinate);          //add this first, 
                    coordinate = { x:_2E_interpolationX, y:_2E_interpolationY };
                    webArray.push(coordinate);          //then the other
                }
                else {
                    coordinate = { x:_2E_interpolationX, y:_2E_interpolationY };
                    webArray.push(coordinate);        //add that first, 
                    coordinate = { x:_2E_intersect["x"], y:_2E_intersect["y"] };
                    webArray.push(coordinate);        //then the other 
                }
            }
//==//==//==// point E to point 1 
            coordinate = { x:pointEx, y:pointEy };      //add point E
            webArray.push(coordinate);
        
            if ( _1E_intersect != undefined && typeof(_1E_interpolationX) == "undefined") {
                coordinate = { x:_1E_intersect["x"], y:_1E_intersect["y"] };
                webArray.push(coordinate);      // If there is only one point of intersection/interpolation on line 1E
            }                                   // Add it to array.
            else if ( _1E_intersect == undefined && typeof(_1E_interpolationX) != "undefined") {
                coordinate = { x:_1E_interpolationX, y:_1E_interpolationY };
                    webArray.push(coordinate);      //whichever it is
            }
            else if ( _1E_intersect != undefined && typeof(_1E_interpolationX) != "undefined") {        //if theres both
                var lengthToIntersect = Math.sqrt(squared(_1E_intersect["x"]-pointEx)+squared(_1E_intersect["y"]-pointEy));  //calculate which we reach first
                var lengthToInterpolation = Math.sqrt(squared(_1E_interpolationX-pointEx)+squared(_1E_interpolationY-pointEy));
                if(lengthToIntersect < lengthToInterpolation) {     //if we reach intersect before interpolation point
                    coordinate = { x:_1E_intersect["x"], y:_1E_intersect["y"] };
                    webArray.push(coordinate);          //add this first, 
                    coordinate = { x:_1E_interpolationX, y:_1E_interpolationY };
                    webArray.push(coordinate);          //then the other
                }
                else {
                    coordinate = { x:_1E_interpolationX, y:_1E_interpolationY };
                    webArray.push(coordinate);        //add that first, 
                    coordinate = { x:_1E_intersect["x"], y:_1E_intersect["y"] };
                    webArray.push(coordinate);        //then the other 
                }
            }   
            
            
            //==     Now we have an array of all the edge coords, in clockwise order     ==//
            //==  We must calculate HIC and isInPerim? at the centroid of each triangle  ==//
            //==                To know whether to count its area or not.                ==//
            
            for (var j = 0; j < webArray.length; j++)  {        //go thru each coord
                
                var k = j+1;            //triangle defined by 2 consecutive edge coords and the centre.
                if (k == webArray.length) { k = 0; } //looping round
               
               //calculate position of centroid - then we can calculate HIC here and test whether it is inside perim.
               var myCentroid = undefined; 
                var myCentroid = centroidify(intersection2["x"],intersection2["y"],webArray[j]["x"],webArray[j]["y"],webArray[k]["x"],webArray[k]["y"]);
                var HICatCentroid = (triangleInterpolate(myCentroid["x"],myCentroid["y"],point1x,point1y,HIC_1,point2x,point2y,HIC_2,pointEx,pointEy,HIC_E));
                var centroidInPerim = pointInPolygon(myCentroid["x"],myCentroid["y"],XPerimCoords,YPerimCoords);
                
                                                         //if they are both true
                if (HICatCentroid < val && centroidInPerim == "true") {    // then we want to count the area
                    area = areaTriangle(intersection2["x"],intersection2["y"],webArray[j]["x"],webArray[j]["y"],webArray[k]["x"],webArray[k]["y"]);
                    areas[val].push(area);
                } //if either is not true, then we dont care 'bout area.
            }
        }
    }
}


//===========================================/

export function perimAreas() {         //adds perim area to areaTOTAL area, AND returns value of area for later reference
    //uses already-defined A,B,C,D and E to split quad into tris and throw each tri into perimTris function.
        areaInPerimVersion["A"] = perimTrisArea(pointAx,pointAy,pointBx,pointBy,pointEx,pointEy,"A");  //make note of area of tri in perim; so we don't have to recalculate for each HIC iteration.
        _1_on_PerimFlagVersion["A"] = _1_on_PerimFlag;           //keep a note of these so we don't have to recalculate them each time.     
        _2_on_PerimFlagVersion["A"] = _2_on_PerimFlag;   
        
        _12_flagPerimVersion["A"] = _12_flagPerim;   
        _1E_flagPerimVersion["A"] = _1E_flagPerim; 
        _2E_flagPerimVersion["A"] = _2E_flagPerim;   
        
        _12_intersectVersion["A"] = _12_intersect;
        _1E_intersectVersion["A"] = _1E_intersect;
        _2E_intersectVersion["A"] = _2E_intersect;
            
        areaInPerimVersion["B"] = perimTrisArea(pointBx,pointBy,pointDx,pointDy,pointEx,pointEy,"B");  //make note of area of tri in perim; so we don't have to recalculate for each HIC iteration.
                _1_on_PerimFlagVersion["B"] = _1_on_PerimFlag;           //keep a note of these so we don't have to recalculate them each time.     
        _2_on_PerimFlagVersion["B"] = _2_on_PerimFlag;   
        
        _12_flagPerimVersion["B"] = _12_flagPerim;   
        _1E_flagPerimVersion["B"] = _1E_flagPerim; 
        _2E_flagPerimVersion["B"] = _2E_flagPerim;   
        
        _12_intersectVersion["B"] = _12_intersect;
        _1E_intersectVersion["B"] = _1E_intersect;
        _2E_intersectVersion["B"] = _2E_intersect;
        
        areaInPerimVersion["C"] = perimTrisArea(pointCx,pointCy,pointAx,pointAy,pointEx,pointEy,"C");  //make note of area of tri in perim; so we don't have to recalculate for each HIC iteration.        
        _1_on_PerimFlagVersion["C"] = _1_on_PerimFlag;           //keep a note of these so we don't have to recalculate them each time.     
        _2_on_PerimFlagVersion["C"] = _2_on_PerimFlag;   
        
        _12_flagPerimVersion["C"] = _12_flagPerim;   
        _1E_flagPerimVersion["C"] = _1E_flagPerim; 
        _2E_flagPerimVersion["C"] = _2E_flagPerim;   
        
        _12_intersectVersion["C"] = _12_intersect;
        _1E_intersectVersion["C"] = _1E_intersect;
        _2E_intersectVersion["C"] = _2E_intersect;
        
        areaInPerimVersion["D"] = perimTrisArea(pointDx,pointDy,pointCx,pointCy,pointEx,pointEy,"D");  //make note of area of tri in perim; so we don't have to recalculate for each HIC iteration.
        _1_on_PerimFlagVersion["D"] = _1_on_PerimFlag;           //keep a note of these so we don't have to recalculate them each time.     
        _2_on_PerimFlagVersion["D"] = _2_on_PerimFlag;   
        
        _12_flagPerimVersion["D"] = _12_flagPerim;   
        _1E_flagPerimVersion["D"] = _1E_flagPerim; 
        _2E_flagPerimVersion["D"] = _2E_flagPerim;   
        
        _12_intersectVersion["D"] = _12_intersect;
        _1E_intersectVersion["D"] = _1E_intersect;
        _2E_intersectVersion["D"] = _2E_intersect;
}
    
//===========================================//

export function perimTrisArea(point1x,point1y,point2x,point2y,pointEx,pointEy,startingAtAorBorCorD) {    //point 1 and 2 are AB,BD,DC or CA of quad.
    //final argument can be "A","B","C" or "D" - tells us which corner we start on

//=========================================================================================================================================================
//  Based on snippets from triangleWeb; breaks a quad into 4 tris and calculates the area inside perim for each tri.
//=========================================================================================================================================================


//================================//
//==   EXTRACT USEFUL NUMBERS   ==//
//================================//
            
        // depending which point we start at, retrieve vals for _12_interpolation, 1_on_perim etc..
                    //to save recalculating these, we can just dig for the values - so long's we know which tri we're dealing with (is ABE or BDE etc).
        if (startingAtAorBorCorD == "A") {              //if we start at A, then point1 is A and point2 is B etc.
            _1_on_PerimFlag = A_on_PerimFlag;
            _2_on_PerimFlag = B_on_PerimFlag;

            _12_flagPerim = AB_flagPerim;
            _1E_flagPerim = AE_flagPerim;
            _2E_flagPerim = BE_flagPerim;

            _12_intersect = AB_intersect;
            _1E_intersect = AE_intersect;
            _2E_intersect = BE_intersect;
        }
        else if (startingAtAorBorCorD == "B") {         //ditto rotated 90deg
            _1_on_PerimFlag = B_on_PerimFlag;
            _2_on_PerimFlag = D_on_PerimFlag;
            
            _12_flagPerim = BD_flagPerim;
            _1E_flagPerim = BE_flagPerim;
            _2E_flagPerim = DE_flagPerim;

            _12_intersect = BD_intersect;
            _1E_intersect = BE_intersect;
            _2E_intersect = DE_intersect;
        }
        else if (startingAtAorBorCorD == "D") {         //ditto rotated another 90deg
            _1_on_PerimFlag = D_on_PerimFlag;
            _2_on_PerimFlag = C_on_PerimFlag;

            _12_flagPerim = DC_flagPerim;
            _1E_flagPerim = DE_flagPerim;
            _2E_flagPerim = CE_flagPerim;

            _12_intersect = DC_intersect;
            _1E_intersect = DE_intersect;
            _2E_intersect = CE_intersect;
        }
        else if (startingAtAorBorCorD == "C") {         //ditto rotated another 90deg
            _1_on_PerimFlag = C_on_PerimFlag;
            _2_on_PerimFlag = A_on_PerimFlag;

            _12_flagPerim = CA_flagPerim;
            _1E_flagPerim = CE_flagPerim;
            _2E_flagPerim = AE_flagPerim;

            _12_intersect = CA_intersect;
            _1E_intersect = CE_intersect;
            _2E_intersect = AE_intersect;
        }
        

//=========================================//
//== CALCULATE AREA OF TRIANGLE IN PERIM ==//
//=========================================//
        //calculate area of whole tri.
        var areaTRIANGLE = areaTriangle(point1x,point1y,point2x,point2y,pointEx,pointEy);
        img.fillColour = "red";
        var centroid = centroidify(point1x,point1y,point2x,point2y,pointEx,pointEy); 
        
        //need to calculate area of triangle that is within perim (regardless of contours). 
        //Go thru the different scenarios for where perim line cuts and which area is inside one by one.

        if (_1_on_PerimFlag == 1 && _2E_flagPerim == 1) {
            if (pointInPolygon(point2x,point2y,XPerimCoords,YPerimCoords) == "true") {      
                areaInPerim = areaTriangle(point1x,point1y,_2E_intersect["x"],_2E_intersect["y"],point2x,point2y)
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
            else {
                areaInPerim = areaTriangle(point1x,point1y,_2E_intersect["x"],_2E_intersect["y"],pointEx,pointEy)
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim; 
            }
        }
        else if (E_on_PerimFlag == 1 && _12_flagPerim == 1) {
            if (pointInPolygon(point1x,point1y,XPerimCoords,YPerimCoords) == "true") {      
                areaInPerim = areaTriangle(pointEx,pointEy,_12_intersect["x"],_12_intersect["y"],point1x,point1y)
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
            else {
                areaInPerim = areaTriangle(pointEx,pointEy,_12_intersect["x"],_12_intersect["y"],point2x,point2y)
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
        }
        else if (_2_on_PerimFlag == 1 && _1E_flagPerim == 1) {
            if (pointInPolygon(point1x,point1y,XPerimCoords,YPerimCoords) == "true") {      
                areaInPerim = areaTriangle(point2x,point2y,_1E_intersect["x"],_1E_intersect["y"],point1x,point1y)
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
            else {
                areaInPerim = areaTriangle(point2x,point2y,_1E_intersect["x"],_1E_intersect["y"],pointEx,pointEy)
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
        }
        else if (_12_flagPerim == 1 && _1E_flagPerim == 1) {
            areaTri = areaTriangle(point1x,point1y,_12_intersect["x"],_12_intersect["y"],_1E_intersect["x"],_1E_intersect["y"])
            if (pointInPolygon(point1x,point1y,XPerimCoords,YPerimCoords) == "true") {      
                areaInPerim = areaTri;
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
            else {
                areaInPerim = areaTRIANGLE - areaTri;     //inverse area
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
        }
        else if (_1E_flagPerim == 1 && _2E_flagPerim == 1) {
            areaTri = areaTriangle(pointEx,pointEy,_1E_intersect["x"],_1E_intersect["y"],_2E_intersect["x"],_2E_intersect["y"])
            if (pointInPolygon(pointEx,pointEy,XPerimCoords,YPerimCoords) == "true") {      
                areaInPerim = areaTri;
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
            else {
                areaInPerim = areaTriangle(point1x,point1y,point2x,point2y,pointEx,pointEy) - areaTri;     //inverse area
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
        }
        else if (_12_flagPerim == 1 && _2E_flagPerim == 1) {
            areaTri = areaTriangle(point2x,point2y,_12_intersect["x"],_12_intersect["y"],_2E_intersect["x"],_2E_intersect["y"])
            if (pointInPolygon(point2x,point2y,XPerimCoords,YPerimCoords) == "true") {      
                areaInPerim = areaTri;
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
            else {
                areaInPerim = areaTriangle(point1x,point1y,point2x,point2y,pointEx,pointEy) - areaTri;     //inverse area
                areaTOTAL.push(areaInPerim);
if (areaInPerim < 0) {
}
                return areaInPerim;
            }
        }
            
        //if none of the above were true, line of perim must go along an edge or just touch a corner, so either all inside or all out.
        else {          //test centroid of tri instead of any of the corners, as they may be ON perim and come up false. 
            var myCentroid = centroidify(point1x,point1y,point2x,point2y,pointEx,pointEy);
            var centroid_in_perim = 0;
            if (pointInPolygon(myCentroid["x"],myCentroid["y"],XPerimCoords,YPerimCoords) == "true") {
                centroid_in_perim = 1;
            }            
            if (centroid_in_perim == 1) {
                areaInPerim = areaTRIANGLE;
                areaTOTAL.push(areaInPerim); //push pre-calculated area onto array
if (areaInPerim < 0) {
}
                return areaInPerim; //and skip the rest of sub
            }
            else {
                areaInPerim = 0;
                return areaInPerim;
            }
            
        }
    }
