/* Reporter js script to obtain the title and LCSS curve from
   *MAT_PIECEWISE_LINEAR_PLASTICITY_TITLE cards
   Miles Thornton 25/8/2006

PROGRAM::mat24_title_and_lcss.js
DESC::Extract title and LCSS curve from *MAT_PIECEWISE_LINEAR_PLASTICITY_TITLE cards
FOLDER::Keyword file
RETURN::text
ARG::Keyword file name::%DEFAULT_DIR%/%DEFAULT_JOB%.key
END_INFO
*/

if (arguments.length == 0)
    throw Error("no keyword file argument\n");

var line;
var comment_regex               = new RegExp("^\\$");
var include_path_regex          = new RegExp("^\\*INCLUDE_PATH");
var include_path_relative_regex = new RegExp("^\\*INCLUDE_PATH_RELATIVE");
var include_regex               = new RegExp("^\\*INCLUDE");
var append_regex                = new RegExp(" \\+$");
var read_include_path = 0;
var read_include = 0;
var read_mat = 0;
var title;
var curve;

var key_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
    key_filename = File.SimplifyName(key_filename);

var root_directory = File.Directory(key_filename);

var key_file = new File(key_filename, File.READ);

var key_stack = new Array(key_file);
var include_stack = new Array();
var include_paths = new Array();
include_paths.push(root_directory);

while (key_stack.length != 0)
{
// Find keyword
    while ( (line = key_stack[key_stack.length-1].FindLineStarting("*") ) != File.EOF)
    {
        if (line.search(include_path_relative_regex) != -1)
            LogWarning(line+" cards are not supported by the *MAT_PIECEWISE_LINEAR_PLASTICITY_TITLE Library Program.");
        else if (line.search(include_path_regex) != -1)
            read_include_path++;
        else if (line.search(include_regex) != -1)
            read_include++;
        else if (line.substr(0,38) == "*MAT_PIECEWISE_LINEAR_PLASTICITY_TITLE")
        {
            read_mat = 1;
        }

// Read include file path
        if (read_include_path)
        { 
            var include_path = "";
            while (true)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 Exit();
                else if (line.search(comment_regex) != -1) continue;

                if (read_include_path == 1) line = line.replace(/^\s+/, ""); // remove leading white space on first line
                line = line.replace(/\s+$/, "");                             // remove trailing white space

                if (line.search(append_regex) != -1)
                {
                    include_path += line.substr(0, line.length-2);
                    read_include_path++;
                    continue;
                }

                include_path += line;

                include_path = File.DriveMapFilename(include_path, Include.NATIVE);
                include_path = File.SimplifyName(include_path);      

                if(!File.IsDirectory(include_path))
                {
                    LogWarning("Include path "+include_path+" could not be found. It won't be included in searches for a *MAT_PIECEWISE_LINEAR_PLASTICITY_TITLE card.");
                }
                else
                {
                    include_paths.push(include_path);
                }

                read_include_path = 0;
                break;
            }
        }
// Read include file
        else if (read_include)
        { 
            var include_file = "";
            while (true)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 Exit();
                else if (line.search(comment_regex) != -1) continue;

                if (read_include == 1) line = line.replace(/^\s+/, "");   // remove leading white space on first line
                line = line.replace(/\s+$/, "");                          // remove trailing white space

                if (line.search(append_regex) != -1)
                {
                    include_file += line.substr(0, line.length-2);
                    read_include++;
                    continue;
                }

                include_file += line;

                if (File.IsAbsolute(include_file))
                {
                    include_file = File.DriveMapFilename(include_file, Include.NATIVE);
                    include_file = File.SimplifyName(include_file);      

                    if(!File.Exists(include_file))
                    {
                        LogWarning("Include file "+include_file+" could not be found. It won't be searched for a *MAT_PIECEWISE_LINEAR_PLASTICITY_TITLE card.");
                    }
                    else if(!File.IsFile(include_file))
                    {
                        LogWarning("Include file "+include_file+" is not a file. It won't be searched for a *MAT_PIECEWISE_LINEAR_PLASTICITY_TITLE card.");
                    }
                    else
                    {
                        key_file = new File(include_file, File.READ);
                        key_stack.push(key_file);
                    }
                }
                else
                {
                    var found_file = false;
                    for (var i = 0; i < include_paths.length; i++)
                    {
                        var abs_include_file = include_paths[i] + "/" + include_file;
                        abs_include_file = File.ConvertSeparators(abs_include_file);
                        abs_include_file = File.SimplifyName(abs_include_file);      

                        if(File.Exists(abs_include_file) && File.IsFile(abs_include_file))
                        {
                            key_file = new File(abs_include_file, File.READ);
                            key_stack.push(key_file);
                            found_file = true;
                            break;
                        }
                    }
                    if (!found_file)
                    {
                        LogWarning("Include file "+include_file+" could not be found. It won't be searched for a *MAT_PIECEWISE_LINEAR_PLASTICITY_TITLE card.");
                    }
                }

                read_include = 0;
                break;
            }
        }
// Read material card
        else if (read_mat)
        {
            while (read_mat <= 3)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 exit;
                else if (line.search(comment_regex) != -1)
                {
                    read_mat++;
                    continue;
                }

// Read title on first line
                if (read_mat == 1)
                {
                    line = line.replace(/^\s+/, "");   // remove leading white space
                    line = line.replace(/\s+$/, "");   // remove trailing white space
                    title = line;
                }

// Read curve from 3rd field on 3rd card
                else if (read_mat == 3)
                {
                    line = line.substr(20, 10);
                    line = line.replace(/^\s+/, "");   // remove leading white space
                    line = line.replace(/\s+$/, "");   // remove trailing white space
                    curve = line;

                    output(title + " " + curve + "\n");
                }

                read_mat++;
            }

            read_mat = 0;
        }
    }

    key_stack[key_stack.length-1].Close();
    key_stack.pop();
}

