/* Reporter js script to obtain initial velocity card used in analysis
   Miles Thornton 8/3/2005

PROGRAM::initial_velocity.js
DESC::Initial velocity card used in analysis
FOLDER::Keyword file
RETURN::text
ARG::Keyword file name::%DEFAULT_DIR%/%DEFAULT_JOB%.key
END_INFO
*/

if (arguments.length == 0)
    throw Error("no keyword file argument\n");

var line;
var comment_regex               = new RegExp("^\\$");
var include_path_regex          = new RegExp("^\\*INCLUDE_PATH");
var include_path_relative_regex = new RegExp("^\\*INCLUDE_PATH_RELATIVE");
var include_regex               = new RegExp("^\\*INCLUDE");
var initial_regex               = new RegExp("^\\*INITIAL_VELOCITY");
var append_regex                = new RegExp(" \\+$");
var finished           = false;
var read_include_path  = 0;
var read_include       = 0;
var read_velocity      = 0;

var key_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
    key_filename = File.SimplifyName(key_filename);

var root_directory = File.Directory(key_filename);

var key_file = new File(key_filename, File.READ);

var key_stack = new Array(key_file);
var include_stack = new Array();
var include_paths = new Array();
include_paths.push(root_directory);

while (key_stack.length != 0)
{
    if (finished)
    {
        key_stack[key_stack.length-1].Close();
        key_stack.pop();
        continue;
    }

// Find keyword
    while ( (line = key_stack[key_stack.length-1].FindLineStarting("*") ) != File.EOF)
    {
        if (finished)
            break;
        else if (line.search(include_path_relative_regex) != -1)
            LogWarning(line+" cards are not supported by the Initial Velocity Card Library Program.");
        else if (line.search(include_path_regex) != -1)
            read_include_path++;
        else if (line.search(include_regex) != -1)
            read_include++;
        else if (line.search(initial_regex) != -1)
        {
            if (line.charAt(17) == '_') continue;
            read_velocity = 1;
        }

// Read include file path
        if (read_include_path)
        { 
            var include_path = "";
            while (true)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 Exit();
                else if (line.search(comment_regex) != -1) continue;

                if (read_include_path == 1) line = line.replace(/^\s+/, ""); // remove leading white space on first line
                line = line.replace(/\s+$/, "");                             // remove trailing white space

                if (line.search(append_regex) != -1)
                {
                    include_path += line.substr(0, line.length-2);
                    read_include_path++;
                    continue;
                }

                include_path += line;

                include_path = File.DriveMapFilename(include_path, Include.NATIVE);
                include_path = File.SimplifyName(include_path);      

                if(!File.IsDirectory(include_path))
                {
                    LogWarning("Include path "+include_path+" could not be found. It won't be included in searches for an *INITIAL_VELOCITY card.");
                }
                else
                {
                    include_paths.push(include_path);
                }

                read_include_path = 0;
                break;
            }
        }
// Read include file
        else if (read_include)
        { 
            var include_file = "";
            while (true)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 Exit();
                else if (line.search(comment_regex) != -1) continue;

                if (read_include == 1) line = line.replace(/^\s+/, "");   // remove leading white space on first line
                line = line.replace(/\s+$/, "");                          // remove trailing white space

                if (line.search(append_regex) != -1)
                {
                    include_file += line.substr(0, line.length-2);
                    read_include++;
                    continue;
                }

                include_file += line;

                if (File.IsAbsolute(include_file))
                {
                    include_file = File.DriveMapFilename(include_file, Include.NATIVE);
                    include_file = File.SimplifyName(include_file);      

                    if(!File.Exists(include_file))
                    {
                        LogWarning("Include file "+include_file+" could not be found. It won't be searched for an *INITIAL_VELOCITY card.");
                    }
                    else if(!File.IsFile(include_file))
                    {
                        LogWarning("Include file "+include_file+" is not a file. It won't be searched for an *INITIAL_VELOCITY card.");
                    }
                    else
                    {
                        key_file = new File(include_file, File.READ);
                        key_stack.push(key_file);
                    }
                }
                else
                {
                    var found_file = false;
                    for (var i = 0; i < include_paths.length; i++)
                    {
                        var abs_include_file = include_paths[i] + "/" + include_file;
                        abs_include_file = File.ConvertSeparators(abs_include_file);
                        abs_include_file = File.SimplifyName(abs_include_file);      

                        if(File.Exists(abs_include_file) && File.IsFile(abs_include_file))
                        {
                            key_file = new File(abs_include_file, File.READ);
                            key_stack.push(key_file);
                            found_file = true;
                            break;
                        }
                    }
                    if (!found_file)
                    {
                        LogWarning("Include file "+include_file+" could not be found. It won't be searched for an *INITIAL_VELOCITY card.");
                    }
                }

                read_include = 0;
                break;
            }
        }
        else if (read_velocity)
        {
            while (true)
            {
                line = key_stack[key_stack.length-1].ReadLine();

                if      (line == File.EOF)                 exit;
                else if (line.search(comment_regex) != -1) continue;

                output(line + '\n');
                if (++read_velocity == 3)
                {
                    read_velocity = 0;
                    finished = true;
                    break;
                }
            }
        }
    }

    key_stack[key_stack.length-1].Close();
    key_stack.pop();
}

if (finished == false) output("No *INITIAL_VELOCITY card in analysis");
