/* Reporter script to obtain percentage initial added mass from OTF file
   Miles Thornton 7/12/2004

PROGRAM::initial_added_percent.js
DESC::Percentage initial added mass
FOLDER::OTF or d3hsp file/Mass info
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
ARG::Use HF Mass (selective mass)::false
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(test_filename)) otf_filename = test_filename;
  else break;
}

// Identify which type of added mass to read (only relevant when selective mass is enabled)
if (arguments[1]) {
  var mass_bool = arguments[1].toLowerCase();
} else {
  var mass_bool = "false";
}
if (mass_bool == "true") {
  var mass_type = "hf";
} else if (mass_bool == "false") {
  var mass_type = "lf";
} else {
  var mass_type = "lf";
  LogWarning(
    "Warning. 'Use HF Mass (selective mass)' argument should be set\n\
        to 'true' or 'false' for HF or LF mass respectively.\n\
        Defaulting to added low frequency mass."
  );
}

var line;
var match_regex = new RegExp(
  `(added|physical) (${mass_type} )?mass\\s*=\\s+([\\w\\.\\-\\+]+)`
);

var result;
var added = 0;
var physical = 0;

var otf_file = new File(otf_filename, File.READ);

while ((line = otf_file.ReadLine()) != File.EOF) {
  if (
    line.includes("calculation with mass scaling") ||
    line.includes("calculation with selective mass scaling")
  ) {
    while (true) {
      line = otf_file.ReadLine();
      if (line == File.EOF) break;

      if ((result = line.match(match_regex)) != null) {
        if (result[1] == "added") added = parseFloat(result[3]);
        else if (result[1] == "physical") physical = parseFloat(result[3]);
      }

      if (added && physical) break;
    }

    if (added && physical) {
      var percent = (added / physical) * 100;
      output(percent.toPrecision(2) + "%");
      break;
    }
  }
}

otf_file.Close();
