/* Reporter js script to obtain list of include files used in analysis
   Miles Thornton 8/3/2005

PROGRAM::include_files.js
DESC::Include files used in analysis
FOLDER::Keyword file
RETURN::text
ARG::Keyword file name::%DEFAULT_DIR%/%DEFAULT_JOB%.key
ARG::Full path (YES/NO [default] )
END_INFO
*/

if (arguments.length == 0)
    throw Error("no keyword file argument\n");

var full_path = false;
if (arguments.length == 2)
{
    var temp = arguments[1].toUpperCase();
    if (temp.charAt(0) == 'Y') full_path = true;
}
var line, transform, include_file, at_keyword, continuation, key, nfiles;
var comment_regex = new RegExp("^\\$");
var keyword_regex = new RegExp("^\\*");

var key_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
    key_filename = File.SimplifyName(key_filename);

var root_directory = File.Directory(key_filename);

var key_file = new File(key_filename, File.READ);

var key_stack = new Array(key_file);
var include_stack = new Array();

for (key=0; key<key_stack.length; key++)
{
    while ( (line = key_stack[key].FindLineStarting("*INCLUDE") ) != File.EOF)
    {
        at_keyword   = true;
        continuation = false;

        while (true)
        {
            if (at_keyword)
            {
                if (line.indexOf("*INCLUDE") != 0) break;

                if (line.indexOf("BINARY" ) != -1) break;
                if (line.indexOf("NASTRAN") != -1) break;
                if (line.indexOf("STAMPED") != -1) break;

                if (line.indexOf("_TRANSFORM") != -1) transform = 1;
                else                                  transform = 0;

                include_file = "";
                at_keyword = false;
                nfiles = 0;
            }

            line = key_stack[key].ReadLine();

            if (line == File.EOF)
            {
                if (continuation)
                    throw Error("Unexpected end of file reading continuation for *INCLUDE file name\n");
                else if (transform > 1)
                    throw Error("Unexpected end of file reading *INCLUDE_TRANSFORM data\n");
                else if (nfiles == 0)
                    throw Error("Unexpected end of file reading *INCLUDE data\n");
                else
                    break;
            }
            else if (line.search(comment_regex) != -1)
                continue;

            if (line.search(keyword_regex) != -1)
            {
                if (continuation)
                    throw Error("Missing continuation for *INCLUDE file name\n");
                else if (transform > 1)
                    throw Error("Incomplete *INCLUDE_TRANSFORM data\n");
                else if (line.indexOf("*INCLUDE") == 0)
                {
                    at_keyword = true;
                    continue;
                }
                else
                    break;
            }

// Skip over extra lines for *INCLUDE_TRANSFORM
            if (transform > 1)
            {
                if (++transform == 6) transform = 1;
                continue;
            }

// Remove leading and trailing white space
            line = line.replace(/^\s+/, "");
            line = line.replace(/\s+$/, "");

// Check if the name continues onto the next line
            continuation = false;
            if (line.length > 2 && line.indexOf(" +") == line.length-2)
            {
                continuation = true;
                line = line.replace(/..$/, "");   // remove trailing " +"
            }

            include_file += line;

            if (continuation) continue;

            if (!File.IsAbsolute(include_file))
                include_file = root_directory + "/" + include_file;

            include_file = File.DriveMapFilename(include_file, Include.NATIVE);
            include_file = File.SimplifyName(include_file);      

            include_stack.push(include_file);

            if(!File.Exists(include_file))
            {
                LogWarning("Include file "+include_file+" could not be found. It won't be searched.");
            }
            else
            {
                key_file = new File(include_file, File.READ);
                key_stack.push(key_file);
            }

            include_file = "";
            nfiles++;
            if (transform) transform++;
        }
    }

    key_stack[key].Close();
}

if (full_path == true || include_stack.length < 2)
{
    for (var i=0; i<include_stack.length; i++)
        output(include_stack[i] + "\n");
}
else
{
    var common;
    var ncommon;
    var match = true;

    for (ncommon=0; ncommon<include_stack[0].length; ncommon++)
    {
        common = include_stack[0].substring(0, ncommon+1);

        for (var i=1; i<include_stack.length; i++)
        {
            var len = Math.min(ncommon+1, include_stack[i].length);
            var test = include_stack[i].substring(0, len);

            if (test != common)
            {
                match = false;
                break;
            }
        }

        if (match == false) break;
    }

    if (ncommon) output("Parent directory: " + include_stack[0].substring(0, ncommon) + "\n");

    for (var i=0; i<include_stack.length; i++)
        output("-> " + include_stack[i].substring(ncommon) + "\n");
}
