/* Reporter script to obtain percentage final added mass from OTF file
   Miles Thornton 7/12/2004

PROGRAM::final_added_percent.js
DESC::Percentage final added mass
FOLDER::OTF or d3hsp file/Mass info
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
ARG::Use HF Mass (selective mass)::false
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(test_filename)) otf_filename = test_filename;
  else break;
}

// Identify which type of added mass to read (only relevant when selective mass is enabled)
if (arguments[1]) {
  var mass_bool = arguments[1].toLowerCase();
} else {
  var mass_bool = "false";
}
if (mass_bool == "true") {
  var mass_type = "hf";
} else if (mass_bool == "false") {
  var mass_type = "lf";
} else {
  var mass_type = "lf";
  LogWarning(
    "Warning. 'Use HF Mass (selective mass)' argument should be set\n\
        to 'true' or 'false' for HF or LF mass respectively.\n\
        Defaulting to added low frequency mass."
  );
}

var line;
var match_regex = new RegExp("percentage increase\\s+=\\s+([\\w\\.\\-\\+]+)");
var match_regex_sms = new RegExp(
  "added high frequency mass\\s+=\\s+([\\w\\.\\-\\+]+)"
);
var sms_check = false;
var result;
var added = 0;

// We do 2 passes (if required). On the 1st pass try reading the last 10000 bytes in the file
// to see if the data is there. If it isn't we do a 2nd pass starting from the beginning of
// the file.
var start_pass = 1;

// Get file size and subtract 10000 from it for position to start read from
var size = File.Size(otf_filename) - 10000;
if (size < 0) start_pass = 2;

var percents = [null, null];

for (var pass = start_pass; pass <= 2; pass++) {
  var otf_file = new File(otf_filename, File.READ);

  // Jump to the start position if 1st pass
  if (pass == 1) otf_file.Seek(size);

  while (
    (line = otf_file.FindLineContaining("percentage increase")) != File.EOF
  ) {
    if ((result = line.match(match_regex)) != null) {
      percents[1] = percents[0];
      percents[0] = parseFloat(result[1]);
    }

    line = otf_file.ReadLine();
    if (line.match(match_regex_sms) != null && !sms_check) {
      sms_check = true;
    }
  }

  otf_file.Close();

  if (sms_check && mass_type == "lf") {
    percents[0] = percents[1];
  }

  if (percents[0]) {
    output(percents[0].toPrecision(2) + "%");
    break;
  }
}
