/* Reporter js script to obtain ENDTIM parameter from OTF file
   Miles Thornton 2/3/2005

PROGRAM::endtim.js
DESC::Termination Time (ENDTIM) Echo in OTF File
FOLDER::OTF or d3hsp file/Timing
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = arguments[0];
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(File.DriveMapFilename(test_filename, Include.NATIVE)))
    otf_filename = test_filename;
  else break;
}

var otf_file = new File(
  File.DriveMapFilename(otf_filename, Include.NATIVE),
  File.READ
);
var line;
var match_regex = new RegExp("termination time\\.+\\s+(.*)$");
var result;

while ((line = otf_file.FindLineContaining("termination time")) != File.EOF) {
  if ((result = line.match(match_regex)) != null) {
    var message = result[1];
    message = message.replace(/\s+/g, "");
    output(message);
    break;
  }
}

otf_file.Close();
