/* Reporter js script to obtain elapsed time from OTF file
   Miles Thornton 2/3/2005

PROGRAM::elapsed_time.js
DESC::Elapsed time for analysis
FOLDER::OTF or d3hsp file/Timing
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(test_filename)) otf_filename = test_filename;
  else break;
}

var line;
var match_regex = new RegExp(
  "\\(\\s*(\\d+\\s*hours?\\s+\\d+\\s*min(?:\\.|utes?)\\s+\\d+\\s*sec(?:\\.|onds?))"
);
var result;

// We do 2 passes (if required). On the 1st pass try reading the last 5000 bytes in the file
// to see if the data is there. If it isn't we do a 2nd pass starting from the beginning of
// the file.
var start_pass = 1;
var finished = false;

// Get file size and subtract 5000 from it for position to start read from
var size = File.Size(otf_filename) - 5000;
if (size < 0) start_pass = 2;

for (var pass = start_pass; pass <= 2; pass++) {
  var otf_file = new File(otf_filename, File.READ);

  // Jump to the start position if 1st pass
  if (pass == 1) otf_file.Seek(size);

  // In R7 and older the format is
  // Elapsed time      12 seconds(   0 hours  0 min. 12 sec.) for  135546 cycles

  // In R8 and newer the format is
  // Elapsed time      11 seconds for  135546 cycles using  2 SMP threads
  //             (      0 hour   0 minute  11 seconds)

  // or

  // Elapsed time      12 seconds for  135546 cycles using     4 MPP procs
  //             (      0 hour   0 minute  12 seconds)

  while ((line = otf_file.FindLineContaining("Elapsed time")) != File.EOF) {
    // If line contains "cycles using" then read another line
    if (line.indexOf("cycles using") != -1) {
      if ((line = otf_file.ReadLine()) == File.EOF) break;
    }

    if ((result = line.match(match_regex)) != null) {
      output(result[1]);
      finished = true;
      break;
    }
  }

  otf_file.Close();

  if (finished) break;
}
