/* Reporter js script to obtain DT2MS parameter from OTF file
   Miles Thornton 2/3/2005

PROGRAM::dt2ms.js
DESC::Mass-scaled Timestep (DT2MS) Echo in OTF File
FOLDER::OTF or d3hsp file/Timestep info
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(test_filename)) otf_filename = test_filename;
  else break;
}

var otf_file = new File(otf_filename, File.READ);
var line;
var match_regex = new RegExp("scaled solution, dt2ms\\.+\\s+(.*)$");
var result;

while (
  (line = otf_file.FindLineContaining("scaled solution, dt2ms")) != File.EOF
) {
  if ((result = line.match(match_regex)) != null) {
    var message = result[1];
    message = message.replace(/\s+/g, "");
    output(message);
    break;
  }
}

otf_file.Close();
