/* Reporter script to delete temporary variables

PROGRAM::delete_temporary_variables.js
DESC::Delete all temporary variables
FOLDER::Variables
RETURN::text
END_INFO
*/

// Deletes the values of all temporary variables in the template

var template = Template.GetCurrent();
var variables = Variable.GetAll(template);
var num_var = variables.length;

LogPrint("Deleting temporary variables...");

var count = 0;

// Loop through all variables in template
for (var i = 0; i < num_var; i++)
{
    if (variables[i].temporary)
    {
// Delete temporary variable
        variables[i].Remove();
// Count the number of variables deleted
        count++;
    }
}

LogPrint("Deleted " + count + " temporary variables.");
Exit();
